/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.EnumSet;

final class JDBCType
extends Enum<JDBCType> {
    public static final /* enum */ JDBCType UNKNOWN = new JDBCType(Category.UNKNOWN, 999, "java.lang.Object");
    public static final /* enum */ JDBCType ARRAY = new JDBCType(Category.UNKNOWN, 2003, "java.lang.Object");
    public static final /* enum */ JDBCType BIGINT = new JDBCType(Category.NUMERIC, -5, "java.lang.Long");
    public static final /* enum */ JDBCType BINARY = new JDBCType(Category.BINARY, -2, "[B");
    public static final /* enum */ JDBCType BIT = new JDBCType(Category.NUMERIC, -7, "java.lang.Boolean");
    public static final /* enum */ JDBCType BLOB = new JDBCType(Category.BLOB, 2004, "java.sql.Blob");
    public static final /* enum */ JDBCType BOOLEAN = new JDBCType(Category.NUMERIC, 16, "java.lang.Boolean");
    public static final /* enum */ JDBCType CHAR = new JDBCType(Category.CHARACTER, 1, "java.lang.String");
    public static final /* enum */ JDBCType CLOB = new JDBCType(Category.CLOB, 2005, "java.sql.Clob");
    public static final /* enum */ JDBCType DATALINK = new JDBCType(Category.UNKNOWN, 70, "java.lang.Object");
    public static final /* enum */ JDBCType DATE = new JDBCType(Category.TEMPORAL, 91, "java.sql.Date");
    public static final /* enum */ JDBCType DECIMAL = new JDBCType(Category.NUMERIC, 3, "java.math.BigDecimal");
    public static final /* enum */ JDBCType DISTINCT = new JDBCType(Category.UNKNOWN, 2001, "java.lang.Object");
    public static final /* enum */ JDBCType DOUBLE = new JDBCType(Category.NUMERIC, 8, "java.lang.Double");
    public static final /* enum */ JDBCType FLOAT = new JDBCType(Category.NUMERIC, 6, "java.lang.Double");
    public static final /* enum */ JDBCType INTEGER = new JDBCType(Category.NUMERIC, 4, "java.lang.Integer");
    public static final /* enum */ JDBCType JAVA_OBJECT = new JDBCType(Category.UNKNOWN, 2000, "java.lang.Object");
    public static final /* enum */ JDBCType LONGNVARCHAR = new JDBCType(Category.LONG_NCHARACTER, -16, "java.lang.String");
    public static final /* enum */ JDBCType LONGVARBINARY = new JDBCType(Category.LONG_BINARY, -4, "[B");
    public static final /* enum */ JDBCType LONGVARCHAR = new JDBCType(Category.LONG_CHARACTER, -1, "java.lang.String");
    public static final /* enum */ JDBCType NCHAR = new JDBCType(Category.NCHARACTER, -15, "java.lang.String");
    public static final /* enum */ JDBCType NCLOB = new JDBCType(Category.NCLOB, 2011, "java.sql.NClob");
    public static final /* enum */ JDBCType NULL = new JDBCType(Category.UNKNOWN, 0, "java.lang.Object");
    public static final /* enum */ JDBCType NUMERIC = new JDBCType(Category.NUMERIC, 2, "java.math.BigDecimal");
    public static final /* enum */ JDBCType NVARCHAR = new JDBCType(Category.NCHARACTER, -9, "java.lang.String");
    public static final /* enum */ JDBCType OTHER = new JDBCType(Category.UNKNOWN, 1111, "java.lang.Object");
    public static final /* enum */ JDBCType REAL = new JDBCType(Category.NUMERIC, 7, "java.lang.Float");
    public static final /* enum */ JDBCType REF = new JDBCType(Category.UNKNOWN, 2006, "java.lang.Object");
    public static final /* enum */ JDBCType ROWID = new JDBCType(Category.UNKNOWN, -8, "java.lang.Object");
    public static final /* enum */ JDBCType SMALLINT = new JDBCType(Category.NUMERIC, 5, "java.lang.Short");
    public static final /* enum */ JDBCType SQLXML = new JDBCType(Category.UNKNOWN, 2009, "java.lang.Object");
    public static final /* enum */ JDBCType STRUCT = new JDBCType(Category.UNKNOWN, 2002, "java.lang.Object");
    public static final /* enum */ JDBCType TIME = new JDBCType(Category.TEMPORAL, 92, "java.sql.Time");
    public static final /* enum */ JDBCType TIMESTAMP = new JDBCType(Category.TEMPORAL, 93, "java.sql.Timestamp");
    public static final /* enum */ JDBCType TINYINT = new JDBCType(Category.NUMERIC, -6, "java.lang.Short");
    public static final /* enum */ JDBCType VARBINARY = new JDBCType(Category.BINARY, -3, "[B");
    public static final /* enum */ JDBCType VARCHAR = new JDBCType(Category.CHARACTER, 12, "java.lang.String");
    final Category category;
    private final int intValue;
    private final String className;
    private static final EnumSet<JDBCType> signedTypes;
    private static final EnumSet<JDBCType> binaryTypes;
    private static final EnumSet<Category> textualCategories;
    private static final /* synthetic */ JDBCType[] $VALUES;

    public static JDBCType[] values() {
        return (JDBCType[])$VALUES.clone();
    }

    public static JDBCType valueOf(String string) {
        return Enum.valueOf(JDBCType.class, string);
    }

    final String className() {
        return this.className;
    }

    private JDBCType(Category category, int n2, String string2) {
        this.category = category;
        this.intValue = n2;
        this.className = string2;
    }

    boolean convertsTo(JDBCType jDBCType) {
        return SetterConversion.converts(this, jDBCType);
    }

    boolean convertsTo(SSType sSType) {
        return UpdaterConversion.converts(this, sSType);
    }

    static JDBCType of(Object object, JDBCType jDBCType, SSType sSType) throws SQLServerException {
        assert (null != object);
        if (String.class.isInstance(object)) {
            jDBCType = CHAR;
        } else if (NClob.class.isInstance(object)) {
            jDBCType = NCLOB;
        } else if (Clob.class.isInstance(object)) {
            jDBCType = CLOB;
        } else if (Byte.class.isInstance(object)) {
            jDBCType = TINYINT;
        } else if (Integer.class.isInstance(object)) {
            jDBCType = INTEGER;
        } else if (Time.class.isInstance(object)) {
            jDBCType = TIME;
        } else if (Date.class.isInstance(object)) {
            jDBCType = DATE;
        } else if (Timestamp.class.isInstance(object)) {
            jDBCType = TIMESTAMP;
        } else if (Float.class.isInstance(object)) {
            jDBCType = REAL;
        } else if (Double.class.isInstance(object)) {
            jDBCType = DOUBLE;
        } else if (BigDecimal.class.isInstance(object)) {
            jDBCType = DECIMAL;
        } else if (Long.class.isInstance(object)) {
            jDBCType = BIGINT;
        } else if (Short.class.isInstance(object)) {
            jDBCType = SMALLINT;
        } else if (Boolean.class.isInstance(object)) {
            jDBCType = BIT;
        } else if (byte[].class.isInstance(object)) {
            jDBCType = BINARY;
        } else if (Blob.class.isInstance(object)) {
            jDBCType = BLOB;
        } else if (InputStream.class.isInstance(object)) {
            if (SSType.UNKNOWN != sSType) {
                assert (UNKNOWN == jDBCType);
                switch (sSType) {
                    case CHAR: 
                    case VARCHAR: 
                    case VARCHARMAX: 
                    case TEXT: 
                    case NCHAR: 
                    case NVARCHAR: 
                    case NVARCHARMAX: 
                    case NTEXT: {
                        jDBCType = LONGVARCHAR;
                        break;
                    }
                    default: {
                        jDBCType = LONGVARBINARY;
                        break;
                    }
                }
            } else {
                jDBCType = jDBCType.isTextual() ? LONGVARCHAR : LONGVARBINARY;
            }
        } else if (Reader.class.isInstance(object)) {
            jDBCType = LONGVARCHAR;
        } else {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unknownType"));
            Object[] objectArray = new Object[]{new String(object.getClass().getName())};
            SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, false);
        }
        return jDBCType;
    }

    static JDBCType of(int n) throws SQLServerException {
        for (JDBCType jDBCType : JDBCType.values()) {
            if (jDBCType.intValue != n) continue;
            return jDBCType;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unknownJDBCType"));
        Object[] objectArray = new Object[]{n};
        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
        return UNKNOWN;
    }

    boolean isSigned() {
        return signedTypes.contains((Object)this);
    }

    boolean isBinary() {
        return binaryTypes.contains((Object)this);
    }

    boolean isTextual() {
        return textualCategories.contains((Object)this.category);
    }

    boolean isUnsupported() {
        return Category.UNKNOWN == this.category;
    }

    int asJavaSqlType() {
        if (Util.SYSTEM_SPEC_VERSION.equals("1.5")) {
            switch (this) {
                case NCHAR: {
                    return 1;
                }
                case NVARCHAR: {
                    return 12;
                }
                case LONGNVARCHAR: {
                    return -1;
                }
                case NCLOB: {
                    return 2005;
                }
                case ROWID: {
                    return 1111;
                }
                case SQLXML: {
                    return 12;
                }
            }
            return this.intValue;
        }
        return this.intValue;
    }

    static {
        $VALUES = new JDBCType[]{UNKNOWN, ARRAY, BIGINT, BINARY, BIT, BLOB, BOOLEAN, CHAR, CLOB, DATALINK, DATE, DECIMAL, DISTINCT, DOUBLE, FLOAT, INTEGER, JAVA_OBJECT, LONGNVARCHAR, LONGVARBINARY, LONGVARCHAR, NCHAR, NCLOB, NULL, NUMERIC, NVARCHAR, OTHER, REAL, REF, ROWID, SMALLINT, SQLXML, STRUCT, TIME, TIMESTAMP, TINYINT, VARBINARY, VARCHAR};
        signedTypes = EnumSet.of(SMALLINT, new JDBCType[]{INTEGER, BIGINT, REAL, FLOAT, DOUBLE, DECIMAL, NUMERIC});
        binaryTypes = EnumSet.of(BINARY, VARBINARY, LONGVARBINARY, BLOB);
        textualCategories = EnumSet.of(Category.CHARACTER, new Category[]{Category.LONG_CHARACTER, Category.CLOB, Category.NCHARACTER, Category.LONG_NCHARACTER, Category.NCLOB});
    }

    static enum UpdaterConversion {
        CHARACTER(Category.CHARACTER, EnumSet.of(SSType.Category.NUMERIC, new SSType.Category[]{SSType.Category.TEMPORAL, SSType.Category.CHARACTER, SSType.Category.LONG_CHARACTER, SSType.Category.NCHARACTER, SSType.Category.LONG_NCHARACTER, SSType.Category.XML, SSType.Category.BINARY, SSType.Category.LONG_BINARY, SSType.Category.UDT, SSType.Category.GUID, SSType.Category.TIMESTAMP})),
        LONG_CHARACTER(Category.LONG_CHARACTER, EnumSet.of(SSType.Category.CHARACTER, new SSType.Category[]{SSType.Category.LONG_CHARACTER, SSType.Category.NCHARACTER, SSType.Category.LONG_NCHARACTER, SSType.Category.XML, SSType.Category.BINARY, SSType.Category.LONG_BINARY})),
        CLOB(Category.CLOB, EnumSet.of(SSType.Category.LONG_CHARACTER, SSType.Category.LONG_NCHARACTER, SSType.Category.XML)),
        NCHARACTER(Category.NCHARACTER, EnumSet.of(SSType.Category.NCHARACTER, SSType.Category.LONG_NCHARACTER, SSType.Category.XML)),
        LONG_NCHARACTER(Category.LONG_NCHARACTER, EnumSet.of(SSType.Category.NCHARACTER, SSType.Category.LONG_NCHARACTER, SSType.Category.XML)),
        NCLOB(Category.NCLOB, EnumSet.of(SSType.Category.LONG_NCHARACTER, SSType.Category.XML)),
        BINARY(Category.BINARY, EnumSet.of(SSType.Category.NUMERIC, new SSType.Category[]{SSType.Category.TEMPORAL, SSType.Category.CHARACTER, SSType.Category.LONG_CHARACTER, SSType.Category.NCHARACTER, SSType.Category.LONG_NCHARACTER, SSType.Category.XML, SSType.Category.BINARY, SSType.Category.LONG_BINARY, SSType.Category.UDT, SSType.Category.TIMESTAMP, SSType.Category.GUID})),
        LONG_BINARY(Category.LONG_BINARY, EnumSet.of(SSType.Category.XML, SSType.Category.BINARY, SSType.Category.LONG_BINARY, SSType.Category.UDT)),
        BLOB(Category.BLOB, EnumSet.of(SSType.Category.LONG_BINARY, SSType.Category.XML)),
        NUMERIC(Category.NUMERIC, EnumSet.of(SSType.Category.NUMERIC, SSType.Category.CHARACTER, SSType.Category.LONG_CHARACTER, SSType.Category.NCHARACTER, SSType.Category.LONG_NCHARACTER)),
        TEMPORAL(Category.TEMPORAL, EnumSet.of(SSType.Category.TEMPORAL, SSType.Category.CHARACTER, SSType.Category.LONG_CHARACTER, SSType.Category.NCHARACTER, SSType.Category.LONG_NCHARACTER));

        private final Category from;
        private final EnumSet<SSType.Category> to;
        private static final EnumMap<Category, EnumSet<SSType.Category>> conversionMap;

        private UpdaterConversion(Category category, EnumSet<SSType.Category> enumSet) {
            this.from = category;
            this.to = enumSet;
        }

        static boolean converts(JDBCType jDBCType, SSType sSType) {
            return conversionMap.get((Object)jDBCType.category).contains((Object)sSType.category);
        }

        static {
            conversionMap = new EnumMap(Category.class);
            for (Category enum_ : Category.values()) {
                conversionMap.put(enum_, EnumSet.noneOf(SSType.Category.class));
            }
            for (Enum enum_ : UpdaterConversion.values()) {
                conversionMap.get((Object)((UpdaterConversion)enum_).from).addAll(((UpdaterConversion)enum_).to);
            }
        }
    }

    static enum SetterConversion {
        CHARACTER(Category.CHARACTER, EnumSet.of(Category.NUMERIC, new Category[]{Category.TEMPORAL, Category.CHARACTER, Category.LONG_CHARACTER, Category.NCHARACTER, Category.LONG_NCHARACTER, Category.BINARY, Category.LONG_BINARY})),
        LONG_CHARACTER(Category.LONG_CHARACTER, EnumSet.of(Category.CHARACTER, new Category[]{Category.LONG_CHARACTER, Category.NCHARACTER, Category.LONG_NCHARACTER, Category.BINARY, Category.LONG_BINARY})),
        CLOB(Category.CLOB, EnumSet.of(Category.CLOB, Category.LONG_CHARACTER, Category.LONG_NCHARACTER)),
        NCHARACTER(Category.NCHARACTER, EnumSet.of(Category.NCHARACTER, Category.LONG_NCHARACTER, Category.NCLOB)),
        LONG_NCHARACTER(Category.LONG_NCHARACTER, EnumSet.of(Category.NCHARACTER, Category.LONG_NCHARACTER)),
        NCLOB(Category.NCLOB, EnumSet.of(Category.LONG_NCHARACTER, Category.NCLOB)),
        BINARY(Category.BINARY, EnumSet.of(Category.NUMERIC, new Category[]{Category.TEMPORAL, Category.CHARACTER, Category.LONG_CHARACTER, Category.NCHARACTER, Category.LONG_NCHARACTER, Category.BINARY, Category.LONG_BINARY, Category.BLOB})),
        LONG_BINARY(Category.LONG_BINARY, EnumSet.of(Category.BINARY, Category.LONG_BINARY)),
        BLOB(Category.BLOB, EnumSet.of(Category.LONG_BINARY, Category.BLOB)),
        NUMERIC(Category.NUMERIC, EnumSet.of(Category.NUMERIC, Category.CHARACTER, Category.LONG_CHARACTER, Category.NCHARACTER, Category.LONG_NCHARACTER)),
        TEMPORAL(Category.TEMPORAL, EnumSet.of(Category.TEMPORAL, Category.CHARACTER, Category.LONG_CHARACTER, Category.NCHARACTER, Category.LONG_NCHARACTER));

        private final Category from;
        private final EnumSet<Category> to;
        private static final EnumMap<Category, EnumSet<Category>> conversionMap;

        private SetterConversion(Category category, EnumSet<Category> enumSet) {
            this.from = category;
            this.to = enumSet;
        }

        static boolean converts(JDBCType jDBCType, JDBCType jDBCType2) {
            return conversionMap.get((Object)jDBCType.category).contains((Object)jDBCType2.category);
        }

        static {
            conversionMap = new EnumMap(Category.class);
            for (Category enum_ : Category.values()) {
                conversionMap.put(enum_, EnumSet.noneOf(Category.class));
            }
            for (Enum enum_ : SetterConversion.values()) {
                conversionMap.get((Object)((SetterConversion)enum_).from).addAll(((SetterConversion)enum_).to);
            }
        }
    }

    static enum Category {
        CHARACTER,
        LONG_CHARACTER,
        CLOB,
        NCHARACTER,
        LONG_NCHARACTER,
        NCLOB,
        BINARY,
        LONG_BINARY,
        BLOB,
        NUMERIC,
        TEMPORAL,
        UNKNOWN;

    }
}

