/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import java.util.Arrays;
import java.util.Collection;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowBuilder;

public class StageBuilder<B extends StageBuilder<B>>
extends WindowBuilder<B> {
    private int __set;
    private boolean fullScreen;
    private boolean iconified;
    private Collection<? extends Image> icons;
    private boolean resizable;
    private Scene scene;
    private StageStyle style = StageStyle.DECORATED;
    private String title;

    protected StageBuilder() {
    }

    public static StageBuilder<?> create() {
        return new StageBuilder();
    }

    public void applyTo(Stage stage) {
        super.applyTo(stage);
        int n = this.__set;
        if ((n & 1) != 0) {
            stage.setFullScreen(this.fullScreen);
        }
        if ((n & 2) != 0) {
            stage.setIconified(this.iconified);
        }
        if ((n & 4) != 0) {
            stage.getIcons().setAll(this.icons);
        }
        if ((n & 8) != 0) {
            stage.setResizable(this.resizable);
        }
        if ((n & 0x10) != 0) {
            stage.setScene(this.scene);
        }
        if ((n & 0x20) != 0) {
            stage.setTitle(this.title);
        }
    }

    public B fullScreen(boolean bl) {
        this.fullScreen = bl;
        this.__set |= 1;
        return (B)this;
    }

    public B iconified(boolean bl) {
        this.iconified = bl;
        this.__set |= 2;
        return (B)this;
    }

    public B icons(Collection<? extends Image> collection) {
        this.icons = collection;
        this.__set |= 4;
        return (B)this;
    }

    public B icons(Image ... imageArray) {
        return this.icons(Arrays.asList(imageArray));
    }

    public B resizable(boolean bl) {
        this.resizable = bl;
        this.__set |= 8;
        return (B)this;
    }

    public B scene(Scene scene) {
        this.scene = scene;
        this.__set |= 0x10;
        return (B)this;
    }

    public B style(StageStyle stageStyle) {
        this.style = stageStyle;
        return (B)this;
    }

    public B title(String string) {
        this.title = string;
        this.__set |= 0x20;
        return (B)this;
    }

    public Stage build() {
        Stage stage = new Stage(this.style);
        this.applyTo(stage);
        return stage;
    }
}

