/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.robot.impl.FXRobotHelper;
import com.sun.javafx.stage.StagePeerListener;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class Stage
extends Window {
    private boolean inNestedEventLoop = false;
    private static ObservableList<Stage> stages = FXCollections.observableArrayList();
    private boolean primary = false;
    private boolean important = true;
    private StageStyle style;
    private Modality modality = Modality.NONE;
    private Window owner = null;
    private ReadOnlyBooleanWrapper fullScreen;
    private ObservableList<Image> icons = new TrackableObservableList<Image>(){

        @Override
        protected void onChanged(ListChangeListener.Change<Image> change) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Image image : Stage.this.icons) {
                arrayList.add(image.impl_getPlatformImage());
            }
            if (Stage.this.impl_peer != null) {
                Stage.this.impl_peer.setIcons(arrayList);
            }
        }
    };
    private StringProperty title;
    private ReadOnlyBooleanWrapper iconified;
    private BooleanProperty resizable;
    private int focusGrabCounter;

    public Stage() {
        this(StageStyle.DECORATED);
    }

    public Stage(StageStyle stageStyle) {
        Toolkit.getToolkit().checkFxUserThread();
        this.initStyle(stageStyle);
    }

    @Override
    public final void setScene(Scene scene) {
        super.setScene(scene);
    }

    @Override
    public final void show() {
        super.show();
    }

    @Deprecated
    public void impl_setPrimary(boolean bl) {
        this.primary = bl;
    }

    boolean isPrimary() {
        return this.primary;
    }

    @Override
    @Deprecated
    public String impl_getMXWindowType() {
        return this.primary ? "PrimaryStage" : this.getClass().getSimpleName();
    }

    @Deprecated
    public void impl_setImportant(boolean bl) {
        this.important = bl;
    }

    private boolean isImportant() {
        return this.important;
    }

    @Deprecated
    public void impl_showAndWait() {
        Toolkit.getToolkit().checkFxUserThread();
        if (this.isPrimary()) {
            throw new IllegalStateException("Cannot call this method on primary stage");
        }
        if (this.isShowing()) {
            throw new IllegalStateException("Stage already visible");
        }
        this.show();
        this.inNestedEventLoop = true;
        Toolkit.getToolkit().enterNestedEventLoop();
    }

    public final void initStyle(StageStyle stageStyle) {
        if (this.hasBeenVisible) {
            throw new IllegalStateException("Cannot set style once stage has been set visible");
        }
        this.style = stageStyle;
    }

    public final StageStyle getStyle() {
        return this.style;
    }

    public final void initModality(Modality modality) {
        if (this.hasBeenVisible) {
            throw new IllegalStateException("Cannot set modality once stage has been set visible");
        }
        if (this.isPrimary()) {
            throw new IllegalStateException("Cannot set modality for the primary stage");
        }
        this.modality = modality;
    }

    public final Modality getModality() {
        return this.modality;
    }

    public final void initOwner(Window window) {
        if (this.hasBeenVisible) {
            throw new IllegalStateException("Cannot set owner once stage has been set visible");
        }
        if (this.isPrimary()) {
            throw new IllegalStateException("Cannot set owner for the primary stage");
        }
        this.owner = window;
    }

    public final Window getOwner() {
        return this.owner;
    }

    public final void setFullScreen(boolean bl) {
        Toolkit.getToolkit().checkFxUserThread();
        this.fullScreenPropertyImpl().set(bl);
    }

    public final boolean isFullScreen() {
        return this.fullScreen == null ? false : this.fullScreen.get();
    }

    public final ReadOnlyBooleanProperty fullScreenProperty() {
        return this.fullScreenPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper fullScreenPropertyImpl() {
        if (this.fullScreen == null) {
            this.fullScreen = new ReadOnlyBooleanWrapper(){

                @Override
                protected void invalidated() {
                    if (Stage.this.impl_peer != null) {
                        Stage.this.impl_peer.setFullScreen(this.get());
                    }
                }

                @Override
                public Object getBean() {
                    return Stage.this;
                }

                @Override
                public String getName() {
                    return "fullScreen";
                }
            };
        }
        return this.fullScreen;
    }

    public final ObservableList<Image> getIcons() {
        return this.icons;
    }

    public final void setTitle(String string) {
        this.titleProperty().set(string);
    }

    public final String getTitle() {
        return this.title == null ? null : (String)this.title.get();
    }

    public final StringProperty titleProperty() {
        if (this.title == null) {
            this.title = new StringPropertyBase(){

                @Override
                protected void invalidated() {
                    if (Stage.this.impl_peer != null) {
                        Stage.this.impl_peer.setTitle(this.get());
                    }
                }

                @Override
                public Object getBean() {
                    return Stage.this;
                }

                @Override
                public String getName() {
                    return "title";
                }
            };
        }
        return this.title;
    }

    public final void setIconified(boolean bl) {
        this.iconifiedPropertyImpl().set(bl);
    }

    public final boolean isIconified() {
        return this.iconified == null ? false : this.iconified.get();
    }

    public final ReadOnlyBooleanProperty iconifiedProperty() {
        return this.iconifiedPropertyImpl().getReadOnlyProperty();
    }

    private final ReadOnlyBooleanWrapper iconifiedPropertyImpl() {
        if (this.iconified == null) {
            this.iconified = new ReadOnlyBooleanWrapper(){

                @Override
                protected void invalidated() {
                    if (Stage.this.impl_peer != null) {
                        Stage.this.impl_peer.setIconified(this.get());
                    }
                }

                @Override
                public Object getBean() {
                    return Stage.this;
                }

                @Override
                public String getName() {
                    return "iconified";
                }
            };
        }
        return this.iconified;
    }

    public final void setResizable(boolean bl) {
        this.resizableProperty().set(bl);
    }

    public final boolean isResizable() {
        return this.resizable == null ? true : this.resizable.get();
    }

    public final BooleanProperty resizableProperty() {
        if (this.resizable == null) {
            this.resizable = new BooleanPropertyBase(true){

                @Override
                protected void invalidated() {
                    if (Stage.this.impl_peer != null) {
                        Stage.this.impl_peer.setResizable(this.get());
                    }
                }

                @Override
                public Object getBean() {
                    return Stage.this;
                }

                @Override
                public String getName() {
                    return "resizable";
                }
            };
        }
        return this.resizable;
    }

    @Override
    @Deprecated
    protected void impl_visibleChanging(boolean bl) {
        super.impl_visibleChanging(bl);
        Toolkit toolkit = Toolkit.getToolkit();
        if (bl && this.impl_peer == null) {
            Window window = this.getOwner();
            TKStage tKStage = window == null ? null : window.impl_getPeer();
            this.impl_peer = toolkit.createTKStage(this.getStyle(), this.isPrimary(), this.getModality(), tKStage);
            this.impl_peer.setImportant(this.isImportant());
            this.peerListener = new StagePeerListener(this);
            this.impl_peer.setResizable(this.isResizable());
            this.impl_peer.setFullScreen(this.isFullScreen());
            this.impl_peer.setIconified(this.isIconified());
            this.impl_peer.setTitle(this.getTitle());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Image image : this.icons) {
                arrayList.add(image.impl_getPlatformImage());
            }
            if (this.impl_peer != null) {
                this.impl_peer.setIcons(arrayList);
            }
            stages.add(this);
        }
    }

    @Override
    @Deprecated
    protected void impl_visibleChanged(boolean bl) {
        super.impl_visibleChanged(bl);
        if (!bl && this.impl_peer != null) {
            stages.remove(this);
            this.peerListener = null;
            this.impl_peer = null;
        }
        if (!bl && this.inNestedEventLoop) {
            this.inNestedEventLoop = false;
            Toolkit.getToolkit().exitNestedEventLoop();
        }
    }

    public void toFront() {
        if (this.impl_peer != null) {
            this.impl_peer.toFront();
        }
    }

    public void toBack() {
        if (this.impl_peer != null) {
            this.impl_peer.toBack();
        }
    }

    public void close() {
        this.hide();
    }

    @Deprecated
    public void impl_increaseFocusGrabCounter() {
        if (++this.focusGrabCounter == 1 && this.impl_peer != null && this.isFocused()) {
            this.impl_peer.grabFocus();
        }
    }

    @Deprecated
    public void impl_decreaseFocusGrabCounter() {
        if (--this.focusGrabCounter == 0 && this.impl_peer != null) {
            this.impl_peer.ungrabFocus();
        }
    }

    @Override
    void focusChanged(boolean bl) {
        if (this.focusGrabCounter > 0 && this.impl_peer != null && bl) {
            this.impl_peer.grabFocus();
        }
    }

    static {
        FXRobotHelper.setStageAccessor(new FXRobotHelper.FXRobotStageAccessor(){

            @Override
            public ObservableList<Stage> getStages() {
                return stages;
            }
        });
    }
}

