/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import com.sun.javafx.event.EventHandlerManager;
import com.sun.javafx.event.EventRedirector;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.stage.PopupEventRedirector;
import com.sun.javafx.stage.PopupWindowPeerListener;
import com.sun.javafx.stage.WindowCloseRequestHandler;
import com.sun.javafx.stage.WindowEventDispatcher;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public abstract class PopupWindow
extends Window {
    private final Group group;
    private final List<PopupWindow> children = new ArrayList<PopupWindow>();
    private ReadOnlyObjectWrapper<Window> ownerWindow = new ReadOnlyObjectWrapper(this, "ownerWindow");
    private ReadOnlyObjectWrapper<Node> ownerNode = new ReadOnlyObjectWrapper(this, "ownerNode");
    private BooleanProperty autoFix = new SimpleBooleanProperty(this, "autoFix", true);
    private BooleanProperty autoHide = new SimpleBooleanProperty(this, "autoHide");
    private ObjectProperty<EventHandler<Event>> onAutoHide = new SimpleObjectProperty<EventHandler<Event>>(this, "onAutoHide");
    private BooleanProperty hideOnEscape = new SimpleBooleanProperty(this, "hideOnEscape", true);
    private ChangeListener<Boolean> ownerFocusedListener;

    public PopupWindow() {
        this.group = new Group();
        this.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (PopupWindow.this.isAutoHide() && !bl2.booleanValue()) {
                    PopupWindow.this.doAutoHide();
                }
            }
        });
        this.group.layoutBoundsProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                PopupWindow.this.updateDimensions();
            }
        });
        Scene scene = new Scene(this.group);
        scene.setFill(null);
        this.updateDimensions();
        super.setScene(scene);
    }

    @Deprecated
    protected ObservableList<Node> getContent() {
        return this.group.getChildren();
    }

    public final Window getOwnerWindow() {
        return (Window)this.ownerWindow.get();
    }

    public final ReadOnlyObjectProperty<Window> ownerWindowProperty() {
        return this.ownerWindow.getReadOnlyProperty();
    }

    public final Node getOwnerNode() {
        return (Node)this.ownerNode.get();
    }

    public final ReadOnlyObjectProperty<Node> ownerNodeProperty() {
        return this.ownerNode.getReadOnlyProperty();
    }

    @Override
    protected final void setScene(Scene scene) {
        throw new UnsupportedOperationException();
    }

    public final void setAutoFix(boolean bl) {
        this.autoFix.set(bl);
    }

    public final boolean isAutoFix() {
        return this.autoFix.get();
    }

    public final BooleanProperty autoFixProperty() {
        return this.autoFix;
    }

    public final void setAutoHide(boolean bl) {
        this.autoHide.set(bl);
    }

    public final boolean isAutoHide() {
        return this.autoHide.get();
    }

    public final BooleanProperty autoHideProperty() {
        return this.autoHide;
    }

    public final void setOnAutoHide(EventHandler<Event> eventHandler) {
        this.onAutoHide.set(eventHandler);
    }

    public final EventHandler<Event> getOnAutoHide() {
        return (EventHandler)this.onAutoHide.get();
    }

    public final ObjectProperty<EventHandler<Event>> onAutoHideProperty() {
        return this.onAutoHide;
    }

    public final void setHideOnEscape(boolean bl) {
        this.hideOnEscape.set(bl);
    }

    public final boolean isHideOnEscape() {
        return this.hideOnEscape.get();
    }

    public final BooleanProperty hideOnEscapeProperty() {
        return this.hideOnEscape;
    }

    public void show(Window window) {
        Window window2;
        if (window == null) {
            throw new NullPointerException();
        }
        this.ownerWindow.set(window);
        if (window instanceof PopupWindow) {
            ((PopupWindow)window).children.add(this);
        }
        if ((window2 = this.getRootWindow()) != null && window2.isShowing()) {
            this.show();
            Bounds bounds = this.group.getLayoutBounds();
            if (this.isAutoFix()) {
                Screen screen = Screen.getScreenForPoint(this.getX(), this.getY());
                Rectangle2D rectangle2D = screen.getVisualBounds();
                double d = Math.min(this.getX(), rectangle2D.getMaxX() - this.getWidth());
                double d2 = Math.min(this.getY(), rectangle2D.getMaxY() - this.getHeight());
                d = Math.max(d, rectangle2D.getMinX());
                d2 = Math.max(d2, rectangle2D.getMinY());
                this.setX(d);
                this.setY(d2);
            } else {
                this.setX(this.getX() + bounds.getMinX());
                this.setY(this.getY() + bounds.getMinY());
            }
        }
    }

    public void show(Node node, double d, double d2) {
        Scene scene = node.getScene();
        if (scene == null || scene.getWindow() == null) {
            throw new IllegalStateException("The owner node needs to be associated with a window");
        }
        this.ownerNode.set(node);
        this.show(scene.getWindow(), d, d2);
    }

    public void show(Window window, double d, double d2) {
        this.setX(d);
        this.setY(d2);
        this.show(window);
    }

    @Override
    public void hide() {
        for (PopupWindow popupWindow : this.children) {
            if (!popupWindow.isShowing()) continue;
            popupWindow.hide();
        }
        this.children.clear();
        super.hide();
    }

    @Override
    @Deprecated
    protected void impl_visibleChanging(boolean bl) {
        super.impl_visibleChanging(bl);
        PerformanceTracker.logEvent("PopupWindow.storeVisible for [PopupWindow]");
        Toolkit toolkit = Toolkit.getToolkit();
        if (bl && this.impl_peer == null) {
            this.impl_peer = toolkit.createTKPopupStage(StageStyle.TRANSPARENT, this.getOwnerWindow().impl_getPeer());
            this.peerListener = new PopupWindowPeerListener(this);
        }
    }

    @Override
    @Deprecated
    protected void impl_visibleChanged(boolean bl) {
        super.impl_visibleChanged(bl);
        if (!bl && this.impl_peer != null) {
            this.peerListener = null;
            this.impl_peer = null;
        }
        Window window = this.getOwnerWindow();
        if (bl) {
            this.startMonitorOwnerEvents(window);
            this.bindOwnerFocusedProperty(window);
            this.setFocused(window.isFocused());
        } else {
            this.stopMonitorOwnerEvents(window);
            this.unbindOwnerFocusedProperty(window);
            this.setFocused(false);
        }
        PerformanceTracker.logEvent("PopupWindow.storeVisible for [PopupWindow] finished");
    }

    private void updateDimensions() {
        this.setWidth(this.group.getLayoutBounds().getMaxX() - this.group.getLayoutBounds().getMinX());
        this.setHeight(this.group.getLayoutBounds().getMaxY() - this.group.getLayoutBounds().getMinY());
        this.group.setTranslateX(-this.group.getLayoutBounds().getMinX());
        this.group.setTranslateY(-this.group.getLayoutBounds().getMinY());
    }

    private Window getRootWindow() {
        Window window = this.getOwnerWindow();
        while (window instanceof PopupWindow) {
            window = ((PopupWindow)window).getOwnerWindow();
        }
        return window;
    }

    @Deprecated
    public void doAutoHide() {
        this.hide();
        if (this.getOnAutoHide() != null) {
            this.getOnAutoHide().handle(new Event(this, this, Event.ANY));
        }
    }

    @Override
    WindowEventDispatcher createInternalEventDispatcher() {
        return new WindowEventDispatcher(new PopupEventRedirector(this), new WindowCloseRequestHandler(this), new EventHandlerManager(this));
    }

    private void startMonitorOwnerEvents(Window window) {
        EventRedirector eventRedirector = window.getInternalEventDispatcher().getEventRedirector();
        eventRedirector.addEventDispatcher(this.getEventDispatcher());
        if (window instanceof Stage) {
            ((Stage)window).impl_increaseFocusGrabCounter();
        }
    }

    private void stopMonitorOwnerEvents(Window window) {
        EventRedirector eventRedirector = window.getInternalEventDispatcher().getEventRedirector();
        eventRedirector.removeEventDispatcher(this.getEventDispatcher());
        if (window instanceof Stage) {
            ((Stage)window).impl_decreaseFocusGrabCounter();
        }
    }

    private void bindOwnerFocusedProperty(Window window) {
        this.ownerFocusedListener = new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                PopupWindow.this.setFocused(bl2);
            }
        };
        window.focusedProperty().addListener(this.ownerFocusedListener);
    }

    private void unbindOwnerFocusedProperty(Window window) {
        window.focusedProperty().removeListener(this.ownerFocusedListener);
        this.ownerFocusedListener = null;
    }
}

