/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.web;

import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.Toolkit;
import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.platform.LoadListenerClient;
import com.sun.webpane.platform.WebFrameID;
import com.sun.webpane.platform.WebPage;
import com.sun.webpane.sg.Accessor;
import com.sun.webpane.sg.ImplementationManager;
import com.sun.webpane.sg.PGWebView;
import com.sun.webpane.webkit.Timer;
import com.sun.webpane.webkit.network.Util;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import javafx.animation.AnimationTimer;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.PromptData;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import org.w3c.dom.Document;

public final class WebEngine {
    private final ObjectProperty<WebView> view = new SimpleObjectProperty<WebView>(this, "view");
    private final LoadWorker loadWorker = new LoadWorker();
    private final WebPage page;
    private final ReadOnlyObjectWrapper<Document> document = new ReadOnlyObjectWrapper(this, "document");
    private final ReadOnlyStringWrapper location = new ReadOnlyStringWrapper(this, "location");
    private final ReadOnlyStringWrapper title = new ReadOnlyStringWrapper(this, "title");
    private ObjectProperty<EventHandler<WebEvent<String>>> onAlert = new SimpleObjectProperty<EventHandler<WebEvent<String>>>(this, "onAlert");
    private ObjectProperty<EventHandler<WebEvent<String>>> onStatusChanged = new SimpleObjectProperty<EventHandler<WebEvent<String>>>(this, "onStatusChanged");
    private ObjectProperty<EventHandler<WebEvent<Rectangle2D>>> onResized = new SimpleObjectProperty<EventHandler<WebEvent<Rectangle2D>>>(this, "onResized");
    private ObjectProperty<EventHandler<WebEvent<Boolean>>> onVisibilityChanged = new SimpleObjectProperty<EventHandler<WebEvent<Boolean>>>(this, "onVisibilityChanged");
    private ObjectProperty<Callback<PopupFeatures, WebEngine>> createPopupHandler = new SimpleObjectProperty<2>(this, "createPopupHandler", new Callback<PopupFeatures, WebEngine>(){

        @Override
        public WebEngine call(PopupFeatures popupFeatures) {
            return WebEngine.this;
        }
    });
    private ObjectProperty<Callback<String, Boolean>> confirmHandler = new SimpleObjectProperty<Callback<String, Boolean>>(this, "confirmHandler");
    private ObjectProperty<Callback<PromptData, String>> promptHandler = new SimpleObjectProperty<Callback<PromptData, String>>(this, "promptHandler");

    public final Worker<Void> getLoadWorker() {
        return this.loadWorker;
    }

    public final Document getDocument() {
        return (Document)this.document.getValue();
    }

    public final ReadOnlyObjectProperty<Document> documentProperty() {
        return this.document.getReadOnlyProperty();
    }

    private void updateDocument() {
        this.document.set(this.page.getDocument(this.page.getMainFrame()));
    }

    public final String getLocation() {
        return this.location.getValue();
    }

    public final ReadOnlyStringProperty locationProperty() {
        return this.location.getReadOnlyProperty();
    }

    private void updateLocation(String string) {
        this.location.set(string);
        this.document.set(null);
        this.title.set(null);
    }

    public final String getTitle() {
        return this.title.getValue();
    }

    public final ReadOnlyStringProperty titleProperty() {
        return this.title.getReadOnlyProperty();
    }

    private void updateTitle() {
        this.title.set(this.page.getTitle(this.page.getMainFrame()));
    }

    public final EventHandler<WebEvent<String>> getOnAlert() {
        return (EventHandler)this.onAlert.get();
    }

    public final void setOnAlert(EventHandler<WebEvent<String>> eventHandler) {
        this.onAlert.set(eventHandler);
    }

    public final ObjectProperty<EventHandler<WebEvent<String>>> onAlertProperty() {
        return this.onAlert;
    }

    public final EventHandler<WebEvent<String>> getOnStatusChanged() {
        return (EventHandler)this.onStatusChanged.get();
    }

    public final void setOnStatusChanged(EventHandler<WebEvent<String>> eventHandler) {
        this.onStatusChanged.set(eventHandler);
    }

    public final ObjectProperty<EventHandler<WebEvent<String>>> onStatusChangedProperty() {
        return this.onStatusChanged;
    }

    public final EventHandler<WebEvent<Rectangle2D>> getOnResized() {
        return (EventHandler)this.onResized.get();
    }

    public final void setOnResized(EventHandler<WebEvent<Rectangle2D>> eventHandler) {
        this.onResized.set(eventHandler);
    }

    public final ObjectProperty<EventHandler<WebEvent<Rectangle2D>>> onResizedProperty() {
        return this.onResized;
    }

    public final EventHandler<WebEvent<Boolean>> getOnVisibilityChanged() {
        return (EventHandler)this.onVisibilityChanged.get();
    }

    public final void setOnVisibilityChanged(EventHandler<WebEvent<Boolean>> eventHandler) {
        this.onVisibilityChanged.set(eventHandler);
    }

    public final ObjectProperty<EventHandler<WebEvent<Boolean>>> onVisibilityChangedProperty() {
        return this.onVisibilityChanged;
    }

    public final Callback<PopupFeatures, WebEngine> getCreatePopupHandler() {
        return (Callback)this.createPopupHandler.get();
    }

    public final void setCreatePopupHandler(Callback<PopupFeatures, WebEngine> callback) {
        this.createPopupHandler.set(callback);
    }

    public final ObjectProperty<Callback<PopupFeatures, WebEngine>> createPopupHandlerProperty() {
        return this.createPopupHandler;
    }

    public final Callback<String, Boolean> getConfirmHandler() {
        return (Callback)this.confirmHandler.get();
    }

    public final void setConfirmHandler(Callback<String, Boolean> callback) {
        this.confirmHandler.set(callback);
    }

    public final ObjectProperty<Callback<String, Boolean>> confirmHandlerProperty() {
        return this.confirmHandler;
    }

    public final Callback<PromptData, String> getPromptHandler() {
        return (Callback)this.promptHandler.get();
    }

    public final void setPromptHandler(Callback<PromptData, String> callback) {
        this.promptHandler.set(callback);
    }

    public final ObjectProperty<Callback<PromptData, String>> promptHandlerProperty() {
        return this.promptHandler;
    }

    public WebEngine() {
        this(null);
    }

    public WebEngine(String string) {
        if (WebPage.getInstanceCount() == 0 && Timer.getMode() == Timer.Mode.PLATFORM_TICKS) {
            PulseTimer.start();
        }
        AccessorImpl accessorImpl = new AccessorImpl(this);
        this.page = ImplementationManager.createPage(accessorImpl);
        this.page.addLoadListenerClient(new PageLoadListener(this));
        Disposer.addRecord(this, new SelfDisposer(this.page));
        this.load(string);
    }

    public void load(String string) {
        WebEngine.checkThread();
        this.loadWorker.cancelAndReset();
        if (string == null) {
            string = "";
        } else {
            try {
                string = Util.adjustUrlForWebKit(string);
            }
            catch (MalformedURLException malformedURLException) {
                this.loadWorker.dispatchLoadEvent(this.getMainFrame(), 0, string, null, 0.0, 0);
                this.loadWorker.dispatchLoadEvent(this.getMainFrame(), 5, string, null, 0.0, 2);
            }
        }
        this.page.open(this.page.getMainFrame(), string);
    }

    public void loadContent(String string) {
        this.loadContent(string, "text/html");
    }

    public void loadContent(String string, String string2) {
        WebEngine.checkThread();
        this.loadWorker.cancelAndReset();
        this.page.load(this.page.getMainFrame(), string, string2);
    }

    public void reload() {
        WebEngine.checkThread();
        this.page.refresh(this.page.getMainFrame());
    }

    public Object executeScript(String string) {
        WebEngine.checkThread();
        return this.page.executeScript(this.page.getMainFrame(), string);
    }

    private WebFrameID getMainFrame() {
        return this.page.getMainFrame();
    }

    WebPage getPage() {
        return this.page;
    }

    void setView(WebView webView) {
        this.view.setValue(webView);
    }

    private void stop() {
        WebEngine.checkThread();
        this.page.stop(this.page.getMainFrame());
    }

    static void checkThread() {
        Toolkit.getToolkit().checkFxUserThread();
    }

    static {
        Accessor.setPageAccessor(new Accessor.PageAccessor(){

            @Override
            public WebPage getPage(WebEngine webEngine) {
                return webEngine == null ? null : webEngine.getPage();
            }
        });
    }

    private class LoadWorker
    implements Worker<Void> {
        private ReadOnlyObjectWrapper<Worker.State> state = new ReadOnlyObjectWrapper<Worker.State>(this, "state", Worker.State.READY);
        private ReadOnlyObjectWrapper<Void> value = new ReadOnlyObjectWrapper(this, "value");
        private ReadOnlyObjectWrapper<Throwable> exception = new ReadOnlyObjectWrapper(this, "exception");
        private ReadOnlyDoubleWrapper workDone = new ReadOnlyDoubleWrapper(this, "workDone", -1.0);
        private ReadOnlyDoubleWrapper totalWorkToBeDone = new ReadOnlyDoubleWrapper(this, "totalWork", -1.0);
        private ReadOnlyDoubleWrapper progress = new ReadOnlyDoubleWrapper(this, "progress", -1.0);
        private ReadOnlyBooleanWrapper running = new ReadOnlyBooleanWrapper(this, "running", false);
        private ReadOnlyStringWrapper message = new ReadOnlyStringWrapper(this, "message", "");
        private ReadOnlyStringWrapper title = new ReadOnlyStringWrapper(this, "title", "WebEngine Loader");

        private LoadWorker() {
        }

        @Override
        public final Worker.State getState() {
            WebEngine.checkThread();
            return (Worker.State)((Object)this.state.get());
        }

        @Override
        public final ReadOnlyObjectProperty<Worker.State> stateProperty() {
            WebEngine.checkThread();
            return this.state.getReadOnlyProperty();
        }

        private final void updateState(Worker.State state) {
            WebEngine.checkThread();
            this.state.set(state);
            this.running.set(state == Worker.State.SCHEDULED || state == Worker.State.RUNNING);
        }

        @Override
        public final Void getValue() {
            WebEngine.checkThread();
            return (Void)this.value.get();
        }

        @Override
        public final ReadOnlyObjectProperty<Void> valueProperty() {
            WebEngine.checkThread();
            return this.value.getReadOnlyProperty();
        }

        @Override
        public final Throwable getException() {
            WebEngine.checkThread();
            return (Throwable)this.exception.get();
        }

        @Override
        public final ReadOnlyObjectProperty<Throwable> exceptionProperty() {
            WebEngine.checkThread();
            return this.exception.getReadOnlyProperty();
        }

        @Override
        public final double getWorkDone() {
            WebEngine.checkThread();
            return this.workDone.get();
        }

        @Override
        public final ReadOnlyDoubleProperty workDoneProperty() {
            WebEngine.checkThread();
            return this.workDone.getReadOnlyProperty();
        }

        private void updateWorkDone(long l, long l2) {
            this.totalWorkToBeDone.set(l2);
            this.workDone.set(l);
            if (l == -1L) {
                this.progress.set(-1.0);
            } else {
                this.progress.set(l / l2);
            }
        }

        @Override
        public final double getTotalWork() {
            WebEngine.checkThread();
            return this.totalWorkToBeDone.get();
        }

        @Override
        public final ReadOnlyDoubleProperty totalWorkProperty() {
            WebEngine.checkThread();
            return this.totalWorkToBeDone.getReadOnlyProperty();
        }

        @Override
        public final double getProgress() {
            WebEngine.checkThread();
            return this.progress.get();
        }

        @Override
        public final ReadOnlyDoubleProperty progressProperty() {
            WebEngine.checkThread();
            return this.progress.getReadOnlyProperty();
        }

        @Override
        public final boolean isRunning() {
            WebEngine.checkThread();
            return this.running.get();
        }

        @Override
        public final ReadOnlyBooleanProperty runningProperty() {
            WebEngine.checkThread();
            return this.running.getReadOnlyProperty();
        }

        @Override
        public final String getMessage() {
            return this.message.get();
        }

        @Override
        public final ReadOnlyStringProperty messageProperty() {
            return this.message.getReadOnlyProperty();
        }

        @Override
        public final String getTitle() {
            return this.title.get();
        }

        @Override
        public final ReadOnlyStringProperty titleProperty() {
            return this.title.getReadOnlyProperty();
        }

        @Override
        public boolean cancel() {
            if (this.isRunning()) {
                WebEngine.this.stop();
                return true;
            }
            return false;
        }

        private void cancelAndReset() {
            this.cancel();
            this.updateState(Worker.State.READY);
            this.value.set(null);
            this.exception.set(null);
            this.workDone.set(-1.0);
            this.totalWorkToBeDone.set(-1.0);
            this.progress.set(-1.0);
            this.running.set(false);
        }

        private void dispatchLoadEvent(WebFrameID webFrameID, int n, String string, String string2, double d, int n2) {
            if (!webFrameID.equals(WebEngine.this.getMainFrame())) {
                return;
            }
            switch (n) {
                case 0: {
                    this.configure(n, n2, 0.0);
                }
                case 2: {
                    WebEngine.this.updateLocation(string);
                    this.message.set("Loading " + string);
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 30: {
                    this.configure(n, n2, d);
                    break;
                }
                case 11: {
                    WebEngine.this.updateTitle();
                    break;
                }
                case 14: {
                    WebEngine.this.updateDocument();
                }
            }
        }

        void configure(int n, int n2, double d) {
            switch (n) {
                case 0: {
                    this.updateState(Worker.State.SCHEDULED);
                    this.updateState(Worker.State.RUNNING);
                    this.updateWorkDone(0L, 100L);
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    this.updateState(Worker.State.SUCCEEDED);
                    this.updateWorkDone(100L, 100L);
                    break;
                }
                case 5: {
                    this.updateState(Worker.State.FAILED);
                    this.exception.set(this.describeError(n2));
                    break;
                }
                case 6: {
                    this.updateState(Worker.State.CANCELLED);
                    break;
                }
                case 30: {
                    this.updateWorkDone((long)(d * 100.0), 100L);
                    break;
                }
                default: {
                    assert (false) : "Unknown state " + n;
                    break;
                }
            }
        }

        Throwable describeError(int n) {
            String string = "Unknown error";
            switch (n) {
                case 1: {
                    string = "Unknown host";
                    break;
                }
                case 2: {
                    string = "Malformed URL";
                    break;
                }
                case 3: {
                    string = "SSL handshake failed";
                    break;
                }
                case 4: {
                    string = "Connection refused by server";
                    break;
                }
                case 5: {
                    string = "Connection reset by server";
                    break;
                }
                case 6: {
                    string = "No route to host";
                    break;
                }
                case 7: {
                    string = "Connection timed out";
                    break;
                }
                case 8: {
                    string = "Permission denied";
                    break;
                }
                case 9: {
                    string = "Invalid response from server";
                    break;
                }
                case 10: {
                    string = "Too many redirects";
                }
            }
            return new Throwable(string);
        }
    }

    private static class PageLoadListener
    implements LoadListenerClient {
        private WeakReference<WebEngine> engine;

        PageLoadListener(WebEngine webEngine) {
            this.engine = new WeakReference<WebEngine>(webEngine);
        }

        @Override
        public void dispatchLoadEvent(WebFrameID webFrameID, int n, String string, String string2, double d, int n2) {
            WebEngine webEngine = (WebEngine)this.engine.get();
            if (webEngine != null) {
                webEngine.loadWorker.dispatchLoadEvent(webFrameID, n, string, string2, d, n2);
            }
        }

        @Override
        public void dispatchResourceLoadEvent(WebFrameID webFrameID, int n, String string, String string2, double d, int n2) {
        }
    }

    private static class PulseTimer {
        private static AnimationTimer animation = new AnimationTimer(){

            @Override
            public void handle(long l) {
            }
        };
        private static TKPulseListener listener = new TKPulseListener(){

            @Override
            public void pulse() {
                Timer.getTimer().notifyTick();
            }
        };

        private PulseTimer() {
        }

        public static void start() {
            Toolkit.getToolkit().addSceneTkPulseListener(listener);
            animation.start();
        }

        public static void stop() {
            Toolkit.getToolkit().removeSceneTkPulseListener(listener);
            animation.stop();
        }
    }

    private static class AccessorImpl
    extends Accessor {
        private WeakReference<WebEngine> engine;

        public AccessorImpl(WebEngine webEngine) {
            this.engine = new WeakReference<WebEngine>(webEngine);
        }

        @Override
        public WebEngine getEngine() {
            return (WebEngine)this.engine.get();
        }

        @Override
        public WebPage getPage() {
            WebEngine webEngine = this.getEngine();
            return webEngine == null ? null : webEngine.page;
        }

        @Override
        public WebView getView() {
            WebEngine webEngine = this.getEngine();
            return webEngine == null ? null : (WebView)webEngine.view.get();
        }

        @Override
        public PGWebView getPGView() {
            WebView webView = this.getView();
            return webView == null ? null : webView.getPGWebView();
        }

        @Override
        public void addChild(Node node) {
            WebView webView = this.getView();
            if (webView != null) {
                webView.getChildren().add(node);
            }
        }

        @Override
        public void removeChild(Node node) {
            WebView webView = this.getView();
            if (webView != null) {
                webView.getChildren().remove(node);
            }
        }

        @Override
        public void addViewListener(InvalidationListener invalidationListener) {
            WebEngine webEngine = this.getEngine();
            if (webEngine != null) {
                webEngine.view.addListener(invalidationListener);
            }
        }
    }

    private static class SelfDisposer
    implements DisposerRecord {
        WebPage page;

        SelfDisposer(WebPage webPage) {
            this.page = webPage;
        }

        @Override
        public void dispose() {
            this.page.dispose();
            if (WebPage.getInstanceCount() == 0 && Timer.getMode() == Timer.Mode.PLATFORM_TICKS) {
                PulseTimer.stop();
            }
        }
    }
}

