/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.PGArc;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.tk.Toolkit;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Shape;

public class Arc
extends Shape {
    private final Arc2D shape = new Arc2D();
    private DoubleProperty centerX;
    private DoubleProperty centerY;
    private DoubleProperty radiusX;
    private DoubleProperty radiusY;
    private DoubleProperty startAngle;
    private DoubleProperty length;
    private ObjectProperty<ArcType> type;

    static PGArc.ArcType toPGArcType(ArcType arcType) {
        switch (arcType) {
            case OPEN: {
                return PGArc.ArcType.OPEN;
            }
            case CHORD: {
                return PGArc.ArcType.CHORD;
            }
        }
        return PGArc.ArcType.ROUND;
    }

    public Arc() {
    }

    public Arc(double d, double d2, double d3, double d4, double d5, double d6) {
        this.setCenterX(d);
        this.setCenterY(d2);
        this.setRadiusX(d3);
        this.setRadiusY(d4);
        this.setStartAngle(d5);
        this.setLength(d6);
    }

    public final void setCenterX(double d) {
        this.centerXProperty().set(d);
    }

    public final double getCenterX() {
        return this.centerX == null ? 0.0 : this.centerX.get();
    }

    public final DoubleProperty centerXProperty() {
        if (this.centerX == null) {
            this.centerX = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Arc.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Arc.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Arc.this;
                }

                @Override
                public String getName() {
                    return "centerX";
                }
            };
        }
        return this.centerX;
    }

    public final void setCenterY(double d) {
        this.centerYProperty().set(d);
    }

    public final double getCenterY() {
        return this.centerY == null ? 0.0 : this.centerY.get();
    }

    public final DoubleProperty centerYProperty() {
        if (this.centerY == null) {
            this.centerY = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Arc.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Arc.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Arc.this;
                }

                @Override
                public String getName() {
                    return "centerY";
                }
            };
        }
        return this.centerY;
    }

    public final void setRadiusX(double d) {
        this.radiusXProperty().set(d);
    }

    public final double getRadiusX() {
        return this.radiusX == null ? 0.0 : this.radiusX.get();
    }

    public final DoubleProperty radiusXProperty() {
        if (this.radiusX == null) {
            this.radiusX = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Arc.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Arc.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Arc.this;
                }

                @Override
                public String getName() {
                    return "radiusX";
                }
            };
        }
        return this.radiusX;
    }

    public final void setRadiusY(double d) {
        this.radiusYProperty().set(d);
    }

    public final double getRadiusY() {
        return this.radiusY == null ? 0.0 : this.radiusY.get();
    }

    public final DoubleProperty radiusYProperty() {
        if (this.radiusY == null) {
            this.radiusY = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Arc.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Arc.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Arc.this;
                }

                @Override
                public String getName() {
                    return "radiusY";
                }
            };
        }
        return this.radiusY;
    }

    public final void setStartAngle(double d) {
        this.startAngleProperty().set(d);
    }

    public final double getStartAngle() {
        return this.startAngle == null ? 0.0 : this.startAngle.get();
    }

    public final DoubleProperty startAngleProperty() {
        if (this.startAngle == null) {
            this.startAngle = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Arc.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Arc.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Arc.this;
                }

                @Override
                public String getName() {
                    return "startAngle";
                }
            };
        }
        return this.startAngle;
    }

    public final void setLength(double d) {
        this.lengthProperty().set(d);
    }

    public final double getLength() {
        return this.length == null ? 0.0 : this.length.get();
    }

    public final DoubleProperty lengthProperty() {
        if (this.length == null) {
            this.length = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Arc.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Arc.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Arc.this;
                }

                @Override
                public String getName() {
                    return "length";
                }
            };
        }
        return this.length;
    }

    public final void setType(ArcType arcType) {
        this.typeProperty().set(arcType);
    }

    public final ArcType getType() {
        return this.type == null ? ArcType.OPEN : (ArcType)((Object)this.type.get());
    }

    public final ObjectProperty<ArcType> typeProperty() {
        if (this.type == null) {
            this.type = new ObjectPropertyBase<ArcType>(ArcType.OPEN){

                @Override
                public void invalidated() {
                    Arc.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Arc.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Arc.this;
                }

                @Override
                public String getName() {
                    return "type";
                }
            };
        }
        return this.type;
    }

    @Override
    @Deprecated
    protected PGNode impl_createPGNode() {
        return Toolkit.getToolkit().createPGArc();
    }

    PGArc getPGArc() {
        return (PGArc)this.impl_getPGNode();
    }

    @Override
    @Deprecated
    public Arc2D impl_configShape() {
        int n;
        switch (this.getType()) {
            case OPEN: {
                n = 0;
                break;
            }
            case CHORD: {
                n = 1;
                break;
            }
            default: {
                n = 2;
            }
        }
        this.shape.setArc((float)(this.getCenterX() - this.getRadiusX()), (float)(this.getCenterY() - this.getRadiusY()), (float)(this.getRadiusX() * 2.0), (float)(this.getRadiusY() * 2.0), (float)this.getStartAngle(), (float)this.getLength(), n);
        return this.shape;
    }

    @Override
    @Deprecated
    public void impl_updatePG() {
        super.impl_updatePG();
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            PGArc pGArc = this.getPGArc();
            pGArc.updateArc((float)this.getCenterX(), (float)this.getCenterY(), (float)this.getRadiusX(), (float)this.getRadiusY(), (float)this.getStartAngle(), (float)this.getLength(), Arc.toPGArcType(this.getType()));
        }
    }
}

