/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.paint;

import com.sun.javafx.tk.Toolkit;
import java.util.Collections;
import java.util.List;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;

public final class LinearGradient
extends Paint {
    private double startX;
    private double startY;
    private double endX;
    private double endY;
    private boolean proportional;
    private CycleMethod cycleMethod;
    private List<Stop> stops;
    private Object platformPaint;
    private int hash;

    public final double getStartX() {
        return this.startX;
    }

    public final double getStartY() {
        return this.startY;
    }

    public final double getEndX() {
        return this.endX;
    }

    public final double getEndY() {
        return this.endY;
    }

    public final boolean isProportional() {
        return this.proportional;
    }

    public final CycleMethod getCycleMethod() {
        return this.cycleMethod;
    }

    public final List<Stop> getStops() {
        return this.stops;
    }

    public LinearGradient(double d, double d2, double d3, double d4, boolean bl, CycleMethod cycleMethod, Stop ... stopArray) {
        this.startX = d;
        this.startY = d2;
        this.endX = d3;
        this.endY = d4;
        this.proportional = bl;
        this.cycleMethod = cycleMethod == null ? CycleMethod.NO_CYCLE : cycleMethod;
        this.stops = Collections.unmodifiableList(LinearGradient.getNonNullStops(stopArray));
    }

    public LinearGradient(double d, double d2, double d3, double d4, boolean bl, CycleMethod cycleMethod, List<Stop> list) {
        this.startX = d;
        this.startY = d2;
        this.endX = d3;
        this.endY = d4;
        this.proportional = bl;
        this.cycleMethod = cycleMethod == null ? CycleMethod.NO_CYCLE : cycleMethod;
        this.stops = Collections.unmodifiableList(LinearGradient.getNonNullStops(list.toArray(new Stop[list.size()])));
    }

    @Override
    @Deprecated
    public Object impl_getPlatformPaint() {
        if (this.platformPaint == null) {
            this.platformPaint = Toolkit.getToolkit().getPaint((Paint)this);
        }
        return this.platformPaint;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof LinearGradient) {
            LinearGradient linearGradient = (LinearGradient)object;
            if (this.startX != linearGradient.startX || this.startY != linearGradient.startY || this.endX != linearGradient.endX || this.endY != linearGradient.endY || this.proportional != linearGradient.proportional || this.cycleMethod != linearGradient.cycleMethod) {
                return false;
            }
            return ((Object)this.stops).equals(linearGradient.stops);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long l = 17L;
            l = 37L * l + Double.doubleToLongBits(this.startX);
            l = 37L * l + Double.doubleToLongBits(this.startY);
            l = 37L * l + Double.doubleToLongBits(this.endX);
            l = 37L * l + Double.doubleToLongBits(this.endY);
            l = 37L * l + (this.proportional ? 1231L : 1237L);
            l = 37L * l + (long)this.cycleMethod.hashCode();
            for (Stop stop : this.stops) {
                l = 37L * l + (long)stop.hashCode();
            }
            this.hash = (int)(l ^ l >> 32);
        }
        return this.hash;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("LinearGradient[startX=").append(this.startX).append(",startY=").append(this.startY).append(",endX=").append(this.endX).append(",endY=").append(this.endY).append(",proportional=").append(this.proportional).append(",cycleMethod=").append((Object)this.cycleMethod).append(",stops=<");
        if (this.stops.isEmpty()) {
            stringBuilder.append("empty");
        } else {
            for (Stop stop : this.stops) {
                stringBuilder.append(stop).append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(">]");
        return stringBuilder.toString();
    }
}

