/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;

public class HBox
extends Pane {
    private static final String MARGIN_CONSTRAINT = "hbox-margin";
    private static final String HGROW_CONSTRAINT = "hbox-hgrow";
    @Styleable(property="-fx-spacing", initial="0")
    private DoubleProperty spacing;
    @Styleable(property="-fx-alignment", initial="top-left")
    private ObjectProperty<Pos> alignment;
    @Styleable(property="-fx-fill-height", initial="true")
    private BooleanProperty fillHeight;
    private double[] areaWidths;

    public static void setHgrow(Node node, Priority priority) {
        HBox.setConstraint(node, HGROW_CONSTRAINT, (Object)priority);
    }

    public static Priority getHgrow(Node node) {
        return (Priority)((Object)HBox.getConstraint(node, HGROW_CONSTRAINT));
    }

    public static void setMargin(Node node, Insets insets) {
        HBox.setConstraint(node, MARGIN_CONSTRAINT, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)HBox.getConstraint(node, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node node) {
        HBox.setHgrow(node, null);
        HBox.setMargin(node, null);
    }

    public HBox() {
    }

    public HBox(double d) {
        this();
        this.setSpacing(d);
    }

    public final DoubleProperty spacingProperty() {
        if (this.spacing == null) {
            this.spacing = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    HBox.this.requestLayout();
                    HBox.this.impl_cssPropertyInvalidated(StyleableProperties.SPACING);
                }

                @Override
                public Object getBean() {
                    return HBox.this;
                }

                @Override
                public String getName() {
                    return "spacing";
                }
            };
        }
        return this.spacing;
    }

    public final void setSpacing(double d) {
        this.spacingProperty().set(d);
    }

    public final double getSpacing() {
        return this.spacing == null ? 0.0 : this.spacing.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new ObjectPropertyBase<Pos>(Pos.TOP_LEFT){

                @Override
                public void invalidated() {
                    HBox.this.requestLayout();
                    HBox.this.impl_cssPropertyInvalidated(StyleableProperties.ALIGNMENT);
                }

                @Override
                public Object getBean() {
                    return HBox.this;
                }

                @Override
                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.TOP_LEFT : (Pos)((Object)this.alignment.get());
    }

    public final BooleanProperty fillHeightProperty() {
        if (this.fillHeight == null) {
            this.fillHeight = new BooleanPropertyBase(true){

                @Override
                public void invalidated() {
                    HBox.this.requestLayout();
                    HBox.this.impl_cssPropertyInvalidated(StyleableProperties.FILL_HEIGHT);
                }

                @Override
                public Object getBean() {
                    return HBox.this;
                }

                @Override
                public String getName() {
                    return "fillHeight";
                }
            };
        }
        return this.fillHeight;
    }

    public final void setFillHeight(boolean bl) {
        this.fillHeightProperty().set(bl);
    }

    public final boolean isFillHeight() {
        return this.fillHeight == null ? true : this.fillHeight.get();
    }

    private boolean shouldFillHeight() {
        return this.isFillHeight() && this.getAlignment().getVpos() != VPos.BASELINE;
    }

    @Override
    public Orientation getContentBias() {
        if (this.shouldFillHeight()) {
            for (int i = 0; i < this.getChildren().size(); ++i) {
                Node node = (Node)this.getChildren().get(i);
                if (!node.isManaged() || node.getContentBias() != Orientation.VERTICAL) continue;
                return Orientation.VERTICAL;
            }
        }
        return null;
    }

    @Override
    protected double computeMinWidth(double d) {
        return this.getInsets().getLeft() + this.computeContentWidth(this.getAreaWidths(true, d)) + this.getInsets().getRight();
    }

    @Override
    protected double computeMinHeight(double d) {
        List<Node> list = this.getManagedChildren();
        return this.getInsets().getTop() + this.computeMaxMinAreaHeight(list, this.getMargins(list), this.getAlignment().getVpos()) + this.getInsets().getBottom();
    }

    @Override
    protected double computePrefWidth(double d) {
        return this.getInsets().getLeft() + this.computeContentWidth(this.getAreaWidths(false, d)) + this.getInsets().getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        List<Node> list = this.getManagedChildren();
        return this.getInsets().getTop() + this.computeMaxPrefAreaHeight(list, this.getMargins(list), this.getAlignment().getVpos()) + this.getInsets().getBottom();
    }

    private Insets[] getMargins(List<Node> list) {
        Insets[] insetsArray = new Insets[list.size()];
        for (int i = 0; i < insetsArray.length; ++i) {
            insetsArray[i] = HBox.getMargin(list.get(i));
        }
        return insetsArray;
    }

    private double[] getAreaWidths(boolean bl, double d) {
        List list = this.getManagedChildren();
        double[] dArray = new double[list.size()];
        double d2 = (d == -1.0 ? this.prefHeight(-1.0) : d) - this.snapSpace(this.getInsets().getTop()) - this.snapSpace(this.getInsets().getBottom());
        for (int i = 0; i < list.size(); ++i) {
            Node node = (Node)list.get(i);
            Insets insets = HBox.getMargin(node);
            dArray[i] = bl ? this.computeChildMinAreaWidth(node, insets, this.shouldFillHeight() ? d2 : node.minHeight(-1.0)) : this.computeChildPrefAreaWidth(node, insets, this.shouldFillHeight() ? d2 : node.prefHeight(-1.0));
        }
        return dArray;
    }

    private double computeContentWidth(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d + (double)(dArray.length - 1) * this.snapSpace(this.getSpacing());
    }

    @Override
    protected void layoutChildren() {
        double d;
        List<Node> list = this.getManagedChildren();
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        double d4 = this.getInsets().getTop();
        double d5 = this.getInsets().getLeft();
        double d6 = this.getInsets().getBottom();
        double d7 = this.getInsets().getRight();
        double d8 = this.snapSpace(this.getSpacing());
        double d9 = d2 - d5 - d7;
        double d10 = d3 - d4 - d6;
        this.areaWidths = this.getAreaWidths(false, d3);
        double d11 = this.computeContentWidth(this.areaWidths);
        double d12 = d10;
        double d13 = d9 - d11;
        if (d13 != 0.0) {
            d = this.adjustAreaWidths(list, Priority.ALWAYS, d13, this.shouldFillHeight() ? d10 : -1.0);
            d = this.adjustAreaWidths(list, Priority.SOMETIMES, d, this.shouldFillHeight() ? d10 : -1.0);
            d11 += d13 - d;
        }
        d = d5 + HBox.computeXOffset(d9, d11, this.getAlignment().getHpos());
        double d14 = d4;
        double d15 = this.getAlignment().getVpos() == VPos.BASELINE ? HBox.getMaxBaselineOffset(list) : d3 / 2.0;
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            Insets insets = HBox.getMargin(node);
            this.layoutInArea(node, d, d14, this.areaWidths[i], d12, d15, insets, true, this.shouldFillHeight(), this.getAlignment().getHpos(), this.getAlignment().getVpos());
            d += this.areaWidths[i] + d8;
        }
    }

    private double adjustAreaWidths(List<Node> list, Priority priority, double d, double d2) {
        Node[] nodeArray;
        boolean bl = d < 0.0;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            if (!bl && HBox.getHgrow(node) != priority) continue;
            arrayList.add(node);
            arrayList2.add(node);
        }
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            Node node = (Node)arrayList.get(i);
            nodeArray = HBox.getMargin(node);
            dArray[i] = bl ? this.computeChildMinAreaWidth(node, (Insets)nodeArray, d2) : this.computeChildMaxAreaWidth(node, (Insets)nodeArray, d2);
        }
        double d3 = d;
        while (Math.abs(d3) > 1.0 && arrayList2.size() > 0) {
            nodeArray = new Node[arrayList.size()];
            double d4 = d3 / (double)arrayList2.size();
            for (int i = 0; i < arrayList2.size(); ++i) {
                Node node = (Node)arrayList2.get(i);
                int n = list.indexOf(node);
                double d5 = dArray[arrayList.indexOf(node)] - this.areaWidths[n];
                double d6 = Math.abs(d5) <= Math.abs(d4) ? d5 : d4;
                int n2 = n;
                this.areaWidths[n2] = this.areaWidths[n2] + d6;
                d3 -= d6;
                if (!(Math.abs(d6) < Math.abs(d4))) continue;
                nodeArray[i] = node;
            }
            for (Node node : nodeArray) {
                if (node == null) continue;
                arrayList2.remove(node);
            }
        }
        return d3;
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-alignment".equals(string)) {
            this.setAlignment((Pos)((Object)object));
        } else if ("-fx-fill-height".equals(string)) {
            this.setFillHeight((Boolean)object);
        } else if ("-fx-spacing".equals(string)) {
            this.setSpacing((Double)object);
        } else {
            return super.impl_cssSet(string, object);
        }
        return true;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-alignment".equals(string)) {
            return this.alignment == null || !this.alignment.isBound();
        }
        if ("-fx-fill-height".equals(string)) {
            return this.fillHeight == null || !this.fillHeight.isBound();
        }
        if ("-fx-spacing".equals(string)) {
            return this.spacing == null || !this.spacing.isBound();
        }
        return super.impl_cssSettable(string);
    }

    private static class StyleableProperties {
        private static final StyleableProperty ALIGNMENT = new StyleableProperty(HBox.class, "alignment");
        private static final StyleableProperty FILL_HEIGHT = new StyleableProperty(HBox.class, "fillHeight");
        private static final StyleableProperty SPACING = new StyleableProperty(HBox.class, "spacing");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Pane.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, FILL_HEIGHT, ALIGNMENT, SPACING);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

