/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.scene.control.WeakListChangeListener;
import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;

public class TreeCell<T>
extends IndexedCell<T> {
    private final InvalidationListener indexListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TreeCell.this.updateItem();
            TreeCell.this.updateSelection();
            TreeCell.this.updateFocus();
        }
    };
    private final ListChangeListener selectedListener = new ListChangeListener(){

        public void onChanged(ListChangeListener.Change change) {
            TreeCell.this.updateSelection();
        }
    };
    private final InvalidationListener focusedListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TreeCell.this.updateFocus();
        }
    };
    private final InvalidationListener editingListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TreeCell.this.updateEditing();
        }
    };
    private final WeakListChangeListener weakSelectedListener = new WeakListChangeListener(this.selectedListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private ReadOnlyObjectWrapper<TreeItem<T>> treeItem = new ReadOnlyObjectWrapper(this, "treeItem");
    private ObjectProperty<Node> disclosureNode = new SimpleObjectProperty<Node>(this, "disclosureNode");
    private ReadOnlyObjectWrapper<TreeView<T>> treeView = new ReadOnlyObjectWrapper<TreeView<T>>(){
        private WeakReference<TreeView<T>> weakTreeViewRef;

        @Override
        protected void invalidated() {
            FocusModel focusModel;
            MultipleSelectionModel<TreeItem<Object>> multipleSelectionModel;
            if (this.weakTreeViewRef != null) {
                TreeView treeView = (TreeView)this.weakTreeViewRef.get();
                if (treeView != null) {
                    multipleSelectionModel = treeView.getSelectionModel();
                    if (multipleSelectionModel != null) {
                        multipleSelectionModel.getSelectedIndices().removeListener(TreeCell.this.weakSelectedListener);
                    }
                    if ((focusModel = treeView.getFocusModel()) != null) {
                        focusModel.focusedIndexProperty().removeListener(TreeCell.this.weakFocusedListener);
                    }
                    treeView.editingItemProperty().removeListener(TreeCell.this.weakEditingListener);
                }
                this.weakTreeViewRef = null;
            }
            if (this.get() != null) {
                multipleSelectionModel = ((TreeView)this.get()).getSelectionModel();
                if (multipleSelectionModel != null) {
                    multipleSelectionModel.getSelectedIndices().addListener(TreeCell.this.weakSelectedListener);
                }
                if ((focusModel = ((TreeView)this.get()).getFocusModel()) != null) {
                    focusModel.focusedIndexProperty().addListener(TreeCell.this.weakFocusedListener);
                }
                ((TreeView)this.get()).editingItemProperty().addListener(TreeCell.this.weakEditingListener);
                this.weakTreeViewRef = new WeakReference(this.get());
            }
            TreeCell.this.requestLayout();
        }

        @Override
        public Object getBean() {
            return TreeCell.this;
        }

        @Override
        public String getName() {
            return "treeView";
        }
    };
    private static final String DEFAULT_STYLE_CLASS = "tree-cell";
    private static final String PSEUDO_CLASS_EXPANDED = "expanded";
    private static final String PSEUDO_CLASS_COLLAPSED = "collapsed";
    private static final long EXPANDED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("expanded");
    private static final long COLLAPSED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("collapsed");

    public TreeCell() {
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.indexProperty().addListener(this.indexListener);
    }

    private void setTreeItem(TreeItem<T> treeItem) {
        this.treeItem.set(treeItem);
    }

    public final TreeItem<T> getTreeItem() {
        return (TreeItem)this.treeItem.get();
    }

    public final ReadOnlyObjectProperty<TreeItem<T>> treeItemProperty() {
        return this.treeItem.getReadOnlyProperty();
    }

    public final void setDisclosureNode(Node node) {
        this.disclosureNodeProperty().set(node);
    }

    public final Node getDisclosureNode() {
        return (Node)this.disclosureNode.get();
    }

    public final ObjectProperty<Node> disclosureNodeProperty() {
        return this.disclosureNode;
    }

    private void setTreeView(TreeView<T> treeView) {
        this.treeView.set(treeView);
    }

    public final TreeView<T> getTreeView() {
        return (TreeView)this.treeView.get();
    }

    public final ReadOnlyObjectProperty<TreeView<T>> treeViewProperty() {
        return this.treeView.getReadOnlyProperty();
    }

    @Override
    public void startEdit() {
        TreeView<T> treeView = this.getTreeView();
        if (!this.isEditable() || treeView != null && !treeView.isEditable()) {
            return;
        }
        super.startEdit();
        if (treeView != null) {
            treeView.fireEvent(new TreeView.EditEvent<Object>((TreeView<Object>)treeView, TreeView.editStartEvent(), (TreeItem<Object>)this.getTreeItem(), this.getItem(), null));
            treeView.requestFocus();
        }
    }

    @Override
    public void commitEdit(T t) {
        if (!this.isEditing()) {
            return;
        }
        TreeItem<T> treeItem = this.getTreeItem();
        TreeView treeView = this.getTreeView();
        if (treeView != null) {
            treeView.fireEvent(new TreeView.EditEvent<T>(treeView, TreeView.editCommitEvent(), treeItem, this.getItem(), t));
        }
        if (treeItem != null) {
            treeItem.setValue(t);
            this.updateTreeItem(treeItem);
            this.updateItem(t, false);
        }
        super.commitEdit(t);
        if (treeView != null) {
            treeView.edit(null);
            treeView.requestFocus();
        }
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        TreeView treeView = this.getTreeView();
        if (treeView != null) {
            treeView.fireEvent(new TreeView.EditEvent<Object>(treeView, TreeView.editCancelEvent(), (TreeItem<Object>)this.getTreeItem(), this.getItem(), null));
        }
        super.cancelEdit();
        if (treeView != null) {
            treeView.edit(null);
            treeView.requestFocus();
        }
    }

    private void updateItem() {
        TreeItem<T> treeItem;
        TreeView<T> treeView = this.getTreeView();
        if (treeView == null) {
            return;
        }
        boolean bl = this.getIndex() >= 0 && this.getIndex() < treeView.impl_getTreeItemCount();
        TreeItem<T> treeItem2 = treeItem = bl ? treeView.getTreeItem(this.getIndex()) : null;
        if (bl && treeItem != null) {
            this.updateTreeItem(treeItem);
            this.updateItem(treeItem.getValue(), false);
        } else {
            this.updateTreeItem(null);
            this.updateItem(null, true);
        }
    }

    private void updateSelection() {
        if (this.getIndex() == -1 || this.getTreeView() == null) {
            return;
        }
        if (this.getTreeView().getSelectionModel() == null) {
            return;
        }
        this.updateSelected(this.getTreeView().getSelectionModel().isSelected(this.getIndex()));
    }

    private void updateFocus() {
        if (this.getIndex() == -1 || this.getTreeView() == null) {
            return;
        }
        if (this.getTreeView().getFocusModel() == null) {
            return;
        }
        this.setFocused(this.getTreeView().getFocusModel().isFocused(this.getIndex()));
    }

    private void updateEditing() {
        if (this.getIndex() == -1 || this.getTreeView() == null || this.getTreeItem() == null) {
            return;
        }
        TreeItem<T> treeItem = this.getTreeView().getEditingItem();
        if (!this.isEditing() && this.getTreeItem().equals(treeItem)) {
            this.startEdit();
        } else if (this.isEditing() && !this.getTreeItem().equals(treeItem)) {
            this.cancelEdit();
        }
    }

    public final void updateTreeView(TreeView<T> treeView) {
        this.setTreeView(treeView);
    }

    public final void updateTreeItem(TreeItem<T> treeItem) {
        this.setTreeItem(treeItem);
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        if (this.getTreeItem() != null && !this.getTreeItem().isLeaf()) {
            l |= this.getTreeItem().isExpanded() ? EXPANDED_PSEUDOCLASS_STATE : COLLAPSED_PSEUDOCLASS_STATE;
        }
        return l;
    }
}

