/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.PopupControl;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.stage.Window;
import javafx.util.Duration;

public class Tooltip
extends PopupControl {
    private static String TOOLTIP_PROP_KEY = "javafx.scene.control.Tooltip";
    private static TooltipBehavior BEHAVIOR = new TooltipBehavior(new Duration(1000.0), new Duration(5000.0), new Duration(200.0), false);
    private final StringProperty text = new SimpleStringProperty(this, "text", "");
    @Styleable(property="-fx-text-alignment", initial="left")
    private ObjectProperty<TextAlignment> textAlignment;
    @Styleable(property="-fx-text-overrun", initial="ellipsis")
    private ObjectProperty<OverrunStyle> textOverrun;
    @Styleable(property="-fx-wrap-text", initial="false")
    private BooleanProperty wrapText;
    @Styleable(property="-fx-font", inherits=true)
    private ObjectProperty<Font> font;
    @Styleable(property="-fx-graphic", converter="com.sun.javafx.css.converters.URLConverter")
    private ObjectProperty<Node> graphic;
    @Styleable(property="-fx-content-display", initial="left")
    private ObjectProperty<ContentDisplay> contentDisplay;
    @Styleable(property="-fx-graphic-text-gap", initial="4")
    private DoubleProperty graphicTextGap;
    private final ReadOnlyBooleanWrapper activated = new ReadOnlyBooleanWrapper(this, "activated");
    private String cachedImageUrl = null;

    public static void install(Node node, Tooltip tooltip) {
        Tooltip.BEHAVIOR.install(node, tooltip);
    }

    public static void uninstall(Node node, Tooltip tooltip) {
        Tooltip.BEHAVIOR.uninstall(node);
    }

    public Tooltip() {
        this.initialize();
    }

    public Tooltip(String string) {
        this.setText(string);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().setAll((String[])new String[]{"tooltip"});
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final void setText(String string) {
        if (this.isShowing() && string != null && !string.equals(this.getText())) {
            this.setX(BEHAVIOR.lastMouseX);
            this.setY(BEHAVIOR.lastMouseY);
        }
        this.textProperty().setValue(string);
    }

    public final String getText() {
        return this.text == null ? "" : this.text.getValue();
    }

    public final void setTextAlignment(TextAlignment textAlignment) {
        this.textAlignmentProperty().setValue(textAlignment);
    }

    public final TextAlignment getTextAlignment() {
        return this.textAlignment == null ? TextAlignment.LEFT : (TextAlignment)((Object)this.textAlignment.getValue());
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        if (this.textAlignment == null) {
            this.textAlignment = new ObjectPropertyBase<TextAlignment>(TextAlignment.LEFT){

                @Override
                public void invalidated() {
                    Tooltip.this.impl_cssPropertyInvalidated(StyleableProperties.TEXT_ALIGNMENT);
                }

                @Override
                public Object getBean() {
                    return Tooltip.this;
                }

                @Override
                public String getName() {
                    return "textAlignment";
                }
            };
        }
        return this.textAlignment;
    }

    public final void setTextOverrun(OverrunStyle overrunStyle) {
        this.textOverrunProperty().setValue(overrunStyle);
    }

    public final OverrunStyle getTextOverrun() {
        return this.textOverrun == null ? OverrunStyle.ELLIPSIS : (OverrunStyle)((Object)this.textOverrun.getValue());
    }

    public final ObjectProperty<OverrunStyle> textOverrunProperty() {
        if (this.textOverrun == null) {
            this.textOverrun = new ObjectPropertyBase<OverrunStyle>(OverrunStyle.ELLIPSIS){

                @Override
                public void invalidated() {
                    Tooltip.this.impl_cssPropertyInvalidated(StyleableProperties.TEXT_OVERRUN);
                }

                @Override
                public Object getBean() {
                    return Tooltip.this;
                }

                @Override
                public String getName() {
                    return "textOverrun";
                }
            };
        }
        return this.textOverrun;
    }

    public final void setWrapText(boolean bl) {
        this.wrapTextProperty().setValue(bl);
    }

    public final boolean isWrapText() {
        return this.wrapText == null ? false : this.wrapText.getValue();
    }

    public final BooleanProperty wrapTextProperty() {
        if (this.wrapText == null) {
            this.wrapText = new BooleanPropertyBase(){

                @Override
                public void invalidated() {
                    Tooltip.this.impl_cssPropertyInvalidated(StyleableProperties.WRAP_TEXT);
                }

                @Override
                public Object getBean() {
                    return Tooltip.this;
                }

                @Override
                public String getName() {
                    return "wrapText";
                }
            };
        }
        return this.wrapText;
    }

    public final void setFont(Font font) {
        this.fontProperty().setValue(font);
    }

    public final Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.getValue();
    }

    public final ObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new ObjectPropertyBase<Font>(Font.getDefault()){

                @Override
                public void invalidated() {
                    Tooltip.this.impl_cssPropertyInvalidated(StyleableProperties.FONT);
                }

                @Override
                public Object getBean() {
                    return Tooltip.this;
                }

                @Override
                public String getName() {
                    return "font";
                }
            };
        }
        return this.font;
    }

    public final void setGraphic(Node node) {
        this.graphicProperty().setValue(node);
        this.cachedImageUrl = null;
    }

    public final Node getGraphic() {
        return this.graphic == null ? null : (Node)this.graphic.getValue();
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new ObjectPropertyBase<Node>(){

                @Override
                public void invalidated() {
                    Tooltip.this.impl_cssPropertyInvalidated(StyleableProperties.GRAPHIC);
                }

                @Override
                public Object getBean() {
                    return Tooltip.this;
                }

                @Override
                public String getName() {
                    return "graphic";
                }
            };
        }
        return this.graphic;
    }

    public final void setContentDisplay(ContentDisplay contentDisplay) {
        this.contentDisplayProperty().setValue(contentDisplay);
    }

    public final ContentDisplay getContentDisplay() {
        return this.contentDisplay == null ? ContentDisplay.LEFT : (ContentDisplay)((Object)this.contentDisplay.getValue());
    }

    public final ObjectProperty<ContentDisplay> contentDisplayProperty() {
        if (this.contentDisplay == null) {
            this.contentDisplay = new ObjectPropertyBase<ContentDisplay>(ContentDisplay.LEFT){

                @Override
                public void invalidated() {
                    Tooltip.this.impl_cssPropertyInvalidated(StyleableProperties.CONTENT_DISPLAY);
                }

                @Override
                public Object getBean() {
                    return Tooltip.this;
                }

                @Override
                public String getName() {
                    return "contentDisplay";
                }
            };
        }
        return this.contentDisplay;
    }

    public final void setGraphicTextGap(double d) {
        this.graphicTextGapProperty().setValue(d);
    }

    public final double getGraphicTextGap() {
        return this.graphicTextGap == null ? 4.0 : this.graphicTextGap.getValue();
    }

    public final DoubleProperty graphicTextGapProperty() {
        if (this.graphicTextGap == null) {
            this.graphicTextGap = new DoublePropertyBase(4.0){

                @Override
                public void invalidated() {
                    Tooltip.this.impl_cssPropertyInvalidated(StyleableProperties.GRAPHIC_TEXT_GAP);
                }

                @Override
                public Object getBean() {
                    return Tooltip.this;
                }

                @Override
                public String getName() {
                    return "graphicTextGap";
                }
            };
        }
        return this.graphicTextGap;
    }

    final void setActivated(boolean bl) {
        this.activated.set(bl);
    }

    public final boolean isActivated() {
        return this.activated.get();
    }

    public final ReadOnlyBooleanProperty activatedProperty() {
        return this.activated.getReadOnlyProperty();
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-text-alignment".equals(string)) {
            this.setTextAlignment((TextAlignment)((Object)object));
        } else if ("-fx-text-overrun".equals(string)) {
            this.setTextOverrun((OverrunStyle)((Object)object));
        } else if ("-fx-wrap-text".equals(string)) {
            this.setWrapText((Boolean)object);
        } else if ("-fx-font".equals(string)) {
            this.setFont((Font)object);
        } else if ("-fx-graphic".equals(string)) {
            String string2 = (String)object;
            if (string2 != null && !string2.equals(this.cachedImageUrl)) {
                this.setGraphic(new ImageView(new Image(string2)));
            }
            this.cachedImageUrl = string2;
        } else if ("-fx-content-display".equals(string)) {
            this.setContentDisplay((ContentDisplay)((Object)object));
        } else if ("-fx-graphic-text-gap".equals(string)) {
            this.setGraphicTextGap((Double)object);
        }
        return super.impl_cssSet(string, object);
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-text-alignment".equals(string)) {
            return this.textAlignment == null || !this.textAlignment.isBound();
        }
        if ("-fx-text-overrun".equals(string)) {
            return this.textOverrun == null || !this.textOverrun.isBound();
        }
        if ("-fx-wrap-text".equals(string)) {
            return this.wrapText == null || !this.wrapText.isBound();
        }
        if ("-fx-font".equals(string)) {
            return this.font == null || !this.font.isBound();
        }
        if ("-fx-graphic".equals(string)) {
            return this.graphic == null || !this.graphic.isBound();
        }
        if ("-fx-content-display".equals(string)) {
            return this.contentDisplay == null || !this.contentDisplay.isBound();
        }
        if ("-fx-graphic-text-gap".equals(string)) {
            return this.graphicTextGap == null || !this.graphicTextGap.isBound();
        }
        return super.impl_cssSettable(string);
    }

    private static class TooltipBehavior {
        private Timeline activationTimer = new Timeline();
        private Timeline hideTimer = new Timeline();
        private Timeline leftTimer = new Timeline();
        private Node hoveredNode;
        private Tooltip activatedTooltip;
        private Tooltip visibleTooltip;
        private double lastMouseX;
        private double lastMouseY;
        private boolean hideOnExit;
        private EventHandler<MouseEvent> MOVE_HANDLER = new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                double d = mouseEvent.getScreenX();
                double d2 = mouseEvent.getScreenY();
                if (d == TooltipBehavior.this.lastMouseX && d2 == TooltipBehavior.this.lastMouseY) {
                    return;
                }
                TooltipBehavior.this.lastMouseX = d;
                TooltipBehavior.this.lastMouseY = d2;
                if (TooltipBehavior.this.hideTimer.getStatus() == Animation.Status.RUNNING) {
                    return;
                }
                TooltipBehavior.this.hoveredNode = (Node)mouseEvent.getSource();
                Tooltip tooltip = (Tooltip)TooltipBehavior.this.hoveredNode.getProperties().get(TOOLTIP_PROP_KEY);
                if (tooltip != null) {
                    Window window = TooltipBehavior.this.getWindow(TooltipBehavior.this.hoveredNode);
                    boolean bl = TooltipBehavior.this.isWindowHierarchyVisible(TooltipBehavior.this.hoveredNode);
                    if (window != null && bl) {
                        if (TooltipBehavior.this.leftTimer.getStatus() == Animation.Status.RUNNING) {
                            if (TooltipBehavior.this.visibleTooltip != null) {
                                TooltipBehavior.this.visibleTooltip.hide();
                            }
                            TooltipBehavior.this.visibleTooltip = tooltip;
                            TooltipBehavior.this.hoveredNode = null;
                            tooltip.show(window, mouseEvent.getScreenX(), mouseEvent.getScreenY());
                            TooltipBehavior.this.leftTimer.stop();
                            TooltipBehavior.this.hideTimer.playFromStart();
                        } else {
                            tooltip.setActivated(true);
                            TooltipBehavior.this.activatedTooltip = tooltip;
                            TooltipBehavior.this.activationTimer.stop();
                            TooltipBehavior.this.activationTimer.playFromStart();
                        }
                    }
                }
            }
        };
        private EventHandler<MouseEvent> LEAVING_HANDLER = new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (TooltipBehavior.this.activationTimer.getStatus() == Animation.Status.RUNNING) {
                    TooltipBehavior.this.activationTimer.stop();
                } else if (TooltipBehavior.this.hideTimer.getStatus() == Animation.Status.RUNNING) {
                    assert (TooltipBehavior.this.visibleTooltip != null);
                    TooltipBehavior.this.hideTimer.stop();
                    if (TooltipBehavior.this.hideOnExit) {
                        TooltipBehavior.this.visibleTooltip.hide();
                    }
                    TooltipBehavior.this.leftTimer.playFromStart();
                }
                TooltipBehavior.this.hoveredNode = null;
                TooltipBehavior.this.activatedTooltip = null;
                if (TooltipBehavior.this.hideOnExit) {
                    TooltipBehavior.this.visibleTooltip = null;
                }
            }
        };
        private EventHandler<MouseEvent> KILL_HANDLER = new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                TooltipBehavior.this.activationTimer.stop();
                TooltipBehavior.this.hideTimer.stop();
                TooltipBehavior.this.leftTimer.stop();
                if (TooltipBehavior.this.visibleTooltip != null) {
                    TooltipBehavior.this.visibleTooltip.hide();
                }
                TooltipBehavior.this.hoveredNode = null;
                TooltipBehavior.this.activatedTooltip = null;
                TooltipBehavior.this.visibleTooltip = null;
            }
        };

        TooltipBehavior(Duration duration, Duration duration2, Duration duration3, final boolean bl) {
            this.hideOnExit = bl;
            this.activationTimer.getKeyFrames().add(new KeyFrame(duration, new KeyValue[0]));
            this.activationTimer.setOnFinished(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    assert (TooltipBehavior.this.activatedTooltip != null);
                    Window window = TooltipBehavior.this.getWindow(TooltipBehavior.this.hoveredNode);
                    boolean bl = TooltipBehavior.this.isWindowHierarchyVisible(TooltipBehavior.this.hoveredNode);
                    if (window != null && window.isShowing() && bl) {
                        TooltipBehavior.this.activatedTooltip.show(window, TooltipBehavior.this.lastMouseX, TooltipBehavior.this.lastMouseY);
                        TooltipBehavior.this.visibleTooltip = TooltipBehavior.this.activatedTooltip;
                        TooltipBehavior.this.hoveredNode = null;
                        TooltipBehavior.this.hideTimer.playFromStart();
                    }
                    TooltipBehavior.this.activatedTooltip.setActivated(false);
                    TooltipBehavior.this.activatedTooltip = null;
                }
            });
            this.hideTimer.getKeyFrames().add(new KeyFrame(duration2, new KeyValue[0]));
            this.hideTimer.setOnFinished(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    assert (TooltipBehavior.this.visibleTooltip != null);
                    TooltipBehavior.this.visibleTooltip.hide();
                    TooltipBehavior.this.visibleTooltip = null;
                    TooltipBehavior.this.hoveredNode = null;
                }
            });
            this.leftTimer.getKeyFrames().add(new KeyFrame(duration3, new KeyValue[0]));
            this.leftTimer.setOnFinished(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    if (!bl) {
                        assert (TooltipBehavior.this.visibleTooltip != null);
                        TooltipBehavior.this.visibleTooltip.hide();
                        TooltipBehavior.this.visibleTooltip = null;
                        TooltipBehavior.this.hoveredNode = null;
                    }
                }
            });
        }

        private void install(Node node, Tooltip tooltip) {
            if (node == null) {
                return;
            }
            node.addEventHandler(MouseEvent.MOUSE_MOVED, this.MOVE_HANDLER);
            node.addEventHandler(MouseEvent.MOUSE_EXITED, this.LEAVING_HANDLER);
            node.addEventHandler(MouseEvent.MOUSE_PRESSED, this.KILL_HANDLER);
            node.getProperties().put(TOOLTIP_PROP_KEY, tooltip);
        }

        private void uninstall(Node node) {
            if (node == null) {
                return;
            }
            node.removeEventHandler(MouseEvent.MOUSE_MOVED, this.MOVE_HANDLER);
            node.removeEventHandler(MouseEvent.MOUSE_EXITED, this.LEAVING_HANDLER);
            node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.KILL_HANDLER);
            Tooltip tooltip = (Tooltip)node.getProperties().get(TOOLTIP_PROP_KEY);
            if (tooltip != null) {
                node.getProperties().remove(TOOLTIP_PROP_KEY);
                if (tooltip.equals(this.visibleTooltip) || tooltip.equals(this.activatedTooltip)) {
                    this.KILL_HANDLER.handle(null);
                }
            }
        }

        private Window getWindow(Node node) {
            Scene scene = node == null ? null : node.getScene();
            return scene == null ? null : scene.getWindow();
        }

        private boolean isWindowHierarchyVisible(Node node) {
            Parent parent;
            boolean bl = node != null;
            Parent parent2 = parent = node == null ? null : node.getParent();
            while (parent != null && bl) {
                bl = parent.isVisible();
                parent = parent.getParent();
            }
            return bl;
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty FONT = new StyleableProperty(Tooltip.class, "font", StyleableProperty.FONT.getSubProperties());
        private static final StyleableProperty TEXT_ALIGNMENT = new StyleableProperty(Tooltip.class, "textAlignment");
        private static final StyleableProperty TEXT_OVERRUN = new StyleableProperty(Tooltip.class, "textOverrun");
        private static final StyleableProperty WRAP_TEXT = new StyleableProperty(Tooltip.class, "wrapText");
        private static final StyleableProperty GRAPHIC = new StyleableProperty(Tooltip.class, "graphic");
        private static final StyleableProperty CONTENT_DISPLAY = new StyleableProperty(Tooltip.class, "contentDisplay");
        private static final StyleableProperty GRAPHIC_TEXT_GAP = new StyleableProperty(Tooltip.class, "graphicTextGap");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(PopupControl.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, FONT, TEXT_ALIGNMENT, TEXT_OVERRUN, WRAP_TEXT, GRAPHIC, CONTENT_DISPLAY, GRAPHIC_TEXT_GAP);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

