/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.property.PropertyReference;
import com.sun.javafx.scene.control.WeakListChangeListener;
import java.lang.ref.WeakReference;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.event.Event;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;

public class TableCell<S, T>
extends IndexedCell<T> {
    private InvalidationListener indexListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableCell.this.updateItem();
            TableCell.this.updateSelection();
            TableCell.this.updateFocus();
        }
    };
    private ListChangeListener<TablePosition> selectedListener = new ListChangeListener<TablePosition>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TablePosition> change) {
            TableCell.this.updateSelection();
        }
    };
    private final InvalidationListener focusedListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableCell.this.updateFocus();
        }
    };
    private final InvalidationListener tableRowUpdateObserver = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableCell.this.updateItem();
        }
    };
    private final InvalidationListener editingListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableCell.this.updateEditing();
        }
    };
    private ListChangeListener<TableColumn<S, T>> visibleLeafColumnsListener = new ListChangeListener<TableColumn<S, T>>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TableColumn<S, T>> change) {
            TableCell.this.updateColumnIndex();
        }
    };
    private final WeakListChangeListener weakSelectedListener = new WeakListChangeListener<TablePosition>(this.selectedListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakInvalidationListener weaktableRowUpdateObserver = new WeakInvalidationListener(this.tableRowUpdateObserver);
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private final WeakListChangeListener weakVisibleLeafColumnsListener = new WeakListChangeListener<TableColumn<S, T>>(this.visibleLeafColumnsListener);
    private ReadOnlyObjectWrapper<TableColumn<S, T>> tableColumn = new ReadOnlyObjectWrapper<TableColumn<S, T>>(){

        @Override
        protected void invalidated() {
            TableCell.this.updateColumnIndex();
        }

        @Override
        public Object getBean() {
            return TableCell.this;
        }

        @Override
        public String getName() {
            return "tableColumn";
        }
    };
    private ReadOnlyObjectWrapper<TableView<S>> tableView;
    private ReadOnlyObjectWrapper<TableRow> tableRow = new ReadOnlyObjectWrapper(this, "tableRow");
    private Map<String, PropertyReference> observablePropertyReferences;
    private boolean isLastVisibleColumn = false;
    private int columnIndex = -1;
    private static final String DEFAULT_STYLE_CLASS = "table-cell";
    private static final String PSEUDO_CLASS_LAST_VISIBLE = "last-visible";

    public TableCell() {
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.updateColumnIndex();
        this.indexProperty().addListener(this.indexListener);
        this.updateItem();
    }

    public final ReadOnlyObjectProperty<TableColumn<S, T>> tableColumnProperty() {
        return this.tableColumn.getReadOnlyProperty();
    }

    private void setTableColumn(TableColumn<S, T> tableColumn) {
        this.tableColumn.set(tableColumn);
    }

    public final TableColumn<S, T> getTableColumn() {
        return (TableColumn)this.tableColumn.get();
    }

    private void setTableView(TableView<S> tableView) {
        this.tableViewPropertyImpl().set(tableView);
    }

    public final TableView<S> getTableView() {
        return this.tableView == null ? null : (TableView)this.tableView.get();
    }

    public final ReadOnlyObjectProperty<TableView<S>> tableViewProperty() {
        return this.tableViewPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TableView<S>> tableViewPropertyImpl() {
        if (this.tableView == null) {
            this.tableView = new ReadOnlyObjectWrapper<TableView<S>>(){
                private WeakReference<TableView<S>> weakTableViewRef;

                @Override
                protected void invalidated() {
                    TableView.TableViewFocusModel tableViewFocusModel;
                    TableView.TableViewSelectionModel tableViewSelectionModel;
                    TableView tableView;
                    if (this.weakTableViewRef != null && (tableView = (TableView)this.weakTableViewRef.get()) != null) {
                        tableViewSelectionModel = tableView.getSelectionModel();
                        if (tableViewSelectionModel != null) {
                            tableViewSelectionModel.getSelectedCells().removeListener(TableCell.this.weakSelectedListener);
                        }
                        if ((tableViewFocusModel = tableView.getFocusModel()) != null) {
                            tableViewFocusModel.focusedCellProperty().removeListener(TableCell.this.weakFocusedListener);
                        }
                        tableView.editingCellProperty().removeListener(TableCell.this.weakEditingListener);
                        tableView.getVisibleLeafColumns().removeListener(TableCell.this.weakVisibleLeafColumnsListener);
                    }
                    if (this.get() != null) {
                        tableViewSelectionModel = ((TableView)this.get()).getSelectionModel();
                        if (tableViewSelectionModel != null) {
                            tableViewSelectionModel.getSelectedCells().addListener(TableCell.this.weakSelectedListener);
                        }
                        if ((tableViewFocusModel = ((TableView)this.get()).getFocusModel()) != null) {
                            tableViewFocusModel.focusedCellProperty().addListener(TableCell.this.weakFocusedListener);
                        }
                        ((TableView)this.get()).editingCellProperty().addListener(TableCell.this.weakEditingListener);
                        ((TableView)this.get()).getVisibleLeafColumns().addListener(TableCell.this.weakVisibleLeafColumnsListener);
                        this.weakTableViewRef = new WeakReference(this.get());
                    }
                    TableCell.this.updateColumnIndex();
                }

                @Override
                public Object getBean() {
                    return TableCell.this;
                }

                @Override
                public String getName() {
                    return "tableView";
                }
            };
        }
        return this.tableView;
    }

    private void setTableRow(TableRow tableRow) {
        this.tableRow.set(tableRow);
    }

    public final TableRow getTableRow() {
        return (TableRow)this.tableRow.get();
    }

    public final ReadOnlyObjectProperty<TableRow> tableRowProperty() {
        return this.tableRow;
    }

    @Override
    public void startEdit() {
        TableView<S> tableView = this.getTableView();
        TableColumn<S, T> tableColumn = this.getTableColumn();
        if (!this.isEditable() || tableView != null && !tableView.isEditable() || tableColumn != null && !this.getTableColumn().isEditable()) {
            return;
        }
        super.startEdit();
        if (tableColumn != null) {
            TableColumn.CellEditEvent<S, Object> cellEditEvent = new TableColumn.CellEditEvent<S, Object>(tableView, tableView.getEditingCell(), TableColumn.editStartEvent(), null);
            Event.fireEvent(tableColumn, cellEditEvent);
        }
    }

    @Override
    public void commitEdit(T t) {
        if (!this.isEditing()) {
            return;
        }
        TableView tableView = this.getTableView();
        if (tableView != null) {
            TableColumn.CellEditEvent cellEditEvent = new TableColumn.CellEditEvent(tableView, tableView.getEditingCell(), TableColumn.editCommitEvent(), t);
            Event.fireEvent(this.getTableColumn(), cellEditEvent);
        }
        this.updateItem(t, false);
        super.commitEdit(t);
        if (tableView != null) {
            tableView.edit(-1, null);
            tableView.requestFocus();
        }
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        TableView tableView = this.getTableView();
        if (this.getTableColumn() != null) {
            TableColumn.CellEditEvent<S, Object> cellEditEvent = new TableColumn.CellEditEvent<S, Object>(tableView, tableView.getEditingCell(), TableColumn.editCancelEvent(), null);
            Event.fireEvent(this.getTableColumn(), cellEditEvent);
        }
        super.cancelEdit();
        if (tableView != null) {
            tableView.edit(-1, null);
        }
    }

    private void updateColumnIndex() {
        TableView<S> tableView = this.getTableView();
        TableColumn<S, T> tableColumn = this.getTableColumn();
        this.columnIndex = tableView == null || tableColumn == null ? -1 : tableView.getVisibleLeafIndex(tableColumn);
        boolean bl = this.isLastVisibleColumn;
        boolean bl2 = this.isLastVisibleColumn = this.getTableColumn() != null && this.columnIndex != -1 && this.columnIndex == this.getTableView().getVisibleLeafColumns().size() - 1;
        if (bl != this.isLastVisibleColumn) {
            this.impl_pseudoClassStateChanged(PSEUDO_CLASS_LAST_VISIBLE);
        }
    }

    private void updateSelection() {
        if (this.getIndex() == -1 || this.getTableView() == null) {
            return;
        }
        if (this.getTableView().getSelectionModel() == null) {
            return;
        }
        boolean bl = this.isInCellSelectionMode() && this.getTableView().getSelectionModel().isSelected(this.getIndex(), this.getTableColumn());
        this.updateSelected(bl);
    }

    private void updateFocus() {
        if (this.getIndex() == -1 || this.getTableView() == null) {
            return;
        }
        if (this.getTableView().getFocusModel() == null) {
            return;
        }
        boolean bl = this.isInCellSelectionMode() && this.getTableView().getFocusModel() != null && this.getTableView().getFocusModel().isFocused(this.getIndex(), this.getTableColumn());
        this.setFocused(bl);
    }

    private void updateEditing() {
        if (this.getIndex() == -1 || this.getTableView() == null) {
            return;
        }
        TablePosition<S, ?> tablePosition = this.getTableView().getEditingCell();
        if (!this.isEditing()) {
            if (this.match(tablePosition)) {
                this.startEdit();
            }
        } else {
            this.cancelEdit();
        }
    }

    private boolean match(TablePosition tablePosition) {
        return tablePosition != null && tablePosition.getRow() == this.getIndex() && tablePosition.getTableColumn() == this.getTableColumn();
    }

    private boolean isInCellSelectionMode() {
        return this.getTableView() != null && this.getTableView().getSelectionModel() != null && this.getTableView().getSelectionModel().isCellSelectionEnabled();
    }

    private void updateItem() {
        if (this.getIndex() < 0 || this.columnIndex < 0) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.getTableColumn() == null || !this.getTableColumn().isVisible()) {
            return;
        }
        if (this.getIndex() < 0) {
            return;
        }
        int n = this.getTableView().getItems().size();
        ObservableValue<T> observableValue = null;
        if (this.getIndex() >= n) {
            this.updateItem(null, true);
            return;
        }
        if (this.getIndex() < n) {
            observableValue = this.getTableColumn().getCellObservableValue(this.getIndex());
        }
        Object t = observableValue == null ? null : (Object)observableValue.getValue();
        this.updateItem(t, t == null);
        if (observableValue == null) {
            return;
        }
        observableValue.removeListener(this.weaktableRowUpdateObserver);
        observableValue.addListener(this.weaktableRowUpdateObserver);
    }

    public final void updateTableView(TableView tableView) {
        this.setTableView(tableView);
    }

    public final void updateTableRow(TableRow tableRow) {
        this.setTableRow(tableRow);
    }

    public final void updateTableColumn(TableColumn tableColumn) {
        this.setTableColumn(tableColumn);
    }
}

