/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Side;
import javafx.scene.control.Control;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;

public class TabPane
extends Control {
    private static final double DEFAULT_TAB_MIN_WIDTH = 0.0;
    private static final double DEFAULT_TAB_MAX_WIDTH = Double.MAX_VALUE;
    private static final double DEFAULT_TAB_MIN_HEIGHT = 0.0;
    private static final double DEFAULT_TAB_MAX_HEIGHT = Double.MAX_VALUE;
    public static final String STYLE_CLASS_FLOATING = "floating";
    private ObservableList<Tab> tabs = FXCollections.observableArrayList();
    private ObjectProperty<SingleSelectionModel<Tab>> selectionModel = new SimpleObjectProperty<SingleSelectionModel<Tab>>(this, "selectionModel");
    private ObjectProperty<Side> side;
    private ObjectProperty<TabClosingPolicy> tabClosingPolicy;
    private BooleanProperty rotateGraphic;
    @Styleable(property="-fx-tab-min-width", initial="0")
    private DoubleProperty tabMinWidth;
    @Styleable(property="-fx-tab-max-width")
    private DoubleProperty tabMaxWidth;
    @Styleable(property="-fx-tab-min-height", initial="0")
    private DoubleProperty tabMinHeight;
    @Styleable(property="-fx-tab-max-height")
    private DoubleProperty tabMaxHeight;
    private Side cachedSide;
    private String cachedSideString;
    private static final long TOP_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("top");
    private static final long BOTTOM_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("bottom");
    private static final long LEFT_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("left");
    private static final long RIGHT_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("right");

    public TabPane() {
        this.getStyleClass().setAll((String[])new String[]{"tab-pane"});
        this.setSelectionModel(new TabPaneSelectionModel(this));
        this.tabs.addListener(new ListChangeListener<Tab>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Tab> change) {
                while (change.next()) {
                    for (Tab tab : change.getRemoved()) {
                        if (tab == null || TabPane.this.getTabs().contains(tab)) continue;
                        tab.setTabPane(null);
                    }
                    for (Tab tab : change.getAddedSubList()) {
                        if (tab == null) continue;
                        tab.setTabPane(TabPane.this);
                    }
                }
            }
        });
    }

    public final ObservableList<Tab> getTabs() {
        return this.tabs;
    }

    public final void setSelectionModel(SingleSelectionModel<Tab> singleSelectionModel) {
        this.selectionModel.set(singleSelectionModel);
    }

    public final SingleSelectionModel<Tab> getSelectionModel() {
        return (SingleSelectionModel)this.selectionModel.get();
    }

    public final ObjectProperty<SingleSelectionModel<Tab>> selectionModelProperty() {
        return this.selectionModel;
    }

    public final void setSide(Side side) {
        this.sideProperty().set(side);
    }

    public final Side getSide() {
        return this.side == null ? Side.TOP : (Side)((Object)this.side.get());
    }

    public final ObjectProperty<Side> sideProperty() {
        if (this.side == null) {
            this.side = new ObjectPropertyBase<Side>(Side.TOP){
                private Side oldSide;

                @Override
                protected void invalidated() {
                    if (this.oldSide != null) {
                        TabPane.this.impl_pseudoClassStateChanged(this.oldSide.name().toLowerCase());
                    }
                    this.oldSide = (Side)((Object)this.get());
                    if (this.get() != null) {
                        TabPane.this.impl_pseudoClassStateChanged(((Side)((Object)this.get())).name().toLowerCase());
                    }
                }

                @Override
                public Object getBean() {
                    return TabPane.this;
                }

                @Override
                public String getName() {
                    return "side";
                }
            };
        }
        return this.side;
    }

    public final void setTabClosingPolicy(TabClosingPolicy tabClosingPolicy) {
        this.tabClosingPolicyProperty().set(tabClosingPolicy);
    }

    public final TabClosingPolicy getTabClosingPolicy() {
        return this.tabClosingPolicy == null ? TabClosingPolicy.SELECTED_TAB : (TabClosingPolicy)((Object)this.tabClosingPolicy.get());
    }

    public final ObjectProperty<TabClosingPolicy> tabClosingPolicyProperty() {
        if (this.tabClosingPolicy == null) {
            this.tabClosingPolicy = new SimpleObjectProperty<TabClosingPolicy>(this, "tabClosingPolicy", TabClosingPolicy.SELECTED_TAB);
        }
        return this.tabClosingPolicy;
    }

    public final void setRotateGraphic(boolean bl) {
        this.rotateGraphicProperty().set(bl);
    }

    public final boolean isRotateGraphic() {
        return this.rotateGraphic == null ? false : this.rotateGraphic.get();
    }

    public final BooleanProperty rotateGraphicProperty() {
        if (this.rotateGraphic == null) {
            this.rotateGraphic = new SimpleBooleanProperty(this, "rotateGraphic", false);
        }
        return this.rotateGraphic;
    }

    public final void setTabMinWidth(double d) {
        this.tabMinWidthProperty().setValue(d);
    }

    public final double getTabMinWidth() {
        return this.tabMinWidth == null ? 0.0 : this.tabMinWidth.getValue();
    }

    public final DoubleProperty tabMinWidthProperty() {
        if (this.tabMinWidth == null) {
            this.tabMinWidth = new DoublePropertyBase(0.0){

                @Override
                public void invalidated() {
                    TabPane.this.impl_cssPropertyInvalidated(StyleableProperties.TAB_MIN_WIDTH);
                }

                @Override
                public Object getBean() {
                    return TabPane.this;
                }

                @Override
                public String getName() {
                    return "tabMinWidth";
                }
            };
        }
        return this.tabMinWidth;
    }

    public final void setTabMaxWidth(double d) {
        this.tabMaxWidthProperty().setValue(d);
    }

    public final double getTabMaxWidth() {
        return this.tabMaxWidth == null ? Double.MAX_VALUE : this.tabMaxWidth.getValue();
    }

    public final DoubleProperty tabMaxWidthProperty() {
        if (this.tabMaxWidth == null) {
            this.tabMaxWidth = new DoublePropertyBase(Double.MAX_VALUE){

                @Override
                public void invalidated() {
                    TabPane.this.impl_cssPropertyInvalidated(StyleableProperties.TAB_MAX_WIDTH);
                }

                @Override
                public Object getBean() {
                    return TabPane.this;
                }

                @Override
                public String getName() {
                    return "tabMaxWidth";
                }
            };
        }
        return this.tabMaxWidth;
    }

    public final void setTabMinHeight(double d) {
        this.tabMinHeightProperty().setValue(d);
    }

    public final double getTabMinHeight() {
        return this.tabMinHeight == null ? 0.0 : this.tabMinHeight.getValue();
    }

    public final DoubleProperty tabMinHeightProperty() {
        if (this.tabMinHeight == null) {
            this.tabMinHeight = new DoublePropertyBase(0.0){

                @Override
                public void invalidated() {
                    TabPane.this.impl_cssPropertyInvalidated(StyleableProperties.TAB_MIN_HEIGHT);
                }

                @Override
                public Object getBean() {
                    return TabPane.this;
                }

                @Override
                public String getName() {
                    return "tabMinHeight";
                }
            };
        }
        return this.tabMinHeight;
    }

    public final void setTabMaxHeight(double d) {
        this.tabMaxHeightProperty().setValue(d);
    }

    public final double getTabMaxHeight() {
        return this.tabMaxHeight == null ? Double.MAX_VALUE : this.tabMaxHeight.getValue();
    }

    public final DoubleProperty tabMaxHeightProperty() {
        if (this.tabMaxHeight == null) {
            this.tabMaxHeight = new DoublePropertyBase(Double.MAX_VALUE){

                @Override
                public void invalidated() {
                    TabPane.this.impl_cssPropertyInvalidated(StyleableProperties.TAB_MAX_HEIGHT);
                }

                @Override
                public Object getBean() {
                    return TabPane.this;
                }

                @Override
                public String getName() {
                    return "tabMaxHeight";
                }
            };
        }
        return this.tabMaxHeight;
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        switch (this.getSide()) {
            case TOP: {
                l |= TOP_PSEUDOCLASS_STATE;
                break;
            }
            case RIGHT: {
                l |= RIGHT_PSEUDOCLASS_STATE;
                break;
            }
            case BOTTOM: {
                l |= BOTTOM_PSEUDOCLASS_STATE;
                break;
            }
            case LEFT: {
                l |= LEFT_PSEUDOCLASS_STATE;
            }
        }
        return l;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if (string.equals("-fx-tab-min-width")) {
            double d = (Double)object;
            this.setTabMinWidth(d <= 0.0 ? 0.0 : d);
        } else if (string.equals("-fx-tab-max-width")) {
            double d = (Double)object;
            this.setTabMaxWidth(d <= 0.0 ? Double.MAX_VALUE : d);
        } else if (string.equals("-fx-tab-min-height")) {
            double d = (Double)object;
            this.setTabMinHeight(d <= 0.0 ? 0.0 : d);
        } else if (string.equals("-fx-tab-max-height")) {
            double d = (Double)object;
            this.setTabMaxHeight(d <= 0.0 ? Double.MAX_VALUE : d);
        } else {
            return super.impl_cssSet(string, object);
        }
        return true;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if (string.equals("-fx-tab-min-width")) {
            return this.tabMinWidth == null || !this.tabMinWidth.isBound();
        }
        if (string.equals("-fx-tab-max-width")) {
            return this.tabMaxWidth == null || !this.tabMaxWidth.isBound();
        }
        if (string.equals("-fx-tab-min-height")) {
            return this.tabMinHeight == null || !this.tabMinHeight.isBound();
        }
        if (string.equals("-fx-tab-max-height")) {
            return this.tabMaxHeight == null || !this.tabMaxHeight.isBound();
        }
        return super.impl_cssSettable(string);
    }

    public static enum TabClosingPolicy {
        SELECTED_TAB,
        ALL_TABS,
        UNAVAILABLE;

    }

    static class TabPaneSelectionModel
    extends SingleSelectionModel<Tab> {
        private final TabPane tabPane;

        public TabPaneSelectionModel(TabPane tabPane) {
            if (tabPane == null) {
                throw new NullPointerException("TabPane can not be null");
            }
            this.tabPane = tabPane;
            ListChangeListener<Tab> listChangeListener = new ListChangeListener<Tab>(){

                @Override
                public void onChanged(ListChangeListener.Change<? extends Tab> change) {
                    while (change.next()) {
                        for (Tab tab : change.getRemoved()) {
                            if (tab == null || TabPaneSelectionModel.this.tabPane.getTabs().contains(tab)) continue;
                            if (TabPaneSelectionModel.this.getSelectedIndex() == 0 && TabPaneSelectionModel.this.tabPane.getTabs().size() > 0) {
                                TabPaneSelectionModel.this.clearAndSelect(0);
                            }
                            if (!tab.isSelected()) continue;
                            tab.setSelected(false);
                            if (change.getFrom() == 0) {
                                if (TabPaneSelectionModel.this.tabPane.getTabs().size() <= 1) continue;
                                TabPaneSelectionModel.this.selectFirst();
                                continue;
                            }
                            TabPaneSelectionModel.this.selectPrevious();
                        }
                    }
                    if (TabPaneSelectionModel.this.getSelectedIndex() == -1 && TabPaneSelectionModel.this.tabPane.getTabs().size() > 0) {
                        TabPaneSelectionModel.this.selectFirst();
                    } else if (TabPaneSelectionModel.this.tabPane.getTabs().isEmpty()) {
                        TabPaneSelectionModel.this.clearSelection();
                    }
                }
            };
            if (this.tabPane.getTabs() != null) {
                this.tabPane.getTabs().addListener(listChangeListener);
            }
        }

        @Override
        public void select(int n) {
            int n2 = this.getItemCount();
            if (n2 == 0 || n < 0 || n >= n2) {
                return;
            }
            if (this.getSelectedIndex() != -1 && this.getSelectedIndex() < this.tabPane.getTabs().size()) {
                ((Tab)this.tabPane.getTabs().get(this.getSelectedIndex())).setSelected(false);
            }
            this.setSelectedIndex(n);
            this.setSelectedItem(this.getModelItem(n));
            ((Tab)this.tabPane.getTabs().get(this.getSelectedIndex())).setSelected(true);
        }

        @Override
        protected Tab getModelItem(int n) {
            ObservableList<Tab> observableList = this.tabPane.getTabs();
            if (observableList == null) {
                return null;
            }
            if (n < 0 || n >= observableList.size()) {
                return null;
            }
            return (Tab)observableList.get(n);
        }

        @Override
        protected int getItemCount() {
            ObservableList<Tab> observableList = this.tabPane.getTabs();
            return observableList == null ? 0 : observableList.size();
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty TAB_MIN_WIDTH = new StyleableProperty(TabPane.class, "tabMinWidth");
        private static final StyleableProperty TAB_MAX_WIDTH = new StyleableProperty(TabPane.class, "tabMaxWidth");
        private static final StyleableProperty TAB_MIN_HEIGHT = new StyleableProperty(TabPane.class, "tabMinHeight");
        private static final StyleableProperty TAB_MAX_HEIGHT = new StyleableProperty(TabPane.class, "tabMaxHeight");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Control.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, TAB_MIN_WIDTH, TAB_MAX_WIDTH, TAB_MIN_HEIGHT, TAB_MAX_HEIGHT);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

