/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.MappingChange;
import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.scene.control.ReadOnlyUnbackedObservableList;
import java.util.AbstractList;
import java.util.BitSet;
import java.util.Collections;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;

abstract class MultipleSelectionModelBase<T>
extends MultipleSelectionModel<T> {
    private final BitSet selectedIndices;
    private final ReadOnlyUnbackedObservableList<Integer> selectedIndicesSeq;
    private final ReadOnlyUnbackedObservableList selectedItemsSeq;

    public MultipleSelectionModelBase() {
        this.selectedIndexProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                MultipleSelectionModelBase.this.setSelectedItem(MultipleSelectionModelBase.this.getModelItem(MultipleSelectionModelBase.this.getSelectedIndex()));
            }
        });
        this.selectedIndices = new BitSet();
        this.selectedIndicesSeq = new ReadOnlyUnbackedObservableList<Integer>(){

            @Override
            public Integer get(int n) {
                if (n < 0 || n >= MultipleSelectionModelBase.this.getItemCount()) {
                    return -1;
                }
                int n2 = MultipleSelectionModelBase.this.selectedIndices.nextSetBit(0);
                for (int i = 0; n2 >= 0 || i == n; ++i) {
                    if (i == n) {
                        return n2;
                    }
                    n2 = MultipleSelectionModelBase.this.selectedIndices.nextSetBit(n2 + 1);
                }
                return -1;
            }

            @Override
            public int size() {
                return MultipleSelectionModelBase.this.selectedIndices.cardinality();
            }

            @Override
            public boolean contains(Object object) {
                if (object instanceof Integer || object instanceof Integer) {
                    Number number = (Number)object;
                    int n = number.intValue();
                    return n > 0 && n < MultipleSelectionModelBase.this.selectedIndices.length() && MultipleSelectionModelBase.this.selectedIndices.get(n);
                }
                return false;
            }
        };
        final MappingChange.Map<Integer, Object> map = new MappingChange.Map<Integer, Object>(){

            @Override
            public Object map(Integer n) {
                return MultipleSelectionModelBase.this.getModelItem(n);
            }
        };
        this.selectedIndicesSeq.addListener(new ListChangeListener<Integer>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Integer> change) {
                MultipleSelectionModelBase.this.selectedItemsSeq.callObservers(new MappingChange(change, map, MultipleSelectionModelBase.this.selectedItemsSeq));
                change.reset();
            }
        });
        this.selectedItemsSeq = new ReadOnlyUnbackedObservableList<T>(){

            @Override
            public T get(int n) {
                int n2 = (Integer)MultipleSelectionModelBase.this.selectedIndicesSeq.get(n);
                return MultipleSelectionModelBase.this.getModelItem(n2);
            }

            @Override
            public int size() {
                return MultipleSelectionModelBase.this.selectedIndices.cardinality();
            }
        };
    }

    @Override
    public ObservableList<Integer> getSelectedIndices() {
        return this.selectedIndicesSeq;
    }

    private void setSelectedIndices(BitSet bitSet) {
        this.selectedIndices.clear();
        this.selectedIndices.or(bitSet);
    }

    @Override
    public ObservableList<T> getSelectedItems() {
        return this.selectedItemsSeq;
    }

    protected abstract int getItemCount();

    protected abstract T getModelItem(int var1);

    protected abstract void focus(int var1);

    protected abstract int getFocusedIndex();

    void shiftSelection(int n, int n2) {
        if (n < 0) {
            return;
        }
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                for (int j = this.selectedIndices.size() - 1; j >= n && j >= 0; --j) {
                    this.selectedIndices.set(j + 1, this.selectedIndices.get(j));
                }
                this.selectedIndices.clear(n);
            }
        } else if (n2 < 0) {
            for (int i = 0; i < Math.abs(n2); ++i) {
                for (int j = n; j < this.selectedIndices.size(); ++j) {
                    this.selectedIndices.set(j, this.selectedIndices.get(j + 1));
                }
            }
        }
        if (this.getFocusedIndex() >= n && this.getFocusedIndex() > -1 && this.getFocusedIndex() + n2 > -1) {
            this.setSelectedIndex(this.getFocusedIndex() + n2);
        }
    }

    @Override
    public void clearAndSelect(int n) {
        this.quietClearSelection();
        this.select(n);
    }

    @Override
    public void select(int n) {
        if (n == -1) {
            this.clearSelection();
            return;
        }
        if (n < 0 || n >= this.getItemCount()) {
            return;
        }
        if (!this.selectedIndices.get(n)) {
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
            }
            this.selectedIndices.set(n);
        }
        this.setSelectedIndex(n);
        this.focus(n);
        this.selectedIndicesSeq.callObservers(new NonIterableChange.SimpleAddChange<Integer>(0, 1, this.selectedIndicesSeq));
    }

    @Override
    public void select(T t) {
        Object object = null;
        for (int i = 0; i < this.getItemCount(); ++i) {
            object = this.getModelItem(i);
            if (object == null || !object.equals(t)) continue;
            if (this.isSelected(i)) {
                return;
            }
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
            }
            this.select(i);
            return;
        }
        this.setSelectedItem(t);
    }

    @Override
    public void selectIndices(int n, int ... nArray) {
        if (nArray == null) {
            this.select(n);
            return;
        }
        int n2 = this.getItemCount();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n3 = nArray[i];
                if (n3 < 0 || n3 >= n2) continue;
                this.selectedIndices.set(n3);
                this.select(n3);
                break;
            }
            if (this.selectedIndices.isEmpty() && n > 0 && n < n2) {
                this.selectedIndices.set(n);
                this.select(n);
            }
            this.selectedIndicesSeq.callObservers(new NonIterableChange.SimpleAddChange(0, 1, this.selectedItemsSeq));
        } else {
            int n4 = -1;
            if (n >= 0 && n < n2) {
                n4 = n;
                this.selectedIndices.set(n);
            }
            for (int i = 0; i < nArray.length; ++i) {
                int n5 = nArray[i];
                if (n5 < 0 || n5 >= n2) continue;
                n4 = n5;
                this.selectedIndices.set(n5);
            }
            if (n4 != -1) {
                this.select(n4);
            }
            if (nArray.length == 0) {
                this.selectedIndicesSeq.callObservers(new NonIterableChange.SimpleAddChange<Integer>(n, n, this.selectedIndicesSeq));
            } else {
                this.selectedIndicesSeq.callObservers(new NonIterableChange.SimpleAddChange<Integer>(n, nArray[nArray.length - 1], this.selectedIndicesSeq));
            }
        }
    }

    @Override
    public void selectAll() {
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        this.quietClearSelection();
        if (this.getItemCount() <= 0) {
            return;
        }
        int n = this.getItemCount();
        this.quietClearSelection();
        this.selectedIndices.set(0, n, true);
        this.selectedIndicesSeq.callObservers(new NonIterableChange.SimpleAddChange<Integer>(0, n, this.selectedIndicesSeq));
        this.setSelectedIndex(n - 1);
        this.focus(this.getSelectedIndex());
    }

    @Override
    public void selectFirst() {
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if (this.getItemCount() > 0) {
            this.select(0);
        }
    }

    @Override
    public void selectLast() {
        int n;
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if ((n = this.getItemCount()) > 0 && this.getSelectedIndex() < n - 1) {
            this.select(n - 1);
        }
    }

    @Override
    public void clearSelection(int n) {
        this.selectedIndices.clear(n);
        this.selectedIndicesSeq.callObservers(new NonIterableChange.GenericAddRemoveChange<Integer>(0, 0, Collections.singletonList(n), this.selectedIndicesSeq));
    }

    @Override
    public void clearSelection() {
        this.setSelectedIndex(-1);
        this.focus(-1);
        if (!this.selectedIndices.isEmpty()) {
            AbstractList<Integer> abstractList = new AbstractList<Integer>(){
                final BitSet clone;
                {
                    this.clone = (BitSet)MultipleSelectionModelBase.this.selectedIndices.clone();
                }

                @Override
                public Integer get(int n) {
                    return this.clone.nextSetBit(n);
                }

                @Override
                public int size() {
                    return this.clone.cardinality();
                }
            };
            this.quietClearSelection();
            this.selectedIndicesSeq.callObservers(new NonIterableChange.GenericAddRemoveChange<Integer>(0, 0, abstractList, this.selectedIndicesSeq));
        }
    }

    private void quietClearSelection() {
        this.selectedIndices.clear();
    }

    @Override
    public boolean isSelected(int n) {
        if (n >= 0 && n < this.getItemCount()) {
            return this.selectedIndices.get(n);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.selectedIndices.isEmpty();
    }

    @Override
    public void selectPrevious() {
        int n = this.getFocusedIndex();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if (n == -1) {
            this.select(this.getItemCount() - 1);
        } else if (n > 0) {
            this.select(n - 1);
        }
    }

    @Override
    public void selectNext() {
        int n = this.getFocusedIndex();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if (n == -1) {
            this.select(0);
        } else if (n != this.getItemCount() - 1) {
            this.select(n + 1);
        }
    }
}

