/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.MenuItem;

public class MenuButton
extends ButtonBase {
    private final ObservableList<MenuItem> items = FXCollections.observableArrayList();
    private ReadOnlyBooleanWrapper showing = new ReadOnlyBooleanWrapper(this, "showing", false);
    private ObjectProperty<Side> popupSide;
    private static final String DEFAULT_STYLE_CLASS = "menu-button";
    private static final String PSEUDO_CLASS_OPENVERTICALLY = "openvertically";
    private static final long OPENVERTICALLY_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("openvertically");

    public MenuButton() {
        this(null, null);
    }

    public MenuButton(String string) {
        this(string, null);
    }

    public MenuButton(String string, Node node) {
        if (string != null) {
            this.setText(string);
        }
        if (node != null) {
            this.setGraphic(node);
        }
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setMnemonicParsing(true);
    }

    public final ObservableList<MenuItem> getItems() {
        return this.items;
    }

    private void setShowing(boolean bl) {
        this.showing.set(bl);
    }

    public final boolean isShowing() {
        return this.showing.get();
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.showing.getReadOnlyProperty();
    }

    public final void setPopupSide(Side side) {
        this.popupSideProperty().set(side);
    }

    public final Side getPopupSide() {
        return this.popupSide == null ? Side.BOTTOM : (Side)((Object)this.popupSide.get());
    }

    public final ObjectProperty<Side> popupSideProperty() {
        if (this.popupSide == null) {
            this.popupSide = new ObjectPropertyBase<Side>(Side.BOTTOM){

                @Override
                protected void invalidated() {
                    MenuButton.this.impl_pseudoClassStateChanged(MenuButton.PSEUDO_CLASS_OPENVERTICALLY);
                }

                @Override
                public Object getBean() {
                    return MenuButton.this;
                }

                @Override
                public String getName() {
                    return "popupSide";
                }
            };
        }
        return this.popupSide;
    }

    public void show() {
        if (!this.isDisabled() && !this.showing.isBound()) {
            this.setShowing(true);
        }
    }

    public void hide() {
        if (!this.showing.isBound()) {
            this.setShowing(false);
        }
    }

    @Override
    public void fire() {
        this.fireEvent(new ActionEvent());
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        if (this.getPopupSide() == Side.TOP || this.getPopupSide() == Side.BOTTOM) {
            l |= OPENVERTICALLY_PSEUDOCLASS_STATE;
        }
        return l;
    }
}

