/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.WeakListChangeListener;
import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;

public class ListCell<T>
extends IndexedCell<T> {
    private InvalidationListener indexListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            ListCell.this.updateItem();
            ListCell.this.updateSelection();
            ListCell.this.updateFocus();
        }
    };
    private final InvalidationListener editingListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            int n = ListCell.this.getIndex();
            ListView listView = ListCell.this.getListView();
            int n2 = listView == null ? -1 : listView.getEditingIndex();
            boolean bl = ListCell.this.isEditing();
            if (n != -1 && listView != null) {
                if (n == n2 && !bl) {
                    ListCell.this.startEdit();
                } else if (n != n2 && bl) {
                    ListCell.this.updateEditingIndex = false;
                    ListCell.this.cancelEdit();
                    ListCell.this.updateEditingIndex = true;
                }
            }
        }
    };
    private boolean updateEditingIndex = true;
    private final ListChangeListener selectedListener = new ListChangeListener(){

        public void onChanged(ListChangeListener.Change change) {
            ListCell.this.updateSelection();
        }
    };
    private final ChangeListener selectionModelPropertyListener = new ChangeListener<MultipleSelectionModel>(){

        @Override
        public void changed(ObservableValue observableValue, MultipleSelectionModel multipleSelectionModel, MultipleSelectionModel multipleSelectionModel2) {
            if (multipleSelectionModel != null) {
                multipleSelectionModel.getSelectedIndices().removeListener(ListCell.this.weakSelectedListener);
            }
            if (multipleSelectionModel2 != null) {
                multipleSelectionModel2.getSelectedIndices().addListener(ListCell.this.weakSelectedListener);
            }
            ListCell.this.updateSelection();
        }
    };
    private final ListChangeListener itemsListener = new ListChangeListener(){

        public void onChanged(ListChangeListener.Change change) {
            ListCell.this.updateItem();
        }
    };
    private final ChangeListener itemsPropertyListener = new ChangeListener<ObservableList>(){

        @Override
        public void changed(ObservableValue observableValue, ObservableList observableList, ObservableList observableList2) {
            if (observableList != null) {
                observableList.removeListener(ListCell.this.weakItemsListener);
            }
            if (observableList2 != null) {
                observableList2.addListener(ListCell.this.weakItemsListener);
            }
            ListCell.this.updateItem();
        }
    };
    private final InvalidationListener focusedListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            ListCell.this.updateFocus();
        }
    };
    private final ChangeListener focusModelPropertyListener = new ChangeListener<FocusModel>(){

        @Override
        public void changed(ObservableValue observableValue, FocusModel focusModel, FocusModel focusModel2) {
            if (focusModel != null) {
                focusModel.focusedIndexProperty().removeListener(ListCell.this.weakFocusedListener);
            }
            if (focusModel2 != null) {
                focusModel2.focusedIndexProperty().addListener(ListCell.this.weakFocusedListener);
            }
            ListCell.this.updateFocus();
        }
    };
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private final WeakListChangeListener weakSelectedListener = new WeakListChangeListener(this.selectedListener);
    private final WeakChangeListener weakSelectionModelPropertyListener = new WeakChangeListener(this.selectionModelPropertyListener);
    private final WeakListChangeListener weakItemsListener = new WeakListChangeListener(this.itemsListener);
    private final WeakChangeListener weakItemsPropertyListener = new WeakChangeListener(this.itemsPropertyListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakChangeListener weakFocusModelPropertyListener = new WeakChangeListener(this.focusModelPropertyListener);
    private ReadOnlyObjectWrapper<ListView<T>> listView = new ReadOnlyObjectWrapper<ListView<T>>(this, "listView"){
        private WeakReference<ListView<T>> weakListViewRef;
        {
            this.weakListViewRef = new WeakReference<Object>(null);
        }

        @Override
        protected void invalidated() {
            ObservableList observableList;
            FocusModel focusModel;
            MultipleSelectionModel multipleSelectionModel;
            ListView listView;
            ListView listView2 = (ListView)this.get();
            if (listView2 == (listView = (ListView)this.weakListViewRef.get())) {
                return;
            }
            if (listView != null) {
                multipleSelectionModel = listView.getSelectionModel();
                if (multipleSelectionModel != null) {
                    multipleSelectionModel.getSelectedIndices().removeListener(ListCell.this.weakSelectedListener);
                }
                if ((focusModel = listView.getFocusModel()) != null) {
                    focusModel.focusedIndexProperty().removeListener(ListCell.this.weakFocusedListener);
                }
                if ((observableList = listView.getItems()) != null) {
                    observableList.removeListener(ListCell.this.weakItemsListener);
                }
                listView.editingIndexProperty().removeListener(ListCell.this.weakEditingListener);
                listView.itemsProperty().removeListener(ListCell.this.weakItemsPropertyListener);
                listView.focusModelProperty().removeListener(ListCell.this.weakFocusModelPropertyListener);
                listView.selectionModelProperty().removeListener(ListCell.this.weakSelectionModelPropertyListener);
            }
            if (listView2 != null) {
                multipleSelectionModel = listView2.getSelectionModel();
                if (multipleSelectionModel != null) {
                    multipleSelectionModel.getSelectedIndices().addListener(ListCell.this.weakSelectedListener);
                }
                if ((focusModel = listView2.getFocusModel()) != null) {
                    focusModel.focusedIndexProperty().addListener(ListCell.this.weakFocusedListener);
                }
                if ((observableList = listView2.getItems()) != null) {
                    observableList.addListener(ListCell.this.weakItemsListener);
                }
                listView2.editingIndexProperty().addListener(ListCell.this.weakEditingListener);
                listView2.itemsProperty().addListener(ListCell.this.weakItemsPropertyListener);
                listView2.focusModelProperty().addListener(ListCell.this.weakFocusModelPropertyListener);
                listView2.selectionModelProperty().addListener(ListCell.this.weakSelectionModelPropertyListener);
                this.weakListViewRef = new WeakReference<ListView>(listView2);
            }
            ListCell.this.updateItem();
            ListCell.this.updateSelection();
            ListCell.this.updateFocus();
            ListCell.this.requestLayout();
        }
    };
    private static final String DEFAULT_STYLE_CLASS = "list-cell";

    public ListCell() {
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.indexProperty().addListener(this.indexListener);
    }

    private void setListView(ListView<T> listView) {
        this.listView.set(listView);
    }

    public final ListView<T> getListView() {
        return (ListView)this.listView.get();
    }

    public final ReadOnlyObjectProperty<ListView<T>> listViewProperty() {
        return this.listView.getReadOnlyProperty();
    }

    @Override
    public void startEdit() {
        ListView<T> listView = this.getListView();
        if (!this.isEditable() || listView != null && !listView.isEditable()) {
            return;
        }
        super.startEdit();
        if (listView != null) {
            listView.fireEvent(new ListView.EditEvent<Object>(listView, ListView.editStartEvent(), null, listView.getEditingIndex()));
            listView.edit(this.getIndex());
            listView.requestFocus();
        }
    }

    @Override
    public void commitEdit(T t) {
        if (!this.isEditing()) {
            return;
        }
        ListView<T> listView = this.getListView();
        if (listView != null) {
            listView.fireEvent(new ListView.EditEvent<T>(listView, ListView.editCommitEvent(), t, listView.getEditingIndex()));
        }
        this.updateItem(t, false);
        super.commitEdit(t);
        if (listView != null) {
            listView.edit(-1);
            listView.requestFocus();
        }
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        ListView<T> listView = this.getListView();
        if (listView != null) {
            listView.fireEvent(new ListView.EditEvent<Object>(listView, ListView.editCancelEvent(), null, listView.getEditingIndex()));
        }
        super.cancelEdit();
        if (listView != null) {
            if (this.updateEditingIndex) {
                listView.edit(-1);
            }
            listView.requestFocus();
        }
    }

    private void updateItem() {
        boolean bl;
        ListView<T> listView = this.getListView();
        ObservableList<T> observableList = listView == null ? null : listView.getItems();
        boolean bl2 = bl = observableList != null && this.getIndex() >= 0 && this.getIndex() < observableList.size();
        if (bl) {
            Object e = observableList.get(this.getIndex());
            if (e == null || !e.equals(this.getItem())) {
                this.updateItem(e, false);
            }
        } else {
            this.updateItem(null, true);
        }
    }

    public final void updateListView(ListView<T> listView) {
        this.setListView(listView);
    }

    private void updateSelection() {
        if (this.getIndex() == -1 || this.getListView() == null) {
            return;
        }
        if (this.getListView().getSelectionModel() == null) {
            return;
        }
        this.updateSelected(this.getListView().getSelectionModel().isSelected(this.getIndex()));
    }

    private void updateFocus() {
        if (this.getIndex() == -1 || this.getListView() == null) {
            return;
        }
        if (this.getListView().getFocusModel() == null) {
            return;
        }
        this.setFocused(this.getListView().getFocusModel().isFocused(this.getIndex()));
    }
}

