/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.ChartLayoutAnimator;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Dimension2D;
import javafx.geometry.Side;
import javafx.scene.chart.Axis;
import javafx.util.Duration;

public final class CategoryAxis
extends Axis<String> {
    private List<String> allDataCategories = new ArrayList<String>();
    private final DoubleProperty firstCategoryPos = new SimpleDoubleProperty(this, "firstCategoryPos", 0.0);
    private Object currentAnimationID;
    private final ChartLayoutAnimator animator = new ChartLayoutAnimator(this);
    private ListChangeListener<String> itemsListener = new ListChangeListener<String>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends String> change) {
            CategoryAxis.this.requestAxisLayout();
        }
    };
    @Styleable(property="-fx-start-margin", initial="5")
    private DoubleProperty startMargin = new DoublePropertyBase(5.0){

        @Override
        protected void invalidated() {
            CategoryAxis.this.requestAxisLayout();
        }

        @Override
        public Object getBean() {
            return CategoryAxis.this;
        }

        @Override
        public String getName() {
            return "startMargin";
        }
    };
    @Styleable(property="-fx-end-margin", initial="5")
    private DoubleProperty endMargin = new DoublePropertyBase(5.0){

        @Override
        protected void invalidated() {
            CategoryAxis.this.requestAxisLayout();
        }

        @Override
        public Object getBean() {
            return CategoryAxis.this;
        }

        @Override
        public String getName() {
            return "endMargin";
        }
    };
    @Styleable(property="-fx-gap-start-and-end", initial="true")
    private BooleanProperty gapStartAndEnd = new BooleanPropertyBase(true){

        @Override
        protected void invalidated() {
            CategoryAxis.this.requestAxisLayout();
        }

        @Override
        public Object getBean() {
            return CategoryAxis.this;
        }

        @Override
        public String getName() {
            return "gapStartAndEnd";
        }
    };
    private ObjectProperty<ObservableList<String>> categories = new ObjectPropertyBase<ObservableList<String>>(){
        ObservableList<String> old;

        @Override
        protected void invalidated() {
            ObservableList observableList = (ObservableList)this.get();
            if (this.old != observableList) {
                if (this.old != null) {
                    this.old.removeListener(CategoryAxis.this.itemsListener);
                }
                if (observableList != null) {
                    observableList.addListener(CategoryAxis.this.itemsListener);
                }
                this.old = observableList;
            }
        }

        @Override
        public Object getBean() {
            return CategoryAxis.this;
        }

        @Override
        public String getName() {
            return "categories";
        }
    };
    private final ReadOnlyDoubleWrapper categorySpacing = new ReadOnlyDoubleWrapper(this, "categorySpacing", 1.0);

    public final double getStartMargin() {
        return this.startMargin.getValue();
    }

    public final void setStartMargin(double d) {
        this.startMargin.setValue(d);
    }

    public final DoubleProperty startMarginProperty() {
        return this.startMargin;
    }

    public final double getEndMargin() {
        return this.endMargin.getValue();
    }

    public final void setEndMargin(double d) {
        this.endMargin.setValue(d);
    }

    public final DoubleProperty endMarginProperty() {
        return this.endMargin;
    }

    public final boolean isGapStartAndEnd() {
        return this.gapStartAndEnd.getValue();
    }

    public final void setGapStartAndEnd(boolean bl) {
        this.gapStartAndEnd.setValue(bl);
    }

    public final BooleanProperty gapStartAndEndProperty() {
        return this.gapStartAndEnd;
    }

    public final void setCategories(ObservableList<String> observableList) {
        this.categories.set(observableList);
        this.requestAxisLayout();
    }

    public final ObservableList<String> getCategories() {
        return (ObservableList)this.categories.get();
    }

    public final double getCategorySpacing() {
        return this.categorySpacing.get();
    }

    public final ReadOnlyDoubleProperty categorySpacingProperty() {
        return this.categorySpacing.getReadOnlyProperty();
    }

    public CategoryAxis() {
    }

    public CategoryAxis(ObservableList<String> observableList) {
        this.setAnimated(false);
        this.setCategories(observableList);
        this.allDataCategories.addAll(observableList);
    }

    private double calculateNewSpacing(double d, List<String> list) {
        Side side = this.getSide();
        double d2 = 1.0;
        if (side != null && list != null) {
            double d3 = this.isGapStartAndEnd() ? list.size() : list.size() - 1;
            double d4 = d2 = d3 == 0.0 ? 1.0 : (d - this.getStartMargin() - this.getEndMargin()) / d3;
        }
        if (!this.isAutoRanging()) {
            this.categorySpacing.set(d2);
        }
        return d2;
    }

    private double calculateNewFirstPos(double d, double d2) {
        Side side = this.getSide();
        double d3 = 1.0;
        if (side != null) {
            double d4 = this.isGapStartAndEnd() ? d2 / 2.0 : 0.0;
            d3 = side.equals((Object)Side.TOP) || side.equals((Object)Side.BOTTOM) ? 0.0 + this.getStartMargin() + d4 : d - this.getStartMargin() - d4;
        }
        if (!this.isAutoRanging()) {
            this.firstCategoryPos.set(d3);
        }
        return d3;
    }

    @Override
    protected Object getRange() {
        return new Object[]{this.getCategories(), this.categorySpacing.get(), this.firstCategoryPos.get(), this.getTickLabelRotation()};
    }

    @Override
    protected void setRange(Object object, boolean bl) {
        Object[] objectArray = (Object[])object;
        List list = (List)objectArray[0];
        double d = (Double)objectArray[1];
        double d2 = (Double)objectArray[2];
        double d3 = (Double)objectArray[3];
        this.setTickLabelRotation(d3);
        this.setCategories(FXCollections.observableArrayList(list));
        if (bl) {
            this.animator.stop(this.currentAnimationID);
            this.currentAnimationID = this.animator.animate(new KeyFrame(Duration.ZERO, new KeyValue(this.firstCategoryPos, this.firstCategoryPos.get()), new KeyValue(this.categorySpacing, this.categorySpacing.get())), new KeyFrame(Duration.millis(1000.0), new KeyValue(this.firstCategoryPos, d2), new KeyValue(this.categorySpacing, d)));
        } else {
            this.categorySpacing.set(d);
            this.firstCategoryPos.set(d2);
        }
    }

    @Override
    protected Object autoRange(double d) {
        Side side = this.getSide();
        boolean bl = Side.LEFT.equals((Object)side) || Side.RIGHT.equals((Object)side);
        double d2 = this.calculateNewSpacing(d, this.allDataCategories);
        double d3 = this.calculateNewFirstPos(d, d2);
        double d4 = 0.0;
        double d5 = this.calculateRequiredSize(bl, d4);
        if (d5 > d) {
            d4 = 90.0;
        }
        return new Object[]{this.allDataCategories, d2, d3, d4};
    }

    private double calculateRequiredSize(boolean bl, double d) {
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl2 = true;
        for (String string : this.allDataCategories) {
            double d5;
            Dimension2D dimension2D = this.measureTickMarkSize(string, d);
            double d6 = d5 = bl || d != 0.0 ? dimension2D.getHeight() : dimension2D.getWidth();
            if (bl2) {
                bl2 = false;
                d4 = d5 / 2.0;
                continue;
            }
            d3 = Math.max(d3, d4 + 6.0 + d5 / 2.0);
        }
        return this.getStartMargin() + d3 * (double)this.allDataCategories.size() + this.getEndMargin();
    }

    @Override
    protected List<String> calculateTickValues(double d, Object object) {
        Object[] objectArray = (Object[])object;
        return (List)objectArray[0];
    }

    @Override
    protected String getTickMarkLabel(String string) {
        return string;
    }

    @Override
    protected Dimension2D measureTickMarkSize(String string, Object object) {
        Object[] objectArray = (Object[])object;
        double d = (Double)objectArray[3];
        return this.measureTickMarkSize(string, d);
    }

    @Override
    public void invalidateRange(List<String> list) {
        super.invalidateRange(list);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(list);
        this.allDataCategories.clear();
        this.allDataCategories.addAll(linkedHashSet);
    }

    @Override
    public double getDisplayPosition(String string) {
        if (Side.TOP.equals((Object)this.getSide()) || Side.BOTTOM.equals((Object)this.getSide())) {
            return this.firstCategoryPos.get() + (double)this.getCategories().indexOf("" + string) * this.categorySpacing.get();
        }
        return this.firstCategoryPos.get() + (double)this.getCategories().indexOf("" + string) * this.categorySpacing.get() * -1.0;
    }

    @Override
    public String getValueForDisplay(double d) {
        if (this.getSide().equals((Object)Side.TOP) || this.getSide().equals((Object)Side.BOTTOM)) {
            if (d < 0.0 || d > this.getHeight()) {
                return null;
            }
            double d2 = (d - this.firstCategoryPos.get()) / this.categorySpacing.get();
            return this.toRealValue(d2);
        }
        if (d < 0.0 || d > this.getWidth()) {
            return null;
        }
        double d3 = (d - this.firstCategoryPos.get()) / (this.categorySpacing.get() * -1.0);
        return this.toRealValue(d3);
    }

    @Override
    public boolean isValueOnAxis(String string) {
        return this.getCategories().indexOf("" + string) != -1;
    }

    @Override
    public double toNumericValue(String string) {
        return this.getCategories().indexOf(string);
    }

    @Override
    public String toRealValue(double d) {
        int n = (int)Math.round(d);
        ObservableList<String> observableList = this.getCategories();
        if (n >= 0 && n < observableList.size()) {
            return (String)this.getCategories().get(n);
        }
        return null;
    }

    @Override
    public double getZeroPosition() {
        return Double.NaN;
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-start-margin".equals(string)) {
            this.setStartMargin((Double)object);
        } else if ("-fx-end-margin".equals(string)) {
            this.setEndMargin((Double)object);
        } else if ("-fx-gap-start-and-end".equals(string)) {
            this.setGapStartAndEnd((Boolean)object);
        } else {
            return super.impl_cssSet(string, object);
        }
        return true;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-start-margin".equals(string)) {
            return this.startMargin == null || !this.startMargin.isBound();
        }
        if ("-fx-end-margin".equals(string)) {
            return this.endMargin == null || !this.endMargin.isBound();
        }
        if ("-fx-gap-start-and-end".equals(string)) {
            return this.gapStartAndEnd == null || !this.gapStartAndEnd.isBound();
        }
        return super.impl_cssSettable(string);
    }

    private static class StyleableProperties {
        private static final StyleableProperty START_MARGIN = new StyleableProperty(CategoryAxis.class, "startMargin");
        private static final StyleableProperty END_MARGIN = new StyleableProperty(CategoryAxis.class, "endMargin");
        private static final StyleableProperty GAP_START_AND_END = new StyleableProperty(CategoryAxis.class, "gapStartAndEnd");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Axis.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, START_MARGIN, END_MARGIN, GAP_START_AND_END);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

