/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.Logging;
import com.sun.javafx.Utils;
import com.sun.javafx.beans.event.AbstractNotifyListener;
import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.robot.impl.FXRobotHelper;
import com.sun.javafx.runtime.SystemProperties;
import com.sun.javafx.scene.CSSFlags;
import com.sun.javafx.scene.SceneEventDispatcher;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalEngine;
import com.sun.javafx.tk.TKDragGestureListener;
import com.sun.javafx.tk.TKDragSourceListener;
import com.sun.javafx.tk.TKDropTargetListener;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKSceneListener;
import com.sun.javafx.tk.TKScenePaintListener;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.Toolkit;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Camera;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.Mnemonic;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Window;
import javafx.util.Duration;

public class Scene
implements EventTarget {
    private double widthSetByUser = -1.0;
    private double heightSetByUser = -1.0;
    private boolean sizeInitialized = false;
    private boolean depthBuffer = false;
    private int dirtyBits;
    private static final double HASH_LOAD = 0.75;
    private static final int MIN_DIRTY_CAPACITY = 40;
    private static boolean inSynchronizer;
    private static boolean inMousePick;
    private static boolean allowPGAccess;
    private static int pgAccessCount;
    private static final boolean PLATFORM_DRAG_GESTURE_INITIATION = false;
    private LinkedHashSet dirtyNodesA;
    private LinkedHashSet dirtyNodesB;
    private LinkedHashSet dirtyNodes;
    private List dirtyLayoutRoots = new ArrayList(10);
    @Deprecated
    private TKScene impl_peer;
    ScenePulseListener scenePulseListener = new ScenePulseListener();
    private ReadOnlyObjectWrapper<Window> window;
    DnDGesture dndGesture = null;
    DragGestureListener dragGestureListener;
    private ReadOnlyDoubleWrapper x;
    private ReadOnlyDoubleWrapper y;
    private ReadOnlyDoubleWrapper width;
    private ReadOnlyDoubleWrapper height;
    private ObjectProperty<Camera> camera;
    private Camera oldCamera;
    private final AbstractNotifyListener cameraChangeListener = new AbstractNotifyListener(){

        @Override
        public void invalidated(Observable observable) {
            if (Scene.this.getCamera().impl_isDirty()) {
                Scene.this.markDirty(DirtyBits.CAMERA_DIRTY);
            }
        }
    };
    private ObjectProperty<Paint> fill;
    private ObjectProperty<Parent> root;
    Parent oldRoot;
    boolean initialized = false;
    private ObjectProperty<Cursor> cursor;
    private final ObservableList<String> stylesheets = new TrackableObservableList<String>(){

        @Override
        protected void onChanged(ListChangeListener.Change<String> change) {
            StyleManager.getInstance().updateStylesheets(Scene.this);
            Scene.this.getRoot().impl_reapplyCSS();
        }
    };
    private PerformanceTracker tracker;
    private static final Object trackerMonitor;
    private MouseHandler mouseHandler;
    private ClickGenerator clickGenerator;
    private KeyHandler keyHandler = null;
    private boolean focusDirty = true;
    Map traversalRegistry;
    private final ObservableList<EventHandler<KeyEvent>> keyListeners = FXCollections.observableArrayList();
    @Deprecated
    private ObjectProperty<Node> impl_focusOwner;
    @Deprecated
    public Runnable impl_testPulseListener = null;
    private ObjectProperty<EventDispatcher> eventDispatcher;
    private SceneEventDispatcher internalEventDispatcher;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseClicked;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseDragged;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseEntered;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseExited;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseMoved;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMousePressed;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseReleased;
    private ObjectProperty<EventHandler<? super MouseEvent>> onDragDetected;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseWheelRotated;
    private ObjectProperty<EventHandler<? super ScrollEvent>> onScroll;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragEntered;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragExited;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragOver;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragDropped;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragDone;
    private ObjectProperty<EventHandler<? super KeyEvent>> onKeyPressed;
    private ObjectProperty<EventHandler<? super KeyEvent>> onKeyReleased;
    private ObjectProperty<EventHandler<? super KeyEvent>> onKeyTyped;
    private ObjectProperty<EventHandler<? super InputMethodEvent>> onInputMethodTextChanged;

    public Scene(Parent parent) {
        this(parent, -1.0, -1.0, Color.WHITE, false);
    }

    public Scene(Parent parent, double d, double d2) {
        this(parent, d, d2, Color.WHITE, false);
    }

    public Scene(Parent parent, Paint paint) {
        this(parent, -1.0, -1.0, paint, false);
    }

    public Scene(Parent parent, double d, double d2, Paint paint) {
        this(parent, d, d2, paint, false);
    }

    public Scene(Parent parent, double d, double d2, boolean bl) {
        this(parent, d, d2, Color.WHITE, bl);
    }

    private Scene(Parent parent, double d, double d2, Paint paint, boolean bl) {
        Toolkit.getToolkit().checkFxUserThread();
        this.setRoot(parent);
        this.init(d, d2, bl);
        this.setFill(paint);
    }

    @Deprecated
    public static boolean impl_isPGAccessAllowed() {
        return inSynchronizer || inMousePick || allowPGAccess;
    }

    @Deprecated
    public static void impl_setAllowPGAccess(boolean bl) {
        if (Utils.assertionEnabled()) {
            if (bl) {
                ++pgAccessCount;
                allowPGAccess = true;
            } else {
                if (pgAccessCount <= 0) {
                    throw new AssertionError((Object)"*** pgAccessCount underflow");
                }
                if (--pgAccessCount == 0) {
                    allowPGAccess = false;
                }
            }
        }
    }

    void addToDirtyList(Node node) {
        if ((this.dirtyNodes == null || this.dirtyNodes.isEmpty()) && this.impl_peer != null) {
            Toolkit.getToolkit().requestNextPulse();
        }
        if (this.dirtyNodes != null) {
            this.dirtyNodes.add(node);
        }
    }

    void removeFromDirtyList(Node node) {
        if (this.dirtyNodes != null) {
            this.dirtyNodes.remove(node);
        }
    }

    private void doCSSPass() {
        StyleManager.getInstance().clearCachedValues(this);
        if (this.getRoot().impl_isDirty(com.sun.javafx.scene.DirtyBits.NODE_CSS)) {
            this.getRoot().impl_clearDirty(com.sun.javafx.scene.DirtyBits.NODE_CSS);
            this.getRoot().processCSS();
        }
    }

    @Deprecated
    public void addToDirtyLayoutList(Parent parent) {
        if (this.dirtyLayoutRoots.isEmpty()) {
            Toolkit.getToolkit().requestNextPulse();
        }
        if (!this.dirtyLayoutRoots.contains(parent)) {
            this.dirtyLayoutRoots.add(parent);
        }
    }

    void removeFromDirtyLayoutList(Parent parent) {
        if (this.dirtyLayoutRoots.contains(parent)) {
            this.dirtyLayoutRoots.remove(parent);
        }
    }

    private void doLayoutPass() {
        this.layoutDirtyRoots();
        this.layoutDirtyRoots();
        if (this.dirtyLayoutRoots.size() > 0) {
            PlatformLogger platformLogger = Logging.getLayoutLogger();
            if (platformLogger.isLoggable(400)) {
                platformLogger.finer("after layout pass, " + this.dirtyLayoutRoots.size() + " layout root nodes still dirty");
            }
            Toolkit.getToolkit().requestNextPulse();
        }
    }

    private void layoutDirtyRoots() {
        if (this.dirtyLayoutRoots.size() > 0) {
            PlatformLogger platformLogger = Logging.getLayoutLogger();
            ArrayList arrayList = new ArrayList(this.dirtyLayoutRoots);
            this.dirtyLayoutRoots.clear();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Parent parent = (Parent)arrayList.get(i);
                if (parent.getScene() != this || !parent.isNeedsLayout()) continue;
                if (platformLogger.isLoggable(500)) {
                    platformLogger.fine("<<< START >>> root = " + parent.toString());
                }
                parent.layout();
                if (!platformLogger.isLoggable(500)) continue;
                platformLogger.fine("<<<  END  >>> root = " + parent.toString());
            }
        }
    }

    @Deprecated
    public TKScene impl_getPeer() {
        return this.impl_peer;
    }

    @Deprecated
    public TKPulseListener impl_getScenePulseListener() {
        if (SystemProperties.isDebug()) {
            return this.scenePulseListener;
        }
        return null;
    }

    private void setWindow(Window window) {
        this.windowPropertyImpl().set(window);
    }

    public final Window getWindow() {
        return this.window == null ? null : (Window)this.window.get();
    }

    public final ReadOnlyObjectProperty<Window> windowProperty() {
        return this.windowPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Window> windowPropertyImpl() {
        if (this.window == null) {
            this.window = new ReadOnlyObjectWrapper<Window>(){

                @Override
                protected void invalidated() {
                    if (this.get() != null) {
                        Scene.this.impl_disposePeer();
                    }
                    Window window = (Window)this.get();
                    KeyHandler keyHandler = Scene.this.getKeyHandler();
                    keyHandler.windowForSceneChanged(window, (Window)this.get());
                    if (this.get() != null) {
                        Scene.this.impl_initPeer();
                    }
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "window";
                }
            };
        }
        return this.window;
    }

    @Deprecated
    public void impl_setWindow(Window window) {
        this.setWindow(window);
        if (this.impl_peer != null) {
            this.impl_peer.markDirty();
        }
    }

    @Deprecated
    public void impl_initPeer() {
        if (this.impl_peer != null) {
            return;
        }
        PerformanceTracker.logEvent("Scene.initPeer started");
        Toolkit toolkit = Toolkit.getToolkit();
        if (this.getWindow() == null) {
            return;
        }
        TKStage tKStage = this.getWindow().impl_getPeer();
        if (tKStage == null) {
            return;
        }
        Scene.impl_setAllowPGAccess(true);
        this.impl_peer = tKStage.createTKScene(this.isDepthBuffer());
        PerformanceTracker.logEvent("Scene.initPeer TKScene created");
        this.impl_peer.setTKSceneListener(new ScenePeerListener());
        this.impl_peer.setTKScenePaintListener(new ScenePeerPaintListener());
        this.impl_peer.setScene(this);
        PerformanceTracker.logEvent("Scene.initPeer TKScene set");
        this.impl_peer.setRoot(this.getRoot().impl_getPGNode());
        if (!this.sizeInitialized) {
            this.preferredSize();
        }
        this.impl_peer.setFillPaint(this.getFill() == null ? null : toolkit.getPaint(this.getFill()));
        this.impl_peer.setCamera(this.getCamera() == null ? null : this.getCamera().getPlatformCamera());
        Scene.impl_setAllowPGAccess(false);
        PerformanceTracker.logEvent("Scene.initPeer TKScene initialized");
        toolkit.addSceneTkPulseListener(this.scenePulseListener);
        toolkit.enableDrop(this.impl_peer, new DropTargetListener());
        toolkit.installInputMethodRequests(this.impl_peer, new InputMethodRequestsDelegate());
        PerformanceTracker.logEvent("Scene.initPeer finished");
    }

    @Deprecated
    public void impl_disposePeer() {
        if (this.impl_peer == null) {
            return;
        }
        Toolkit toolkit = Toolkit.getToolkit();
        toolkit.removeSceneTkPulseListener(this.scenePulseListener);
        this.impl_peer.setScene(null);
        this.impl_peer = null;
    }

    private final void setX(double d) {
        this.xPropertyImpl().set(d);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final ReadOnlyDoubleProperty xProperty() {
        return this.xPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper xPropertyImpl() {
        if (this.x == null) {
            this.x = new ReadOnlyDoubleWrapper(this, "x");
        }
        return this.x;
    }

    private final void setY(double d) {
        this.yPropertyImpl().set(d);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final ReadOnlyDoubleProperty yProperty() {
        return this.yPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper yPropertyImpl() {
        if (this.y == null) {
            this.y = new ReadOnlyDoubleWrapper(this, "y");
        }
        return this.y;
    }

    private final void setWidth(double d) {
        this.widthPropertyImpl().set(d);
    }

    public final double getWidth() {
        return this.width == null ? 0.0 : this.width.get();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.widthPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper widthPropertyImpl() {
        if (this.width == null) {
            this.width = new ReadOnlyDoubleWrapper(){

                @Override
                protected void invalidated() {
                    Parent parent = Scene.this.getRoot();
                    if (parent.isResizable()) {
                        parent.resize(this.get() - parent.getLayoutX() - parent.getTranslateX(), parent.getLayoutBounds().getHeight());
                    }
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "width";
                }
            };
        }
        return this.width;
    }

    private final void setHeight(double d) {
        this.heightPropertyImpl().set(d);
    }

    public final double getHeight() {
        return this.height == null ? 0.0 : this.height.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.heightPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper heightPropertyImpl() {
        if (this.height == null) {
            this.height = new ReadOnlyDoubleWrapper(){

                @Override
                protected void invalidated() {
                    Parent parent = Scene.this.getRoot();
                    if (parent.isResizable()) {
                        parent.resize(parent.getLayoutBounds().getWidth(), this.get() - parent.getLayoutY() - parent.getTranslateY());
                    }
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "height";
                }
            };
        }
        return this.height;
    }

    public final void setCamera(Camera camera) {
        this.cameraProperty().set(camera);
    }

    public final Camera getCamera() {
        return this.camera == null ? null : (Camera)this.camera.get();
    }

    public final ObjectProperty<Camera> cameraProperty() {
        if (this.camera == null) {
            this.camera = new ObjectPropertyBase<Camera>(){

                @Override
                protected void invalidated() {
                    if (Scene.this.oldCamera != null) {
                        Scene.this.oldCamera.dirtyProperty().removeListener(Scene.this.cameraChangeListener.getWeakListener());
                    }
                    Scene.this.oldCamera = (Camera)this.get();
                    if (this.get() != null) {
                        ((Camera)this.get()).dirtyProperty().addListener(Scene.this.cameraChangeListener.getWeakListener());
                    }
                    Scene.this.markDirty(DirtyBits.CAMERA_DIRTY);
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "camera";
                }
            };
        }
        return this.camera;
    }

    public final void setFill(Paint paint) {
        this.fillProperty().set(paint);
    }

    public final Paint getFill() {
        return this.fill == null ? Color.WHITE : (Paint)this.fill.get();
    }

    public final ObjectProperty<Paint> fillProperty() {
        if (this.fill == null) {
            this.fill = new ObjectPropertyBase<Paint>((Paint)Color.WHITE){

                @Override
                protected void invalidated() {
                    Scene.this.markDirty(DirtyBits.FILL_DIRTY);
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "fill";
                }
            };
        }
        return this.fill;
    }

    public final void setRoot(Parent parent) {
        this.rootProperty().set(parent);
    }

    public final Parent getRoot() {
        return this.root == null ? null : (Parent)this.root.get();
    }

    public final ObjectProperty<Parent> rootProperty() {
        if (this.root == null) {
            this.root = new ObjectPropertyBase<Parent>(){

                private void forceUnbind() {
                    System.err.println("Unbinding illegal root.");
                    this.unbind();
                }

                @Override
                protected void invalidated() {
                    Parent parent = (Parent)this.get();
                    if (parent != null && parent.getParent() != null) {
                        if (this.isBound()) {
                            this.forceUnbind();
                        }
                        throw new IllegalArgumentException(parent + "is already inside a scene-graph and cannot be set as root");
                    }
                    if (parent != null && parent.impl_getClipParent() != null) {
                        if (this.isBound()) {
                            this.forceUnbind();
                        }
                        throw new IllegalArgumentException(parent + "is set as a clip on another node, so cannot be set as root");
                    }
                    if (parent != null && parent.isSceneRoot() && parent.getScene() != Scene.this) {
                        if (this.isBound()) {
                            this.forceUnbind();
                        }
                        throw new IllegalArgumentException(parent + "is already set as root of another scene");
                    }
                    if (Scene.this.oldRoot != null) {
                        Scene.this.oldRoot.setScene(null);
                        Scene.this.oldRoot.setImpl_traversalEngine(null);
                    }
                    Scene.this.oldRoot = parent;
                    if (parent != null) {
                        if (parent.getImpl_traversalEngine() == null) {
                            parent.setImpl_traversalEngine(new TraversalEngine(parent, true));
                        }
                        parent.getStyleClass().add(0, "root");
                        parent.setScene(Scene.this);
                        Scene.this.markDirty(DirtyBits.ROOT_DIRTY);
                        if (Scene.this.impl_peer != null && !Scene.this.sizeInitialized) {
                            Scene.this.preferredSize();
                        }
                        parent.resize(Scene.this.getWidth(), Scene.this.getHeight());
                        parent.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "root";
                }
            };
        }
        return this.root;
    }

    @Deprecated
    public Object renderToImage(Object object) {
        return this.renderToImage(object, 1.0f);
    }

    @Deprecated
    public Object renderToImage(Object object, float f) {
        return this.renderToImage(object, f, true);
    }

    private void doLayoutPassWithoutPulse(int n) {
        for (int i = 0; this.dirtyLayoutRoots.size() > 0 && i != n; ++i) {
            this.layoutDirtyRoots();
        }
    }

    @Deprecated
    public Object renderToImage(Object object, float f, boolean bl) {
        this.doCSSPass();
        this.doLayoutPassWithoutPulse(3);
        if (bl) {
            this.scenePulseListener.synchronizeSceneNodes();
        }
        Scene.impl_setAllowPGAccess(true);
        if (!this.sizeInitialized) {
            this.preferredSize();
        }
        Toolkit toolkit = Toolkit.getToolkit();
        Toolkit.ImageRenderingContext imageRenderingContext = new Toolkit.ImageRenderingContext();
        imageRenderingContext.width = this.getWidth();
        imageRenderingContext.height = this.getHeight();
        imageRenderingContext.scale = f;
        imageRenderingContext.depthBuffer = this.isDepthBuffer();
        imageRenderingContext.root = this.getRoot().impl_getPGNode();
        Object object2 = imageRenderingContext.platformPaint = this.getFill() == null ? null : toolkit.getPaint(this.getFill());
        if (this.getCamera() != null) {
            this.getCamera().impl_update();
            imageRenderingContext.camera = this.getCamera().getPlatformCamera();
        }
        imageRenderingContext.platformImage = object;
        Scene.impl_setAllowPGAccess(false);
        Object object3 = toolkit.renderToImage(imageRenderingContext);
        if (this.impl_peer != null) {
            this.impl_peer.entireSceneNeedsRepaint();
        }
        return object3;
    }

    public final void setCursor(Cursor cursor) {
        this.cursorProperty().set(cursor);
    }

    public final Cursor getCursor() {
        return this.cursor == null ? null : (Cursor)this.cursor.get();
    }

    public final ObjectProperty<Cursor> cursorProperty() {
        if (this.cursor == null) {
            this.cursor = new SimpleObjectProperty<Cursor>(this, "cursor");
        }
        return this.cursor;
    }

    public Node lookup(String string) {
        return this.getRoot().lookup(string);
    }

    public final ObservableList<String> getStylesheets() {
        return this.stylesheets;
    }

    @Deprecated
    public void impl_invalidateCSS() {
        this.getRoot().impl_reapplyCSS();
    }

    public final boolean isDepthBuffer() {
        return this.depthBuffer;
    }

    private void init(double d, double d2, boolean bl) {
        if (d >= 0.0) {
            this.widthSetByUser = d;
            this.setWidth((float)d);
        }
        if (d2 >= 0.0) {
            this.heightSetByUser = d2;
            this.setHeight((float)d2);
        }
        this.sizeInitialized = this.widthSetByUser >= 0.0 && this.heightSetByUser >= 0.0;
        this.depthBuffer = bl;
        this.init();
    }

    private void init() {
        if (PerformanceTracker.isLoggingEnabled()) {
            PerformanceTracker.logEvent("Scene.init for [" + this + "]");
        }
        this.mouseHandler = new MouseHandler();
        this.clickGenerator = new ClickGenerator();
        this.initialized = true;
        if (PerformanceTracker.isLoggingEnabled()) {
            PerformanceTracker.logEvent("Scene.init for [" + this + "] - finished");
        }
    }

    private void preferredSize() {
        Parent parent = this.getRoot();
        this.doCSSPass();
        boolean bl = false;
        boolean bl2 = false;
        double d = this.widthSetByUser;
        double d2 = this.heightSetByUser;
        if (this.widthSetByUser < 0.0) {
            d = parent.prefWidth(this.heightSetByUser >= 0.0 ? this.heightSetByUser : -1.0);
            bl = true;
        }
        if (this.heightSetByUser < 0.0) {
            d2 = parent.prefHeight(this.widthSetByUser >= 0.0 ? this.widthSetByUser : -1.0);
            bl2 = true;
        }
        parent.resize(d, d2);
        this.doLayoutPass();
        if (bl) {
            this.setWidth(parent.isResizable() ? parent.getLayoutX() + parent.getTranslateX() + parent.getLayoutBounds().getWidth() : parent.getBoundsInParent().getMaxX());
        } else {
            this.setWidth(this.widthSetByUser);
        }
        if (bl2) {
            this.setHeight(parent.isResizable() ? parent.getLayoutY() + parent.getTranslateY() + parent.getLayoutBounds().getHeight() : parent.getBoundsInParent().getMaxY());
        } else {
            this.setHeight(this.heightSetByUser);
        }
        this.sizeInitialized = this.getWidth() > 0.0 && this.getHeight() > 0.0;
        PerformanceTracker.logEvent("Scene preferred bounds computation complete");
    }

    @Deprecated
    public void impl_preferredSize() {
        this.preferredSize();
    }

    @Deprecated
    public void impl_processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getEventType() == MouseEvent.MOUSE_CLICKED) {
            return;
        }
        this.mouseHandler.process(mouseEvent);
    }

    private void processScrollEvent(ScrollEvent scrollEvent) {
        EventTarget eventTarget = null;
        if (scrollEvent.getEventType() != MouseEvent.MOUSE_EXITED) {
            if (this.getCamera() instanceof PerspectiveCamera) {
                PickRay pickRay = new PickRay();
                this.impl_peer.computePickRay((float)scrollEvent.getX(), (float)scrollEvent.getY(), pickRay);
                eventTarget = this.mouseHandler.pickNode(pickRay);
            } else {
                eventTarget = this.mouseHandler.pickNode(scrollEvent.getX(), scrollEvent.getY());
            }
        }
        if (eventTarget == null) {
            eventTarget = this;
        }
        Event.fireEvent(eventTarget, scrollEvent);
    }

    Node test_pick(double d, double d2) {
        inMousePick = true;
        Node node = this.mouseHandler.pickNode(d, d2);
        inMousePick = false;
        return node;
    }

    private KeyHandler getKeyHandler() {
        if (this.keyHandler == null) {
            this.keyHandler = new KeyHandler();
        }
        return this.keyHandler;
    }

    final void setFocusDirty(boolean bl) {
        this.focusDirty = bl;
    }

    final boolean isFocusDirty() {
        return this.focusDirty;
    }

    private TraversalEngine lookupTraversalEngine(Node node) {
        for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getImpl_traversalEngine() == null) continue;
            return parent.getImpl_traversalEngine();
        }
        return this.getRoot().getImpl_traversalEngine();
    }

    void registerTraversable(Node node) {
        TraversalEngine traversalEngine = this.lookupTraversalEngine(node);
        if (traversalEngine != null) {
            if (this.traversalRegistry == null) {
                this.traversalRegistry = new HashMap();
            }
            this.traversalRegistry.put(node, traversalEngine);
            traversalEngine.reg(node);
        }
    }

    void unregisterTraversable(Node node) {
        TraversalEngine traversalEngine = (TraversalEngine)this.traversalRegistry.remove(node);
        if (traversalEngine != null) {
            traversalEngine.unreg(node);
        }
    }

    void traverse(Node node, Direction direction) {
        if (this.traversalRegistry != null) {
            TraversalEngine traversalEngine = (TraversalEngine)this.traversalRegistry.get(node);
            if (traversalEngine == null) {
                traversalEngine = this.lookupTraversalEngine(node);
            }
            traversalEngine.trav(node, direction);
        }
    }

    private void focusInitial() {
        this.getRoot().getImpl_traversalEngine().getTopLeftFocusableNode();
    }

    private void focusIneligible(Node node) {
        this.traverse(node, Direction.NEXT);
    }

    @Deprecated
    public void impl_processKeyEvent(KeyEvent keyEvent) {
        if (this.dndGesture != null && !this.dndGesture.processKey(keyEvent)) {
            this.dndGesture = null;
        }
        int n = this.keyListeners.size();
        for (int i = 0; i < n; ++i) {
            ((EventHandler)this.keyListeners.get(i)).handle(keyEvent);
        }
        this.getKeyHandler().process(keyEvent);
        if (!keyEvent.isConsumed() && keyEvent.getCode() == KeyCode.DIGIT8 && keyEvent.getEventType() == KeyEvent.KEY_PRESSED && keyEvent.isControlDown() && keyEvent.isShiftDown()) {
            try {
                Class<?> clazz = Class.forName("com.javafx.experiments.scenicview.ScenicView");
                Class[] classArray = new Class[]{Scene.class};
                Method method = clazz.getDeclaredMethod("show", classArray);
                method.invoke(null, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public void impl_addKeyListener(EventHandler<KeyEvent> eventHandler) {
        if (!this.keyListeners.contains(eventHandler)) {
            this.keyListeners.add(eventHandler);
        }
    }

    @Deprecated
    public void impl_removeKeyListener(EventHandler<KeyEvent> eventHandler) {
        if (this.keyListeners.contains(eventHandler)) {
            this.keyListeners.remove(eventHandler);
        }
    }

    void requestFocus(Node node) {
        this.getKeyHandler().requestFocus(node);
    }

    @Deprecated
    public Node impl_getFocusOwner() {
        return this.getKeyHandler().getFocusOwner();
    }

    @Deprecated
    public final void setImpl_focusOwner(Node node) {
        this.impl_focusOwnerProperty().set(node);
    }

    @Deprecated
    public final Node getImpl_focusOwner() {
        return this.impl_focusOwner == null ? null : (Node)this.impl_focusOwner.get();
    }

    @Deprecated
    public final ObjectProperty<Node> impl_focusOwnerProperty() {
        if (this.impl_focusOwner == null) {
            this.impl_focusOwner = new SimpleObjectProperty<Node>(this, "impl_focusOwner");
        }
        return this.impl_focusOwner;
    }

    void focusCleanup() {
        this.scenePulseListener.focusCleanup();
    }

    @Deprecated
    public void impl_processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        Node node = this.impl_getFocusOwner();
        if (node != null) {
            node.fireEvent(inputMethodEvent);
        }
    }

    @Deprecated
    public void impl_enableInputMethodEvents(boolean bl) {
        if (this.impl_peer != null) {
            this.impl_peer.enableInputMethodEvents(bl);
        }
    }

    @Deprecated
    public boolean impl_isQuiescent() {
        return !this.isFocusDirty() && this.getRoot().cssFlag == CSSFlags.CLEAN && this.dirtyLayoutRoots.isEmpty();
    }

    private void markDirty(DirtyBits dirtyBits) {
        this.setDirty(dirtyBits);
        if (this.impl_peer != null) {
            Toolkit.getToolkit().requestNextPulse();
        }
    }

    private void setDirty(DirtyBits dirtyBits) {
        this.dirtyBits |= dirtyBits.getMask();
    }

    private boolean isDirty(DirtyBits dirtyBits) {
        return (this.dirtyBits & dirtyBits.getMask()) != 0;
    }

    private boolean isDirtyEmpty() {
        return this.dirtyBits == 0;
    }

    private void clearDirty() {
        this.dirtyBits = 0;
    }

    public final void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcherProperty().set(eventDispatcher);
    }

    public final EventDispatcher getEventDispatcher() {
        return (EventDispatcher)this.eventDispatcherProperty().get();
    }

    public final ObjectProperty<EventDispatcher> eventDispatcherProperty() {
        this.initializeInternalEventDispatcher();
        return this.eventDispatcher;
    }

    public final <T extends Event> void addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void addEventFilter(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventFilter(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventFilter(eventType, eventHandler);
    }

    protected final <T extends Event> void setEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().setEventHandler(eventType, eventHandler);
    }

    private SceneEventDispatcher getInternalEventDispatcher() {
        this.initializeInternalEventDispatcher();
        return this.internalEventDispatcher;
    }

    private void initializeInternalEventDispatcher() {
        if (this.internalEventDispatcher == null) {
            this.internalEventDispatcher = this.createInternalEventDispatcher();
            this.eventDispatcher = new SimpleObjectProperty<SceneEventDispatcher>(this, "eventDispatcher", this.internalEventDispatcher);
        }
    }

    private SceneEventDispatcher createInternalEventDispatcher() {
        return new SceneEventDispatcher(this);
    }

    public void addMnemonic(Mnemonic mnemonic) {
        this.getInternalEventDispatcher().getKeyboardShortcutsHandler().addMnemonic(mnemonic);
    }

    public void removeMnemonic(Mnemonic mnemonic) {
        this.getInternalEventDispatcher().getKeyboardShortcutsHandler().removeMnemonic(mnemonic);
    }

    public ObservableMap<KeyCombination, ObservableList<Mnemonic>> getMnemonics() {
        return this.getInternalEventDispatcher().getKeyboardShortcutsHandler().getMnemonics();
    }

    public ObservableMap<KeyCombination, Runnable> getAccelerators() {
        return this.getInternalEventDispatcher().getKeyboardShortcutsHandler().getAccelerators();
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        if (this.eventDispatcher != null) {
            eventDispatchChain = eventDispatchChain.prepend((EventDispatcher)this.eventDispatcher.get());
        }
        if (this.getWindow() != null) {
            eventDispatchChain = this.getWindow().buildEventDispatchChain(eventDispatchChain);
        }
        return eventDispatchChain;
    }

    public final void setOnMouseClicked(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseClickedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseClicked() {
        return this.onMouseClicked == null ? null : (EventHandler)this.onMouseClicked.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseClickedProperty() {
        if (this.onMouseClicked == null) {
            this.onMouseClicked = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseClicked";
                }
            };
        }
        return this.onMouseClicked;
    }

    public final void setOnMouseDragged(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseDraggedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseDragged() {
        return this.onMouseDragged == null ? null : (EventHandler)this.onMouseDragged.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseDraggedProperty() {
        if (this.onMouseDragged == null) {
            this.onMouseDragged = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_DRAGGED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseDragged";
                }
            };
        }
        return this.onMouseDragged;
    }

    public final void setOnMouseEntered(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseEnteredProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseEntered() {
        return this.onMouseEntered == null ? null : (EventHandler)this.onMouseEntered.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseEnteredProperty() {
        if (this.onMouseEntered == null) {
            this.onMouseEntered = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseEntered";
                }
            };
        }
        return this.onMouseEntered;
    }

    public final void setOnMouseExited(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseExitedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseExited() {
        return this.onMouseExited == null ? null : (EventHandler)this.onMouseExited.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseExitedProperty() {
        if (this.onMouseExited == null) {
            this.onMouseExited = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseExited";
                }
            };
        }
        return this.onMouseExited;
    }

    public final void setOnMouseMoved(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseMovedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseMoved() {
        return this.onMouseMoved == null ? null : (EventHandler)this.onMouseMoved.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseMovedProperty() {
        if (this.onMouseMoved == null) {
            this.onMouseMoved = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_MOVED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseMoved";
                }
            };
        }
        return this.onMouseMoved;
    }

    public final void setOnMousePressed(EventHandler<? super MouseEvent> eventHandler) {
        this.onMousePressedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMousePressed() {
        return this.onMousePressed == null ? null : (EventHandler)this.onMousePressed.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMousePressedProperty() {
        if (this.onMousePressed == null) {
            this.onMousePressed = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMousePressed";
                }
            };
        }
        return this.onMousePressed;
    }

    public final void setOnMouseReleased(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseReleasedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseReleased() {
        return this.onMouseReleased == null ? null : (EventHandler)this.onMouseReleased.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseReleasedProperty() {
        if (this.onMouseReleased == null) {
            this.onMouseReleased = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_RELEASED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseReleased";
                }
            };
        }
        return this.onMouseReleased;
    }

    public final void setOnDragDetected(EventHandler<? super MouseEvent> eventHandler) {
        this.onDragDetectedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnDragDetected() {
        return this.onDragDetected == null ? null : (EventHandler)this.onDragDetected.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onDragDetectedProperty() {
        if (this.onDragDetected == null) {
            this.onDragDetected = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.DRAG_DETECTED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragDetected";
                }
            };
        }
        return this.onDragDetected;
    }

    @Deprecated
    public final void impl_setOnMouseWheelRotated(EventHandler<? super MouseEvent> eventHandler) {
        this.impl_onMouseWheelRotatedProperty().set(eventHandler);
    }

    @Deprecated
    public final EventHandler<? super MouseEvent> impl_getOnMouseWheelRotated() {
        return this.onMouseWheelRotated == null ? null : (EventHandler)this.onMouseWheelRotated.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> impl_onMouseWheelRotatedProperty() {
        if (this.onMouseWheelRotated == null) {
            this.onMouseWheelRotated = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.IMPL_MOUSE_WHEEL_ROTATED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseWheelRotated";
                }
            };
        }
        return this.onMouseWheelRotated;
    }

    public final void setOnScroll(EventHandler<? super ScrollEvent> eventHandler) {
        this.onScrollProperty().set(eventHandler);
    }

    public final EventHandler<? super ScrollEvent> getOnScroll() {
        return this.onScroll == null ? null : (EventHandler)this.onScroll.get();
    }

    public final ObjectProperty<EventHandler<? super ScrollEvent>> onScrollProperty() {
        if (this.onScroll == null) {
            this.onScroll = new ObjectPropertyBase<EventHandler<? super ScrollEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(ScrollEvent.SCROLL, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onScroll";
                }
            };
        }
        return this.onScroll;
    }

    public final void setOnDragEntered(EventHandler<? super DragEvent> eventHandler) {
        this.onDragEnteredProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragEntered() {
        return this.onDragEntered == null ? null : (EventHandler)this.onDragEntered.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragEnteredProperty() {
        if (this.onDragEntered == null) {
            this.onDragEntered = new ObjectPropertyBase<EventHandler<? super DragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(DragEvent.DRAG_ENTERED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragEntered";
                }
            };
        }
        return this.onDragEntered;
    }

    public final void setOnDragExited(EventHandler<? super DragEvent> eventHandler) {
        this.onDragExitedProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragExited() {
        return this.onDragExited == null ? null : (EventHandler)this.onDragExited.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragExitedProperty() {
        if (this.onDragExited == null) {
            this.onDragExited = new ObjectPropertyBase<EventHandler<? super DragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(DragEvent.DRAG_EXITED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragExited";
                }
            };
        }
        return this.onDragExited;
    }

    public final void setOnDragOver(EventHandler<? super DragEvent> eventHandler) {
        this.onDragOverProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragOver() {
        return this.onDragOver == null ? null : (EventHandler)this.onDragOver.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragOverProperty() {
        if (this.onDragOver == null) {
            this.onDragOver = new ObjectPropertyBase<EventHandler<? super DragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(DragEvent.DRAG_OVER, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragOver";
                }
            };
        }
        return this.onDragOver;
    }

    public final void setOnDragDropped(EventHandler<? super DragEvent> eventHandler) {
        this.onDragDroppedProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragDropped() {
        return this.onDragDropped == null ? null : (EventHandler)this.onDragDropped.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragDroppedProperty() {
        if (this.onDragDropped == null) {
            this.onDragDropped = new ObjectPropertyBase<EventHandler<? super DragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(DragEvent.DRAG_DROPPED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragDropped";
                }
            };
        }
        return this.onDragDropped;
    }

    public final void setOnDragDone(EventHandler<? super DragEvent> eventHandler) {
        this.onDragDoneProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragDone() {
        return this.onDragDone == null ? null : (EventHandler)this.onDragDone.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragDoneProperty() {
        if (this.onDragDone == null) {
            this.onDragDone = new ObjectPropertyBase<EventHandler<? super DragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(DragEvent.DRAG_DONE, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragDone";
                }
            };
        }
        return this.onDragDone;
    }

    public Dragboard startDragAndDrop(TransferMode ... transferModeArray) {
        return this.impl_startDragAndDrop(this, transferModeArray);
    }

    @Deprecated
    public Dragboard impl_startDragAndDrop(EventTarget eventTarget, TransferMode ... transferModeArray) {
        if (this.dndGesture.dragDetected != DragDetectedState.PROCESSING) {
            throw new IllegalStateException("Cannot start drag and drop outside of DRAG_DETECTED event handler");
        }
        if (this.dndGesture != null) {
            EnumSet<TransferMode> enumSet = EnumSet.noneOf(TransferMode.class);
            for (TransferMode transferMode : transferModeArray) {
                enumSet.add(transferMode);
            }
            return this.dndGesture.startDrag(eventTarget, enumSet);
        }
        throw new IllegalStateException("Cannot start drag and drop when mouse button is not pressed");
    }

    public final void setOnKeyPressed(EventHandler<? super KeyEvent> eventHandler) {
        this.onKeyPressedProperty().set(eventHandler);
    }

    public final EventHandler<? super KeyEvent> getOnKeyPressed() {
        return this.onKeyPressed == null ? null : (EventHandler)this.onKeyPressed.get();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyPressedProperty() {
        if (this.onKeyPressed == null) {
            this.onKeyPressed = new ObjectPropertyBase<EventHandler<? super KeyEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onKeyPressed";
                }
            };
        }
        return this.onKeyPressed;
    }

    public final void setOnKeyReleased(EventHandler<? super KeyEvent> eventHandler) {
        this.onKeyReleasedProperty().set(eventHandler);
    }

    public final EventHandler<? super KeyEvent> getOnKeyReleased() {
        return this.onKeyReleased == null ? null : (EventHandler)this.onKeyReleased.get();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyReleasedProperty() {
        if (this.onKeyReleased == null) {
            this.onKeyReleased = new ObjectPropertyBase<EventHandler<? super KeyEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(KeyEvent.KEY_RELEASED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onKeyReleased";
                }
            };
        }
        return this.onKeyReleased;
    }

    public final void setOnKeyTyped(EventHandler<? super KeyEvent> eventHandler) {
        this.onKeyTypedProperty().set(eventHandler);
    }

    public final EventHandler<? super KeyEvent> getOnKeyTyped() {
        return this.onKeyTyped == null ? null : (EventHandler)this.onKeyTyped.get();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyTypedProperty() {
        if (this.onKeyTyped == null) {
            this.onKeyTyped = new ObjectPropertyBase<EventHandler<? super KeyEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(KeyEvent.KEY_TYPED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onKeyTyped";
                }
            };
        }
        return this.onKeyTyped;
    }

    public final void setOnInputMethodTextChanged(EventHandler<? super InputMethodEvent> eventHandler) {
        this.onInputMethodTextChangedProperty().set(eventHandler);
    }

    public final EventHandler<? super InputMethodEvent> getOnInputMethodTextChanged() {
        return this.onInputMethodTextChanged == null ? null : (EventHandler)this.onInputMethodTextChanged.get();
    }

    public final ObjectProperty<EventHandler<? super InputMethodEvent>> onInputMethodTextChangedProperty() {
        if (this.onInputMethodTextChanged == null) {
            this.onInputMethodTextChanged = new ObjectPropertyBase<EventHandler<? super InputMethodEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(InputMethodEvent.INPUT_METHOD_TEXT_CHANGED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onInputMethodTextChanged";
                }
            };
        }
        return this.onInputMethodTextChanged;
    }

    static {
        PerformanceTracker.setSceneAccessor(new PerformanceTracker.SceneAccessor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPerfTracker(Scene scene, PerformanceTracker performanceTracker) {
                Object object = trackerMonitor;
                synchronized (object) {
                    scene.tracker = performanceTracker;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PerformanceTracker getPerfTracker(Scene scene) {
                Object object = trackerMonitor;
                synchronized (object) {
                    return scene.tracker;
                }
            }
        });
        FXRobotHelper.setSceneAccessor(new FXRobotHelper.FXRobotSceneAccessor(){

            @Override
            public void processKeyEvent(Scene scene, KeyEvent keyEvent) {
                scene.impl_processKeyEvent(keyEvent);
            }

            @Override
            public void processMouseEvent(Scene scene, MouseEvent mouseEvent) {
                scene.impl_processMouseEvent(mouseEvent);
            }

            @Override
            public void processScrollEvent(Scene scene, ScrollEvent scrollEvent) {
                scene.processScrollEvent(scrollEvent);
            }

            @Override
            public ObservableList<Node> getChildren(Parent parent) {
                return parent.getChildren();
            }

            @Override
            public Object renderToImage(Scene scene, Object object) {
                return scene.renderToImage(object);
            }
        });
        inSynchronizer = false;
        inMousePick = false;
        allowPGAccess = false;
        pgAccessCount = 0;
        trackerMonitor = new Object();
    }

    class InputMethodRequestsDelegate
    implements InputMethodRequests {
        InputMethodRequestsDelegate() {
        }

        @Override
        public Point2D getTextLocation(int n) {
            InputMethodRequests inputMethodRequests = this.getClientRequests();
            if (inputMethodRequests != null) {
                return inputMethodRequests.getTextLocation(n);
            }
            return new Point2D(0.0, 0.0);
        }

        @Override
        public int getLocationOffset(int n, int n2) {
            InputMethodRequests inputMethodRequests = this.getClientRequests();
            if (inputMethodRequests != null) {
                return inputMethodRequests.getLocationOffset(n, n2);
            }
            return 0;
        }

        @Override
        public void cancelLatestCommittedText() {
            InputMethodRequests inputMethodRequests = this.getClientRequests();
            if (inputMethodRequests != null) {
                inputMethodRequests.cancelLatestCommittedText();
            }
        }

        @Override
        public String getSelectedText() {
            InputMethodRequests inputMethodRequests = this.getClientRequests();
            if (inputMethodRequests != null) {
                return inputMethodRequests.getSelectedText();
            }
            return null;
        }

        private InputMethodRequests getClientRequests() {
            Node node = Scene.this.impl_getFocusOwner();
            if (node != null) {
                return node.getInputMethodRequests();
            }
            return null;
        }
    }

    class KeyHandler
    implements InvalidationListener {
        private Node focusOwner = null;
        private boolean windowFocused = true;
        private final InvalidationListener sceneWindowFocusedListener = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                KeyHandler.this.setWindowFocused(((ReadOnlyBooleanProperty)observable).get());
            }
        };

        private Node getFocusOwner() {
            return this.focusOwner;
        }

        private void setFocusOwner(Node node) {
            PlatformLogger platformLogger;
            Node node2 = this.focusOwner;
            if (node2 != null) {
                node2.setFocused(false);
            }
            this.focusOwner = node;
            Scene.this.setImpl_focusOwner(this.focusOwner);
            if (this.focusOwner != null) {
                this.focusOwner.setFocused(this.windowFocused);
                if (this.focusOwner != node2) {
                    this.focusOwner.getScene().impl_enableInputMethodEvents(this.focusOwner.getInputMethodRequests() != null && this.focusOwner.getOnInputMethodTextChanged() != null);
                }
            }
            if ((platformLogger = Logging.getFocusLogger()).isLoggable(500)) {
                platformLogger.fine("Changed focus from " + node2 + " to " + this.focusOwner);
            }
        }

        protected boolean isWindowFocused() {
            return this.windowFocused;
        }

        protected void setWindowFocused(boolean bl) {
            this.windowFocused = bl;
            if (this.getFocusOwner() != null) {
                this.getFocusOwner().setFocused(this.windowFocused);
            }
        }

        private void windowForSceneChanged(Window window, Window window2) {
            if (window != null) {
                window.focusedProperty().removeListener(this.sceneWindowFocusedListener);
            }
            if (window2 != null) {
                window2.focusedProperty().addListener(this.sceneWindowFocusedListener);
                this.setWindowFocused(window2.isFocused());
            } else {
                this.setWindowFocused(false);
            }
        }

        public KeyHandler() {
            this.windowForSceneChanged(Scene.this.getWindow(), Scene.this.getWindow());
        }

        private void process(KeyEvent keyEvent) {
            Node node = this.getFocusOwner();
            EventTarget eventTarget = node != null ? node : Scene.this;
            Event.fireEvent(eventTarget, keyEvent);
        }

        private void requestFocus(Node node) {
            if (this.getFocusOwner() == node || node != null && !node.isCanReceiveFocus()) {
                return;
            }
            this.setFocusOwner(node);
            if (this.getFocusOwner() != null) {
                this.getFocusOwner().impl_requestFocusImpl(new Runnable(){

                    @Override
                    public void run() {
                        if (Scene.this.impl_peer != null) {
                            Scene.this.impl_peer.requestFocus();
                        }
                    }
                });
            }
        }

        @Override
        public void invalidated(Observable observable) {
        }
    }

    class MouseHandler {
        private EventTarget pdrEventTarget = null;
        private boolean pdrInProgress = false;
        private EventTarget currentEventTarget = null;
        private MouseEvent lastEvent;
        private boolean hover = false;
        private boolean primaryButtonDown = false;
        private boolean secondaryButtonDown = false;
        private boolean middleButtonDown = false;
        private final List<EventTarget> pdrEventTargets = new ArrayList<EventTarget>();
        private final List<EventTarget> currentEventTargets = new ArrayList<EventTarget>();
        private final List<EventTarget> newEventTargets = new ArrayList<EventTarget>();
        private Cursor currCursor;
        private CursorFrame currCursorFrame;

        MouseHandler() {
        }

        private void pulse() {
            if (this.hover && this.lastEvent != null) {
                this.process(this.lastEvent, true);
            }
        }

        private void process(MouseEvent mouseEvent) {
            this.process(mouseEvent, false);
        }

        private void clearPDREventTargets() {
            this.pdrInProgress = false;
            this.currentEventTarget = this.currentEventTargets.size() > 0 ? this.currentEventTargets.get(0) : null;
            this.pdrEventTarget = null;
        }

        private void handleEnterExit(MouseEvent mouseEvent, EventTarget eventTarget) {
            if (eventTarget != this.currentEventTarget || mouseEvent.getEventType() == MouseEvent.MOUSE_EXITED) {
                EventTarget eventTarget2;
                this.newEventTargets.clear();
                if (mouseEvent.getEventType() != MouseEvent.MOUSE_EXITED) {
                    if (eventTarget instanceof Node) {
                        for (Node node = (Node)eventTarget; node != null; node = node.getParent()) {
                            this.newEventTargets.add(node);
                        }
                    }
                    this.newEventTargets.add(Scene.this);
                }
                int n = this.newEventTargets.size();
                int n2 = this.currentEventTargets.size() - 1;
                int n3 = n - 1;
                int n4 = this.pdrEventTargets.size() - 1;
                while (n2 >= 0 && n3 >= 0 && this.currentEventTargets.get(n2) == this.newEventTargets.get(n3)) {
                    --n2;
                    --n3;
                    --n4;
                }
                int n5 = n4;
                while (n2 >= 0) {
                    eventTarget2 = this.currentEventTargets.get(n2);
                    if (this.pdrInProgress && (n4 < 0 || eventTarget2 != this.pdrEventTargets.get(n4))) break;
                    Event.fireEvent(eventTarget2, MouseEvent.impl_copy(eventTarget2, eventTarget2, mouseEvent, MouseEvent.MOUSE_EXITED_TARGET));
                    --n2;
                    --n4;
                }
                n4 = n5;
                while (n3 >= 0) {
                    eventTarget2 = this.newEventTargets.get(n3);
                    if (this.pdrInProgress && (n4 < 0 || eventTarget2 != this.pdrEventTargets.get(n4))) break;
                    Event.fireEvent(eventTarget2, MouseEvent.impl_copy(eventTarget2, eventTarget2, mouseEvent, MouseEvent.MOUSE_ENTERED_TARGET));
                    --n3;
                    --n4;
                }
                this.currentEventTarget = eventTarget;
                this.currentEventTargets.clear();
                ++n3;
                while (n3 < n) {
                    this.currentEventTargets.add(this.newEventTargets.get(n3));
                    ++n3;
                }
            }
        }

        private void process(MouseEvent mouseEvent, boolean bl) {
            Object object;
            Object object2;
            Toolkit.getToolkit().checkFxUserThread();
            inMousePick = true;
            boolean bl2 = false;
            if (!bl) {
                if (mouseEvent.getEventType() == MouseEvent.MOUSE_PRESSED) {
                    if (!(this.primaryButtonDown || this.secondaryButtonDown || this.middleButtonDown)) {
                        bl2 = true;
                        Scene.this.dndGesture = new DnDGesture();
                        this.clearPDREventTargets();
                    }
                } else if (mouseEvent.getEventType() == MouseEvent.MOUSE_MOVED) {
                    this.clearPDREventTargets();
                } else if (mouseEvent.getEventType() == MouseEvent.MOUSE_ENTERED) {
                    this.hover = true;
                } else if (mouseEvent.getEventType() == MouseEvent.MOUSE_EXITED) {
                    this.hover = false;
                }
                this.primaryButtonDown = mouseEvent.isPrimaryButtonDown();
                this.secondaryButtonDown = mouseEvent.isSecondaryButtonDown();
                this.middleButtonDown = mouseEvent.isMiddleButtonDown();
            }
            EventTarget eventTarget = null;
            if (mouseEvent.getEventType() != MouseEvent.MOUSE_EXITED) {
                if (Scene.this.getCamera() instanceof PerspectiveCamera) {
                    object2 = new PickRay();
                    Scene.this.impl_peer.computePickRay((float)mouseEvent.getX(), (float)mouseEvent.getY(), (PickRay)object2);
                    eventTarget = this.pickNode((PickRay)object2);
                } else {
                    eventTarget = this.pickNode(mouseEvent.getX(), mouseEvent.getY());
                }
            }
            if (eventTarget == null) {
                eventTarget = Scene.this;
            }
            object2 = this.pdrInProgress ? this.pdrEventTarget : eventTarget;
            if (bl2) {
                this.pdrEventTarget = object2;
                this.pdrEventTargets.clear();
                if (this.pdrEventTarget instanceof Node) {
                    for (object = (Node)this.pdrEventTarget; object != null; object = ((Node)object).getParent()) {
                        this.pdrEventTargets.add((EventTarget)object);
                    }
                }
                this.pdrEventTargets.add(Scene.this);
            }
            if (!bl) {
                Scene.this.clickGenerator.preProcess(mouseEvent, (EventTarget)object2);
            }
            this.handleEnterExit(mouseEvent, eventTarget);
            object = null;
            if (object2 instanceof Node && object == null) {
                object = ((Node)object2).getCursor();
                for (Parent parent = ((Node)object2).getParent(); object == null && parent != null; parent = parent.getParent()) {
                    object = parent.getCursor();
                }
            }
            if (Scene.this.dndGesture != null) {
                Scene.this.dndGesture.processDragDetection(mouseEvent, (EventTarget)object2);
            }
            if (object2 != null && mouseEvent.getEventType() != MouseEvent.MOUSE_ENTERED && mouseEvent.getEventType() != MouseEvent.MOUSE_EXITED && !bl) {
                Event.fireEvent((EventTarget)object2, mouseEvent);
            }
            if (!bl) {
                Scene.this.clickGenerator.postProcess(mouseEvent, (EventTarget)object2);
            }
            if (!bl && Scene.this.dndGesture != null && !Scene.this.dndGesture.process(mouseEvent, (EventTarget)object2)) {
                Scene.this.dndGesture = null;
            }
            if (object == null && this.hover) {
                object = Scene.this.getCursor();
            }
            this.updateCursor((Cursor)object);
            this.updateCursorFrame();
            if (bl2) {
                this.pdrInProgress = true;
            }
            if (this.pdrInProgress && !this.primaryButtonDown && !this.secondaryButtonDown && !this.middleButtonDown) {
                this.clearPDREventTargets();
                this.handleEnterExit(mouseEvent, eventTarget);
            }
            this.lastEvent = mouseEvent;
            inMousePick = false;
        }

        private void updateCursor(Cursor cursor) {
            if (this.currCursor != cursor) {
                if (this.currCursor != null) {
                    this.currCursor.deactivate();
                }
                if (cursor != null) {
                    cursor.activate();
                }
                this.currCursor = cursor;
            }
        }

        public void updateCursorFrame() {
            CursorFrame cursorFrame;
            CursorFrame cursorFrame2 = cursorFrame = this.currCursor != null ? this.currCursor.impl_getCurrentFrame() : Cursor.DEFAULT.impl_getCurrentFrame();
            if (this.currCursorFrame != cursorFrame) {
                if (Scene.this.impl_peer != null) {
                    Scene.this.impl_peer.setCursor(cursorFrame);
                }
                this.currCursorFrame = cursorFrame;
            }
        }

        private Node pickNode(double d, double d2) {
            return Scene.this.getRoot().impl_pickNode(d, d2);
        }

        private Node pickNode(PickRay pickRay) {
            return Scene.this.getRoot().impl_pickNode(pickRay);
        }
    }

    class ClickGenerator {
        private ClickCounter lastPress = null;
        private Map<MouseButton, ClickCounter> counters = new EnumMap<MouseButton, ClickCounter>(MouseButton.class);

        public ClickGenerator() {
            for (MouseButton mouseButton : MouseButton.values()) {
                if (mouseButton == MouseButton.NONE) continue;
                this.counters.put(mouseButton, new ClickCounter());
            }
        }

        private void preProcess(MouseEvent mouseEvent, EventTarget eventTarget) {
            boolean bl;
            for (ClickCounter clickCounter : this.counters.values()) {
                clickCounter.moved(mouseEvent.getSceneX(), mouseEvent.getSceneY());
            }
            ClickCounter clickCounter = this.counters.get((Object)mouseEvent.getButton());
            boolean bl2 = bl = this.lastPress != null ? this.lastPress.isStill() : false;
            if (mouseEvent.getEventType() == MouseEvent.MOUSE_PRESSED) {
                if (!mouseEvent.isPrimaryButtonDown()) {
                    this.counters.get((Object)MouseButton.PRIMARY).clear();
                }
                if (!mouseEvent.isSecondaryButtonDown()) {
                    this.counters.get((Object)MouseButton.SECONDARY).clear();
                }
                if (!mouseEvent.isMiddleButtonDown()) {
                    this.counters.get((Object)MouseButton.MIDDLE).clear();
                }
                clickCounter.checkTarget(eventTarget);
                clickCounter.applyOut();
                clickCounter.inc();
                clickCounter.start(mouseEvent.getSceneX(), mouseEvent.getSceneY());
                this.lastPress = clickCounter;
            }
            mouseEvent.impl_setClickParams(clickCounter != null && mouseEvent.getEventType() != MouseEvent.MOUSE_MOVED ? clickCounter.get() : 0, bl);
        }

        private void postProcess(MouseEvent mouseEvent, EventTarget eventTarget) {
            if (mouseEvent.getEventType() == MouseEvent.MOUSE_RELEASED) {
                Object object;
                ClickCounter clickCounter = this.counters.get((Object)mouseEvent.getButton());
                Object object2 = null;
                if (eventTarget instanceof Node) {
                    for (object = (Node)eventTarget; object != null; object = ((Node)object).getParent()) {
                        if (!((Node)object).contains(((Node)object).sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY()))) continue;
                        object2 = object;
                        break;
                    }
                }
                if (object2 == null && mouseEvent.getSceneX() >= 0.0 && mouseEvent.getSceneY() >= 0.0 && mouseEvent.getSceneX() <= Scene.this.getWidth() && mouseEvent.getSceneY() <= Scene.this.getHeight()) {
                    object2 = Scene.this;
                }
                if (object2 != null) {
                    object = MouseEvent.impl_copy(null, object2, mouseEvent, MouseEvent.MOUSE_CLICKED);
                    ((MouseEvent)object).impl_setClickParams(clickCounter.get(), this.lastPress.isStill());
                    clickCounter.setTarget((EventTarget)object2);
                    Event.fireEvent((EventTarget)object2, (Event)object);
                }
            }
        }
    }

    class ClickCounter {
        Toolkit toolkit = Toolkit.getToolkit();
        private int count;
        private boolean out;
        private boolean still;
        private Timeline timeout;
        private double pressedX;
        private double pressedY;
        private EventTarget clickTarget;

        ClickCounter() {
        }

        private void inc() {
            ++this.count;
        }

        private int get() {
            return this.count;
        }

        private boolean isStill() {
            return this.still;
        }

        private void clear() {
            this.count = 0;
            this.clickTarget = null;
            this.stopTimeout();
        }

        private void out() {
            this.out = true;
            this.stopTimeout();
        }

        private void applyOut() {
            if (this.out) {
                this.clear();
            }
            this.out = false;
        }

        private void moved(double d, double d2) {
            if (Math.abs(d - this.pressedX) > (double)this.toolkit.getMultiClickMaxX() || Math.abs(d2 - this.pressedY) > (double)this.toolkit.getMultiClickMaxY()) {
                this.out();
                this.still = false;
            }
        }

        private void start(double d, double d2) {
            this.pressedX = d;
            this.pressedY = d2;
            this.out = false;
            if (this.timeout != null) {
                this.timeout.stop();
            }
            this.timeout = new Timeline();
            this.timeout.getKeyFrames().add(new KeyFrame(new Duration(this.toolkit.getMultiClickTime()), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    ClickCounter.this.out = true;
                    ClickCounter.this.timeout = null;
                }
            }, new KeyValue[0]));
            this.timeout.play();
            this.still = true;
        }

        private void setTarget(EventTarget eventTarget) {
            this.clickTarget = eventTarget;
        }

        private void checkTarget(EventTarget eventTarget) {
            if (this.clickTarget == null) {
                return;
            }
            boolean bl = false;
            if (eventTarget instanceof Node) {
                for (Node node = (Node)eventTarget; node != null; node = node.getParent()) {
                    if (node != this.clickTarget) continue;
                    bl = true;
                    break;
                }
            }
            if (this.clickTarget == Scene.this) {
                bl = true;
            }
            if (!bl) {
                this.out();
            }
        }

        private void stopTimeout() {
            if (this.timeout != null) {
                this.timeout.stop();
                this.timeout = null;
            }
        }
    }

    class DragSourceListener
    implements TKDragSourceListener {
        DragSourceListener() {
        }

        @Override
        public void dropActionChanged(Object object) {
        }

        @Override
        public void dragDropEnd(Object object) {
            if (Scene.this.dndGesture != null) {
                Scene.this.dndGesture.processDropEnd(Toolkit.getToolkit().convertDragSourceEventToFX(object, Scene.this.dndGesture.dragboard));
                Scene.this.dndGesture = null;
            }
        }
    }

    private static enum DragDetectedState {
        NOT_YET,
        PROCESSING,
        DONE;

    }

    class DnDGesture {
        private final double hysteresisSizeX = Toolkit.getToolkit().getMultiClickMaxX();
        private final double hysteresisSizeY = Toolkit.getToolkit().getMultiClickMaxY();
        private EventTarget source = null;
        private Set<TransferMode> sourceTransferModes = null;
        private TransferMode acceptedTransferMode = null;
        private Dragboard dragboard = null;
        private EventTarget potentialTarget = null;
        private EventTarget target = null;
        private DragDetectedState dragDetected = DragDetectedState.NOT_YET;
        private double pressedX;
        private double pressedY;
        private List<EventTarget> currentTargets = new ArrayList<EventTarget>();
        private List<EventTarget> newTargets = new ArrayList<EventTarget>();

        DnDGesture() {
        }

        private EventTarget targetOrScene(EventTarget eventTarget) {
            return eventTarget != null ? eventTarget : Scene.this;
        }

        private void fireEvent(EventTarget eventTarget, Event event) {
            Event.fireEvent(this.targetOrScene(eventTarget), event);
        }

        private void processingDragDetected() {
            this.dragDetected = DragDetectedState.PROCESSING;
        }

        private void dragDetectedProcessed() {
            boolean bl;
            this.dragDetected = DragDetectedState.DONE;
            boolean bl2 = bl = this.dragboard != null && this.dragboard.impl_contentPut();
            if (bl) {
                Toolkit.getToolkit().startDrag(Scene.this.impl_peer, this.sourceTransferModes, new DragSourceListener(), this.dragboard);
            }
        }

        private void processDragDetection(MouseEvent mouseEvent, EventTarget eventTarget) {
            if (this.dragDetected != DragDetectedState.NOT_YET) {
                mouseEvent.setDragDetect(false);
                return;
            }
            if (mouseEvent.getEventType() == MouseEvent.MOUSE_PRESSED) {
                this.pressedX = mouseEvent.getSceneX();
                this.pressedY = mouseEvent.getSceneY();
                mouseEvent.setDragDetect(false);
            } else if (mouseEvent.getEventType() == MouseEvent.MOUSE_DRAGGED) {
                double d = Math.abs(mouseEvent.getSceneX() - this.pressedX);
                double d2 = Math.abs(mouseEvent.getSceneY() - this.pressedY);
                mouseEvent.setDragDetect(d > this.hysteresisSizeX || d2 > this.hysteresisSizeY);
            }
        }

        private boolean process(MouseEvent mouseEvent, EventTarget eventTarget) {
            boolean bl = true;
            if (this.dragDetected != DragDetectedState.DONE && (mouseEvent.getEventType() == MouseEvent.MOUSE_PRESSED || mouseEvent.getEventType() == MouseEvent.MOUSE_DRAGGED) && mouseEvent.isDragDetect()) {
                this.processingDragDetected();
                MouseEvent mouseEvent2 = MouseEvent.impl_copy(mouseEvent.getSource(), eventTarget, mouseEvent, MouseEvent.DRAG_DETECTED);
                this.fireEvent(eventTarget, mouseEvent2);
                this.dragDetectedProcessed();
            }
            if (mouseEvent.getEventType() == MouseEvent.MOUSE_RELEASED) {
                bl = false;
            }
            return bl;
        }

        private boolean processRecognized(Node node, DragEvent dragEvent) {
            boolean bl;
            MouseEvent mouseEvent = MouseEvent.impl_mouseEvent(dragEvent.getX(), dragEvent.getY(), dragEvent.getSceneX(), dragEvent.getScreenY(), 0.0, MouseButton.PRIMARY, 1, false, false, false, false, false, true, false, false, MouseEvent.DRAG_DETECTED);
            this.processingDragDetected();
            this.fireEvent(node, mouseEvent);
            this.dragDetectedProcessed();
            boolean bl2 = bl = this.dragboard != null && !this.dragboard.getContentTypes().isEmpty();
            if (bl) {
                Toolkit.getToolkit().startDrag(Scene.this.impl_peer, this.sourceTransferModes, new DragSourceListener(), this.dragboard);
                return true;
            }
            return false;
        }

        private void processDropEnd(DragEvent dragEvent) {
            if (this.source == null) {
                System.out.println("Scene.DnDGesture.processDropEnd() - UNEXPECTD - source is NULL");
                return;
            }
            dragEvent = DragEvent.impl_copy(dragEvent.getSource(), this.source, (Object)this.source, (Object)this.target, dragEvent, DragEvent.DRAG_DONE);
            Event.fireEvent(this.source, dragEvent);
            this.handleExitEnter(dragEvent, null);
            Toolkit.getToolkit().stopDrag(this.dragboard);
        }

        private TransferMode processTargetEnterOver(DragEvent dragEvent) {
            Node node = Scene.this.mouseHandler.pickNode(dragEvent.getX(), dragEvent.getY());
            if (node == null || node.impl_isTreeVisible()) {
                if (this.dragboard == null) {
                    this.dragboard = this.createDragboard();
                }
                dragEvent = DragEvent.impl_copy(dragEvent.getSource(), (EventTarget)node, (Object)this.source, (Object)this.potentialTarget, this.dragboard, dragEvent);
                this.handleExitEnter(dragEvent, this.targetOrScene(node));
                dragEvent = DragEvent.impl_copy(dragEvent.getSource(), (EventTarget)node, (Object)this.source, (Object)this.potentialTarget, dragEvent, DragEvent.DRAG_OVER);
                this.fireEvent(node, dragEvent);
                Object object = dragEvent.impl_getAcceptingObject();
                this.potentialTarget = object instanceof EventTarget ? (EventTarget)object : null;
                this.acceptedTransferMode = dragEvent.getAcceptedTransferMode();
                return this.acceptedTransferMode;
            }
            this.processTargetExit(dragEvent);
            this.acceptedTransferMode = null;
            return null;
        }

        private void processTargetActionChanged(DragEvent dragEvent) {
        }

        private void processTargetExit(DragEvent dragEvent) {
            if (this.currentTargets.size() > 0) {
                this.potentialTarget = null;
                this.handleExitEnter(dragEvent, null);
            }
        }

        private TransferMode processTargetDrop(DragEvent dragEvent) {
            Node node = Scene.this.mouseHandler.pickNode(dragEvent.getX(), dragEvent.getY());
            if (node == null || node.impl_isTreeVisible()) {
                dragEvent = DragEvent.impl_copy(dragEvent.getSource(), node, this.source, this.potentialTarget, this.acceptedTransferMode, dragEvent, DragEvent.DRAG_DROPPED);
                if (this.dragboard == null) {
                    this.dragboard = this.createDragboard();
                }
                this.handleExitEnter(dragEvent, this.targetOrScene(node));
                this.fireEvent(node, dragEvent);
                Object object = dragEvent.impl_getAcceptingObject();
                this.target = this.potentialTarget = object instanceof EventTarget ? (EventTarget)object : null;
                TransferMode transferMode = dragEvent.isDropCompleted() ? dragEvent.getAcceptedTransferMode() : null;
                this.handleExitEnter(dragEvent, null);
                return transferMode;
            }
            this.processTargetExit(dragEvent);
            return null;
        }

        private void handleExitEnter(DragEvent dragEvent, EventTarget eventTarget) {
            EventTarget eventTarget2;
            EventTarget eventTarget3 = eventTarget2 = this.currentTargets.size() > 0 ? this.currentTargets.get(0) : null;
            if (eventTarget != eventTarget2) {
                EventTarget eventTarget4;
                int n;
                this.newTargets.clear();
                if (eventTarget instanceof Node) {
                    for (Node node = (Node)eventTarget; node != null; node = node.getParent()) {
                        this.newTargets.add(node);
                    }
                }
                if (eventTarget != null) {
                    this.newTargets.add(Scene.this);
                }
                int n2 = this.currentTargets.size() - 1;
                for (n = this.newTargets.size() - 1; n2 >= 0 && n >= 0 && this.currentTargets.get(n2) == this.newTargets.get(n); --n2, --n) {
                }
                while (n2 >= 0) {
                    eventTarget4 = this.currentTargets.get(n2);
                    if (this.potentialTarget == eventTarget4) {
                        this.potentialTarget = null;
                    }
                    dragEvent = DragEvent.impl_copy(dragEvent.getSource(), eventTarget4, (Object)this.source, (Object)this.potentialTarget, dragEvent, DragEvent.DRAG_EXITED_TARGET);
                    Event.fireEvent(eventTarget4, dragEvent);
                    --n2;
                }
                this.potentialTarget = null;
                while (n >= 0) {
                    eventTarget4 = this.newTargets.get(n);
                    Object object = (dragEvent = DragEvent.impl_copy(dragEvent.getSource(), eventTarget4, (Object)this.source, (Object)this.potentialTarget, dragEvent, DragEvent.DRAG_ENTERED_TARGET)).impl_getAcceptingObject();
                    if (object instanceof EventTarget) {
                        this.potentialTarget = (EventTarget)object;
                    }
                    Event.fireEvent(eventTarget4, dragEvent);
                    --n;
                }
                this.currentTargets.clear();
                this.currentTargets.addAll(this.newTargets);
            }
        }

        private boolean processKey(KeyEvent keyEvent) {
            if (keyEvent.getEventType() == KeyEvent.KEY_PRESSED && keyEvent.getCode() == KeyCode.ESCAPE) {
                DragEvent dragEvent = DragEvent.impl_create(DragEvent.DRAG_DONE, this.source, this.source, this.source, null, 0.0, 0.0, 0.0, 0.0, null, this.dragboard, null);
                if (this.source != null) {
                    Event.fireEvent(this.source, dragEvent);
                }
                this.handleExitEnter(dragEvent, null);
                return false;
            }
            return true;
        }

        private Dragboard startDrag(EventTarget eventTarget, Set<TransferMode> set) {
            if (this.dragDetected != DragDetectedState.PROCESSING) {
                throw new IllegalStateException("Cannot start drag and drop outside of DRAG_DETECTED event handler");
            }
            if (set.isEmpty()) {
                this.dragboard = null;
            } else if (this.dragboard == null) {
                this.dragboard = this.createDragboard();
            }
            this.source = eventTarget;
            this.potentialTarget = eventTarget;
            this.sourceTransferModes = set;
            return this.dragboard;
        }

        private Dragboard createDragboard() {
            return Toolkit.getToolkit().createDragboard();
        }
    }

    class DragGestureListener
    implements TKDragGestureListener {
        DragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(Object object) {
            Scene.this.dndGesture = new DnDGesture();
            DragEvent dragEvent = Toolkit.getToolkit().convertDragRecognizedEventToFX(object, null);
            Node node = Scene.this.mouseHandler.pickNode(dragEvent.getX(), dragEvent.getY());
            Scene.this.dndGesture.dragboard = dragEvent.impl_getPlatformDragboard();
            if (Scene.this.dndGesture.processRecognized(node, dragEvent)) {
                return;
            }
            Scene.this.dndGesture = null;
        }
    }

    class DropTargetListener
    implements TKDropTargetListener {
        DropTargetListener() {
        }

        @Override
        public TransferMode dragEnter(Object object) {
            if (Scene.this.dndGesture == null) {
                Scene.this.dndGesture = new DnDGesture();
            }
            return Scene.this.dndGesture.processTargetEnterOver(Toolkit.getToolkit().convertDropTargetEventToFX(object, Scene.this.dndGesture.dragboard));
        }

        @Override
        public TransferMode dragOver(Object object) {
            if (Scene.this.dndGesture == null) {
                System.out.println("GOT A dragOver when dndGesture is null!");
                return null;
            }
            return Scene.this.dndGesture.processTargetEnterOver(Toolkit.getToolkit().convertDropTargetEventToFX(object, Scene.this.dndGesture.dragboard));
        }

        @Override
        public void dropActionChanged(Object object) {
            if (Scene.this.dndGesture == null) {
                System.out.println("GOT A dropActionChanged when dndGesture is null!");
            } else {
                Scene.this.dndGesture.processTargetActionChanged(Toolkit.getToolkit().convertDropTargetEventToFX(object, Scene.this.dndGesture.dragboard));
            }
        }

        @Override
        public void dragExit(Object object) {
            if (Scene.this.dndGesture == null) {
                System.out.println("GOT A dragExit when dndGesture is null!");
            } else {
                Scene.this.dndGesture.processTargetExit(Toolkit.getToolkit().convertDropTargetEventToFX(object, Scene.this.dndGesture.dragboard));
            }
        }

        @Override
        public TransferMode drop(Object object) {
            if (Scene.this.dndGesture == null) {
                System.out.println("GOT A drop when dndGesture is null!");
                return null;
            }
            TransferMode transferMode = Scene.this.dndGesture.processTargetDrop(Toolkit.getToolkit().convertDropTargetEventToFX(object, Scene.this.dndGesture.dragboard));
            if (Scene.this.dndGesture.source == null) {
                Scene.this.dndGesture = null;
            }
            return transferMode;
        }
    }

    private class ScenePeerPaintListener
    implements TKScenePaintListener {
        private ScenePeerPaintListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void frameRendered() {
            Object object = trackerMonitor;
            synchronized (object) {
                if (Scene.this.tracker != null) {
                    Scene.this.tracker.frameRendered();
                }
            }
        }
    }

    class ScenePeerListener
    implements TKSceneListener {
        ScenePeerListener() {
        }

        @Override
        public void changedLocation(float f, float f2) {
            if ((double)f != Scene.this.getX()) {
                Scene.this.setX(f);
            }
            if ((double)f2 != Scene.this.getY()) {
                Scene.this.setY(f2);
            }
        }

        @Override
        public void changedSize(float f, float f2) {
            if ((double)f != Scene.this.getWidth()) {
                Scene.this.setWidth(f);
            }
            if ((double)f2 != Scene.this.getHeight()) {
                Scene.this.setHeight(f2);
            }
        }

        @Override
        public void mouseEvent(Object object) {
            Scene.this.impl_processMouseEvent(Toolkit.getToolkit().convertMouseEventToFX(object));
        }

        @Override
        public void keyEvent(Object object) {
            Scene.this.impl_processKeyEvent(Toolkit.getToolkit().convertKeyEventToFX(object));
        }

        @Override
        public void inputMethodEvent(Object object) {
            Scene.this.impl_processInputMethodEvent(Toolkit.getToolkit().convertInputMethodEventToFX(object));
        }

        @Override
        public void scrollEvent(double d, double d2, double d3, double d4, int n, int n2, int n3, int n4, double d5, double d6, double d7, double d8, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            double d9;
            ScrollEvent.HorizontalTextScrollUnits horizontalTextScrollUnits = n > 0 ? ScrollEvent.HorizontalTextScrollUnits.CHARACTERS : ScrollEvent.HorizontalTextScrollUnits.NONE;
            double d10 = d9 = n < 0 ? 0.0 : (double)n * d;
            ScrollEvent.VerticalTextScrollUnits verticalTextScrollUnits = n2 > 0 ? ScrollEvent.VerticalTextScrollUnits.LINES : (n2 < 0 ? ScrollEvent.VerticalTextScrollUnits.PAGES : ScrollEvent.VerticalTextScrollUnits.NONE);
            double d11 = n2 < 0 ? d2 : (double)n2 * d2;
            d3 = n3 > 0 && n >= 0 ? (double)Math.round(d3 * (double)n / (double)n3) : d3;
            d4 = n4 > 0 && n2 >= 0 ? (double)Math.round(d4 * (double)n2 / (double)n4) : d4;
            Scene.this.processScrollEvent(ScrollEvent.impl_scrollEvent(d * d3, d2 * d4, horizontalTextScrollUnits, d9, verticalTextScrollUnits, d11, d5, d6, d7, d8, bl, bl2, bl3, bl4));
        }
    }

    class ScenePulseListener
    implements TKPulseListener {
        private boolean firstPulse = true;

        ScenePulseListener() {
        }

        private void synchronizeSceneNodes() {
            Toolkit.getToolkit().checkFxUserThread();
            inSynchronizer = true;
            if (Scene.this.dirtyNodes == null) {
                int n = this.syncAll(Scene.this.getRoot());
                Scene.this.dirtyNodesA = new LinkedHashSet(40);
                Scene.this.dirtyNodesB = new LinkedHashSet(40);
                Scene.this.dirtyNodes = Scene.this.dirtyNodesA;
            } else {
                LinkedHashSet linkedHashSet = Scene.this.dirtyNodes;
                if (Scene.this.dirtyNodes == Scene.this.dirtyNodesA) {
                    Scene.this.dirtyNodes = Scene.this.dirtyNodesB;
                } else {
                    Scene.this.dirtyNodes = Scene.this.dirtyNodesA;
                }
                for (Node node : linkedHashSet) {
                    if (node.getScene() != Scene.this) continue;
                    node.impl_syncPGNode();
                }
                linkedHashSet.clear();
            }
            inSynchronizer = false;
        }

        private int syncAll(Node node) {
            node.impl_syncPGNode();
            int n = 1;
            if (node instanceof Parent) {
                Parent parent = (Parent)node;
                int n2 = parent.getChildren().size();
                for (int i = 0; i < n2; ++i) {
                    Node node2 = (Node)parent.getChildren().get(i);
                    if (node2 == null) continue;
                    n += this.syncAll(node2);
                }
            }
            if (node.getClip() != null) {
                n += this.syncAll(node.getClip());
            }
            return n;
        }

        private void synchronizeSceneProperties() {
            inSynchronizer = true;
            if (Scene.this.isDirty(DirtyBits.ROOT_DIRTY)) {
                Scene.this.impl_peer.setRoot(Scene.this.getRoot().impl_getPGNode());
            }
            if (Scene.this.isDirty(DirtyBits.FILL_DIRTY)) {
                Toolkit toolkit = Toolkit.getToolkit();
                Scene.this.impl_peer.setFillPaint(Scene.this.getFill() == null ? null : toolkit.getPaint(Scene.this.getFill()));
            }
            if (Scene.this.isDirty(DirtyBits.CAMERA_DIRTY)) {
                if (Scene.this.getCamera() != null) {
                    Scene.this.getCamera().impl_update();
                    Scene.this.impl_peer.setCamera(Scene.this.getCamera().getPlatformCamera());
                } else {
                    Scene.this.impl_peer.setCamera(null);
                }
            }
            Scene.this.clearDirty();
            inSynchronizer = false;
        }

        private void focusCleanup() {
            if (Scene.this.isFocusDirty()) {
                Node node = Scene.this.impl_getFocusOwner();
                if (node == null) {
                    Scene.this.focusInitial();
                } else if (node.getScene() != Scene.this) {
                    Scene.this.requestFocus(null);
                    Scene.this.focusInitial();
                } else if (!node.isCanReceiveFocus()) {
                    Scene.this.requestFocus(null);
                    Scene.this.focusIneligible(node);
                }
                Scene.this.setFocusDirty(false);
            }
        }

        @Override
        public void pulse() {
            boolean bl;
            if (Scene.this.tracker != null) {
                Scene.this.tracker.pulse();
            }
            if (this.firstPulse) {
                PerformanceTracker.logEvent("Scene - first repaint");
            }
            Scene.this.doCSSPass();
            Scene.this.doLayoutPass();
            boolean bl2 = bl = Scene.this.dirtyNodes == null || !Scene.this.dirtyNodes.isEmpty() || !Scene.this.isDirtyEmpty();
            if (bl) {
                this.synchronizeSceneProperties();
                this.synchronizeSceneNodes();
                Scene.this.mouseHandler.pulse();
                Scene.this.impl_peer.markDirty();
            }
            Scene.this.mouseHandler.updateCursorFrame();
            this.focusCleanup();
            if (this.firstPulse) {
                if (PerformanceTracker.isLoggingEnabled()) {
                    PerformanceTracker.logEvent("Scene - first repaint - layout complete");
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            if (System.getProperty("sun.perflog.fx.firstpaintflush") != null) {
                                PerformanceTracker.outputLog();
                            }
                            return null;
                        }
                    });
                }
                this.firstPulse = false;
            }
            if (Scene.this.impl_testPulseListener != null) {
                Scene.this.impl_testPulseListener.run();
            }
        }
    }

    private static enum DirtyBits {
        FILL_DIRTY,
        ROOT_DIRTY,
        CAMERA_DIRTY;

        private int mask = 1 << this.ordinal();

        public final int getMask() {
            return this.mask;
        }
    }
}

