/*
 * Decompiled with CFR 0.152.
 */
package javafx.fxml;

import com.sun.javafx.fxml.BeanAdapter;
import com.sun.javafx.fxml.LoadListener;
import com.sun.javafx.fxml.PropertyChangeEvent;
import com.sun.javafx.fxml.expression.Expression;
import com.sun.javafx.fxml.expression.ExpressionBinding;
import com.sun.javafx.fxml.expression.KeyPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javafx.beans.DefaultProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.fxml.LoadException;
import javafx.util.Builder;
import javafx.util.BuilderFactory;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public class FXMLLoader {
    private Charset charset;
    private ObservableMap<String, Object> namespace = FXCollections.observableHashMap();
    private URL location = null;
    private ResourceBundle resources = null;
    private BuilderFactory builderFactory = null;
    private boolean staticLoad = false;
    private LoadListener loadListener = null;
    private XMLStreamReader xmlStreamReader = null;
    private Element current = null;
    private Object root = null;
    private Object controller = null;
    private ScriptEngine scriptEngine = null;
    private LinkedList<String> packages = new LinkedList();
    private HashMap<String, Class<?>> classes = new HashMap();
    private ScriptEngineManager scriptEngineManager = null;
    private HashMap<String, Field> controllerFields = null;
    private HashMap<String, Method> controllerMethods = null;
    private ArrayList<FXMLLoader> includes = new ArrayList();
    private static final Pattern extraneousWhitespacePattern = Pattern.compile("\\s+");
    private static Logger logger = Logger.getLogger(FXMLLoader.class.getName());
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final String LANGUAGE_PROCESSING_INSTRUCTION = "language";
    public static final String IMPORT_PROCESSING_INSTRUCTION = "import";
    public static final String FX_NAMESPACE_PREFIX = "fx";
    public static final String FX_CONTROLLER_ATTRIBUTE = "controller";
    public static final String FX_ID_ATTRIBUTE = "id";
    public static final String FX_VALUE_ATTRIBUTE = "value";
    public static final String FX_FACTORY_ATTRIBUTE = "factory";
    public static final String INCLUDE_TAG = "include";
    public static final String INCLUDE_SOURCE_ATTRIBUTE = "source";
    public static final String INCLUDE_RESOURCES_ATTRIBUTE = "resources";
    public static final String INCLUDE_CHARSET_ATTRIBUTE = "charset";
    public static final String SCRIPT_TAG = "script";
    public static final String SCRIPT_SOURCE_ATTRIBUTE = "source";
    public static final String SCRIPT_CHARSET_ATTRIBUTE = "charset";
    public static final String DEFINE_TAG = "define";
    public static final String REFERENCE_TAG = "reference";
    public static final String REFERENCE_SOURCE_ATTRIBUTE = "source";
    public static final String COPY_TAG = "copy";
    public static final String COPY_SOURCE_ATTRIBUTE = "source";
    public static final String EVENT_HANDLER_PREFIX = "on";
    public static final String EVENT_KEY = "event";
    public static final String CHANGE_EVENT_HANDLER_SUFFIX = "Change";
    public static final String NULL_KEYWORD = "null";
    public static final String RELATIVE_PATH_PREFIX = "@";
    public static final String RESOURCE_KEY_PREFIX = "%";
    public static final String EXPRESSION_PREFIX = "$";
    public static final String BINDING_EXPRESSION_PREFIX = "{";
    public static final String BINDING_EXPRESSION_SUFFIX = "}";
    public static final String CONTROLLER_METHOD_PREFIX = "#";

    public FXMLLoader() {
        this(Charset.forName(DEFAULT_CHARSET_NAME));
    }

    public FXMLLoader(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset is null.");
        }
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public ObservableMap<String, Object> getNamespace() {
        return this.namespace;
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getController() {
        return this.controller;
    }

    public List<FXMLLoader> getIncludes() {
        return Collections.unmodifiableList(this.includes);
    }

    public URL getLocation() {
        return this.location;
    }

    public void setLocation(URL uRL) {
        this.location = uRL;
    }

    public ResourceBundle getResources() {
        return this.resources;
    }

    public void setResources(ResourceBundle resourceBundle) {
        this.resources = resourceBundle;
    }

    public BuilderFactory getBuilderFactory() {
        return this.builderFactory;
    }

    public void setBuilderFactory(BuilderFactory builderFactory) {
        this.builderFactory = builderFactory;
    }

    public boolean isStaticLoad() {
        return this.staticLoad;
    }

    public void setStaticLoad(boolean bl) {
        this.staticLoad = bl;
    }

    public LoadListener getLoadListener() {
        return this.loadListener;
    }

    public void setLoadListener(LoadListener loadListener) {
        this.loadListener = loadListener;
    }

    public Object load(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is null.");
        }
        this.root = null;
        this.controller = null;
        this.scriptEngine = null;
        this.includes.clear();
        try {
            try {
                XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
                xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, this.charset);
                this.xmlStreamReader = new StreamReaderDelegate(xMLInputFactory.createXMLStreamReader(inputStreamReader)){

                    @Override
                    public String getPrefix() {
                        String string = super.getPrefix();
                        if (string != null && string.length() == 0) {
                            string = null;
                        }
                        return string;
                    }

                    @Override
                    public String getAttributePrefix(int n) {
                        String string = super.getAttributePrefix(n);
                        if (string != null && string.length() == 0) {
                            string = null;
                        }
                        return string;
                    }
                };
                while (this.xmlStreamReader.hasNext()) {
                    int n = this.xmlStreamReader.next();
                    switch (n) {
                        case 3: {
                            this.processProcessingInstruction();
                            break;
                        }
                        case 5: {
                            this.processComment();
                            break;
                        }
                        case 1: {
                            this.processStartElement();
                            break;
                        }
                        case 2: {
                            this.processEndElement();
                            break;
                        }
                        case 4: {
                            this.processCharacters();
                        }
                    }
                }
            }
            catch (XMLStreamException xMLStreamException) {
                throw new LoadException(xMLStreamException);
            }
        }
        catch (IOException iOException) {
            this.logException(iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.logException(runtimeException);
            throw runtimeException;
        }
        finally {
            this.xmlStreamReader = null;
        }
        if (this.controller instanceof Initializable) {
            ((Initializable)this.controller).initialize(this.location, this.resources);
        }
        this.packages.clear();
        this.classes.clear();
        this.controllerFields = null;
        this.controllerMethods = null;
        this.resources = null;
        return this.root;
    }

    private void logException(Exception exception) {
        StringBuilder stringBuilder = new StringBuilder("The following error occurred at line ");
        stringBuilder.append(this.xmlStreamReader.getLocation().getLineNumber());
        if (this.location != null) {
            stringBuilder.append(" in file " + this.location.getPath());
        }
        stringBuilder.append(exception.getStackTrace());
        logger.severe(stringBuilder.toString());
    }

    private void processProcessingInstruction() throws LoadException {
        String string = this.xmlStreamReader.getPITarget().trim();
        if (string.equals(LANGUAGE_PROCESSING_INSTRUCTION)) {
            this.processLanguage();
        } else if (string.equals(IMPORT_PROCESSING_INSTRUCTION)) {
            this.processImport();
        }
    }

    private void processLanguage() throws LoadException {
        if (this.scriptEngine != null) {
            throw new LoadException("Page language already set.");
        }
        String string = this.xmlStreamReader.getPIData();
        if (this.loadListener != null) {
            this.loadListener.readLanguageProcessingInstruction(string);
        }
        if (!this.staticLoad) {
            ScriptEngineManager scriptEngineManager = this.getScriptEngineManager();
            this.scriptEngine = scriptEngineManager.getEngineByName(string);
            this.scriptEngine.setBindings(scriptEngineManager.getBindings(), 100);
        }
    }

    private void processImport() throws LoadException {
        String string = this.xmlStreamReader.getPIData().trim();
        if (this.loadListener != null) {
            this.loadListener.readImportProcessingInstruction(string);
        }
        if (string.endsWith(".*")) {
            this.importPackage(string.substring(0, string.length() - 2));
        } else {
            this.importClass(string);
        }
    }

    private void processComment() throws LoadException {
        if (this.loadListener != null) {
            this.loadListener.readComment(this.xmlStreamReader.getText());
        }
    }

    private void processStartElement() throws IOException {
        this.createElement();
        this.current.processStartElement();
        if (this.root == null) {
            this.root = this.current.value;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createElement() throws IOException {
        String string = this.xmlStreamReader.getPrefix();
        String string2 = this.xmlStreamReader.getLocalName();
        if (string == null) {
            int n = string2.lastIndexOf(46);
            if (Character.isLowerCase(string2.charAt(n + 1))) {
                Class<?> clazz;
                String string3 = string2.substring(n + 1);
                Class<?> clazz2 = clazz = n == -1 ? null : this.getType(string2.substring(0, n));
                if (this.loadListener != null) {
                    this.loadListener.beginPropertyElement(string3, clazz);
                }
                this.current = new PropertyElement(string3, clazz);
                return;
            } else {
                Class<?> clazz = this.getType(string2);
                if (this.loadListener != null) {
                    this.loadListener.beginInstanceDeclarationElement(clazz);
                }
                this.current = new InstanceDeclarationElement(clazz);
            }
            return;
        } else {
            if (!string.equals(FX_NAMESPACE_PREFIX)) throw new LoadException("Unexpected namespace prefix: " + string + ".");
            if (string2.equals(INCLUDE_TAG)) {
                if (this.loadListener != null) {
                    this.loadListener.beginIncludeElement();
                }
                this.current = new IncludeElement();
                return;
            } else if (string2.equals(REFERENCE_TAG)) {
                if (this.loadListener != null) {
                    this.loadListener.beginReferenceElement();
                }
                this.current = new ReferenceElement();
                return;
            } else if (string2.equals(COPY_TAG)) {
                if (this.loadListener != null) {
                    this.loadListener.beginCopyElement();
                }
                this.current = new CopyElement();
                return;
            } else if (string2.equals(SCRIPT_TAG)) {
                if (this.loadListener != null) {
                    this.loadListener.beginScriptElement();
                }
                this.current = new ScriptElement();
                return;
            } else {
                if (!string2.equals(DEFINE_TAG)) throw new LoadException(string + ":" + string2 + " is not a valid element.");
                if (this.loadListener != null) {
                    this.loadListener.beginDefineElement();
                }
                this.current = new DefineElement();
            }
        }
    }

    private void processEndElement() throws LoadException {
        this.current.processEndElement();
        if (this.loadListener != null) {
            this.loadListener.endElement(this.current.value);
        }
        this.current = this.current.parent;
    }

    private void processCharacters() throws LoadException {
        if (!this.xmlStreamReader.isWhiteSpace()) {
            this.current.processCharacters();
        }
    }

    private void importPackage(String string) throws LoadException {
        this.packages.add(string);
    }

    private void importClass(String string) throws LoadException {
        try {
            this.loadType(string, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LoadException(classNotFoundException);
        }
    }

    private Class<?> getType(String string) throws LoadException {
        Class<?> clazz = null;
        if (Character.isLowerCase(string.charAt(0))) {
            try {
                clazz = this.loadType(string, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new LoadException(classNotFoundException);
            }
        } else {
            clazz = this.classes.get(string);
            if (clazz == null) {
                for (String string2 : this.packages) {
                    try {
                        clazz = FXMLLoader.loadType(string2, string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                if (clazz == null) {
                    throw new LoadException("Unable to resolve type for " + string + ".");
                }
                this.classes.put(string, clazz);
            }
        }
        return clazz;
    }

    private Class<?> loadType(String string, boolean bl) throws ClassNotFoundException {
        int n = string.indexOf(46);
        int n2 = string.length();
        while (n != -1 && n < n2 && Character.isLowerCase(string.charAt(n + 1))) {
            n = string.indexOf(46, n + 1);
        }
        if (n == -1 || n == n2) {
            throw new ClassNotFoundException();
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Class<?> clazz = FXMLLoader.loadType(string2, string3);
        if (bl) {
            this.classes.put(string3, clazz);
        }
        return clazz;
    }

    private ScriptEngineManager getScriptEngineManager() {
        if (this.scriptEngineManager == null) {
            this.scriptEngineManager = new ScriptEngineManager();
            this.scriptEngineManager.setBindings(new SimpleBindings(this.namespace));
        }
        return this.scriptEngineManager;
    }

    private HashMap<String, Method> getControllerMethods() {
        if (this.controllerMethods == null) {
            Class<?> clazz = this.controller.getClass();
            this.controllerMethods = new HashMap();
            Method[] methodArray = clazz.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                this.controllerMethods.put(method.getName(), method);
            }
        }
        return this.controllerMethods;
    }

    private HashMap<String, Field> getControllerFields() {
        if (this.controllerFields == null) {
            Class<?> clazz = this.controller.getClass();
            this.controllerFields = new HashMap();
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                this.controllerFields.put(field.getName(), field);
            }
        }
        return this.controllerFields;
    }

    public static Class<?> loadType(String string, String string2) throws ClassNotFoundException {
        return FXMLLoader.loadType(string + "." + string2.replace('.', '$'));
    }

    public static Class<?> loadType(String string) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return Class.forName(string, true, classLoader);
    }

    public static <T> T load(URL uRL) throws IOException {
        return FXMLLoader.load(uRL, null);
    }

    public static <T> T load(URL uRL, ResourceBundle resourceBundle) throws IOException {
        return FXMLLoader.load(uRL, resourceBundle, new JavaFXBuilderFactory(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T load(URL uRL, ResourceBundle resourceBundle, BuilderFactory builderFactory) throws IOException {
        Object object;
        if (uRL == null) {
            throw new NullPointerException();
        }
        FXMLLoader fXMLLoader = new FXMLLoader();
        fXMLLoader.setLocation(uRL);
        fXMLLoader.setResources(resourceBundle);
        fXMLLoader.setBuilderFactory(builderFactory);
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            object = fXMLLoader.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return (T)object;
    }

    private static class ExpressionTargetMapping
    implements ChangeListener<Object> {
        public final ExpressionBinding source;
        public final Map<String, Object> target;
        public final String key;

        public ExpressionTargetMapping(ExpressionBinding expressionBinding, Map<String, Object> map, String string) {
            this.source = expressionBinding;
            this.target = map;
            this.key = string;
        }

        @Override
        public void changed(ObservableValue<? extends Object> observableValue, Object object, Object object2) {
            if (this.source.getExpression().isDefined(this.source.getNamespace())) {
                this.target.put(this.key, this.source.getValue());
            }
        }
    }

    private static class PropertyChangeListener
    implements ChangeListener<Object> {
        public final Object source;
        public final EventHandler<PropertyChangeEvent> handler;

        public PropertyChangeListener(Object object, EventHandler<PropertyChangeEvent> eventHandler) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (eventHandler == null) {
                throw new NullPointerException();
            }
            this.source = object;
            this.handler = eventHandler;
        }

        @Override
        public void changed(ObservableValue<? extends Object> observableValue, Object object, Object object2) {
            this.handler.handle(new PropertyChangeEvent(this.source));
        }
    }

    private static class ScriptEventHandler
    implements EventHandler<Event> {
        public final String script;
        public final ScriptEngine scriptEngine;

        public ScriptEventHandler(String string, ScriptEngine scriptEngine) {
            this.script = string;
            this.scriptEngine = scriptEngine;
        }

        @Override
        public void handle(Event event) {
            Bindings bindings = this.scriptEngine.getBindings(100);
            Bindings bindings2 = this.scriptEngine.createBindings();
            bindings2.put(FXMLLoader.EVENT_KEY, (Object)event);
            this.scriptEngine.setBindings(bindings2, 100);
            try {
                this.scriptEngine.eval(this.script);
            }
            catch (ScriptException scriptException) {
                throw new RuntimeException(scriptException);
            }
            this.scriptEngine.setBindings(bindings, 100);
        }
    }

    private static class ControllerMethodEventHandler
    implements EventHandler<Event> {
        public final Object controller;
        public final Method method;

        public ControllerMethodEventHandler(Object object, Method method) {
            this.controller = object;
            this.method = method;
        }

        @Override
        public void handle(Event event) {
            try {
                this.method.invoke(this.controller, event);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
    }

    private static class Attribute {
        public final String name;
        public final Class<?> sourceType;
        public final String value;

        public Attribute(String string, Class<?> clazz, String string2) {
            this.name = string;
            this.sourceType = clazz;
            this.value = string2;
        }
    }

    private class DefineElement
    extends Element {
        private DefineElement() {
        }

        @Override
        public void processAttribute(String string, String string2, String string3) throws LoadException {
            throw new LoadException("Element does not support attributes.");
        }
    }

    private class ScriptElement
    extends Element {
        public String source;
        public Charset charset;

        private ScriptElement() {
            this.source = null;
            this.charset = FXMLLoader.this.charset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processStartElement() throws IOException {
            super.processStartElement();
            if (this.source != null && !FXMLLoader.this.staticLoad) {
                ScriptEngine scriptEngine;
                Object object;
                int n = this.source.lastIndexOf(".");
                if (n == -1) {
                    throw new LoadException("Cannot determine type of script \"" + this.source + "\".");
                }
                String string = this.source.substring(n + 1);
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    object = FXMLLoader.this.getScriptEngineManager();
                    scriptEngine = ((ScriptEngineManager)object).getEngineByExtension(string);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                if (scriptEngine == null) {
                    throw new LoadException("Unable to locate scripting engine for extension " + string + ".");
                }
                scriptEngine.setBindings(FXMLLoader.this.scriptEngineManager.getBindings(), 100);
                try {
                    Object object2;
                    if (this.source.charAt(0) == '/') {
                        object2 = this.getClass().getClassLoader();
                        object = ((ClassLoader)object2).getResource(this.source.substring(1));
                    } else {
                        if (FXMLLoader.this.location == null) {
                            throw new LoadException("Base location is undefined.");
                        }
                        object = new URL(FXMLLoader.this.location, this.source);
                    }
                    object2 = null;
                    try {
                        object2 = new InputStreamReader(((URL)object).openStream(), this.charset);
                        scriptEngine.eval((Reader)object2);
                    }
                    catch (ScriptException scriptException) {
                        scriptException.printStackTrace();
                    }
                    finally {
                        if (object2 != null) {
                            ((InputStreamReader)object2).close();
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new LoadException(iOException);
                }
            }
        }

        @Override
        public void processEndElement() throws LoadException {
            super.processEndElement();
            if (this.value != null && !FXMLLoader.this.staticLoad) {
                try {
                    FXMLLoader.this.scriptEngine.eval((String)this.value);
                }
                catch (ScriptException scriptException) {
                    logger.warning(scriptException.getMessage());
                }
            }
        }

        @Override
        public void processCharacters() throws LoadException {
            if (this.source != null) {
                throw new LoadException("Script source already specified.");
            }
            if (!FXMLLoader.this.staticLoad) {
                if (FXMLLoader.this.scriptEngine == null) {
                    throw new LoadException("Page language not specified.");
                }
                this.updateValue(FXMLLoader.this.xmlStreamReader.getText());
            }
        }

        @Override
        public void processAttribute(String string, String string2, String string3) throws IOException {
            if (string == null && string2.equals("source")) {
                if (FXMLLoader.this.loadListener != null) {
                    FXMLLoader.this.loadListener.readInternalAttribute(string2, string3);
                }
                this.source = string3;
            } else if (string2.equals("charset")) {
                if (FXMLLoader.this.loadListener != null) {
                    FXMLLoader.this.loadListener.readInternalAttribute(string2, string3);
                }
                this.charset = Charset.forName(string3);
            } else {
                throw new LoadException(string == null ? string2 : string + ":" + string2 + " is not a valid attribute.");
            }
        }
    }

    private class PropertyElement
    extends Element {
        public final String name;
        public final Class<?> sourceType;
        public final boolean readOnly;

        public PropertyElement(String string, Class<?> clazz) throws LoadException {
            if (this.parent == null) {
                throw new LoadException("Invalid root element.");
            }
            if (this.parent.value == null) {
                throw new LoadException("Parent element does not support property elements.");
            }
            this.name = string;
            this.sourceType = clazz;
            if (clazz == null) {
                if (string.startsWith(FXMLLoader.EVENT_HANDLER_PREFIX)) {
                    throw new LoadException("\"" + string + "\" is not a valid element name.");
                }
                if (this.parent.value instanceof Map) {
                    if (this.parent.value instanceof Builder) {
                        Object object = this.parent.getProperties().get(string);
                        if (object instanceof List || object instanceof Map) {
                            this.updateValue(object);
                            this.readOnly = true;
                        } else {
                            this.readOnly = false;
                        }
                    } else {
                        this.readOnly = false;
                    }
                } else {
                    BeanAdapter beanAdapter = this.parent.getBeanAdapter();
                    this.readOnly = beanAdapter.isReadOnly(string);
                    if (this.readOnly) {
                        this.updateValue(beanAdapter.get(string));
                    }
                }
            } else {
                this.readOnly = false;
            }
        }

        @Override
        public void processEndElement() throws LoadException {
            super.processEndElement();
            this.processEventHandlerAttributes();
            if (!this.readOnly) {
                if (this.sourceType == null) {
                    this.parent.getProperties().put(this.name, this.value);
                } else if (this.parent.value instanceof Builder) {
                    this.parent.staticPropertyElements.add(this);
                } else {
                    BeanAdapter.put(this.parent.value, this.sourceType, this.name, this.value);
                }
            }
        }

        @Override
        public void processCharacters() throws LoadException {
            if (!this.readOnly) {
                String string = FXMLLoader.this.xmlStreamReader.getText();
                string = extraneousWhitespacePattern.matcher(string).replaceAll(" ");
                this.updateValue(string.trim());
            } else {
                super.processCharacters();
            }
        }
    }

    private class CopyElement
    extends ValueElement {
        public String source;

        private CopyElement() {
            this.source = null;
        }

        @Override
        public void processAttribute(String string, String string2, String string3) throws IOException {
            if (string == null) {
                if (string2.equals("source")) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readInternalAttribute(string2, string3);
                    }
                    this.source = string3;
                } else {
                    super.processAttribute(string, string2, string3);
                }
            } else {
                super.processAttribute(string, string2, string3);
            }
        }

        @Override
        public void constructValue() throws LoadException {
            if (this.source == null) {
                throw new LoadException("source is required.");
            }
            KeyPath keyPath = KeyPath.valueOf(this.source);
            if (!Expression.isDefined((Object)FXMLLoader.this.namespace, keyPath)) {
                throw new LoadException("Value \"" + this.source + "\" does not exist.");
            }
            Object t = Expression.get((Object)FXMLLoader.this.namespace, keyPath);
            Class<?> clazz = t.getClass();
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getConstructor(clazz);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (constructor != null) {
                try {
                    this.updateValue(constructor.newInstance(t));
                }
                catch (InstantiationException instantiationException) {
                    throw new LoadException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new LoadException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new LoadException(invocationTargetException);
                }
            } else {
                throw new LoadException("Can't copy value " + t + ".");
            }
        }
    }

    private class ReferenceElement
    extends ValueElement {
        public String source;

        private ReferenceElement() {
            this.source = null;
        }

        @Override
        public void processAttribute(String string, String string2, String string3) throws IOException {
            if (string == null) {
                if (string2.equals("source")) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readInternalAttribute(string2, string3);
                    }
                    this.source = string3;
                } else {
                    super.processAttribute(string, string2, string3);
                }
            } else {
                super.processAttribute(string, string2, string3);
            }
        }

        @Override
        public void constructValue() throws LoadException {
            if (this.source == null) {
                throw new LoadException("source is required.");
            }
            KeyPath keyPath = KeyPath.valueOf(this.source);
            if (!Expression.isDefined((Object)FXMLLoader.this.namespace, keyPath)) {
                throw new LoadException("Value \"" + this.source + "\" does not exist.");
            }
            this.updateValue(Expression.get((Object)FXMLLoader.this.namespace, keyPath));
        }
    }

    private class IncludeElement
    extends ValueElement {
        public String source;
        public ResourceBundle resources;
        public Charset charset;

        private IncludeElement() {
            this.source = null;
            this.resources = FXMLLoader.this.resources;
            this.charset = FXMLLoader.this.charset;
        }

        @Override
        public void processAttribute(String string, String string2, String string3) throws IOException {
            if (string == null) {
                if (string2.equals("source")) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readInternalAttribute(string2, string3);
                    }
                    this.source = string3;
                } else if (string2.equals(FXMLLoader.INCLUDE_RESOURCES_ATTRIBUTE)) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readInternalAttribute(string2, string3);
                    }
                    this.resources = ResourceBundle.getBundle(string3);
                } else if (string2.equals("charset")) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readInternalAttribute(string2, string3);
                    }
                    this.charset = Charset.forName(string3);
                } else {
                    super.processAttribute(string, string2, string3);
                }
            } else {
                super.processAttribute(string, string2, string3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void constructValue() throws IOException {
            URL uRL;
            Object object;
            if (this.source == null) {
                throw new LoadException("source is required.");
            }
            FXMLLoader fXMLLoader = new FXMLLoader(this.charset);
            if (this.source.charAt(0) == '/') {
                object = this.getClass().getClassLoader();
                uRL = ((ClassLoader)object).getResource(this.source.substring(1));
            } else {
                if (FXMLLoader.this.location == null) {
                    throw new LoadException("Base location is undefined.");
                }
                uRL = new URL(FXMLLoader.this.location, this.source);
            }
            fXMLLoader.setLocation(uRL);
            fXMLLoader.setResources(this.resources);
            fXMLLoader.setBuilderFactory(FXMLLoader.this.builderFactory);
            object = null;
            try {
                object = uRL.openStream();
                this.updateValue(fXMLLoader.load((InputStream)object));
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
    }

    private class InstanceDeclarationElement
    extends ValueElement {
        public Class<?> type;
        public String factory;

        public InstanceDeclarationElement(Class<?> clazz) throws LoadException {
            this.factory = null;
            this.type = clazz;
        }

        @Override
        public void processAttribute(String string, String string2, String string3) throws IOException {
            if (string != null && string.equals(FXMLLoader.FX_NAMESPACE_PREFIX)) {
                if (string2.equals(FXMLLoader.FX_VALUE_ATTRIBUTE)) {
                    this.value = string3;
                } else if (string2.equals(FXMLLoader.FX_FACTORY_ATTRIBUTE)) {
                    this.factory = string3;
                } else {
                    super.processAttribute(string, string2, string3);
                }
            } else {
                super.processAttribute(string, string2, string3);
            }
        }

        @Override
        public void constructValue() throws LoadException {
            if (this.factory == null) {
                if (this.value == null) {
                    if (this.value == null && FXMLLoader.this.builderFactory != null) {
                        this.updateValue(FXMLLoader.this.builderFactory.getBuilder(this.type));
                    }
                    if (this.value == null) {
                        try {
                            this.updateValue(this.type.newInstance());
                        }
                        catch (InstantiationException instantiationException) {
                            throw new LoadException(instantiationException);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new LoadException(illegalAccessException);
                        }
                    }
                } else {
                    this.updateValue(BeanAdapter.coerce(this.value, this.type));
                }
            } else {
                Method method;
                if (this.value != null) {
                    throw new LoadException("fx:value cannot be used with fx:factory.");
                }
                try {
                    method = this.type.getMethod(this.factory, new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new LoadException(this.type.getName() + " does not define a " + "valueOf" + "() method.");
                }
                try {
                    this.updateValue(method.invoke(null, new Object[0]));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new LoadException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new LoadException(invocationTargetException);
                }
            }
        }
    }

    private abstract class ValueElement
    extends Element {
        public String id;

        private ValueElement() {
            this.id = null;
        }

        @Override
        public void processStartElement() throws IOException {
            super.processStartElement();
            this.constructValue();
            if (!(this.value instanceof Builder)) {
                this.processValue();
            }
        }

        @Override
        public void processEndElement() throws LoadException {
            Class<?> clazz;
            super.processEndElement();
            if (this.value instanceof Builder) {
                clazz = (Builder)this.value;
                this.updateValue(clazz.build());
                this.processValue();
            }
            this.processEventHandlerAttributes();
            if (this.staticPropertyAttributes.size() > 0) {
                for (Object object : this.staticPropertyAttributes) {
                    this.processPropertyAttribute((Attribute)object);
                }
            }
            if (this.staticPropertyElements.size() > 0) {
                for (Object object : this.staticPropertyElements) {
                    BeanAdapter.put(this.value, ((PropertyElement)object).sourceType, ((PropertyElement)object).name, ((PropertyElement)object).value);
                }
            }
            if (this.parent != null) {
                if (this.parent.value != null) {
                    if (this.parent.value instanceof List) {
                        clazz = (List)this.parent.value;
                        clazz.add((Object)this.value);
                    } else {
                        Object object;
                        clazz = this.parent.value.getClass();
                        object = clazz.getAnnotation(DefaultProperty.class);
                        if (object == null) {
                            throw new LoadException(clazz.getName() + " does not have a default property.");
                        }
                        String string = object.value();
                        BeanAdapter beanAdapter = this.parent.getBeanAdapter();
                        if (List.class.isAssignableFrom(beanAdapter.getType(string))) {
                            List list = (List)beanAdapter.get(string);
                            list.add(this.value);
                        } else {
                            beanAdapter.put(string, this.value);
                        }
                    }
                } else if (this.parent instanceof PropertyElement) {
                    this.parent.updateValue(this.value);
                }
            }
        }

        private void processValue() throws LoadException {
            if (this.parent == null) {
                FXMLLoader.this.root = this.value;
            }
            if (this.id != null) {
                Field field;
                FXMLLoader.this.namespace.put(this.id, this.value);
                BeanAdapter beanAdapter = this.getBeanAdapter();
                if (beanAdapter.containsKey(FXMLLoader.FX_ID_ATTRIBUTE) && !beanAdapter.isReadOnly(FXMLLoader.FX_ID_ATTRIBUTE)) {
                    beanAdapter.put(FXMLLoader.FX_ID_ATTRIBUTE, (Object)this.id);
                }
                if (FXMLLoader.this.controller != null && (field = (Field)FXMLLoader.this.getControllerFields().get(this.id)) != null) {
                    int n = field.getModifiers();
                    if ((n & 1) == 0 && field.getAnnotation(FXML.class) != null) {
                        try {
                            field.setAccessible(true);
                        }
                        catch (SecurityException securityException) {
                            throw new LoadException(securityException);
                        }
                    }
                    try {
                        field.set(FXMLLoader.this.controller, this.value);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new RuntimeException(illegalAccessException);
                    }
                }
            }
        }

        @Override
        public void processCharacters() throws LoadException {
            Class<?> clazz = this.value.getClass();
            DefaultProperty defaultProperty = clazz.getAnnotation(DefaultProperty.class);
            if (defaultProperty != null) {
                String string = FXMLLoader.this.xmlStreamReader.getText();
                string = extraneousWhitespacePattern.matcher(string).replaceAll(" ");
                String string2 = defaultProperty.value();
                BeanAdapter beanAdapter = this.getBeanAdapter();
                if (beanAdapter.isReadOnly(string2) && List.class.isAssignableFrom(beanAdapter.getType(string2))) {
                    Type type = beanAdapter.getGenericType(string2);
                    Type type2 = BeanAdapter.getGenericListItemType(type);
                    List list = (List)beanAdapter.get(string2);
                    list.add(BeanAdapter.coerce(string, (Class)type2));
                } else {
                    beanAdapter.put(string2, (Object)string.trim());
                }
            } else {
                throw new LoadException(clazz.getName() + " does not have a default property.");
            }
        }

        @Override
        public void processAttribute(String string, String string2, String string3) throws IOException {
            if (string != null && string.equals(FXMLLoader.FX_NAMESPACE_PREFIX)) {
                if (string2.equals(FXMLLoader.FX_ID_ATTRIBUTE)) {
                    if (string3.equals(FXMLLoader.NULL_KEYWORD)) {
                        throw new LoadException("Invalid identifier.");
                    }
                    int n = string3.length();
                    for (int i = 0; i < n; ++i) {
                        if (Character.isJavaIdentifierPart(string3.charAt(i))) continue;
                        throw new LoadException("Invalid identifier.");
                    }
                    this.id = string3;
                } else if (string2.equals(FXMLLoader.FX_CONTROLLER_ATTRIBUTE)) {
                    if (FXMLLoader.this.root != null) {
                        throw new LoadException("fx:controller can only be applied to root element.");
                    }
                    if (!FXMLLoader.this.staticLoad) {
                        Class<?> clazz;
                        try {
                            clazz = FXMLLoader.loadType(string3);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new LoadException(classNotFoundException);
                        }
                        try {
                            FXMLLoader.this.controller = clazz.newInstance();
                        }
                        catch (InstantiationException instantiationException) {
                            throw new LoadException(instantiationException);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new LoadException(illegalAccessException);
                        }
                    }
                }
            } else {
                super.processAttribute(string, string2, string3);
            }
        }

        public abstract void constructValue() throws IOException;
    }

    private abstract class Element {
        public final Element parent;
        public Object value = null;
        private Map<String, Object> properties = null;
        private BeanAdapter beanAdapter = null;
        public final LinkedList<Attribute> eventHandlerAttributes = new LinkedList();
        public final LinkedList<Attribute> instancePropertyAttributes = new LinkedList();
        public final LinkedList<Attribute> staticPropertyAttributes = new LinkedList();
        public final LinkedList<PropertyElement> staticPropertyElements = new LinkedList();

        public Element() {
            this.parent = FXMLLoader.this.current;
        }

        public void updateValue(Object object) {
            this.value = object;
            this.properties = null;
            this.beanAdapter = null;
        }

        public Map<String, Object> getProperties() {
            if (this.properties == null) {
                this.properties = this.value instanceof Map ? (Map)this.value : this.getBeanAdapter();
            }
            return this.properties;
        }

        public BeanAdapter getBeanAdapter() {
            if (this.beanAdapter == null) {
                this.beanAdapter = new BeanAdapter(this.value);
            }
            return this.beanAdapter;
        }

        public void processStartElement() throws IOException {
            int n = FXMLLoader.this.xmlStreamReader.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                String string = FXMLLoader.this.xmlStreamReader.getAttributePrefix(i);
                String string2 = FXMLLoader.this.xmlStreamReader.getAttributeLocalName(i);
                String string3 = FXMLLoader.this.xmlStreamReader.getAttributeValue(i);
                if (FXMLLoader.this.loadListener != null && string != null && string.equals(FXMLLoader.FX_NAMESPACE_PREFIX)) {
                    FXMLLoader.this.loadListener.readInternalAttribute(string + ":" + string2, string3);
                }
                this.processAttribute(string, string2, string3);
            }
        }

        public void processEndElement() throws LoadException {
            if (this.instancePropertyAttributes.size() > 0) {
                for (Attribute attribute : this.instancePropertyAttributes) {
                    this.processPropertyAttribute(attribute);
                }
            }
        }

        public void processCharacters() throws LoadException {
            throw new LoadException("Unexpected characters in input stream.");
        }

        public void processAttribute(String string, String string2, String string3) throws IOException {
            if (string == null) {
                if (string2.startsWith(FXMLLoader.EVENT_HANDLER_PREFIX)) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readEventHandlerAttribute(string2, string3);
                    }
                    this.eventHandlerAttributes.add(new Attribute(string2, null, string3));
                } else {
                    int n = string2.lastIndexOf(46);
                    if (n == -1) {
                        if (FXMLLoader.this.loadListener != null) {
                            FXMLLoader.this.loadListener.readPropertyAttribute(string2, null, string3);
                        }
                        this.instancePropertyAttributes.add(new Attribute(string2, null, string3));
                    } else {
                        String string4 = string2.substring(n + 1);
                        Class clazz = FXMLLoader.this.getType(string2.substring(0, n));
                        if (FXMLLoader.this.loadListener != null) {
                            FXMLLoader.this.loadListener.readPropertyAttribute(string4, clazz, string3);
                        }
                        this.staticPropertyAttributes.add(new Attribute(string4, clazz, string3));
                    }
                }
            } else {
                throw new LoadException(string + ":" + string2 + " is not a valid attribute.");
            }
        }

        public void processPropertyAttribute(Attribute attribute) throws LoadException {
            String string = attribute.value;
            if (string.startsWith(FXMLLoader.RELATIVE_PATH_PREFIX)) {
                if ((string = string.substring(1)).startsWith(FXMLLoader.RELATIVE_PATH_PREFIX)) {
                    this.applyProperty(attribute.name, attribute.sourceType, string);
                } else {
                    if (string.length() == 0) {
                        throw new LoadException("Missing relative path.");
                    }
                    if (FXMLLoader.this.location == null) {
                        throw new LoadException("Base location is undefined.");
                    }
                    try {
                        this.applyProperty(attribute.name, attribute.sourceType, new URL(FXMLLoader.this.location, string));
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new LoadException(malformedURLException);
                    }
                }
            } else if (string.startsWith(FXMLLoader.RESOURCE_KEY_PREFIX)) {
                if ((string = string.substring(1)).startsWith(FXMLLoader.RESOURCE_KEY_PREFIX)) {
                    this.applyProperty(attribute.name, attribute.sourceType, string);
                } else {
                    if (string.length() == 0) {
                        throw new LoadException("Missing resource key.");
                    }
                    if (FXMLLoader.this.resources == null) {
                        throw new LoadException("No resources specified.");
                    }
                    if (!FXMLLoader.this.resources.containsKey(string)) {
                        throw new LoadException("Resource \"" + string + "\" not found.");
                    }
                    this.applyProperty(attribute.name, attribute.sourceType, FXMLLoader.this.resources.getObject(string));
                }
            } else if (string.startsWith(FXMLLoader.EXPRESSION_PREFIX)) {
                if ((string = string.substring(1)).startsWith(FXMLLoader.EXPRESSION_PREFIX)) {
                    this.applyProperty(attribute.name, attribute.sourceType, string);
                } else if (string.equals(FXMLLoader.NULL_KEYWORD)) {
                    this.applyProperty(attribute.name, attribute.sourceType, null);
                } else {
                    Expression expression;
                    if (string.length() == 0) {
                        throw new LoadException("Missing expression.");
                    }
                    if (string.startsWith(FXMLLoader.BINDING_EXPRESSION_PREFIX) && string.endsWith(FXMLLoader.BINDING_EXPRESSION_SUFFIX)) {
                        if (attribute.sourceType != null) {
                            throw new LoadException("Cannot bind to static property.");
                        }
                        expression = Expression.valueOf(string.substring(1, string.length() - 1));
                        ExpressionBinding expressionBinding = new ExpressionBinding(expression, FXMLLoader.this.namespace);
                        expressionBinding.valueProperty().addListener(new ExpressionTargetMapping(expressionBinding, this.getProperties(), attribute.name));
                    } else {
                        expression = Expression.valueOf(string);
                    }
                    if (expression.isDefined(FXMLLoader.this.namespace)) {
                        this.applyProperty(attribute.name, attribute.sourceType, expression.evaluate(FXMLLoader.this.namespace));
                    }
                }
            } else {
                this.applyProperty(attribute.name, attribute.sourceType, string);
            }
        }

        public void applyProperty(String string, Class<?> clazz, Object object) {
            if (clazz == null) {
                this.getProperties().put(string, object);
            } else {
                BeanAdapter.put(this.value, clazz, string, object);
            }
        }

        public void processEventHandlerAttributes() throws LoadException {
            if (this.eventHandlerAttributes.size() > 0 && !FXMLLoader.this.staticLoad) {
                BeanAdapter beanAdapter = this.getBeanAdapter();
                for (Attribute attribute : this.eventHandlerAttributes) {
                    String string = attribute.value;
                    EventHandler<Event> eventHandler = null;
                    if (string.startsWith(FXMLLoader.CONTROLLER_METHOD_PREFIX) && !(string = string.substring(1)).startsWith(FXMLLoader.CONTROLLER_METHOD_PREFIX)) {
                        if (string.length() == 0) {
                            throw new LoadException("Missing controller method.");
                        }
                        if (FXMLLoader.this.controller == null) {
                            throw new LoadException("No controller specified.");
                        }
                        Method method = (Method)FXMLLoader.this.getControllerMethods().get(string);
                        if (method == null) {
                            throw new LoadException("Controller method \"" + string + "\" not found.");
                        }
                        Class<?>[] classArray = method.getParameterTypes();
                        if (classArray.length != 1 || !Event.class.isAssignableFrom(classArray[0])) {
                            throw new LoadException("Method " + string + "() does not have the" + " correct signature for an event handler.");
                        }
                        int n = method.getModifiers();
                        if ((n & 1) == 0 && method.getAnnotation(FXML.class) != null) {
                            try {
                                method.setAccessible(true);
                            }
                            catch (SecurityException securityException) {
                                throw new LoadException(securityException);
                            }
                        }
                        eventHandler = new ControllerMethodEventHandler(FXMLLoader.this.controller, method);
                    }
                    if (eventHandler == null) {
                        if (string.length() == 0) {
                            throw new LoadException("Missing handler script.");
                        }
                        if (FXMLLoader.this.scriptEngine == null) {
                            throw new LoadException("Page language not specified.");
                        }
                        eventHandler = new ScriptEventHandler(string, FXMLLoader.this.scriptEngine);
                    }
                    if (eventHandler == null) continue;
                    if (attribute.name.endsWith(FXMLLoader.CHANGE_EVENT_HANDLER_SUFFIX)) {
                        int n;
                        int n2 = FXMLLoader.EVENT_HANDLER_PREFIX.length();
                        if (n2 == (n = attribute.name.length() - FXMLLoader.CHANGE_EVENT_HANDLER_SUFFIX.length())) {
                            throw new LoadException("Invalid event name.");
                        }
                        String string2 = Character.toLowerCase(attribute.name.charAt(n2)) + attribute.name.substring(n2 + 1, n);
                        Property<Object> property = beanAdapter.getPropertyModel(string2);
                        if (property == null) {
                            throw new LoadException(string.getClass().getName() + " does not define" + " a property model for \"" + string2 + "\".");
                        }
                        property.addListener(new PropertyChangeListener(string, eventHandler));
                        continue;
                    }
                    beanAdapter.put(attribute.name, (Object)eventHandler);
                }
            }
        }
    }
}

