/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.network;

import com.sun.webpane.platform.WebPage;
import com.sun.webpane.webkit.network.ByteBufferPool;
import com.sun.webpane.webkit.network.CookieJar;
import com.sun.webpane.webkit.network.FormDataElement;
import com.sun.webpane.webkit.network.URLFetcher;
import com.sun.webpane.webkit.network.URLProcessor;
import com.sun.webpane.webkit.network.URLs;
import com.sun.webpane.webkit.network.WebkitAuthenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkContext {
    private static final Logger logger = Logger.getLogger(NetworkContext.class.getName());
    private static final Logger pool_logger = Logger.getLogger(NetworkContext.class.getName() + ".threadpool");
    private static final long threadKeepAliveTime = 10000L;
    private static final int DEFAULT_HTTP_MAX_CONNECTIONS = 5;
    private static final int BYTE_BUFFER_SIZE = 40960;
    private static final ByteBufferPool byteBufferPool = ByteBufferPool.newInstance(40960);
    private static ThreadPoolExecutor jobQueue = null;
    private final WebPage wcPage;

    private NetworkContext(WebPage webPage) {
        this.wcPage = webPage;
    }

    public static NetworkContext createContext(WebPage webPage) {
        return new NetworkContext(webPage);
    }

    public static NetworkContext getNetworkContext(long l) {
        WebPage webPage = WebPage.getInstance(l);
        return webPage != null ? webPage.getNetworkContext() : null;
    }

    public WebPage getPage() {
        return this.wcPage;
    }

    public static void init(int n, boolean bl) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "NetworkContext init:" + n + ", " + bl);
        }
        if (n < 1) {
            n = 1;
        }
        if (jobQueue == null) {
            jobQueue = new ThreadPoolExecutor(n, n, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new UrlFetcherThreadFactory());
            jobQueue.allowCoreThreadTimeOut(true);
        }
        if (bl) {
            CookieJar.init();
        }
        WebkitAuthenticator.init();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                HttpURLConnection.setFollowRedirects(false);
                return null;
            }
        });
    }

    public static void shutdownQueue() {
        if (jobQueue != null) {
            jobQueue.shutdown();
        }
    }

    public static boolean canHandleURL(String string) {
        URL uRL = null;
        try {
            uRL = URLs.newURL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL != null;
    }

    public URLFetcher newJob(String string, String string2, String string3, FormDataElement[] formDataElementArray, long l) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, String.format("url: [%s], method: [%s], formDataElements: %s, data: [0x%016X], headers:%n%s", string, string2, formDataElementArray != null ? Arrays.asList(formDataElementArray) : "[null]", l, string3.trim().replaceAll("(?m)^", "    ")));
        }
        URLFetcher uRLFetcher = new URLFetcher(this, string, string2, string3, formDataElementArray, l, URLProcessor.sharedInstance(), byteBufferPool);
        jobQueue.submit(uRLFetcher);
        if (pool_logger.isLoggable(Level.FINE)) {
            String string4 = String.format("Active job count: %d\nThread count: %d\nMax pool size: %d\nTask count: %d\nCompleted task count: %d", jobQueue.getActiveCount(), jobQueue.getPoolSize(), jobQueue.getMaximumPoolSize(), jobQueue.getTaskCount(), jobQueue.getCompletedTaskCount());
            pool_logger.fine(string4);
        }
        return uRLFetcher;
    }

    public URLFetcher newSynchronousJob(String string, String string2) {
        logger.log(Level.FINEST, "New Synchronous Job: GET " + string);
        URLFetcher uRLFetcher = new URLFetcher(this, string, string2);
        if (uRLFetcher.isCanceled()) {
            return null;
        }
        return uRLFetcher;
    }

    public static int getMaximumHttpConnectionCountPerHost() {
        int n = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Integer.getInteger("http.maxConnections", -1);
            }
        });
        return n >= 0 ? n : 5;
    }

    private static class UrlFetcherThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger index = new AtomicInteger(1);

        private UrlFetcherThreadFactory() {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, "URL-Fetcher-" + this.index.getAndIncrement());
            thread.setDaemon(true);
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

