/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import org.w3c.dom.DOMException;
import org.w3c.dom.stylesheets.MediaList;

public class MediaListImpl
implements MediaList {
    protected final long peer;
    protected final long contextPeer;

    protected long getPeer() {
        return this.peer;
    }

    static MediaList getImpl(long peer, long contextPeer) {
        return new MediaListImpl(peer, contextPeer);
    }

    MediaListImpl(long _peer, long contextPeer) {
        this.peer = _peer;
        this.contextPeer = contextPeer;
        Disposer.addRecord(this, new SelfDisposer(_peer));
    }

    public boolean equals(Object that) {
        if (that instanceof MediaListImpl) {
            return this.peer == ((MediaListImpl)that).peer;
        }
        return false;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    @Override
    public String item(int index) {
        String p = MediaListImpl.itemImpl(this.getPeer(), index);
        return p;
    }

    static native String itemImpl(long var0, int var2);

    @Override
    public void deleteMedium(String oldMedium) throws DOMException {
        MediaListImpl.deleteMediumImpl(this.getPeer(), oldMedium);
    }

    static native void deleteMediumImpl(long var0, String var2);

    @Override
    public void appendMedium(String newMedium) throws DOMException {
        MediaListImpl.appendMediumImpl(this.getPeer(), newMedium);
    }

    static native void appendMediumImpl(long var0, String var2);

    @Override
    public String getMediaText() {
        String p = MediaListImpl.getMediaTextImpl(this.getPeer());
        return p;
    }

    static native String getMediaTextImpl(long var0);

    @Override
    public void setMediaText(String mediaText) throws DOMException {
        MediaListImpl.setMediaTextImpl(this.getPeer(), mediaText);
    }

    static native void setMediaTextImpl(long var0, String var2);

    @Override
    public int getLength() {
        int p = MediaListImpl.getLengthImpl(this.getPeer());
        return p;
    }

    static native int getLengthImpl(long var0);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long _peer) {
            this.peer = _peer;
        }

        @Override
        public void dispose() {
            MediaListImpl.dispose(this.peer);
        }
    }
}

