/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg.theme;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.webpane.platform.LoadListenerClient;
import com.sun.webpane.platform.WebFrameID;
import com.sun.webpane.platform.graphics.Ref;
import com.sun.webpane.platform.graphics.RenderTheme;
import com.sun.webpane.platform.graphics.WCGraphicsContext;
import com.sun.webpane.sg.Accessor;
import com.sun.webpane.sg.theme.Renderer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Control;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.shape.Polygon;

public class RenderThemeImpl
extends RenderTheme {
    private static final Logger log = Logger.getLogger(RenderThemeImpl.class.getName());
    private Accessor accessor;
    private boolean isDefault;
    private Pool<FormControl> pool;

    public RenderThemeImpl(final Accessor accessor) {
        this.accessor = accessor;
        this.pool = new Pool<FormControl>(new Pool.Notifier<FormControl>(){

            @Override
            public void notifyRemoved(FormControl formControl) {
                accessor.removeChild(formControl.asControl());
            }
        }, FormControl.class);
        accessor.addViewListener(new ViewListener(this.pool, accessor));
    }

    public RenderThemeImpl() {
        this.isDefault = true;
    }

    private void ensureNotDefault() {
        if (this.isDefault) {
            throw new IllegalStateException("the method should not be called in this context");
        }
    }

    @Override
    public Ref createWidget(long l, int n, int n2, int n3, int n4, int n5) {
        this.ensureNotDefault();
        FormControl formControl = this.pool.get(l);
        WidgetType widgetType = WidgetType.convert(n);
        if (formControl == null || formControl.getType() != widgetType) {
            if (formControl != null) {
                this.accessor.removeChild(formControl.asControl());
            }
            switch (widgetType) {
                case TEXTFIELD: {
                    formControl = new FormTextField();
                    break;
                }
                case BUTTON: {
                    formControl = new FormButton();
                    break;
                }
                case CHECKBOX: {
                    formControl = new FormCheckBox();
                    break;
                }
                case RADIOBUTTON: {
                    formControl = new FormRadioButton();
                    break;
                }
                case MENULIST: {
                    formControl = new FormMenuList();
                    break;
                }
                case MENULISTBUTTON: {
                    formControl = new FormMenuListButton();
                    break;
                }
                default: {
                    log.log(Level.ALL, "unknown widget index: {0}", n);
                    return null;
                }
            }
            this.pool.put(l, formControl);
            this.accessor.addChild(formControl.asControl());
        }
        formControl.setState(n2);
        Control control = formControl.asControl();
        if (control.getWidth() != (double)n3 || control.getHeight() != (double)n4) {
            control.resize(n3, n4);
        }
        if (control.isManaged()) {
            control.setManaged(false);
        }
        return new FormControlRef(formControl);
    }

    @Override
    public void drawWidget(WCGraphicsContext wCGraphicsContext, Ref ref, int n, int n2) {
        this.ensureNotDefault();
        wCGraphicsContext.saveState();
        wCGraphicsContext.translate(n, n2);
        Control control = ((FormControlRef)ref).asControl();
        if (control != null) {
            Renderer.getRenderer().render(control, wCGraphicsContext);
        }
        wCGraphicsContext.restoreState();
    }

    @Override
    public int getRadioButtonSize() {
        return 15;
    }

    @Override
    public int getSelectionColor(int n) {
        switch (n) {
            case 0: {
                return -16739329;
            }
            case 1: {
                return -1;
            }
        }
        return 0;
    }

    protected static boolean hasState(int n, int n2) {
        return (n & n2) != 0;
    }

    class FormMenuListButton
    extends Control
    implements FormControl {
        @Override
        public Control asControl() {
            return this;
        }

        @Override
        public void setState(int n) {
        }

        FormMenuListButton() {
            this.setSkin(new Skin((float)this.getWidth()));
        }

        @Override
        public WidgetType getType() {
            return WidgetType.MENULISTBUTTON;
        }

        class Skin
        extends SkinBase {
            private float width;

            Skin(float f) {
                super(FormMenuListButton.this, new BehaviorBase<FormMenuListButton>(FormMenuListButton.this));
                Polygon polygon = new Polygon(-3.5, -2.0, 3.5, -2.0, 0.0, 2.0);
                polygon.setTranslateX(f - 8.0f);
                polygon.setTranslateY(f / 2.0f);
                this.getChildren().add(polygon);
            }

            @Override
            public boolean contains(double d, double d2) {
                return this.getNode().contains(d, d2);
            }

            @Override
            public boolean intersects(double d, double d2, double d3, double d4) {
                return this.getNode().intersects(d, d2, d3, d4);
            }
        }
    }

    class FormMenuList
    extends ChoiceBox
    implements FormControl {
        private int state;

        public FormMenuList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("");
            this.setItems(FXCollections.observableList(arrayList));
        }

        @Override
        public Control asControl() {
            return this;
        }

        @Override
        public void setState(int n) {
            if (this.state == n) {
                return;
            }
            this.state = n;
            this.setDisabled(!RenderThemeImpl.hasState(n, 4));
            this.setFocused(RenderThemeImpl.hasState(n, 8));
            this.setHover(RenderThemeImpl.hasState(n, 32));
        }

        @Override
        public WidgetType getType() {
            return WidgetType.MENULIST;
        }
    }

    class FormRadioButton
    extends RadioButton
    implements FormControl {
        private int state;

        FormRadioButton() {
        }

        @Override
        public Control asControl() {
            return this;
        }

        @Override
        public void setState(int n) {
            if (this.state == n) {
                return;
            }
            this.state = n;
            this.setDisabled(!RenderThemeImpl.hasState(n, 4));
            this.setFocused(RenderThemeImpl.hasState(n, 8));
            this.setHover(RenderThemeImpl.hasState(n, 32));
            this.setSelected(RenderThemeImpl.hasState(n, 1));
        }

        @Override
        public WidgetType getType() {
            return WidgetType.RADIOBUTTON;
        }
    }

    class FormCheckBox
    extends CheckBox
    implements FormControl {
        private int state;

        FormCheckBox() {
        }

        @Override
        public Control asControl() {
            return this;
        }

        @Override
        public void setState(int n) {
            if (this.state == n) {
                return;
            }
            this.state = n;
            this.setDisabled(!RenderThemeImpl.hasState(n, 4));
            this.setFocused(RenderThemeImpl.hasState(n, 8));
            this.setHover(RenderThemeImpl.hasState(n, 32));
            this.setSelected(RenderThemeImpl.hasState(n, 1));
        }

        @Override
        public WidgetType getType() {
            return WidgetType.CHECKBOX;
        }
    }

    class FormTextField
    extends TextField
    implements FormControl {
        private int state;

        public FormTextField() {
            this.setStyle("-fx-display-caret: false");
        }

        @Override
        public Control asControl() {
            return this;
        }

        @Override
        public void setState(int n) {
            if (this.state == n) {
                return;
            }
            this.state = n;
            this.setDisabled(!RenderThemeImpl.hasState(n, 4));
            this.setEditable(RenderThemeImpl.hasState(n, 64));
            this.setFocused(RenderThemeImpl.hasState(n, 8));
            this.setHover(RenderThemeImpl.hasState(n, 32));
        }

        @Override
        public WidgetType getType() {
            return WidgetType.TEXTFIELD;
        }
    }

    class FormButton
    extends Button
    implements FormControl {
        private int state;

        FormButton() {
        }

        @Override
        public Control asControl() {
            return this;
        }

        @Override
        public void setState(int n) {
            if (this.state == n) {
                return;
            }
            this.state = n;
            this.setDisabled(!RenderThemeImpl.hasState(n, 4));
            this.setFocused(RenderThemeImpl.hasState(n, 8));
            this.setHover(RenderThemeImpl.hasState(n, 32));
            this.setPressed(RenderThemeImpl.hasState(n, 16));
            if (this.isPressed()) {
                this.arm();
            } else {
                this.disarm();
            }
        }

        @Override
        public WidgetType getType() {
            return WidgetType.BUTTON;
        }
    }

    static interface FormControl
    extends Widget {
        public Control asControl();

        public void setState(int var1);
    }

    static interface Widget {
        public WidgetType getType();
    }

    class FormControlRef
    extends Ref {
        private WeakReference<FormControl> fcRef;

        public FormControlRef(FormControl formControl) {
            this.fcRef = new WeakReference<FormControl>(formControl);
        }

        public Control asControl() {
            FormControl formControl = (FormControl)this.fcRef.get();
            return formControl != null ? formControl.asControl() : null;
        }
    }

    static class ViewListener
    implements InvalidationListener {
        Pool pool;
        Accessor accessor;
        LoadListenerClient loadListener;

        public ViewListener(Pool pool, Accessor accessor) {
            this.pool = pool;
            this.accessor = accessor;
        }

        @Override
        public void invalidated(Observable observable) {
            this.pool.clear();
            if (this.accessor.getPage() != null && this.loadListener == null) {
                this.loadListener = new LoadListenerClient(){

                    @Override
                    public void dispatchLoadEvent(WebFrameID webFrameID, int n, String string, String string2, double d, int n2) {
                        if (n == 0) {
                            ViewListener.this.pool.clear();
                        }
                    }

                    @Override
                    public void dispatchResourceLoadEvent(WebFrameID webFrameID, int n, String string, String string2, double d, int n2) {
                    }
                };
                this.accessor.getPage().addLoadListenerClient(this.loadListener);
            }
        }
    }

    static class Pool<T extends Widget> {
        private static final int MAX_SIZE = 100;
        private static final int SORT_BARRIER = 50;
        private LinkedList<Long> ids = new LinkedList();
        private Map<Long, WeakReference<T>> pool = new HashMap<Long, WeakReference<T>>();
        private Notifier<T> notifier;
        private String type;

        public Pool(Notifier<T> notifier, Class<T> clazz) {
            this.notifier = notifier;
            this.type = clazz.getSimpleName();
        }

        public T get(long l) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "type: {0}, size: {1}, id: 0x{2}", new Object[]{this.type, this.pool.size(), Long.toHexString(l)});
            }
            assert (this.ids.size() == this.pool.size());
            WeakReference<T> weakReference = this.pool.get(l);
            if (weakReference == null) {
                return null;
            }
            Widget widget = (Widget)weakReference.get();
            if (widget == null) {
                return null;
            }
            if (this.ids.size() > 50) {
                this.ids.remove(l);
                this.ids.addFirst(l);
            }
            return (T)widget;
        }

        public void put(long l, T t) {
            Widget widget;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "size: {0}, id: 0x{1}, control: {2}", new Object[]{this.pool.size(), Long.toHexString(l), t.getType()});
            }
            if (this.ids.size() >= 100 && (widget = (Widget)this.pool.remove(this.ids.removeLast()).get()) != null) {
                this.notifier.notifyRemoved(widget);
            }
            this.ids.addFirst(l);
            this.pool.put(l, new WeakReference<T>(t));
        }

        public void clear() {
            if (log.isLoggable(Level.FINE)) {
                log.fine("size: " + this.pool.size() + ", controls: " + this.pool.values());
            }
            if (this.pool.size() == 0) {
                return;
            }
            this.ids.clear();
            for (WeakReference<T> weakReference : this.pool.values()) {
                Widget widget = (Widget)weakReference.get();
                if (widget == null) continue;
                this.notifier.notifyRemoved(widget);
            }
            this.pool.clear();
        }

        public static interface Notifier<T> {
            public void notifyRemoved(T var1);
        }
    }

    static enum WidgetType {
        TEXTFIELD(0),
        BUTTON(1),
        CHECKBOX(2),
        RADIOBUTTON(3),
        MENULIST(4),
        MENULISTBUTTON(5),
        SCROLLBAR(6);

        private static final HashMap<Integer, WidgetType> map;
        private int value;

        private WidgetType(int n2) {
            this.value = n2;
        }

        public static WidgetType convert(int n) {
            return map.get(n);
        }

        static {
            map = new HashMap();
            for (WidgetType widgetType : WidgetType.values()) {
                map.put(widgetType.value, widgetType);
            }
        }
    }
}

