/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg.prism;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.iio.ImageFrame;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.Image;
import com.sun.prism.ImageFormatTool;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.webpane.platform.ConfigManager;
import com.sun.webpane.sg.prism.PrismImage;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCImageImpl
extends PrismImage {
    private static final Logger log = Logger.getLogger(WCImageImpl.class.getName());
    public static final int INT_ARGB_PRE = 0;
    public static final int BYTE_BGRA_PRE = 1;
    public static int defaultType = ConfigManager.getProperty("USE_BGRA") != null ? 1 : 0;
    Image img;
    Texture txt;
    private Rectangle rectInTexture = new Rectangle();

    public WCImageImpl(int n, int n2) {
        this(n, n2, defaultType);
    }

    public WCImageImpl(int n, int n2, int n3) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Creating empty image({0},{1},{2})", new Object[]{n, n2, n3});
        }
        switch (n3) {
            case 0: {
                this.img = Image.fromIntArgbPreData(new int[n * n2], n, n2);
                break;
            }
            case 1: {
                this.img = Image.fromByteBgraPreData(new byte[n * n2 * 4], n, n2);
                break;
            }
            default: {
                throw new RuntimeException("Unknown image type: " + n3);
            }
        }
    }

    public WCImageImpl(int[] nArray, int n, int n2) {
        this(nArray, n, n2, defaultType);
    }

    public WCImageImpl(int[] nArray, int n, int n2, int n3) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Creating image({0},{1},{2}) from buffer", new Object[]{n, n2, n3});
        }
        switch (n3) {
            case 0: {
                this.img = Image.fromIntArgbPreData(nArray, n, n2);
                break;
            }
            case 1: {
                byte[] byArray = new byte[nArray.length * 4];
                for (int i = 0; i < nArray.length; ++i) {
                    int n4 = i * 4;
                    byArray[n4++] = (byte)nArray[i];
                    byArray[n4++] = (byte)(nArray[i] >> 8);
                    byArray[n4++] = (byte)(nArray[i] >> 16);
                    byArray[n4++] = (byte)(nArray[i] >> 24);
                }
                this.img = Image.fromByteBgraPreData(byArray, n, n2);
                break;
            }
            default: {
                throw new RuntimeException("Unknown image type: " + n3);
            }
        }
    }

    public WCImageImpl(IntBuffer intBuffer, int n, int n2) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("Creating image %dx%d from buffer", n, n2));
        }
        this.img = Image.fromIntArgbPreData(intBuffer, n, n2);
    }

    public WCImageImpl(ImageFrame imageFrame) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Creating image {0}x{1} of type {2} from buffer", new Object[]{imageFrame.getWidth(), imageFrame.getHeight(), imageFrame.getImageType()});
        }
        this.img = ImageFormatTool.convertImageFrame(imageFrame);
    }

    public WCImageImpl(Image image) {
        this.img = image;
    }

    @Override
    public Image getImage() {
        return this.img;
    }

    @Override
    public Graphics getGraphics() {
        return null;
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.updateTexture(n5, n6, n7, n8);
        if (this.txt != null) {
            graphics.drawTexture(this.txt, n, n2, n3, n4, n5 - this.rectInTexture.x, n6 - this.rectInTexture.y, n7 - this.rectInTexture.x, n8 - this.rectInTexture.y);
        }
    }

    private void updateTexture(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        if (this.txt != null && (n5 > this.rectInTexture.width || n6 > this.rectInTexture.height)) {
            this.txt.dispose();
            this.txt = null;
        }
        if (this.txt == null) {
            ResourceFactory resourceFactory = GraphicsPipeline.getDefaultResourceFactory();
            try {
                this.txt = resourceFactory.createTexture(this.img.getPixelFormat(), Texture.Usage.DEFAULT, n5, n6);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                return;
            }
            if (this.txt == null) {
                return;
            }
            Buffer buffer = this.img.getPixelBuffer();
            buffer.rewind();
            this.txt.update(buffer, this.img.getPixelFormat(), 0, 0, n, n2, Math.min(n5, this.img.getWidth() - n), Math.min(n6, this.img.getHeight() - n2), this.img.getScanlineStride(), false);
            this.rectInTexture.x = n;
            this.rectInTexture.y = n2;
            this.rectInTexture.width = n5;
            this.rectInTexture.height = n6;
        } else if (!this.rectInTexture.contains(n, n2, n5, n6)) {
            Buffer buffer = this.img.getPixelBuffer();
            buffer.rewind();
            this.txt.update(buffer, this.img.getPixelFormat(), 0, 0, n, n2, Math.min(this.rectInTexture.width, this.img.getWidth() - n), Math.min(this.rectInTexture.height, this.img.getHeight() - n2), this.img.getScanlineStride(), false);
            this.rectInTexture.x = n;
            this.rectInTexture.y = n2;
        }
    }

    @Override
    public void dispose() {
        if (this.txt != null) {
            this.txt.dispose();
            this.txt = null;
        }
    }

    @Override
    public int getWidth() {
        return this.img.getWidth();
    }

    @Override
    public int getHeight() {
        return this.img.getHeight();
    }
}

