/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg;

import com.sun.javafx.Utils;
import com.sun.webpane.platform.CursorManager;
import com.sun.webpane.platform.WebPageClient;
import com.sun.webpane.platform.graphics.WCGraphicsManager;
import com.sun.webpane.platform.graphics.WCPageBackBuffer;
import com.sun.webpane.platform.graphics.WCPoint;
import com.sun.webpane.platform.graphics.WCRectangle;
import com.sun.webpane.sg.Accessor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Scene;
import javafx.scene.control.Tooltip;
import javafx.scene.web.WebView;
import javafx.stage.Screen;
import javafx.stage.Window;

public class WebPageClientImpl
implements WebPageClient<WebView> {
    private Accessor accessor;
    private Tooltip tooltip;
    private boolean isTooltipRegistered = false;

    public WebPageClientImpl(Accessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public void repaint(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        WebView webView = this.accessor.getView();
        if (webView != null) {
            webView.impl_repaint();
        }
    }

    @Override
    public void setFocus(boolean bl) {
        WebView webView = this.accessor.getView();
        if (webView != null && bl) {
            webView.requestFocus();
        }
    }

    @Override
    public void setCursor(long l) {
        WebView webView = this.accessor.getView();
        if (webView != null) {
            Object t = CursorManager.getCursorManager().getCursor(l);
            webView.setCursor(t instanceof Cursor ? (Cursor)t : Cursor.DEFAULT);
        }
    }

    @Override
    public void setTooltip(String string) {
        WebView webView = this.accessor.getView();
        if (string != null) {
            if (this.tooltip == null) {
                this.tooltip = new Tooltip(string);
            } else {
                this.tooltip.setText(string);
            }
            if (!this.isTooltipRegistered) {
                Tooltip.install(webView, this.tooltip);
                this.isTooltipRegistered = true;
            }
        } else if (this.isTooltipRegistered) {
            Tooltip.uninstall(webView, this.tooltip);
            this.isTooltipRegistered = false;
        }
    }

    @Override
    public void transferFocus(boolean bl) {
    }

    @Override
    public WCRectangle getScreenBounds(boolean bl) {
        WebView webView = this.accessor.getView();
        Screen screen = Utils.getScreen(webView);
        if (screen != null) {
            Rectangle2D rectangle2D = bl ? screen.getVisualBounds() : screen.getBounds();
            return new WCRectangle((float)rectangle2D.getMinX(), (float)rectangle2D.getMinY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        }
        return null;
    }

    @Override
    public int getScreenDepth() {
        return 24;
    }

    @Override
    public WCPoint getLocationOnScreen() {
        return new WCPoint(0.0f, 0.0f);
    }

    @Override
    public WebView getContainer() {
        return this.accessor.getView();
    }

    @Override
    public WCPoint screenToWindow(WCPoint wCPoint) {
        WebView webView = this.accessor.getView();
        Scene scene = webView.getScene();
        Window window = scene.getWindow();
        Point2D point2D = webView.sceneToLocal((double)wCPoint.getX() - window.getX() - scene.getX(), (double)wCPoint.getY() - window.getY() - scene.getY());
        return new WCPoint((float)point2D.getX(), (float)point2D.getY());
    }

    @Override
    public WCPoint windowToScreen(WCPoint wCPoint) {
        WebView webView = this.accessor.getView();
        Scene scene = webView.getScene();
        Window window = scene.getWindow();
        Point2D point2D = webView.localToScene(wCPoint.getX(), wCPoint.getY());
        return new WCPoint((float)(point2D.getX() + scene.getX() + window.getX()), (float)(point2D.getY() + scene.getY() + window.getY()));
    }

    @Override
    public WCPageBackBuffer createBackBuffer() {
        if (this.isBackBufferSupported()) {
            return WCGraphicsManager.getGraphicsManager().createPageBackBuffer();
        }
        return null;
    }

    @Override
    public boolean isBackBufferSupported() {
        return Boolean.valueOf(AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("com.sun.webpane.pagebackbuffer", "true");
            }
        }));
    }
}

