/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.platform;

import com.sun.webpane.perf.PerfLogger;
import java.util.concurrent.locks.ReentrantLock;

public abstract class Invoker {
    private static Invoker instance;
    private static PerfLogger locksLog;

    public static synchronized void setInvoker(Invoker invoker) {
        instance = invoker;
    }

    public static synchronized Invoker getInvoker() {
        return instance;
    }

    public boolean lock(ReentrantLock reentrantLock) {
        if (reentrantLock.getHoldCount() == 0) {
            reentrantLock.lock();
            locksLog.resumeCount(this.isEventThread() ? "EventThread" : "RenderThread");
            return true;
        }
        return false;
    }

    public boolean unlock(ReentrantLock reentrantLock) {
        if (reentrantLock.getHoldCount() != 0) {
            locksLog.suspendCount(this.isEventThread() ? "EventThread" : "RenderThread");
            reentrantLock.unlock();
            return true;
        }
        return false;
    }

    public abstract boolean isEventThread();

    public abstract void invokeOnEventThread(Runnable var1);

    public abstract void invokeOnRenderThread(Runnable var1);

    public abstract void postOnEventThread(Runnable var1);

    public void checkEventThread() {
        if (!this.isEventThread()) {
            throw new IllegalStateException("Current thread is not event thread, current thread: " + Thread.currentThread().getName());
        }
    }

    static {
        locksLog = PerfLogger.getLogger("Locks");
    }
}

