/*
 * Decompiled with CFR 0.152.
 */
package com.sun.t2k;

import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.t2k.CharToGlyphMapper;
import com.sun.t2k.CompositeFontResource;
import com.sun.t2k.CompositeGlyphMapper;
import com.sun.t2k.CompositeStrike;
import com.sun.t2k.Disposer;
import com.sun.t2k.T2KFont;
import com.sun.t2k.T2KFontFactory;
import com.sun.t2k.T2KFontStrikeDesc;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LogicalFont
implements CompositeFontResource {
    public static final String SYSTEM = "System";
    public static final String SERIF = "Serif";
    public static final String SANS_SERIF = "SansSerif";
    public static final String MONOSPACED = "Monospaced";
    public static final String STYLE_REGULAR = "Regular";
    public static final String STYLE_BOLD = "Bold";
    public static final String STYLE_ITALIC = "Italic";
    public static final String STYLE_BOLD_ITALIC = "Bold Italic";
    static final HashMap<String, String> canonicalFamilyMap = new HashMap();
    static LogicalFont[] logicalFonts;
    boolean isBold;
    boolean isItalic;
    private String fullName;
    private String familyName;
    private String styleName;
    private String physicalFont;
    private FontResource slot0FontResource;
    private static ArrayList<String> linkedFontFiles;
    private static ArrayList<String> linkedFontNames;
    private static FontResource[] fallbacks;
    CompositeGlyphMapper mapper;
    Map<FontStrikeDesc, WeakReference<FontStrike>> strikeMap = new ConcurrentHashMap<FontStrikeDesc, WeakReference<FontStrike>>();
    private static final int SANS_SERIF_INDEX = 0;
    private static final int SERIF_INDEX = 1;
    private static final int MONOSPACED_INDEX = 2;
    private static final int SYSTEM_INDEX = 3;
    static String[][] logFamilies;
    private int hash;

    private static String getCanonicalFamilyName(String string) {
        if (string == null) {
            return SANS_SERIF;
        }
        String string2 = string.toLowerCase();
        return canonicalFamilyMap.get(string2);
    }

    private static String mapLogicalFontFamilyName(String string) {
        if (string.equals(SYSTEM)) {
            return T2KFontFactory.getSystemFont();
        }
        if (string.equals(SANS_SERIF)) {
            return "Arial";
        }
        if (string.equals(SERIF)) {
            return "Times New Roman";
        }
        return "Courier New";
    }

    static PGFont getLogicalFont(String string, boolean bl, boolean bl2, float f) {
        LogicalFont logicalFont;
        String string2 = LogicalFont.getCanonicalFamilyName(string);
        if (string2 == null) {
            return null;
        }
        int n = 0;
        n = string2.equals(SANS_SERIF) ? 0 : (string2.equals(SERIF) ? 4 : (string2.equals(MONOSPACED) ? 8 : 12));
        if (bl) {
            ++n;
        }
        if (bl2) {
            n += 2;
        }
        if ((logicalFont = logicalFonts[n]) == null) {
            LogicalFont.logicalFonts[n] = logicalFont = new LogicalFont(string2, bl, bl2);
        }
        return new T2KFont(logicalFont, logicalFont.getFullName(), f);
    }

    static PGFont getLogicalFont(String string, float f) {
        int n = string.indexOf(32);
        if (n == -1 || n == string.length() - 1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = LogicalFont.getCanonicalFamilyName(string2);
        if (string3 == null) {
            return null;
        }
        String string4 = string.substring(n + 1).toLowerCase();
        boolean bl = false;
        boolean bl2 = false;
        if (!string4.equals("regular")) {
            if (string4.equals("bold")) {
                bl = true;
            } else if (string4.equals("italic")) {
                bl2 = true;
            } else if (string4.equals("bold italic")) {
                bl = true;
                bl2 = true;
            } else {
                return null;
            }
        }
        return LogicalFont.getLogicalFont(string3, bl, bl2, f);
    }

    private LogicalFont(String string, boolean bl, boolean bl2) {
        this.familyName = string;
        this.isBold = bl;
        this.isItalic = bl2;
        this.styleName = !bl && !bl2 ? STYLE_REGULAR : (bl && !bl2 ? STYLE_BOLD : (!bl && bl2 ? STYLE_ITALIC : STYLE_BOLD_ITALIC));
        this.fullName = this.familyName + " " + this.styleName;
        this.physicalFont = LogicalFont.mapLogicalFontFamilyName(this.familyName);
    }

    private FontResource getSlot0Resource() {
        if (this.slot0FontResource == null) {
            this.slot0FontResource = T2KFontFactory.getFontFactory().getFontResource(this.physicalFont, this.isBold, this.isItalic, false);
            if (this.slot0FontResource == null) {
                this.slot0FontResource = T2KFontFactory.getDefaultFontResource(false);
            }
        }
        return this.slot0FontResource;
    }

    private static void getLinkedFonts() {
        if (fallbacks == null) {
            ArrayList<String>[] arrayListArray = T2KFontFactory.getLinkedFonts("Tahoma", true);
            linkedFontFiles = arrayListArray[0];
            linkedFontNames = arrayListArray[1];
            fallbacks = new FontResource[linkedFontFiles.size()];
        }
    }

    @Override
    public int getNumSlots() {
        LogicalFont.getLinkedFonts();
        return linkedFontFiles.size() + 1;
    }

    @Override
    public FontResource getSlotResource(int n) {
        if (n == 0) {
            return this.getSlot0Resource();
        }
        LogicalFont.getLinkedFonts();
        if (fallbacks[--n] == null) {
            String string = linkedFontFiles.get(n);
            String string2 = linkedFontNames.get(n);
            LogicalFont.fallbacks[n] = T2KFontFactory.getFontFactory().getFontResource(string2, string, false);
            if (fallbacks[n] == null) {
                LogicalFont.fallbacks[n] = this.getSlot0Resource();
            }
        }
        return fallbacks[n];
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getFamilyName() {
        return this.familyName;
    }

    @Override
    public String getStyleName() {
        return this.styleName;
    }

    @Override
    public String getLocaleFullName() {
        return this.fullName;
    }

    @Override
    public String getLocaleFamilyName() {
        return this.familyName;
    }

    @Override
    public String getLocaleStyleName() {
        return this.styleName;
    }

    @Override
    public boolean isBold() {
        return this.getSlotResource(0).isBold();
    }

    @Override
    public boolean isItalic() {
        return this.getSlotResource(0).isItalic();
    }

    @Override
    public int getNumGlyphs() {
        return this.getSlotResource(0).getNumGlyphs();
    }

    public boolean supportsGlyphImages() {
        return true;
    }

    @Override
    public float[] getGlyphBoundingBox(int n, float f, float[] fArray) {
        int n2 = n >>> 24;
        int n3 = n & 0xFFFFFF;
        FontResource fontResource = this.getSlotResource(n2);
        return fontResource.getGlyphBoundingBox(n3, f, fArray);
    }

    @Override
    public float getAdvance(int n, float f) {
        int n2 = n >>> 24;
        int n3 = n & 0xFFFFFF;
        FontResource fontResource = this.getSlotResource(n2);
        return fontResource.getAdvance(n3, f);
    }

    @Override
    public CharToGlyphMapper getGlyphMapper() {
        if (this.mapper == null) {
            this.mapper = new CompositeGlyphMapper(this);
        }
        return this.mapper;
    }

    @Override
    public Map<FontStrikeDesc, WeakReference<FontStrike>> getStrikeMap() {
        return this.strikeMap;
    }

    @Override
    public int getDefaultAAMode() {
        return this.getSlot0Resource().getDefaultAAMode();
    }

    @Override
    public FontStrike getStrike(PGFont pGFont, BaseTransform baseTransform) {
        return this.getStrike(pGFont.getSize(), baseTransform, this.getDefaultAAMode());
    }

    @Override
    public FontStrike getStrike(float f, BaseTransform baseTransform) {
        return this.getStrike(f, baseTransform, this.getDefaultAAMode());
    }

    @Override
    public FontStrike getStrike(PGFont pGFont, BaseTransform baseTransform, int n) {
        return this.getStrike(pGFont.getSize(), baseTransform, this.getDefaultAAMode());
    }

    @Override
    public FontStrike getStrike(float f, BaseTransform baseTransform, int n) {
        T2KFontStrikeDesc t2KFontStrikeDesc = new T2KFontStrikeDesc(f, baseTransform, n);
        WeakReference<CompositeStrike> weakReference = this.strikeMap.get(t2KFontStrikeDesc);
        CompositeStrike compositeStrike = null;
        if (weakReference != null) {
            compositeStrike = (CompositeStrike)weakReference.get();
        }
        if (compositeStrike == null) {
            compositeStrike = new CompositeStrike(this, f, baseTransform, t2KFontStrikeDesc);
            weakReference = compositeStrike.disposer != null ? Disposer.addRecord(compositeStrike, compositeStrike.disposer) : new WeakReference<CompositeStrike>(compositeStrike);
            this.strikeMap.put(t2KFontStrikeDesc, weakReference);
        }
        return compositeStrike;
    }

    private static void buildFamily(String[] stringArray, String string) {
        stringArray[0] = string + " " + STYLE_REGULAR;
        stringArray[1] = string + " " + STYLE_BOLD;
        stringArray[2] = string + " " + STYLE_ITALIC;
        stringArray[3] = string + " " + STYLE_BOLD_ITALIC;
    }

    private static void buildFamilies() {
        if (logFamilies == null) {
            String[][] stringArray = new String[4][4];
            LogicalFont.buildFamily(stringArray[0], SANS_SERIF);
            LogicalFont.buildFamily(stringArray[1], SERIF);
            LogicalFont.buildFamily(stringArray[2], MONOSPACED);
            LogicalFont.buildFamily(stringArray[3], SYSTEM);
            logFamilies = stringArray;
        }
    }

    static void addFamilies(ArrayList<String> arrayList) {
        arrayList.add(SANS_SERIF);
        arrayList.add(SERIF);
        arrayList.add(MONOSPACED);
        arrayList.add(SYSTEM);
    }

    static void addFullNames(ArrayList<String> arrayList) {
        LogicalFont.buildFamilies();
        for (int i = 0; i < logFamilies.length; ++i) {
            for (int j = 0; j < logFamilies[i].length; ++j) {
                arrayList.add(logFamilies[i][j]);
            }
        }
    }

    static String[] getFontsInFamily(String string) {
        String string2 = LogicalFont.getCanonicalFamilyName(string);
        if (string2 == null) {
            return null;
        }
        LogicalFont.buildFamilies();
        if (string2.equals(SANS_SERIF)) {
            return logFamilies[0];
        }
        if (string2.equals(SERIF)) {
            return logFamilies[1];
        }
        if (string2.equals(MONOSPACED)) {
            return logFamilies[2];
        }
        return logFamilies[3];
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof LogicalFont)) {
            return false;
        }
        LogicalFont logicalFont = (LogicalFont)object;
        return this.fullName.equals(logicalFont.fullName);
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = this.fullName.hashCode();
        return this.hash;
    }

    static {
        canonicalFamilyMap.put("system", SYSTEM);
        canonicalFamilyMap.put("serif", SERIF);
        canonicalFamilyMap.put("sansserif", SANS_SERIF);
        canonicalFamilyMap.put("sans-serif", SANS_SERIF);
        canonicalFamilyMap.put("dialog", SANS_SERIF);
        canonicalFamilyMap.put("default", SANS_SERIF);
        canonicalFamilyMap.put("monospaced", MONOSPACED);
        canonicalFamilyMap.put("monospace", MONOSPACED);
        canonicalFamilyMap.put("dialoginput", MONOSPACED);
        logicalFonts = new LogicalFont[16];
        logFamilies = null;
    }
}

