/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.prism.ps;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.Image;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.Texture;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderFactory;
import com.sun.prism.ps.ShaderGraphics;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.FloatMap;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.hw.ShaderSource;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrImage;
import com.sun.scenario.effect.impl.prism.PrRenderer;
import com.sun.scenario.effect.impl.prism.PrTexture;
import com.sun.scenario.effect.impl.prism.ps.PPSDrawable;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.FloatBuffer;
import java.util.Map;

public class PPSRenderer
extends PrRenderer {
    private final Screen screen;
    private final ShaderSource shaderSource;
    private Renderer.RendererState state;
    private final ResourceFactoryListener listener = new ResourceFactoryListener(){

        @Override
        public void factoryReset() {
            PPSRenderer.this.dispose();
        }

        @Override
        public void factoryReleased() {
            PPSRenderer.this.dispose();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PPSRenderer(Screen screen, ShaderSource shaderSource) {
        this.screen = screen;
        this.shaderSource = shaderSource;
        PPSRenderer pPSRenderer = this;
        synchronized (pPSRenderer) {
            this.state = Renderer.RendererState.OK;
        }
        GraphicsPipeline.getPipeline().getResourceFactory(screen).addFactoryListener(this.listener);
    }

    @Override
    public PrDrawable createDrawable(RTTexture rTTexture) {
        return PPSDrawable.create(rTTexture);
    }

    @Override
    public Effect.AccelType getAccelType() {
        return this.shaderSource.getAccelType();
    }

    @Override
    public synchronized Renderer.RendererState getRendererState() {
        return this.state;
    }

    @Override
    protected Renderer getBackupRenderer() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        for (EffectPeer effectPeer : this.getPeers()) {
            effectPeer.dispose();
        }
        PPSRenderer pPSRenderer = this;
        synchronized (pPSRenderer) {
            this.state = Renderer.RendererState.DISPOSED;
        }
        GraphicsPipeline.getPipeline().getResourceFactory(this.screen).removeFactoryListener(this.listener);
    }

    protected final synchronized void markLost() {
        if (this.state == Renderer.RendererState.OK) {
            this.state = Renderer.RendererState.LOST;
        }
    }

    @Override
    public final PPSDrawable createCompatibleImage(int n, int n2) {
        return PPSDrawable.create(this.screen, n, n2);
    }

    @Override
    public PPSDrawable getCompatibleImage(int n, int n2) {
        PPSDrawable pPSDrawable = (PPSDrawable)super.getCompatibleImage(n, n2);
        if (pPSDrawable == null) {
            this.markLost();
        }
        return pPSDrawable;
    }

    @Override
    public Object createFloatTexture(int n, int n2) {
        Texture texture = GraphicsPipeline.getPipeline().getResourceFactory(this.screen).createFloatTexture(n, n2);
        return new PrTexture(texture);
    }

    @Override
    public void updateFloatTexture(Object object, FloatMap floatMap) {
        FloatBuffer floatBuffer = floatMap.getBuffer();
        int n = floatMap.getWidth();
        int n2 = floatMap.getHeight();
        Image image = Image.fromFloatMapData(floatBuffer, n, n2);
        Texture texture = ((PrTexture)object).getTextureObject();
        texture.update(image);
    }

    public Shader createShader(String string, Map<String, Integer> map, Map<String, Integer> map2, boolean bl) {
        InputStream inputStream = this.shaderSource.loadSource(string);
        int n = map.keySet().size() - 1;
        ShaderFactory shaderFactory = (ShaderFactory)GraphicsPipeline.getPipeline().getResourceFactory(this.screen);
        return shaderFactory.createShader(inputStream, map, map2, n, bl, false);
    }

    private EffectPeer createIntrinsicPeer(FilterContext filterContext, String string) {
        EffectPeer effectPeer;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.sun.scenario.effect.impl.prism.Pr" + string + "Peer");
            Constructor<?> constructor = clazz.getConstructor(FilterContext.class, Renderer.class, String.class);
            effectPeer = (EffectPeer)constructor.newInstance(filterContext, this, string);
        }
        catch (Exception exception) {
            return null;
        }
        return effectPeer;
    }

    private EffectPeer createPlatformPeer(FilterContext filterContext, String string, int n) {
        EffectPeer effectPeer;
        String string2 = string;
        if (n > 0) {
            string2 = string2 + "_" + n;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.scenario.effect.impl.prism.ps.PPS" + string + "Peer");
            Constructor<?> constructor = clazz.getConstructor(FilterContext.class, Renderer.class, String.class);
            effectPeer = (EffectPeer)constructor.newInstance(filterContext, this, string2);
        }
        catch (Exception exception) {
            System.err.println("Error: Prism peer not found for: " + string + " due to error: " + exception.getMessage());
            return null;
        }
        return effectPeer;
    }

    @Override
    protected EffectPeer createPeer(FilterContext filterContext, String string, int n) {
        if (PrRenderer.isIntrinsicPeer(string)) {
            return this.createIntrinsicPeer(filterContext, string);
        }
        return this.createPlatformPeer(filterContext, string, n);
    }

    @Override
    public boolean isImageDataCompatible(ImageData imageData) {
        if (this.getRendererState() == Renderer.RendererState.OK) {
            Filterable filterable = imageData.getUntransformedImage();
            return filterable instanceof PPSDrawable && !((PPSDrawable)filterable).isLost();
        }
        return false;
    }

    @Override
    public void clearImage(Filterable filterable) {
        PPSDrawable pPSDrawable = (PPSDrawable)filterable;
        pPSDrawable.clear();
    }

    @Override
    public ImageData createImageData(FilterContext filterContext, Filterable filterable) {
        int n;
        if (!(filterable instanceof PrImage)) {
            throw new IllegalArgumentException("Identity source must be PrImage");
        }
        Image image = ((PrImage)filterable).getImage();
        int n2 = image.getWidth();
        PPSDrawable pPSDrawable = this.createCompatibleImage(n2, n = image.getHeight());
        if (pPSDrawable == null) {
            return null;
        }
        ShaderGraphics shaderGraphics = pPSDrawable.createGraphics();
        ResourceFactory resourceFactory = shaderGraphics.getResourceFactory();
        Texture texture = resourceFactory.createTexture(image);
        shaderGraphics.drawTexture(texture, 0.0f, 0.0f, n2, n);
        shaderGraphics.sync();
        texture.dispose();
        return new ImageData(filterContext, pPSDrawable, new Rectangle(n2, n));
    }

    @Override
    public Filterable transform(FilterContext filterContext, Filterable filterable, BaseTransform baseTransform, Rectangle rectangle, Rectangle rectangle2) {
        PPSDrawable pPSDrawable = this.getCompatibleImage(rectangle2.width, rectangle2.height);
        if (pPSDrawable != null) {
            ShaderGraphics shaderGraphics = pPSDrawable.createGraphics();
            shaderGraphics.translate(-rectangle2.x, -rectangle2.y);
            shaderGraphics.transform(baseTransform);
            shaderGraphics.drawTexture(((PPSDrawable)filterable).getTextureObject(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return pPSDrawable;
    }

    @Override
    public ImageData transform(FilterContext filterContext, ImageData imageData, BaseTransform baseTransform, Rectangle rectangle, Rectangle rectangle2) {
        PPSDrawable pPSDrawable = this.getCompatibleImage(rectangle2.width, rectangle2.height);
        if (pPSDrawable != null) {
            PPSDrawable pPSDrawable2 = (PPSDrawable)imageData.getUntransformedImage();
            ShaderGraphics shaderGraphics = pPSDrawable.createGraphics();
            shaderGraphics.translate(-rectangle2.x, -rectangle2.y);
            shaderGraphics.transform(baseTransform);
            shaderGraphics.drawTexture(pPSDrawable2.getTextureObject(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        imageData.unref();
        return new ImageData(filterContext, pPSDrawable, rectangle2);
    }

    private static ShaderSource createShaderSource(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
            return (ShaderSource)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(string + " class not found");
        }
        finally {
            return null;
        }
    }

    private static String getPrefix(Class clazz) {
        String string = clazz.getPackage().getName();
        return string.substring(string.length() - 3);
    }

    public static Renderer createRenderer(FilterContext filterContext) {
        Object object = filterContext.getReferent();
        GraphicsPipeline graphicsPipeline = GraphicsPipeline.getPipeline();
        if (graphicsPipeline == null || !(object instanceof Screen)) {
            return null;
        }
        Screen screen = (Screen)object;
        ShaderSource shaderSource = null;
        String string = PPSRenderer.getPrefix(graphicsPipeline.getClass());
        if ("d3d".equals(string)) {
            shaderSource = PPSRenderer.createShaderSource("com.sun.scenario.effect.impl.hw.d3d.D3DShaderSource");
        } else if ("es2".equals(string)) {
            shaderSource = PPSRenderer.createShaderSource("com.sun.scenario.effect.impl.es2.ES2ShaderSource");
        } else {
            throw new InternalError("Unknown GraphicsPipeline");
        }
        if (shaderSource == null) {
            return null;
        }
        return new PPSRenderer(screen, shaderSource);
    }
}

