/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.nativewindow.impl;

import com.sun.prism.nativewindow.AbstractGraphicsConfiguration;
import com.sun.prism.nativewindow.NativeWindow;
import com.sun.prism.nativewindow.NativeWindowException;
import com.sun.prism.nativewindow.SurfaceChangeable;

public class NullWindow
implements NativeWindow,
SurfaceChangeable {
    private Exception lockedStack = null;
    protected int width;
    protected int height;
    protected int scrnIndex;
    protected long surfaceHandle;
    protected long displayHandle;
    protected AbstractGraphicsConfiguration config;

    public NullWindow(AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        this.invalidate();
        this.config = abstractGraphicsConfiguration;
        this.displayHandle = abstractGraphicsConfiguration.getScreen().getDevice().getHandle();
        this.scrnIndex = abstractGraphicsConfiguration.getScreen().getIndex();
    }

    protected void init(Object object) throws NativeWindowException {
    }

    protected void initNative() throws NativeWindowException {
    }

    public void destroy() {
        this.invalidate();
    }

    public synchronized void invalidate() {
        this.displayHandle = 0L;
        this.scrnIndex = -1;
        this.surfaceHandle = 0L;
    }

    public synchronized int lockSurface() throws NativeWindowException {
        if (null != this.lockedStack) {
            this.lockedStack.printStackTrace();
            throw new NativeWindowException("Surface already locked - " + this);
        }
        this.lockedStack = new Exception("NullWindow previously locked by " + Thread.currentThread().getName());
        return 3;
    }

    public synchronized void unlockSurface() {
        if (null == this.lockedStack) {
            throw new NativeWindowException("NullWindow not locked");
        }
        this.lockedStack = null;
    }

    public synchronized boolean isSurfaceLocked() {
        return null != this.lockedStack;
    }

    public Exception getLockedStack() {
        return this.lockedStack;
    }

    public boolean surfaceSwap() {
        return false;
    }

    public void surfaceUpdated(Object object, NativeWindow nativeWindow, long l) {
    }

    public long getDisplayHandle() {
        return this.displayHandle;
    }

    public int getScreenIndex() {
        return this.scrnIndex;
    }

    public long getWindowHandle() {
        return 0L;
    }

    public long getSurfaceHandle() {
        return this.surfaceHandle;
    }

    public void setSurfaceHandle(long l) {
        this.surfaceHandle = l;
    }

    public AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.config;
    }

    public Object getWrappedWindow() {
        return null;
    }

    public final boolean isTerminalObject() {
        return true;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return "NullWindow[config " + this.config + ", displayHandle 0x" + Long.toHexString(this.getDisplayHandle()) + ", surfaceHandle 0x" + Long.toHexString(this.getSurfaceHandle()) + ", size " + this.getWidth() + "x" + this.getHeight() + "]";
    }
}

