/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.javafx.font.FontStrike;
import com.sun.prism.PixelFormat;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.impl.BaseContext;
import com.sun.prism.impl.BufferUtil;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.packrect.BackingStoreManager;
import com.sun.prism.impl.packrect.Rect;
import com.sun.prism.impl.packrect.RectanglePacker;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.impl.shape.ShapeUtil;
import com.sun.prism.paint.Color;
import com.sun.t2k.CharToGlyphMapper;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.WeakHashMap;

public class GlyphCache {
    private static final int SIZE = 1024;
    private static ByteBuffer emptyMask;
    private final BaseContext context;
    private final FontStrike strike;
    private static final int SEGSHIFT = 5;
    private static final int SEGSIZE = 32;
    HashMap<Integer, GlyphData[]> glyphDataMap = new HashMap();
    private RectanglePacker packer;
    private boolean isLCDCache;
    private int numAllocatedGlyphs = 0;
    static WeakHashMap<BaseContext, RectanglePacker> greyPackerMap;
    static WeakHashMap<BaseContext, RectanglePacker> lcdPackerMap;
    private char[] charData = null;
    private int[] glyphData = null;

    public GlyphCache(BaseContext baseContext, FontStrike fontStrike) {
        this.context = baseContext;
        this.strike = fontStrike;
        boolean bl = fontStrike.getAAMode() == 4;
        WeakHashMap<BaseContext, RectanglePacker> weakHashMap = bl ? lcdPackerMap : greyPackerMap;
        this.packer = weakHashMap.get(baseContext);
        if (this.packer == null) {
            GlyphManager glyphManager = bl ? new LCDGlyphManager() : new GlyphManager();
            this.packer = new RectanglePacker(glyphManager, 1024, 1024);
            weakHashMap.put(baseContext, this.packer);
        }
    }

    int[] getGlyphCodes(String string) {
        int n = string.length();
        if (this.glyphData == null || this.glyphData.length < n) {
            this.charData = new char[n];
            this.glyphData = new int[n];
        }
        string.getChars(0, n, this.charData, 0);
        CharToGlyphMapper charToGlyphMapper = this.strike.getFontResource().getGlyphMapper();
        charToGlyphMapper.charsToGlyphs(n, this.charData, this.glyphData);
        return this.glyphData;
    }

    public boolean isLCDCache() {
        return this.isLCDCache;
    }

    public void render(BaseContext baseContext, String string, float f, float f2) {
        int n = string.length();
        float f3 = f;
        float f4 = f2;
        Texture texture = this.getBackingStore();
        VertexBuffer vertexBuffer = baseContext.getVertexBuffer();
        int[] nArray = this.getGlyphCodes(string);
        for (int i = 0; i < n; ++i) {
            GlyphData glyphData;
            if (nArray[i] == 65535 || (glyphData = this.getCachedGlyph(nArray[i])) == null) continue;
            GlyphCache.addDataToQuad(glyphData, vertexBuffer, texture, f3, f4);
            f3 += glyphData.getXAdvance();
            f4 += glyphData.getYAdvance();
        }
    }

    public void renderWithColorRange(BaseContext baseContext, String string, float f, float f2, int n, int n2, Color color, Color color2) {
        int n3 = string.length();
        float f3 = f;
        float f4 = f2;
        Texture texture = this.getBackingStore();
        VertexBuffer vertexBuffer = baseContext.getVertexBuffer();
        int[] nArray = this.getGlyphCodes(string);
        if (n < 0 && 0 < n2) {
            vertexBuffer.setPerVertexColor(color, 1.0f);
        }
        for (int i = 0; i < n3; ++i) {
            GlyphData glyphData;
            if (n == i) {
                vertexBuffer.setPerVertexColor(color, 1.0f);
            } else if (color2 != null && i == n2) {
                vertexBuffer.setPerVertexColor(color2, 1.0f);
            }
            if (nArray[i] == 65535 || (glyphData = this.getCachedGlyph(nArray[i])) == null) continue;
            GlyphCache.addDataToQuad(glyphData, vertexBuffer, texture, f3, f4);
            f3 += glyphData.getXAdvance();
            f4 += glyphData.getYAdvance();
        }
    }

    private static void addDataToQuad(GlyphData glyphData, VertexBuffer vertexBuffer, Texture texture, float f, float f2) {
        Rect rect = glyphData.getRect();
        if (rect == null) {
            return;
        }
        int n = glyphData.getBlankBoundary();
        float f3 = rect.w() - n * 2;
        float f4 = rect.h() - n * 2;
        float f5 = (float)glyphData.getOriginX() + f;
        float f6 = (float)glyphData.getOriginY() + f2;
        if (glyphData.getYAdvance() == 0.0f) {
            f5 = Math.round(f5);
        }
        if (glyphData.getXAdvance() == 0.0f) {
            f6 = Math.round(f6);
        }
        float f7 = f5 + f3;
        float f8 = f6 + f4;
        float f9 = texture.getPhysicalWidth();
        float f10 = texture.getPhysicalHeight();
        float f11 = (float)(rect.x() + n) / f9;
        float f12 = (float)(rect.y() + n) / f10;
        float f13 = f11 + f3 / f9;
        float f14 = f12 + f4 / f10;
        vertexBuffer.addQuad(f5, f6, f7, f8, f11, f12, f13, f14);
    }

    public void renderLCD(BaseContext baseContext, String string, float f, float f2, float f3, float f4) {
        int n = string.length();
        float f5 = 0.0f;
        float f6 = 0.0f;
        Texture texture = this.getBackingStore();
        VertexBuffer vertexBuffer = baseContext.getVertexBuffer();
        int[] nArray = this.getGlyphCodes(string);
        for (int i = 0; i < n; ++i) {
            GlyphData glyphData;
            if (i == 65535 || (glyphData = this.getCachedGlyph(nArray[i])) == null) continue;
            Rect rect = glyphData.getRect();
            if (rect == null) {
                f5 += glyphData.getXAdvance();
                f6 += glyphData.getYAdvance();
                continue;
            }
            int n2 = glyphData.getBlankBoundary();
            float f7 = rect.w() - n2 * 2;
            float f8 = rect.h() - n2 * 2;
            float f9 = f + (float)glyphData.getOriginX() + f5;
            float f10 = f2 + (float)glyphData.getOriginY() + f6;
            if (glyphData.getYAdvance() == 0.0f) {
                f9 = Math.round(f9);
            }
            if (glyphData.getXAdvance() == 0.0f) {
                f10 = Math.round(f10);
            }
            float f11 = f9 + f7;
            float f12 = f10 + f8;
            float f13 = texture.getPhysicalWidth();
            float f14 = texture.getPhysicalHeight();
            float f15 = (float)(rect.x() + n2) / f13;
            float f16 = (float)(rect.y() + n2) / f14;
            float f17 = f15 + f7 / f13;
            float f18 = f16 + f8 / f14;
            float f19 = f9 / f3;
            float f20 = f11 / f3;
            float f21 = f10 / f4;
            float f22 = f12 / f4;
            vertexBuffer.addQuad(f9, f10, f11, f12, f15, f16, f17, f18, f19, f21, f20, f22);
            f5 += glyphData.getXAdvance();
            f6 += glyphData.getYAdvance();
        }
    }

    public Texture getBackingStore() {
        return (Texture)this.packer.getBackingStore();
    }

    public void clearRects() {
        for (GlyphData[] glyphDataArray : this.glyphDataMap.values()) {
            for (int i = 0; i < glyphDataArray.length; ++i) {
                if (glyphDataArray[i] == null) continue;
                Rect rect = glyphDataArray[i].getRect();
                if (rect != null) {
                    this.packer.remove(rect);
                }
                glyphDataArray[i] = null;
            }
        }
        this.numAllocatedGlyphs = 0;
    }

    public void clear() {
        this.glyphDataMap.clear();
        this.numAllocatedGlyphs = 0;
    }

    public int getNumAllocatedGlyphs() {
        return this.numAllocatedGlyphs;
    }

    private void freeSpace() {
        this.context.flushVertexBuffer();
        this.context.freeUpGlyphCacheSpace(this);
    }

    private void clearAll() {
        this.context.flushVertexBuffer();
        this.context.clearGlyphCaches();
        this.packer.clear();
    }

    private boolean isEmptyGlyph(FontStrike.Glyph glyph) {
        if (!this.strike.supportsGlyphImages()) {
            return glyph.getBBox().isEmpty();
        }
        return glyph.getWidth() == 0 || glyph.getHeight() == 0;
    }

    private GlyphData getCachedGlyph(int n) {
        int n2 = n >> 5;
        int n3 = n % 32;
        GlyphData[] glyphDataArray = this.glyphDataMap.get(n2);
        if (glyphDataArray != null) {
            if (glyphDataArray[n3] != null) {
                return glyphDataArray[n3];
            }
        } else {
            glyphDataArray = new GlyphData[32];
            this.glyphDataMap.put(n2, glyphDataArray);
        }
        GlyphData glyphData = null;
        FontStrike.Glyph glyph = this.strike.getGlyph(n);
        if (glyph != null) {
            if (this.isEmptyGlyph(glyph)) {
                glyphData = new GlyphData(0, 0, 0, glyph.getPixelXAdvance(), glyph.getPixelYAdvance(), null);
            } else {
                MaskData maskData = this.strike.supportsGlyphImages() ? MaskData.create(glyph.getPixelData(), glyph.getOriginX(), glyph.getOriginY(), glyph.getWidth(), glyph.getHeight()) : ShapeUtil.rasterizeGlyphOutline(glyph.getShape());
                int n4 = 1;
                int n5 = maskData.getWidth() + 2 * n4;
                int n6 = maskData.getHeight() + 2 * n4;
                int n7 = maskData.getOriginX();
                int n8 = maskData.getOriginY();
                Rect rect = new Rect(0, 0, n5, n6, maskData);
                glyphData = new GlyphData(n7, n8, n4, glyph.getPixelXAdvance(), glyph.getPixelYAdvance(), rect);
                boolean bl = false;
                int n9 = 0;
                while (!bl) {
                    try {
                        this.packer.add(rect);
                        bl = true;
                    }
                    catch (RuntimeException runtimeException) {
                        if (n9 == 0) {
                            this.freeSpace();
                        } else if (n9 == 1) {
                            this.clearAll();
                        } else {
                            bl = true;
                        }
                        ++n9;
                    }
                }
                boolean bl2 = true;
                Texture texture = this.getBackingStore();
                int n10 = rect.w();
                int n11 = rect.h();
                int n12 = texture.getPixelFormat().getBytesPerPixelUnit();
                int n13 = n10 * n12;
                int n14 = n13 * n11;
                if (emptyMask == null || n14 > emptyMask.capacity()) {
                    emptyMask = BufferUtil.newByteBuffer(n14);
                }
                try {
                    texture.update(emptyMask, texture.getPixelFormat(), rect.x(), rect.y(), 0, 0, n10, n11, n13, bl2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
                maskData.uploadToTexture(texture, n4 + rect.x(), n4 + rect.y(), bl2);
            }
            glyphDataArray[n3] = glyphData;
            ++this.numAllocatedGlyphs;
        }
        return glyphData;
    }

    static {
        greyPackerMap = new WeakHashMap();
        lcdPackerMap = new WeakHashMap();
    }

    class LCDGlyphManager
    extends GlyphManager {
        LCDGlyphManager() {
        }

        @Override
        public Texture allocateBackingStore(int n, int n2) {
            ResourceFactory resourceFactory = GlyphCache.this.context.getResourceFactory();
            Texture texture = resourceFactory.createTexture(PixelFormat.BYTE_RGB, Texture.Usage.DEFAULT, n, n2);
            texture.setLinearFiltering(false);
            return texture;
        }
    }

    class GlyphManager
    implements BackingStoreManager {
        GlyphManager() {
        }

        @Override
        public Texture allocateBackingStore(int n, int n2) {
            Texture texture = GlyphCache.this.context.getResourceFactory().createMaskTexture(n, n2);
            texture.setLinearFiltering(false);
            return texture;
        }

        @Override
        public void deleteBackingStore(Object object) {
            if (object != null) {
                ((Texture)object).dispose();
            }
        }

        @Override
        public boolean canCompact() {
            return false;
        }

        @Override
        public boolean additionFailed(Rect rect, int n) {
            if (n == 0) {
                GlyphCache.this.freeSpace();
                return true;
            }
            if (n == 1) {
                GlyphCache.this.clearAll();
                return true;
            }
            return false;
        }

        @Override
        public boolean preExpand(Rect rect, int n) {
            throw new InternalError("Not implemented");
        }

        @Override
        public void beginMovement(Object object, Object object2) {
            throw new InternalError("Not implemented");
        }

        @Override
        public void move(Object object, Rect rect, Object object2, Rect rect2) {
            throw new InternalError("Not implemented");
        }

        @Override
        public void endMovement(Object object, Object object2) {
            throw new InternalError("Not implemented");
        }
    }

    static class GlyphData {
        private final int originX;
        private final int originY;
        private final int blankBoundary;
        private final float xAdvance;
        private final float yAdvance;
        private final Rect rect;

        GlyphData(int n, int n2, int n3, float f, float f2, Rect rect) {
            this.originX = n;
            this.originY = n2;
            this.blankBoundary = n3;
            this.xAdvance = f;
            this.yAdvance = f2;
            this.rect = rect;
        }

        int getOriginX() {
            return this.originX;
        }

        int getOriginY() {
            return this.originY;
        }

        int getBlankBoundary() {
            return this.blankBoundary;
        }

        float getXAdvance() {
            return this.xAdvance;
        }

        float getYAdvance() {
            return this.yAdvance;
        }

        Rect getRect() {
            return this.rect;
        }
    }
}

