/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.glass.ui.Screen;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.PixelFormat;
import com.sun.prism.RenderTarget;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.camera.PrismCameraImpl;
import com.sun.prism.impl.BaseGraphics;
import com.sun.prism.impl.GlyphCache;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.paint.PaintUtil;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.paint.Gradient;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseContext {
    private final Screen screen;
    private final ResourceFactory factory;
    private final VertexBuffer vertexBuffer;
    private Texture maskTex;
    private Texture paintTex;
    private int[] paintPixels;
    private ByteBuffer paintBuffer;
    private final Map<FontStrike, GlyphCache> greyGlyphCaches = new HashMap<FontStrike, GlyphCache>();
    private final Map<FontStrike, GlyphCache> lcdGlyphCaches = new HashMap<FontStrike, GlyphCache>();
    GlyphCache[] recentCaches = new GlyphCache[8];
    int recentCacheIndex = 0;

    protected BaseContext(Screen screen, ResourceFactory resourceFactory) {
        this.screen = screen;
        this.factory = resourceFactory;
        this.vertexBuffer = this.createVertexBuffer();
    }

    protected abstract VertexBuffer createVertexBuffer();

    public Screen getAssociatedScreen() {
        return this.screen;
    }

    public ResourceFactory getResourceFactory() {
        return this.factory;
    }

    public VertexBuffer getVertexBuffer() {
        return this.vertexBuffer;
    }

    public void flushVertexBuffer() {
        this.vertexBuffer.flush();
    }

    public void setRenderTarget(BaseGraphics baseGraphics) {
        this.setRenderTarget(baseGraphics.getRenderTarget(), baseGraphics.getCameraNoClone(), baseGraphics.isDepthTest() && baseGraphics.isDepthBuffer());
    }

    protected abstract void setRenderTarget(RenderTarget var1, PrismCameraImpl var2, boolean var3);

    public void validateClearOp(BaseGraphics baseGraphics) {
        this.validatePaintOp(baseGraphics, BaseTransform.IDENTITY_TRANSFORM, null, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public abstract void validatePaintOp(BaseGraphics var1, BaseTransform var2, Texture var3, float var4, float var5, float var6, float var7);

    public abstract void validateTextureOp(BaseGraphics var1, BaseTransform var2, Texture var3, PixelFormat var4);

    public void clearGlyphCaches() {
        this.clearCaches(this.greyGlyphCaches);
        this.clearCaches(this.lcdGlyphCaches);
    }

    private void clearCaches(Map<FontStrike, GlyphCache> map) {
        for (GlyphCache glyphCache : map.values()) {
            if (glyphCache == null) continue;
            glyphCache.clear();
        }
        for (int i = 0; i < this.recentCaches.length; ++i) {
            this.recentCaches[i] = null;
        }
        this.recentCacheIndex = 0;
    }

    public GlyphCache getGlyphCache(FontStrike fontStrike) {
        Map<FontStrike, GlyphCache> map = fontStrike.getAAMode() == 4 ? this.lcdGlyphCaches : this.greyGlyphCaches;
        return this.getGlyphCache(fontStrike, map);
    }

    private GlyphCache getGlyphCache(FontStrike fontStrike, Map<FontStrike, GlyphCache> map) {
        GlyphCache glyphCache = map.get(fontStrike);
        boolean bl = false;
        if (glyphCache == null) {
            glyphCache = new GlyphCache(this, fontStrike);
            map.put(fontStrike, glyphCache);
        } else {
            for (int i = 0; i < this.recentCaches.length; ++i) {
                if (this.recentCaches[i] != glyphCache) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.recentCaches[this.recentCacheIndex] = glyphCache;
                ++this.recentCacheIndex;
                if (this.recentCacheIndex == this.recentCaches.length) {
                    this.recentCacheIndex = 0;
                }
            }
        }
        return glyphCache;
    }

    private boolean notRecentlyUsed(GlyphCache glyphCache) {
        for (int i = 0; i < this.recentCaches.length; ++i) {
            if (glyphCache != this.recentCaches[i]) continue;
            return false;
        }
        return true;
    }

    public void freeUpGlyphCacheSpace(GlyphCache glyphCache) {
        Map<FontStrike, GlyphCache> map = glyphCache.isLCDCache() ? this.lcdGlyphCaches : this.greyGlyphCaches;
        int n = 0;
        for (GlyphCache glyphCache2 : map.values()) {
            n += glyphCache2.getNumAllocatedGlyphs();
        }
        int n2 = n >> 3;
        int n3 = 0;
        FontStrike[] fontStrikeArray = new FontStrike[map.size()];
        map.keySet().toArray(fontStrikeArray);
        for (int i = 0; i < fontStrikeArray.length; ++i) {
            FontStrike fontStrike = fontStrikeArray[i];
            GlyphCache glyphCache3 = map.get(fontStrike);
            if (glyphCache3 != glyphCache && this.notRecentlyUsed(glyphCache3)) {
                map.remove(fontStrike);
                fontStrike.clearDesc();
                n3 = glyphCache3.getNumAllocatedGlyphs();
                glyphCache3.clearRects();
            }
            if (n3 > n2) break;
        }
    }

    public boolean isEdgeSmoothingSupported(PixelFormat pixelFormat) {
        return true;
    }

    public Texture getMaskTexture(MaskData maskData) {
        int n = maskData.getWidth();
        int n2 = maskData.getHeight();
        if (this.maskTex == null || this.maskTex.getContentWidth() < n || this.maskTex.getContentHeight() < n2) {
            int n3 = n;
            int n4 = n2;
            if (this.maskTex != null) {
                n3 = Math.max(n, this.maskTex.getContentWidth());
                n4 = Math.max(n2, this.maskTex.getContentHeight());
                this.maskTex.dispose();
            }
            this.maskTex = this.getResourceFactory().createMaskTexture(n3, n4);
        }
        maskData.uploadToTexture(this.maskTex, 0, 0, false);
        return this.maskTex;
    }

    public Texture getGradientTexture(Gradient gradient, BaseTransform baseTransform, int n, int n2, MaskData maskData, float f, float f2, float f3, float f4) {
        int n3;
        int n4 = n * n2;
        int n5 = n4 * 4;
        if (this.paintBuffer == null || this.paintBuffer.capacity() < n5) {
            this.paintPixels = new int[n4];
            this.paintBuffer = ByteBuffer.wrap(new byte[n5]);
        }
        if (this.paintTex == null || this.paintTex.getContentWidth() < n || this.paintTex.getContentHeight() < n2) {
            int n6 = n;
            n3 = n2;
            if (this.paintTex != null) {
                n6 = Math.max(n, this.paintTex.getContentWidth());
                n3 = Math.max(n2, this.paintTex.getContentHeight());
                this.paintTex.dispose();
            }
            this.paintTex = this.getResourceFactory().createTexture(PixelFormat.BYTE_BGRA_PRE, Texture.Usage.DEFAULT, n6, n3, false);
        }
        PaintUtil.fillImageWithGradient(this.paintPixels, gradient, baseTransform, 0, 0, n, n2, f, f2, f3, f4);
        byte[] byArray = this.paintBuffer.array();
        if (maskData != null) {
            byte[] byArray2 = maskData.getMaskBuffer().array();
            int n7 = 0;
            for (int i = 0; i < n4; ++i) {
                int n8 = this.paintPixels[i];
                int n9 = byArray2[i] & 0xFF;
                byArray[n7++] = (byte)((n8 & 0xFF) * n9 / 255);
                byArray[n7++] = (byte)((n8 >> 8 & 0xFF) * n9 / 255);
                byArray[n7++] = (byte)((n8 >> 16 & 0xFF) * n9 / 255);
                byArray[n7++] = (byte)((n8 >>> 24) * n9 / 255);
            }
        } else {
            n3 = 0;
            for (int i = 0; i < n4; ++i) {
                int n10 = this.paintPixels[i];
                byArray[n3++] = (byte)(n10 & 0xFF);
                byArray[n3++] = (byte)(n10 >> 8 & 0xFF);
                byArray[n3++] = (byte)(n10 >> 16 & 0xFF);
                byArray[n3++] = (byte)(n10 >>> 24);
            }
        }
        this.paintTex.update(this.paintBuffer, PixelFormat.BYTE_BGRA_PRE, 0, 0, 0, 0, n, n2, n * 4, false);
        return this.paintTex;
    }
}

