/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.prism.MediaFrame;
import com.sun.prism.MultiTexture;
import com.sun.prism.PixelFormat;
import com.sun.prism.Presentable;
import com.sun.prism.RenderingContext;
import com.sun.prism.Texture;
import com.sun.prism.d3d.D3DContext;
import com.sun.prism.d3d.D3DPipeline;
import com.sun.prism.d3d.D3DRTTexture;
import com.sun.prism.d3d.D3DResource;
import com.sun.prism.d3d.D3DShader;
import com.sun.prism.d3d.D3DSwapChain;
import com.sun.prism.d3d.D3DTexture;
import com.sun.prism.d3d.D3DVertexBuffer;
import com.sun.prism.impl.BaseRenderingContext;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.ps.BaseShaderFactory;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Map;

class D3DResourceFactory
extends BaseShaderFactory {
    private final D3DContext context;
    private Integer maxTextureSize;
    private final ArrayList<D3DResource.D3DRecord> records = new ArrayList(5);

    D3DResourceFactory(Screen screen) {
        this.context = new D3DContext(screen, this);
    }

    D3DContext getContext() {
        return this.context;
    }

    @Override
    public boolean isDeviceReady() {
        return this.context.testLostStateAndReset();
    }

    @Override
    public D3DTexture createTexture(PixelFormat pixelFormat, Texture.Usage usage, int n, int n2, boolean bl) {
        if (!this.isFormatSupported(pixelFormat)) {
            throw new UnsupportedOperationException("Pixel format " + (Object)((Object)pixelFormat) + " not supported on this device");
        }
        if (pixelFormat == PixelFormat.MULTI_YCbCr_420) {
            throw new UnsupportedOperationException("MULTI_YCbCr_420 textures require a MediaFrame");
        }
        long l = D3DResourceFactory.nCreateTexture(this.context.getContextHandle(), pixelFormat.ordinal(), usage.ordinal(), false, n, n2);
        if (l == 0L) {
            return null;
        }
        int n3 = D3DResourceFactory.nGetTextureWidth(l);
        int n4 = D3DResourceFactory.nGetTextureHeight(l);
        return new D3DTexture(this.context, pixelFormat, l, n3, n4, n, n2);
    }

    @Override
    public Texture createTexture(MediaFrame mediaFrame) {
        mediaFrame.holdFrame();
        int n = mediaFrame.getWidth();
        int n2 = mediaFrame.getHeight();
        int n3 = mediaFrame.getEncodedWidth();
        int n4 = mediaFrame.getEncodedHeight();
        PixelFormat pixelFormat = mediaFrame.getPixelFormat();
        if (pixelFormat == PixelFormat.MULTI_YCbCr_420) {
            MultiTexture multiTexture = new MultiTexture(pixelFormat, n, n2);
            for (int i = 0; i < mediaFrame.planeCount(); ++i) {
                int n5 = n3;
                int n6 = n4;
                if (i == 2 || i == 1) {
                    n5 /= 2;
                    n6 /= 2;
                }
                D3DTexture d3DTexture = this.createTexture(PixelFormat.BYTE_ALPHA, Texture.Usage.DYNAMIC, n5, n6, false);
                multiTexture.setTexture(d3DTexture, i);
            }
            mediaFrame.releaseFrame();
            return multiTexture;
        }
        long l = D3DResourceFactory.nCreateTexture(this.context.getContextHandle(), pixelFormat.ordinal(), Texture.Usage.DYNAMIC.ordinal(), false, n3, n4);
        if (0L == l) {
            return null;
        }
        n3 = D3DResourceFactory.nGetTextureWidth(l);
        n4 = D3DResourceFactory.nGetTextureHeight(l);
        D3DTexture d3DTexture = new D3DTexture(this.context, pixelFormat, l, n3, n4, n, n2);
        mediaFrame.releaseFrame();
        return d3DTexture;
    }

    @Override
    public D3DRTTexture createRTTexture(int n, int n2) {
        long l;
        if (PrismSettings.verbose && this.context.isLost()) {
            System.err.println("RT Texture allocation while the device is lost");
        }
        if ((l = D3DResourceFactory.nCreateTexture(this.context.getContextHandle(), PixelFormat.INT_ARGB_PRE.ordinal(), Texture.Usage.DEFAULT.ordinal(), true, n, n2)) == 0L) {
            return null;
        }
        int n3 = D3DResourceFactory.nGetTextureWidth(l);
        int n4 = D3DResourceFactory.nGetTextureHeight(l);
        D3DRTTexture d3DRTTexture = new D3DRTTexture(this.context, l, n3, n4, n, n2);
        d3DRTTexture.createGraphics().clear();
        return d3DRTTexture;
    }

    @Override
    public Presentable createPresentable(View view) {
        long l;
        if (PrismSettings.verbose && this.context.isLost()) {
            System.err.println("SwapChain allocation while the device is lost");
        }
        if ((l = D3DResourceFactory.nCreateSwapChain(this.context.getContextHandle(), view.getNativeView(), PrismSettings.isVsyncEnabled)) != 0L) {
            int n;
            int n2 = D3DResourceFactory.nGetTextureWidth(l);
            D3DRTTexture d3DRTTexture = this.createRTTexture(n2, n = D3DResourceFactory.nGetTextureHeight(l));
            if (d3DRTTexture != null) {
                return new D3DSwapChain(this.context, l, d3DRTTexture);
            }
            D3DResourceFactory.nReleaseResource(this.context.getContextHandle(), l);
        }
        return null;
    }

    @Override
    public VertexBuffer createVertexBuffer(int n, boolean bl) {
        return new D3DVertexBuffer(this.context, n, bl);
    }

    private static ByteBuffer getBuffer(InputStream inputStream) {
        if (inputStream == null) {
            throw new RuntimeException("InputStream must be non-null");
        }
        try {
            Object object;
            int n = 4096;
            Object object2 = new byte[n];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, n);
            int n2 = 0;
            int n3 = -1;
            while ((n3 = bufferedInputStream.read((byte[])object2, n2, n - n2)) != -1) {
                if (n - (n2 += n3) != 0) continue;
                object = new byte[n *= 2];
                System.arraycopy(object2, 0, object, 0, ((byte[])object2).length);
                object2 = object;
            }
            bufferedInputStream.close();
            object = ByteBuffer.allocateDirect(n2);
            ((ByteBuffer)object).put((byte[])object2, 0, n2);
            return object;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error loading D3D shader object", iOException);
        }
    }

    @Override
    public Shader createShader(InputStream inputStream, Map<String, Integer> map, Map<String, Integer> map2, int n, boolean bl, boolean bl2) {
        return new D3DShader(this.context, D3DResourceFactory.getBuffer(inputStream), map2);
    }

    @Override
    public Shader createStockShader(final String string) {
        if (string == null) {
            throw new IllegalArgumentException("Shader name must be non-null");
        }
        try {
            InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    return D3DResourceFactory.class.getResourceAsStream("hlsl/" + string + ".obj");
                }
            });
            Class<?> clazz = Class.forName("com.sun.prism.shader." + string + "_Loader");
            Method method = clazz.getMethod("loadShader", ShaderFactory.class, InputStream.class);
            return (Shader)method.invoke(null, this, inputStream);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new InternalError("Error loading stock shader " + string);
        }
    }

    @Override
    public RenderingContext createRenderingContext(View view) {
        return new BaseRenderingContext();
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isFormatSupported(PixelFormat pixelFormat) {
        return true;
    }

    @Override
    public int getMaximumTextureSize() {
        if (this.maxTextureSize == null) {
            this.maxTextureSize = D3DResourceFactory.nGetMaximumTextureSize(this.context.getContextHandle());
        }
        return this.maxTextureSize;
    }

    @Override
    protected void notifyReset() {
        ListIterator<D3DResource.D3DRecord> listIterator = this.records.listIterator();
        while (listIterator.hasNext()) {
            D3DResource.D3DRecord d3DRecord = listIterator.next();
            if (!d3DRecord.isDefaultPool()) continue;
            d3DRecord.markDisposed();
            listIterator.remove();
        }
        super.notifyReset();
    }

    @Override
    protected void notifyReleased() {
        ListIterator<D3DResource.D3DRecord> listIterator = this.records.listIterator();
        while (listIterator.hasNext()) {
            D3DResource.D3DRecord d3DRecord = listIterator.next();
            d3DRecord.markDisposed();
            listIterator.remove();
        }
        super.notifyReleased();
    }

    void addRecord(D3DResource.D3DRecord d3DRecord) {
        this.records.add(d3DRecord);
    }

    void removeRecord(D3DResource.D3DRecord d3DRecord) {
        this.records.remove(d3DRecord);
    }

    private static void markDefaultPoolReleased(int n) {
        D3DPipeline.getInstance().getD3DResourceFactory(n, null).notifyReset();
    }

    private static void markAllReleased(int n) {
        D3DPipeline.getInstance().getD3DResourceFactory(n, null).notifyReleased();
    }

    protected static native long nGetContext(int var0);

    protected static native boolean nIsDefaultPool(long var0);

    protected static native long nTestCooperativeLevel(long var0);

    protected static native long nResetDevice(long var0);

    protected static native long nCreateTexture(long var0, int var2, int var3, boolean var4, int var5, int var6);

    protected static native long nCreateSwapChain(long var0, long var2, boolean var4);

    protected static native long nReleaseResource(long var0, long var2);

    protected static native int nGetMaximumTextureSize(long var0);

    protected static native int nGetTextureWidth(long var0);

    protected static native int nGetTextureHeight(long var0);

    protected static native long nReadPixelsI(long var0, long var2, long var4, Buffer var6, int[] var7, int var8, int var9);

    protected static native long nReadPixelsB(long var0, long var2, long var4, Buffer var6, byte[] var7, int var8, int var9);

    protected static native long nUpdateTextureI(long var0, long var2, IntBuffer var4, int[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    protected static native long nUpdateTextureF(long var0, long var2, FloatBuffer var4, float[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    protected static native long nUpdateTextureB(long var0, long var2, ByteBuffer var4, byte[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);
}

