/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.glass.ui.Screen;
import com.sun.javafx.runtime.NativeLibLoader;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.ResourceFactory;
import com.sun.prism.d3d.D3DDriverInformation;
import com.sun.prism.d3d.D3DResourceFactory;
import com.sun.prism.impl.PrismSettings;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;

public class D3DPipeline
extends GraphicsPipeline {
    private static final boolean d3dEnabled = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            if (PrismSettings.verbose) {
                System.out.println("Loading D3D native library ...");
            }
            NativeLibLoader.loadLibrary("prism-d3d");
            if (PrismSettings.verbose) {
                System.out.println("\tsucceeded.");
            }
            boolean bl = D3DPipeline.nInit(PrismSettings.class) == 0L;
            D3DDriverInformation d3DDriverInformation = D3DPipeline.nGetDriverInformation(0, new D3DDriverInformation());
            if (!PrismSettings.disableBadDriverWarning) {
                D3DPipeline.checkAndPrintBadDriverWarning(d3DDriverInformation);
            }
            if (PrismSettings.verbose) {
                D3DPipeline.printDriverInformation(d3DDriverInformation);
            }
            return bl;
        }
    });
    private static Thread creator;
    private static D3DPipeline theInstance;
    private final HashMap<Integer, D3DResourceFactory> factories = new HashMap(1);

    public static D3DPipeline getInstance() {
        if (PrismSettings.verbose) {
            System.out.println("D3DPipeline:getInstance(), d3dEnabled=" + d3dEnabled);
        }
        if (theInstance == null && d3dEnabled) {
            theInstance = new D3DPipeline();
            creator = Thread.currentThread();
        }
        return theInstance;
    }

    private static void checkAndPrintBadDriverWarning(D3DDriverInformation d3DDriverInformation) {
        if (d3DDriverInformation != null && d3DDriverInformation.warningMessage != null && d3DDriverInformation.warningMessage.contains("bad driver")) {
            System.out.println(d3DDriverInformation.warningMessage);
        }
    }

    private static void printDriverInformation(D3DDriverInformation d3DDriverInformation) {
        if (d3DDriverInformation != null) {
            System.out.println("OS Information:");
            System.out.println("\t" + d3DDriverInformation.getOsVersion() + " build " + d3DDriverInformation.osBuildNumber);
            System.out.println("D3D Driver Information:");
            System.out.println("\t" + d3DDriverInformation.deviceDescription);
            System.out.println("\t" + d3DDriverInformation.deviceName);
            System.out.println("\tDriver " + d3DDriverInformation.driverName + ", version " + d3DDriverInformation.getDriverVersion());
            System.out.println("\tPixel Shader version " + d3DDriverInformation.psVersionMajor + "." + d3DDriverInformation.psVersionMinor);
            System.out.println("\tDevice : " + d3DDriverInformation.getDeviceID());
            if (d3DDriverInformation.warningMessage != null) {
                System.out.println("\t *** " + d3DDriverInformation.warningMessage);
            }
        }
    }

    @Override
    public boolean init() {
        return d3dEnabled;
    }

    private static native long nInit(Class var0);

    private static native long nDispose();

    protected static native int nGetAdapterOrdinal(long var0);

    public static native D3DDriverInformation nGetDriverInformation(int var0, D3DDriverInformation var1);

    @Override
    public void dispose() {
        assert (creator.equals(Thread.currentThread()));
        D3DPipeline.nDispose();
        super.dispose();
    }

    D3DResourceFactory getD3DResourceFactory(int n, Screen screen) {
        D3DResourceFactory d3DResourceFactory = this.factories.get(n);
        if (d3DResourceFactory == null && screen != null) {
            d3DResourceFactory = new D3DResourceFactory(screen);
            this.factories.put(n, d3DResourceFactory);
        }
        return d3DResourceFactory;
    }

    private D3DResourceFactory getD3DResourceFactory(Screen screen) {
        return this.getD3DResourceFactory(D3DPipeline.nGetAdapterOrdinal(screen.getNativeScreen()), screen);
    }

    @Override
    public ResourceFactory getResourceFactory(Screen screen) {
        return this.getD3DResourceFactory(screen);
    }

    Screen getScreenForAdapter(List<Screen> list, int n) {
        for (Screen screen : list) {
            if (D3DPipeline.nGetAdapterOrdinal(screen.getNativeScreen()) != n) continue;
            return screen;
        }
        return Screen.getMainScreen();
    }

    @Override
    public ResourceFactory getDefaultResourceFactory(List<Screen> list) {
        return this.getD3DResourceFactory(0, this.getScreenForAdapter(list, 0));
    }

    @Override
    public boolean is3DSupported() {
        return true;
    }

    static {
        if (PrismSettings.verbose) {
            System.out.println("Direct3D initialization " + (d3dEnabled ? "succeeded" : "failed"));
        }
    }
}

