/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.prism.CompositeMode;
import com.sun.prism.RenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.camera.PrismCameraImpl;
import com.sun.prism.d3d.D3DPipeline;
import com.sun.prism.d3d.D3DResourceFactory;
import com.sun.prism.d3d.D3DVertexBuffer;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.ps.BaseShaderContext;
import com.sun.prism.ps.Shader;

class D3DContext
extends BaseShaderContext {
    public static final long D3DERR_DEVICENOTRESET = -2005530519L;
    public static final long D3DERR_DEVICELOST = -2005530520L;
    public static final long E_FAIL = -2147467259L;
    public static final long D3DERR_OUTOFVIDEOMEMORY = -2005532292L;
    public static final long D3D_OK = 0L;
    private static GeneralTransform3D projViewTx = new GeneralTransform3D();
    private BaseShaderContext.State state;
    private boolean isLost;
    private long pContext;
    private D3DResourceFactory factory;

    public static boolean FAILED(long l) {
        return l < 0L;
    }

    D3DContext(Screen screen, D3DResourceFactory d3DResourceFactory) {
        super(screen, d3DResourceFactory);
        this.factory = d3DResourceFactory;
    }

    @Override
    public D3DResourceFactory getResourceFactory() {
        return this.factory;
    }

    @Override
    protected void init() {
        super.init();
        this.state = new BaseShaderContext.State();
        int n = D3DPipeline.nGetAdapterOrdinal(this.getAssociatedScreen().getNativeScreen());
        this.pContext = D3DResourceFactory.nGetContext(n);
        D3DContext.nSetBlendEnabled(this.pContext, true, false);
        this.isLost = false;
    }

    long getContextHandle() {
        return this.pContext;
    }

    boolean isLost() {
        return this.isLost;
    }

    void validate(long l) {
        if (PrismSettings.verbose && D3DContext.FAILED(l)) {
            System.out.println("D3D hresult failed :" + D3DContext.hResultToString(l));
            new Exception("Stack trace").printStackTrace(System.out);
        }
    }

    private void setLost() {
        this.isLost = true;
    }

    boolean testLostStateAndReset() {
        long l = D3DResourceFactory.nTestCooperativeLevel(this.pContext);
        if (l == -2005530520L) {
            this.setLost();
        }
        if (l == -2005530519L) {
            this.setLost();
            this.disposeLCDBuffer();
            this.factory.notifyReset();
            l = D3DResourceFactory.nResetDevice(this.pContext);
            if (l == 0L) {
                this.init();
            }
        }
        return l == 0L;
    }

    boolean validatePresent(long l) {
        if (l == -2005530520L || l == -2005530519L) {
            this.setLost();
        } else {
            this.validate(l);
        }
        return l == 0L;
    }

    @Override
    protected VertexBuffer createVertexBuffer() {
        return new D3DVertexBuffer(this, 256, false);
    }

    @Override
    protected BaseShaderContext.State updateRenderTarget(RenderTarget renderTarget, PrismCameraImpl prismCameraImpl, boolean bl) {
        long l = D3DContext.nSetRenderTarget(this.pContext, renderTarget.getNativeDestHandle());
        this.validate(l);
        int n = renderTarget.getPhysicalWidth();
        int n2 = renderTarget.getPhysicalHeight();
        GeneralTransform3D generalTransform3D = prismCameraImpl.getProjViewTx(projViewTx, n, n2, false);
        l = D3DContext.nSetProjViewMatrix(this.pContext, bl, generalTransform3D.get(0), generalTransform3D.get(1), generalTransform3D.get(2), generalTransform3D.get(3), generalTransform3D.get(4), generalTransform3D.get(5), generalTransform3D.get(6), generalTransform3D.get(7), generalTransform3D.get(8), generalTransform3D.get(9), generalTransform3D.get(10), generalTransform3D.get(11), generalTransform3D.get(12), generalTransform3D.get(13), generalTransform3D.get(14), generalTransform3D.get(15));
        this.validate(l);
        return this.state;
    }

    @Override
    protected void updateTexture(int n, Texture texture) {
        int n2;
        boolean bl;
        long l;
        if (texture != null) {
            l = texture.getNativeSourceHandle();
            bl = texture.getLinearFiltering();
            n2 = texture.getWrapMode().ordinal();
        } else {
            l = 0L;
            bl = false;
            n2 = 0;
        }
        this.validate(D3DContext.nSetTexture(this.pContext, l, n, bl, n2));
    }

    @Override
    protected void updateShaderTransform(Shader shader, BaseTransform baseTransform) {
        long l = 0L;
        l = baseTransform == null || baseTransform.isIdentity() ? D3DContext.nResetTransform(this.pContext) : D3DContext.nSetTransform(this.pContext, baseTransform.getMxx(), baseTransform.getMxy(), baseTransform.getMxz(), baseTransform.getMxt(), baseTransform.getMyx(), baseTransform.getMyy(), baseTransform.getMyz(), baseTransform.getMyt(), baseTransform.getMzx(), baseTransform.getMzy(), baseTransform.getMzz(), baseTransform.getMzt(), 0.0, 0.0, 0.0, 1.0);
        this.validate(l);
    }

    @Override
    protected void updateClipRect(Rectangle rectangle) {
        long l;
        if (rectangle == null || rectangle.isEmpty()) {
            l = D3DContext.nResetClipRect(this.pContext);
        } else {
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = n + rectangle.width;
            int n4 = n2 + rectangle.height;
            l = D3DContext.nSetClipRect(this.pContext, n, n2, n3, n4);
        }
        this.validate(l);
    }

    @Override
    protected void updateCompositeMode(CompositeMode compositeMode) {
        long l;
        switch (compositeMode) {
            case CLEAR: {
                l = D3DContext.nSetBlendEnabled(this.pContext, true, true);
                break;
            }
            case SRC: {
                l = D3DContext.nSetBlendEnabled(this.pContext, false, false);
                break;
            }
            case SRC_OVER: {
                l = D3DContext.nSetBlendEnabled(this.pContext, true, false);
                break;
            }
            default: {
                throw new InternalError("Unrecognized composite mode: " + (Object)((Object)compositeMode));
            }
        }
        this.validate(l);
    }

    void sync() {
        this.getVertexBuffer().flush();
    }

    private static native long nSetRenderTarget(long var0, long var2);

    private static native long nSetTexture(long var0, long var2, int var4, boolean var5, int var6);

    private static native long nResetTransform(long var0);

    private static native long nSetTransform(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18, double var20, double var22, double var24, double var26, double var28, double var30, double var32);

    private static native long nSetProjViewMatrix(long var0, boolean var2, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23, double var25, double var27, double var29, double var31, double var33);

    private static native long nResetClipRect(long var0);

    private static native long nSetClipRect(long var0, int var2, int var3, int var4, int var5);

    private static native long nSetBlendEnabled(long var0, boolean var2, boolean var3);

    public static String hResultToString(long l) {
        switch ((int)l) {
            case -2005530519: {
                return "D3DERR_DEVICENOTRESET";
            }
            case -2005530520: {
                return "D3DERR_DEVICELOST";
            }
            case -2005532292: {
                return "D3DERR_OUTOFVIDEOMEMORY";
            }
            case 0: {
                return "D3D_OK";
            }
        }
        return "D3D_ERROR " + Long.toHexString(l);
    }
}

