/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.camera;

import com.sun.javafx.geom.PerspectiveCameraImpl;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.prism.camera.PrismCameraImpl;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PrismPerspectiveCameraImpl
extends PrismCameraImpl
implements PerspectiveCameraImpl {
    private double fov;
    private static final Vec3d viewDir = new Vec3d(0.0, 0.0, 1.0);
    private static final Vec3d up = new Vec3d(0.0, -1.0, 0.0);
    private static GeneralTransform3D invProjTx = new GeneralTransform3D();
    private static Affine3D invViewTx = new Affine3D();

    @Override
    protected void computeProjection(GeneralTransform3D generalTransform3D, boolean bl) {
        generalTransform3D.perspective(this.fov, this.aspect, 0.1, 100.0);
        invProjTx.set(generalTransform3D);
        invProjTx.invert();
    }

    @Override
    protected void computeViewTransform(Affine3D affine3D) {
        double d = Math.tan(this.fov / 2.0);
        double d2 = 2.0 * d / (double)this.viewport.height;
        double d3 = -d * this.aspect;
        double d4 = d;
        affine3D.setToTranslation(d3, d4, 0.0);
        Vec3d vec3d = new Vec3d(this.zero);
        vec3d.mul(d2);
        Vec3d vec3d2 = new Vec3d(viewDir);
        vec3d2.mul(-1.0);
        vec3d2.normalize();
        Vec3d vec3d3 = new Vec3d(vec3d);
        vec3d3.add(vec3d2);
        Affine3D affine3D2 = new Affine3D();
        affine3D2.lookAt(vec3d3, vec3d, up);
        affine3D.concatenate(affine3D2);
        Affine3D affine3D3 = new Affine3D();
        affine3D3.setToScale(d2, d2, d2);
        affine3D.concatenate(affine3D3);
        invViewTx.setTransform(affine3D);
        try {
            invViewTx.invert();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            Logger.getLogger(PrismPerspectiveCameraImpl.class.getName()).log(Level.SEVERE, null, noninvertibleTransformException);
        }
    }

    @Override
    public PickRay computePickRay(float f, float f2, PickRay pickRay) {
        if (pickRay == null) {
            pickRay = new PickRay();
        }
        Vec3d vec3d = pickRay.getOriginNoClone();
        Vec3d vec3d2 = pickRay.getDirectionNoClone();
        double d = f;
        double d2 = f2;
        double d3 = d / (double)this.viewport.width * 2.0 - 1.0;
        double d4 = d2 / (double)this.viewport.height * -2.0 + 1.0;
        double d5 = this.projTx.computeClipZCoord();
        vec3d2.set(d3, d4, d5);
        invProjTx.transform(vec3d2, vec3d2);
        invViewTx.transform(vec3d2, vec3d2);
        vec3d.set(0.0, 0.0, 0.0);
        invViewTx.transform(vec3d, vec3d);
        vec3d2.sub(vec3d);
        return pickRay;
    }

    @Override
    public void setFieldOfView(float f) {
        this.fov = Math.toRadians(f);
    }
}

