/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.Media;
import com.sun.media.jfxmedia.MediaError;
import com.sun.media.jfxmedia.MediaException;
import com.sun.media.jfxmedia.MediaPlayer;
import com.sun.media.jfxmedia.events.MediaErrorListener;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.MediaDisposer;
import com.sun.media.jfxmediaimpl.MediaUtils;
import com.sun.media.jfxmediaimpl.NativeLibLoader;
import com.sun.media.jfxmediaimpl.NativeMedia;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeMediaManager {
    private static NativeMediaManager theInstance = null;
    private List<WeakReference<MediaErrorListener>> errorListeners = new ArrayList<WeakReference<MediaErrorListener>>();
    private static NativeMediaPlayerDisposer playerDisposer = new NativeMediaPlayerDisposer();
    private static List<WeakReference<MediaPlayer>> allMediaPlayers = new Vector<WeakReference<MediaPlayer>>();

    public static synchronized NativeMediaManager getDefaultInstance() {
        if (theInstance == null) {
            theInstance = new NativeMediaManager();
        }
        return theInstance;
    }

    private static native int nativeInitNativeMediaManager();

    private static native boolean nativeCanPlayContentType(String var0);

    private static native String[] nativeGetSupportedContentTypes();

    protected NativeMediaManager() {
        AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    NativeLibLoader.loadLibrary("glib-lite");
                    NativeLibLoader.loadLibrary("gstreamer-lite");
                    NativeLibLoader.loadLibrary("jfxmedia");
                }
                catch (UnsatisfiedLinkError e) {
                    NativeLibLoader.loadLibrary("jfxmedia");
                }
                return Boolean.TRUE;
            }
        });
        Logger.initNative();
        MediaError ret = MediaError.getFromCode(NativeMediaManager.nativeInitNativeMediaManager());
        if (ret != MediaError.ERROR_NONE) {
            MediaUtils.nativeError(NativeMediaManager.class, ret);
        }
    }

    public boolean canPlayContentType(String contentType) {
        return NativeMediaManager.nativeCanPlayContentType(contentType);
    }

    public String[] getSupportedContentTypes() {
        return NativeMediaManager.nativeGetSupportedContentTypes();
    }

    public MediaPlayer getPlayer(Locator locator) {
        NativeMediaPlayer player = new NativeMediaPlayer(locator, true);
        if (player == null) {
            throw new MediaException("Could not create player!");
        }
        player.init();
        final WeakReference<NativeMediaPlayer> refPlayer = new WeakReference<NativeMediaPlayer>(player);
        allMediaPlayers.add(refPlayer);
        player.setOnDispose(new Runnable(){

            public void run() {
                allMediaPlayers.remove(refPlayer);
            }
        });
        return player;
    }

    public Media getMedia(Locator locator, boolean permitFullScan) {
        return new NativeMedia(locator, null, true);
    }

    public void addMediaErrorListener(MediaErrorListener listener) {
        if (listener != null) {
            this.errorListeners.add(new WeakReference<MediaErrorListener>(listener));
        }
    }

    public void removeMediaErrorListener(MediaErrorListener listener) {
        if (listener != null) {
            ListIterator<WeakReference<MediaErrorListener>> it = this.errorListeners.listIterator();
            while (it.hasNext()) {
                MediaErrorListener l = (MediaErrorListener)it.next().get();
                if (l != null && l != listener) continue;
                it.remove();
            }
        }
    }

    public static void registerMediaPlayerForDispose(Object obj, MediaPlayer player) {
        MediaDisposer.addResourceDisposer(obj, player, playerDisposer);
    }

    public List<MediaPlayer> getAllMediaPlayers() {
        ArrayList<MediaPlayer> allPlayers = null;
        if (!allMediaPlayers.isEmpty()) {
            allPlayers = new ArrayList<MediaPlayer>();
            Iterator<WeakReference<MediaPlayer>> refIter = allMediaPlayers.iterator();
            while (refIter.hasNext()) {
                WeakReference<MediaPlayer> refPlayer = refIter.next();
                MediaPlayer player = (MediaPlayer)refPlayer.get();
                if (player != null) {
                    allPlayers.add(player);
                    continue;
                }
                refIter.remove();
            }
        }
        return allPlayers == null || allPlayers.isEmpty() ? null : allPlayers;
    }

    List<WeakReference<MediaErrorListener>> getMediaErrorListeners() {
        return this.errorListeners;
    }

    private static class NativeMediaPlayerDisposer
    implements MediaDisposer.ResourceDisposer {
        private NativeMediaPlayerDisposer() {
        }

        public void disposeResource(Object resource) {
            MediaPlayer player = (MediaPlayer)resource;
            if (player != null) {
                player.dispose();
            }
        }
    }
}

