/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Pen;
import com.sun.glass.ui.View;
import com.sun.javafx.geom.CameraImpl;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.PaintRenderJob;
import com.sun.javafx.tk.quantum.PaintRunnable;
import com.sun.javafx.tk.quantum.QuantumRenderer;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.javafx.tk.quantum.WindowStage;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.camera.PrismCameraImpl;
import com.sun.prism.camera.PrismParallelCameraImpl;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;
import com.sun.prism.render.ToolkitInterface;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.stage.StageStyle;

public final class PrismPen
extends Pen {
    private static PrismCameraImpl DEFAULT_CAMERA = PrismParallelCameraImpl.getInstance();
    Future paintRunnableFuture;
    boolean valid;
    Paint fillPaint;
    PrismCameraImpl camera;
    ViewScene scene;
    HashMap caps = new HashMap();
    AtomicBoolean painting;
    private PaintRunnable paintRunnable;
    protected PaintRenderJob paintRenderJob;
    private boolean depthBuffer;

    public PrismPen(ViewScene viewScene, boolean bl) {
        this.scene = viewScene;
        this.valid = false;
        this.depthBuffer = bl;
        this.setFillPaint(Color.WHITE);
        this.setPaintRunnable(new PaintRunnable(viewScene, this));
        this.painting = new AtomicBoolean(false);
    }

    boolean getDepthBuffer() {
        return this.depthBuffer;
    }

    public void setRoot(NGNode nGNode) {
        this.paintRunnable.setRoot(nGNode);
    }

    public NGNode getRoot() {
        return this.paintRunnable.getRoot();
    }

    @Override
    public Map getCapabilities() {
        GraphicsPipeline graphicsPipeline;
        Boolean bl = Boolean.TRUE;
        if (PrismSettings.isMac && (graphicsPipeline = GraphicsPipeline.getPipeline()) != null && graphicsPipeline.getClass().getName().endsWith("J2DPipeline")) {
            bl = Boolean.FALSE;
        }
        this.addCapability(this.caps, View.Capability.k3dKey, bl);
        this.addCapability(this.caps, View.Capability.k3dDepthKey, new Integer(this.depthBuffer ? 16 : 0));
        return this.caps;
    }

    public void repaint() {
        View view = this.scene.getPlatformView();
        if (view == null) {
            return;
        }
        if (!this.painting.getAndSet(true)) {
            Toolkit toolkit = Toolkit.getToolkit();
            ToolkitInterface toolkitInterface = (ToolkitInterface)((Object)toolkit);
            this.paintRunnableFuture = toolkitInterface.addRenderJob(this.paintRenderJob);
        }
    }

    protected Future getFuture() {
        return this.paintRunnableFuture;
    }

    protected PaintRunnable getPaintRunnable() {
        return this.paintRunnable;
    }

    protected void setPaintRunnable(PaintRunnable paintRunnable) {
        this.paintRunnable = paintRunnable;
        this.paintRenderJob = new PaintRenderJob(this.scene, this.paintRunnable);
        this.paintRenderJob.setCompletionListener(QuantumRenderer.getToolkit());
    }

    protected AtomicBoolean getPainting() {
        return this.painting;
    }

    protected Color getClearColor() {
        WindowStage windowStage;
        WindowStage windowStage2 = windowStage = this.scene != null ? this.scene.getWindowStage() : null;
        if (windowStage != null && windowStage.getStyle() == StageStyle.TRANSPARENT) {
            return Color.TRANSPARENT;
        }
        if (this.fillPaint == null) {
            return Color.WHITE;
        }
        if (this.fillPaint.isOpaque()) {
            if (this.fillPaint.getType() == Paint.Type.COLOR) {
                return (Color)this.fillPaint;
            }
            if (this.depthBuffer) {
                return Color.TRANSPARENT;
            }
            return null;
        }
        return Color.WHITE;
    }

    protected Paint getCurrentPaint() {
        WindowStage windowStage;
        WindowStage windowStage2 = windowStage = this.scene != null ? this.scene.getWindowStage() : null;
        if (windowStage != null && windowStage.getStyle() == StageStyle.TRANSPARENT) {
            return Color.TRANSPARENT.equals(this.fillPaint) ? null : this.fillPaint;
        }
        if (this.fillPaint == null) {
            return null;
        }
        if (this.fillPaint.isOpaque()) {
            if (this.fillPaint.getType() == Paint.Type.COLOR) {
                return null;
            }
            return this.fillPaint;
        }
        return this.fillPaint;
    }

    @Override
    public void paint(long l, int n, int n2) {
    }

    void setCamera(CameraImpl cameraImpl) {
        this.camera = cameraImpl != null ? (PrismCameraImpl)cameraImpl : DEFAULT_CAMERA;
    }

    protected CameraImpl getCamera() {
        return this.camera;
    }

    void setFillPaint(Object object) {
        this.fillPaint = (Paint)object;
    }

    Paint getFillPaint() {
        return this.fillPaint;
    }
}

