/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Screen;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.embed.AbstractEvents;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.sg.DirtyRegionContainer;
import com.sun.javafx.sg.DirtyRegionPool;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.PaintRenderJob;
import com.sun.javafx.tk.quantum.QuantumRenderer;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.RTTexture;
import com.sun.prism.RenderingContext;
import com.sun.prism.ResourceFactory;
import com.sun.prism.camera.PrismPerspectiveCameraImpl;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.Color;
import com.sun.prism.render.ToolkitInterface;
import java.nio.IntBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.event.EventType;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;

public class EmbeddedScene
extends GlassScene
implements EmbeddedSceneInterface {
    private HostInterface host;
    private int width;
    private int height;
    private boolean needsReset = true;
    private RTTexture texture;
    private IntBuffer textureBits;
    private Lock sizeLock = new ReentrantLock();
    private Runnable paintRunnable;
    private PaintRenderJob paintRenderJob;
    private GeneralTransform3D projTx;
    private DirtyRegionPool pool;
    private Affine3D tx;
    private DirtyRegionContainer dirtyRegionContainer;
    private Rectangle dirtyRect;

    public EmbeddedScene(HostInterface hostInterface) {
        this(hostInterface, false);
    }

    public EmbeddedScene(HostInterface hostInterface, boolean bl) {
        super(PrismSettings.verbose, bl);
        this.host = hostInterface;
        this.host.setEmbeddedScene(this);
        this.paintRunnable = new PaintRunnable();
        this.paintRenderJob = new PaintRenderJob(this, this.paintRunnable);
        this.paintRenderJob.setCompletionListener(QuantumRenderer.getToolkit());
        this.projTx = new GeneralTransform3D();
        this.tx = new Affine3D();
        this.pool = new DirtyRegionPool(PrismSettings.dirtyRegionCount);
        this.dirtyRegionContainer = this.pool.checkOut();
        this.dirtyRect = new Rectangle();
    }

    @Override
    public void markDirty() {
        super.markDirty();
        this.host.repaint();
    }

    @Override
    public void enableInputMethodEvents(boolean bl) {
        if (this.verbose) {
            System.err.println("EmbeddedScene.enableInputMethodEvents " + bl);
        }
    }

    @Override
    void stageVisible(boolean bl) {
        if (!bl) {
            this.host.setEmbeddedScene(null);
            this.host = null;
        }
        super.stageVisible(bl);
    }

    @Override
    public void repaint() {
        Toolkit toolkit = Toolkit.getToolkit();
        ToolkitInterface toolkitInterface = (ToolkitInterface)((Object)toolkit);
        toolkitInterface.addRenderJob(this.paintRenderJob);
    }

    @Override
    public boolean traverseOut(Direction direction) {
        if (direction == Direction.NEXT) {
            return this.host.traverseFocusOut(true);
        }
        if (direction == Direction.PREVIOUS) {
            return this.host.traverseFocusOut(false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSize(final int n, final int n2) {
        this.sizeLock.lock();
        try {
            this.width = n;
            this.height = n2;
            this.needsReset = true;
        }
        finally {
            this.sizeLock.unlock();
        }
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (EmbeddedScene.this.sceneListener != null) {
                    EmbeddedScene.this.sceneListener.changedSize(n, n2);
                }
            }
        });
        this.entireSceneNeedsRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getPixels(IntBuffer intBuffer, int n, int n2) {
        this.sizeLock.lock();
        try {
            if (this.textureBits == null || this.needsReset || this.width != n || this.height != n2) {
                boolean bl = false;
                return bl;
            }
            intBuffer.rewind();
            this.textureBits.rewind();
            intBuffer.put(this.textureBits);
            boolean bl = true;
            return bl;
        }
        finally {
            this.sizeLock.unlock();
        }
    }

    @Override
    public void mouseEvent(final int n, final int n2, final boolean bl, final boolean bl2, final boolean bl3, final int n3, final int n4, final int n5, final int n6, final int n7, final boolean bl4, final boolean bl5, final boolean bl6, final boolean bl7, final int n8, final boolean bl8) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (EmbeddedScene.this.sceneListener != null) {
                    EventType<? extends InputEvent> eventType = AbstractEvents.mouseIDToFXEventID(n);
                    if (eventType == ScrollEvent.SCROLL) {
                        EmbeddedScene.this.sceneListener.scrollEvent(0.0, -n8, 40.0, 40.0, 0, 0, 0, 0, n4, n5, n6, n7, bl4, bl5, bl6, bl7);
                        MouseEvent mouseEvent = MouseEvent.impl_mouseEvent(n4, n5, n6, n7, n8, AbstractEvents.mouseButtonToFXMouseButton(n2), n3, bl4, bl5, bl6, bl7, bl8, bl, bl2, bl3, MouseEvent.IMPL_MOUSE_WHEEL_ROTATED);
                        EmbeddedScene.this.sceneListener.mouseEvent(mouseEvent);
                    } else {
                        MouseEvent mouseEvent = MouseEvent.impl_mouseEvent(n4, n5, n6, n7, n8, AbstractEvents.mouseButtonToFXMouseButton(n2), n3, bl4, bl5, bl6, bl7, bl8, bl, bl2, bl3, eventType);
                        EmbeddedScene.this.sceneListener.mouseEvent(mouseEvent);
                    }
                }
            }
        });
    }

    @Override
    public void keyEvent(final int n, final int n2, final char[] cArray, final int n3) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (EmbeddedScene.this.sceneListener != null) {
                    String string = n == 2 ? new String(cArray) : Character.toString((char)n2);
                    String string2 = null;
                    boolean bl = (n3 & 1) != 0;
                    boolean bl2 = (n3 & 2) != 0;
                    boolean bl3 = (n3 & 4) != 0;
                    boolean bl4 = (n3 & 8) != 0;
                    KeyEvent keyEvent = KeyEvent.impl_keyEvent(null, string, string2, n2, bl, bl2, bl3, bl4, AbstractEvents.keyIDToFXEventType(n));
                    EmbeddedScene.this.sceneListener.keyEvent(keyEvent);
                }
            }
        });
    }

    @Override
    public void setCursor(Object object) {
        super.setCursor(object);
        this.host.setCursor((CursorFrame)object);
    }

    private class PaintRunnable
    implements Runnable {
        private PaintRunnable() {
        }

        private int setDirtyRect(Graphics graphics) {
            RectBounds rectBounds = new RectBounds(0.0f, 0.0f, EmbeddedScene.this.width, EmbeddedScene.this.height);
            RectBounds rectBounds2 = new RectBounds();
            EmbeddedScene.this.dirtyRegionContainer.reset();
            EmbeddedScene.this.projTx.setIdentity();
            EmbeddedScene.this.tx.setToIdentity();
            if (EmbeddedScene.this.camera instanceof PrismPerspectiveCameraImpl) {
                Affine3D affine3D = new Affine3D();
                affine3D.setToScale((double)EmbeddedScene.this.width / 2.0, (double)(-EmbeddedScene.this.height) / 2.0, 1.0);
                affine3D.translate(1.0, -1.0);
                EmbeddedScene.this.projTx.mul(affine3D);
                EmbeddedScene.this.projTx.mul(EmbeddedScene.this.camera.getProjViewTx(null, EmbeddedScene.this.width, EmbeddedScene.this.height, false));
            }
            int n = EmbeddedScene.this.root.accumulateDirtyRegions(rectBounds, rectBounds2, EmbeddedScene.this.pool, EmbeddedScene.this.dirtyRegionContainer, BaseTransform.IDENTITY_TRANSFORM, EmbeddedScene.this.projTx);
            return n;
        }

        private void paintImpl(Graphics graphics) {
            if (graphics != null) {
                int n;
                int n2 = 0;
                if (PrismSettings.dirtyOptsEnabled && !EmbeddedScene.this.isEntireSceneDirty() && (n2 = this.setDirtyRect(graphics)) == 1) {
                    EmbeddedScene.this.root.doPreCulling(EmbeddedScene.this.dirtyRegionContainer, EmbeddedScene.this.tx, EmbeddedScene.this.projTx);
                }
                if (PrismSettings.dirtyOptsEnabled && n2 == 1) {
                    for (n = 0; n < EmbeddedScene.this.dirtyRegionContainer.size(); ++n) {
                        EmbeddedScene.this.dirtyRect.setBounds(EmbeddedScene.this.dirtyRegionContainer.getDirtyRegion(n));
                        graphics.setClipRect(EmbeddedScene.this.dirtyRect);
                        graphics.setClipRectIndex(n);
                        this.doPaint(graphics);
                    }
                } else {
                    graphics.setClipRect(null);
                    this.doPaint(graphics);
                }
                if (PrismSettings.showDirtyRegions) {
                    if (PrismSettings.showCull) {
                        EmbeddedScene.this.root.drawCullBits(graphics);
                    }
                    graphics.setDepthTest(false);
                    if (n2 == 1) {
                        graphics.setPaint(new Color(1.0f, 0.0f, 0.0f, 0.3f));
                        for (n = 0; n < EmbeddedScene.this.dirtyRegionContainer.size(); ++n) {
                            RectBounds rectBounds = EmbeddedScene.this.dirtyRegionContainer.getDirtyRegion(n);
                            graphics.fillRect(rectBounds.getMinX(), rectBounds.getMinY(), rectBounds.getWidth(), rectBounds.getHeight());
                        }
                    } else {
                        graphics.setPaint(new Color(1.0f, 0.0f, 0.0f, 0.3f));
                        graphics.fillRect(0.0f, 0.0f, EmbeddedScene.this.width, EmbeddedScene.this.height);
                    }
                }
            }
        }

        private void doPaint(Graphics graphics) {
            EmbeddedScene.this.clearEntireSceneDirty();
            graphics.setDepthTest(EmbeddedScene.this.isDepthBuffer());
            graphics.clear(Color.TRANSPARENT);
            if (EmbeddedScene.this.fillPaint != null) {
                graphics.setPaint(EmbeddedScene.this.fillPaint);
                graphics.fillQuad(0.0f, 0.0f, EmbeddedScene.this.width, EmbeddedScene.this.height);
            }
            graphics.setCamera(EmbeddedScene.this.camera);
            EmbeddedScene.this.root.render(graphics, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Screen screen = Screen.getMainScreen();
            GraphicsPipeline graphicsPipeline = GraphicsPipeline.getPipeline();
            ResourceFactory resourceFactory = graphicsPipeline.getResourceFactory(screen);
            if (!resourceFactory.isDeviceReady()) {
                return;
            }
            RenderingContext renderingContext = resourceFactory.createRenderingContext(null);
            EmbeddedScene.this.sizeLock.lock();
            try {
                renderingContext.begin();
                if (EmbeddedScene.this.width <= 0 || EmbeddedScene.this.height <= 0) {
                    return;
                }
                if (EmbeddedScene.this.texture == null || EmbeddedScene.this.textureBits == null || EmbeddedScene.this.needsReset) {
                    EmbeddedScene.this.texture = resourceFactory.createRTTexture(EmbeddedScene.this.width, EmbeddedScene.this.height);
                    if (EmbeddedScene.this.texture == null) {
                        return;
                    }
                    EmbeddedScene.this.textureBits = IntBuffer.allocate(EmbeddedScene.this.width * EmbeddedScene.this.height);
                    if (EmbeddedScene.this.textureBits == null) {
                        return;
                    }
                    EmbeddedScene.this.needsReset = false;
                }
                Graphics graphics = null;
                try {
                    graphics = EmbeddedScene.this.texture.createGraphics();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                    renderingContext.end();
                    EmbeddedScene.this.sizeLock.unlock();
                    return;
                }
                this.paintImpl(graphics);
                EmbeddedScene.this.textureBits.rewind();
                EmbeddedScene.this.texture.readPixels(EmbeddedScene.this.textureBits);
                if (EmbeddedScene.this.host != null) {
                    EmbeddedScene.this.host.repaint();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
            }
            finally {
                renderingContext.end();
                EmbeddedScene.this.sizeLock.unlock();
            }
        }
    }
}

