/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.sg.PGImageView;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;

public class NGImageView
extends NGNode
implements PGImageView {
    private Image image;
    private Image[] tiles;
    private boolean smooth = true;
    private final RectBounds dimension = new RectBounds();
    private final RectBounds viewport = new RectBounds();

    public boolean isSmooth() {
        return this.smooth;
    }

    @Override
    public void setSmooth(boolean bl) {
        if (bl != this.smooth) {
            this.smooth = bl;
            this.visualsChanged();
        }
    }

    @Override
    public void setImage(Object object) {
        this.image = (Image)object;
        this.tiles = null;
        this.geometryChanged();
    }

    @Override
    public void setX(float f) {
        if (f != this.dimension.getMinX()) {
            float f2 = this.dimension.getWidth();
            this.dimension.setMinX(f);
            this.dimension.setMaxX(f + f2);
            this.geometryChanged();
        }
    }

    @Override
    public void setY(float f) {
        if (f != this.dimension.getMinY()) {
            float f2 = this.dimension.getHeight();
            this.dimension.setMinY(f);
            this.dimension.setMaxY(f + f2);
            this.geometryChanged();
        }
    }

    @Override
    public void setViewport(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        float f7 = this.image != null ? (float)this.image.getWidth() : 0.0f;
        float f8 = this.image != null ? (float)this.image.getHeight() : 0.0f;
        float f9 = f;
        float f10 = f2;
        if (f5 > 0.0f && f6 > 0.0f) {
            this.viewport.setBounds(f3, f4, f3 + f5, f4 + f6);
            f7 = f5;
            f8 = f6;
        } else {
            this.viewport.setBounds(0.0f, 0.0f, f7, f8);
        }
        if (f <= 0.0f && f2 <= 0.0f) {
            f9 = f7;
            f10 = f8;
        } else if (bl) {
            if ((double)f <= 0.0) {
                f9 = f7 * (f2 / f8);
                f10 = f2;
            } else if ((double)f2 <= 0.0) {
                f9 = f;
                f10 = f8 * (f / f7);
            } else {
                float f11 = Math.min(f / f7, f2 / f8);
                f9 = f7 * f11;
                f10 = f8 * f11;
            }
        } else if ((double)f2 <= 0.0) {
            f10 = f8;
        } else if ((double)f <= 0.0) {
            f9 = f7;
        }
        if (f10 < 1.0f) {
            f10 = 1.0f;
        }
        if (f9 < 1.0f) {
            f9 = 1.0f;
        }
        this.dimension.setMaxX(this.dimension.getMinX() + f9);
        this.dimension.setMaxY(this.dimension.getMinY() + f10);
        this.geometryChanged();
    }

    @Override
    protected void renderContent(Graphics graphics) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        if (this.image == null) {
            return;
        }
        float f6 = this.image.getWidth();
        float f7 = this.image.getHeight();
        boolean bl = !this.dimension.isEmpty();
        boolean bl2 = bl && (f6 != this.dimension.getWidth() || f7 != this.dimension.getHeight());
        graphics.translate(this.dimension.getMinX(), this.dimension.getMinY());
        if (bl2 && f6 != 0.0f && f7 != 0.0f) {
            f5 = this.dimension.getWidth() / f6;
            f4 = this.dimension.getHeight() / f7;
            graphics.scale(f5, f4);
        }
        f5 = 0.0f;
        f4 = 0.0f;
        float f8 = f6;
        float f9 = f7;
        float f10 = this.viewport.getMinX();
        float f11 = this.viewport.getMinY();
        float f12 = f10 + this.viewport.getWidth();
        float f13 = f11 + this.viewport.getHeight();
        float f14 = f8 - f5;
        if (f14 <= 0.0f || (f3 = f9 - f4) <= 0.0f || (f2 = f12 - f10) == 0.0f || (f = f13 - f11) == 0.0f) {
            return;
        }
        if (f12 > f6) {
            if (f10 > f6) {
                return;
            }
            f8 = f2 == f14 ? f5 + (f6 - f10) : f5 + (f6 - f10) * f14 / f2;
            f12 = f6;
        }
        if (f10 < 0.0f) {
            if (f12 < 0.0f) {
                return;
            }
            f5 = f2 == f14 ? (f5 -= f10) : (f5 += (0.0f - f10) * f14 / f2);
            f10 = 0.0f;
        }
        if (f13 > f7) {
            if (f11 > f7) {
                return;
            }
            f9 = f == f3 ? f4 + (f7 - f11) : f4 + (f7 - f11) * f3 / f;
            f13 = f7;
        }
        if (f11 < 0.0f) {
            if (f13 < 0.0f) {
                return;
            }
            f4 = f == f3 ? (f4 -= f11) : (f4 += (0.0f - f11) * f3 / f);
            f11 = 0.0f;
        }
        ResourceFactory resourceFactory = graphics.getResourceFactory();
        int n = resourceFactory.getMaximumTextureSize();
        int n2 = n - 4;
        int n3 = this.image.getWidth();
        int n4 = this.image.getHeight();
        if (n3 > n2 || n4 > n2) {
            float f15;
            int n5;
            int n6 = n3 / n2 + 1;
            int n7 = n4 / n2 + 1;
            int n8 = n6 * n7;
            if (this.tiles == null) {
                this.tiles = new Image[n8];
                int n9 = 0;
                int n10 = 0;
                while (n10 < n4) {
                    n5 = n;
                    if (n10 + n5 > n4) {
                        n5 = n4 - n10;
                    }
                    int n11 = 0;
                    while (n11 < n3) {
                        int n12 = n;
                        if (n11 + n12 > n3) {
                            n12 = n3 - n11;
                        }
                        this.tiles[n9++] = this.image.createSubImage(n11, n10, n12, n5);
                        if (n11 == 0) {
                            n11 += n2 - 2;
                            continue;
                        }
                        n11 += n2;
                    }
                    if (n10 == 0) {
                        n10 += n2 - 2;
                        continue;
                    }
                    n10 += n2;
                }
            }
            float f16 = f4;
            for (float f17 = f11; f17 < f7; f17 += f15) {
                float f18;
                float f19;
                n5 = (int)f17 / n2;
                f15 = n2;
                if (f17 == f11) {
                    f19 = f17 % (float)n2;
                    f15 = (float)n2 - f19;
                } else {
                    f19 = 0.0f;
                    f15 = n2;
                }
                if (f17 + f15 > f7) {
                    f15 = f7 - f17;
                }
                if (n5 > 0) {
                    f19 += 2.0f;
                }
                float f20 = f5;
                for (float f21 = f10; f21 < f6; f21 += f18) {
                    float f22;
                    int n13 = (int)f21 / n2;
                    f18 = n2;
                    if (f21 == f10) {
                        f22 = f21 % (float)n2;
                        f18 = (float)n2 - f22;
                    } else {
                        f22 = 0.0f;
                        f18 = n2;
                    }
                    if (f21 + f18 > f6) {
                        f18 = f6 - f21;
                    }
                    if (n13 > 0) {
                        f22 += 2.0f;
                    }
                    int n14 = n5 * n6 + n13;
                    Image image = this.tiles[n14];
                    Texture texture = resourceFactory.getCachedTexture(image, false);
                    graphics.drawTexture(texture, f20, f16, f20 + f18, f16 + f15, f22, f19, f22 + f18, f19 + f15);
                    f20 += f18;
                }
                f16 += f15;
            }
        } else {
            Texture texture = resourceFactory.getCachedTexture(this.image);
            graphics.drawTexture(texture, f5, f4, f8, f9, f10, f11, f12, f13);
        }
    }

    @Override
    protected boolean hasOverlappingContents() {
        return false;
    }
}

