/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.web.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.skin.LabeledSkinBase;
import com.sun.javafx.scene.control.skin.PopupControlSkin;
import com.sun.javafx.scene.web.skin.PopupButton;
import com.sun.javafx.scene.web.skin.PopupButtonBehavior;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.PopupControl;
import javafx.scene.layout.StackPane;

public class PopupButtonSkin
extends LabeledSkinBase<PopupButton, PopupButtonBehavior> {
    protected final StackPane arrow = new StackPane();
    protected final StackPane arrowButton;
    protected final PopupControl popup;

    public PopupButtonSkin(PopupButton popupButton) {
        super(popupButton, new PopupButtonBehavior(popupButton));
        this.arrow.getStyleClass().setAll((String[])new String[]{"arrow"});
        this.arrow.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.arrow.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.arrowButton = new StackPane();
        this.arrowButton.getStyleClass().setAll((String[])new String[]{"arrow-button"});
        this.arrowButton.getChildren().add(this.arrow);
        this.popup = new PopupControl();
        this.popup.setAutoHide(true);
        this.popup.setSkin(new PopupButtonPopupControlSkin());
        this.updatePopupButtonContent();
        this.updateChildren();
        this.registerChangeListener(popupButton.showingProperty(), "SHOWING");
        this.registerChangeListener(popupButton.focusedProperty(), "FOCUSED");
        this.registerChangeListener(popupButton.contentProperty(), "CONTENT");
        this.registerChangeListener(this.popup.showingProperty(), "POPUP_VISIBLE");
    }

    @Override
    protected void updateChildren() {
        super.updateChildren();
        this.getChildren().addAll((Node[])new Node[]{this.arrowButton});
    }

    private void updatePopupButtonContent() {
        ((PopupButtonPopupControlSkin)this.popup.getSkin()).root.getChildren().setAll((Node[])new Node[]{((PopupButton)this.getSkinnable()).getContent()});
    }

    private void show() {
        if (!this.popup.isShowing()) {
            Point2D point2D = Utils.pointRelativeTo((Node)((Object)this.getSkinnable()), this.popup.prefWidth(-1.0), this.popup.prefHeight(-1.0), HPos.CENTER, VPos.BOTTOM, 0.0, 0.0, true);
            this.popup.show(((PopupButton)this.getSkinnable()).getScene().getWindow(), point2D.getX(), point2D.getY());
        }
    }

    private void hide() {
        if (this.popup.isShowing()) {
            this.popup.hide();
        }
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "CONTENT") {
            this.updatePopupButtonContent();
        } else if (string == "SHOWING") {
            if (((PopupButton)this.getSkinnable()).isShowing()) {
                this.show();
            } else {
                this.hide();
            }
        } else if (string == "FOCUSED") {
            if (!((PopupButton)this.getSkinnable()).isFocused() && ((PopupButton)this.getSkinnable()).isShowing()) {
                this.hide();
            }
        } else if (string == "POPUP_VISIBLE" && !this.popup.isShowing() && ((PopupButton)this.getSkinnable()).isShowing()) {
            ((PopupButton)this.getSkinnable()).hide();
        }
    }

    @Override
    protected double computePrefWidth(double d) {
        Insets insets = this.arrowButton.getInsets();
        return super.computePrefWidth(d) + insets.getLeft() + this.arrow.prefWidth(-1.0) + insets.getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        Insets insets = this.getInsets();
        Insets insets2 = this.arrowButton.getInsets();
        return Math.max(super.computePrefHeight(d), insets.getTop() + insets2.getTop() + this.arrow.prefHeight(-1.0) + insets2.getBottom());
    }

    @Override
    protected void layoutChildren() {
        Insets insets = this.getInsets();
        Insets insets2 = this.arrowButton.getInsets();
        double d = this.arrow.prefWidth(-1.0);
        double d2 = insets2.getLeft() + d + insets2.getRight();
        double d3 = this.getWidth();
        double d4 = this.getHeight();
        this.layoutLabelInArea(0.0, 0.0, d3 - d2, d4);
        this.arrowButton.resize(d2, d4 - (insets.getTop() + insets.getBottom()));
        this.positionInArea(this.arrowButton, d3 - insets.getRight() - d2, insets.getTop(), d2, d4, 0.0, HPos.CENTER, VPos.CENTER);
    }

    private class PopupButtonPopupControlSkin
    extends PopupControlSkin<PopupControl> {
        StackPane root;

        private PopupButtonPopupControlSkin() {
        }

        @Override
        public Node getNode() {
            if (this.root == null) {
                this.root = new StackPane();
                this.root.getStyleClass().addAll((String[])new String[]{"context-menu", "popup-button-popup"});
            }
            return this.root;
        }

        @Override
        public PopupControl getSkinnable() {
            return PopupButtonSkin.this.popup;
        }
    }
}

