/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.web.skin;

import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.scene.traversal.TraversalEngine;
import com.sun.javafx.scene.traversal.TraverseListener;
import com.sun.javafx.scene.web.behavior.HTMLEditorBehavior;
import com.sun.javafx.scene.web.skin.ColorPicker;
import com.sun.javafx.scene.web.skin.PopupButton;
import com.sun.webpane.platform.WebPage;
import com.sun.webpane.platform.event.WCFocusEvent;
import com.sun.webpane.sg.Accessor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.web.HTMLEditor;
import javafx.scene.web.WebView;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;

public class HTMLEditorSkin
extends SkinBase<HTMLEditor, HTMLEditorBehavior>
implements TraverseListener {
    private GridPane gridPane;
    private ToolBar toolbar1;
    private ToolBar toolbar2;
    private Button cutButton;
    private Button copyButton;
    private Button pasteButton;
    private Button insertHorizontalRuleButton;
    private ToggleGroup alignmentToggleGroup;
    private ToggleButton alignLeftButton;
    private ToggleButton alignCenterButton;
    private ToggleButton alignRightButton;
    private ToggleButton alignJustifyButton;
    private ToggleButton bulletsButton;
    private ToggleButton numbersButton;
    private Button indentButton;
    private Button outdentButton;
    private ToggleGroup formatToggleGroup;
    private MenuButton formatMenuButton;
    private ToggleGroup fontFamilyToggleGroup;
    private MenuButton fontFamilyMenuButton;
    private ToggleGroup fontSizeToggleGroup;
    private MenuButton fontSizeMenuButton;
    private ToggleButton boldButton;
    private ToggleButton italicButton;
    private ToggleButton underlineButton;
    private ToggleButton strikethroughButton;
    private PopupButton fgColorButton;
    private PopupButton bgColorButton;
    private ColorPicker fgColorPicker;
    private ColorPicker bgColorPicker;
    private Rectangle fgColorRect;
    private Rectangle bgColorRect;
    private WebView webView;
    private WebPage webPage;
    public static final String CUT_COMMAND = "cut";
    public static final String COPY_COMMAND = "copy";
    public static final String PASTE_COMMAND = "paste";
    public static final String UNDO_COMMAND = "undo";
    public static final String REDO_COMMAND = "redo";
    public static final String INSERT_HORIZONTAL_RULE_COMMAND = "inserthorizontalrule";
    public static final String ALIGN_LEFT_COMMAND = "justifyleft";
    public static final String ALIGN_CENTER_COMMAND = "justifycenter";
    public static final String ALIGN_RIGHT_COMMAND = "justifyright";
    public static final String ALIGN_JUSTIFY_COMMAND = "justifyfull";
    public static final String BULLETS_COMMAND = "insertUnorderedList";
    public static final String NUMBERS_COMMAND = "insertOrderedList";
    public static final String INDENT_COMMAND = "indent";
    public static final String OUTDENT_COMMAND = "outdent";
    public static final String FORMAT_COMMAND = "formatblock";
    public static final String FONT_FAMILY_COMMAND = "fontname";
    public static final String FONT_SIZE_COMMAND = "fontsize";
    public static final String BOLD_COMMAND = "bold";
    public static final String ITALIC_COMMAND = "italic";
    public static final String UNDERLINE_COMMAND = "underline";
    public static final String STRIKETHROUGH_COMMAND = "strikethrough";
    public static final String FOREGROUND_COLOR_COMMAND = "forecolor";
    public static final String BACKGROUND_COLOR_COMMAND = "backcolor";
    private static final Color DEFAULT_BG_COLOR = Color.WHITE;
    private static final Color DEFAULT_FG_COLOR = Color.BLACK;
    private static final String FORMAT_PARAGRAPH = "<p>";
    private static final String FORMAT_HEADING_1 = "<h1>";
    private static final String FORMAT_HEADING_2 = "<h2>";
    private static final String FORMAT_HEADING_3 = "<h3>";
    private static final String FORMAT_HEADING_4 = "<h4>";
    private static final String FORMAT_HEADING_5 = "<h5>";
    private static final String FORMAT_HEADING_6 = "<h6>";
    private static final String SIZE_XX_SMALL = "1";
    private static final String SIZE_X_SMALL = "2";
    private static final String SIZE_SMALL = "3";
    private static final String SIZE_MEDIUM = "4";
    private static final String SIZE_LARGE = "5";
    private static final String SIZE_X_LARGE = "6";
    private static final String SIZE_XX_LARGE = "7";
    private static final String INSERT_NEW_LINE_COMMAND = "insertnewline";
    private static final String INSERT_TAB_COMMAND = "inserttab";
    private static final String[][] DEFAULT_FORMAT_MAPPINGS = new String[][]{{"<p>", "", "3"}, {"<h1>", "bold", "6"}, {"<h2>", "bold", "5"}, {"<h3>", "bold", "4"}, {"<h4>", "bold", "3"}, {"<h5>", "bold", "2"}, {"<h6>", "bold", "1"}};
    private static final String[] DEFAULT_WINDOWS_7_MAPPINGS = new String[]{"Windows 7", "Segoe UI", "12px", "", "120"};
    private static final String[][] DEFAULT_OS_MAPPINGS = new String[][]{{"Windows XP", "Tahoma", "12px", "", "96"}, {"Windows Vista", "Segoe UI", "12px", "", "96"}, DEFAULT_WINDOWS_7_MAPPINGS, {"Mac OS X", "Lucida Grande", "12px", "", "72"}};
    private static final String DEFAULT_OS_FONT = HTMLEditorSkin.getOSMappings()[1];
    private TraversalEngine engine;
    private boolean resetToolbarState = false;
    private boolean formatChanged = false;
    private String cachedHTMLText = "<html><body></body></html>";
    private static final int FORMAT_MENUBUTTON_WIDTH = 80;
    private static final int FONT_FAMILY_MENUBUTTON_WIDTH = 87;
    private static final int FONT_SIZE_MENUBUTTON_WIDTH = 72;

    private static String[] getOSMappings() {
        String string = System.getProperty("os.name");
        for (int i = 0; i < DEFAULT_OS_MAPPINGS.length; ++i) {
            if (!string.equals(DEFAULT_OS_MAPPINGS[i][0])) continue;
            return DEFAULT_OS_MAPPINGS[i];
        }
        return DEFAULT_WINDOWS_7_MAPPINGS;
    }

    public HTMLEditorSkin(HTMLEditor hTMLEditor) {
        super(hTMLEditor, new HTMLEditorBehavior(hTMLEditor));
        this.getChildren().clear();
        this.gridPane = new GridPane();
        this.gridPane.getStyleClass().add("html-editor");
        this.getChildren().addAll((Node[])new Node[]{this.gridPane});
        this.toolbar1 = new ToolBar();
        this.toolbar1.getStyleClass().add("top-toolbar");
        this.gridPane.add(this.toolbar1, 0, 0);
        this.toolbar2 = new ToolBar();
        this.toolbar2.getStyleClass().add("bottom-toolbar");
        this.gridPane.add(this.toolbar2, 0, 1);
        this.populateToolbars();
        this.webView = new WebView();
        this.gridPane.add(this.webView, 0, 2);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setHgrow(Priority.ALWAYS);
        this.gridPane.getColumnConstraints().add(columnConstraints);
        this.webPage = Accessor.getPageFor(this.webView.getEngine());
        this.webView.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                Platform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        if (HTMLEditorSkin.this.webPage.getClientSelectedText().isEmpty()) {
                            HTMLEditorSkin.this.updateToolbarState(true);
                        }
                    }
                });
            }
        });
        this.webView.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                Platform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        if (HTMLEditorSkin.this.webPage.getClientSelectedText().isEmpty()) {
                            HTMLEditorSkin.this.updateToolbarState(true);
                        }
                    }
                });
            }
        });
        this.webView.addEventHandler(KeyEvent.KEY_PRESSED, new EventHandler<KeyEvent>(){

            @Override
            public void handle(final KeyEvent keyEvent) {
                HTMLEditorSkin.this.applyTextFormatting();
                if (keyEvent.getCode() == KeyCode.CONTROL || keyEvent.getCode() == KeyCode.META) {
                    return;
                }
                if (keyEvent.getCode() == KeyCode.TAB && !keyEvent.isControlDown()) {
                    HTMLEditorSkin.this.webPage.executeEditorCommand(HTMLEditorSkin.INSERT_TAB_COMMAND);
                    return;
                }
                if (HTMLEditorSkin.this.fgColorButton != null && HTMLEditorSkin.this.fgColorButton.isShowing() || HTMLEditorSkin.this.bgColorButton != null && HTMLEditorSkin.this.bgColorButton.isShowing()) {
                    return;
                }
                Platform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        if (HTMLEditorSkin.this.webPage.getClientSelectedText().isEmpty()) {
                            if (keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN || keyEvent.getCode() == KeyCode.LEFT || keyEvent.getCode() == KeyCode.RIGHT || keyEvent.getCode() == KeyCode.HOME || keyEvent.getCode() == KeyCode.END) {
                                HTMLEditorSkin.this.updateToolbarState(true);
                            } else if (keyEvent.isControlDown() || keyEvent.isMetaDown()) {
                                if (keyEvent.getCode() == KeyCode.B) {
                                    HTMLEditorSkin.this.keyboardShortcuts(HTMLEditorSkin.BOLD_COMMAND);
                                } else if (keyEvent.getCode() == KeyCode.I) {
                                    HTMLEditorSkin.this.keyboardShortcuts(HTMLEditorSkin.ITALIC_COMMAND);
                                } else if (keyEvent.getCode() == KeyCode.U) {
                                    HTMLEditorSkin.this.keyboardShortcuts(HTMLEditorSkin.UNDERLINE_COMMAND);
                                }
                                HTMLEditorSkin.this.updateToolbarState(true);
                            } else {
                                HTMLEditorSkin.this.resetToolbarState = keyEvent.getCode() == KeyCode.ENTER;
                                if (HTMLEditorSkin.this.resetToolbarState) {
                                    HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.BOLD_COMMAND, HTMLEditorSkin.this.boldButton.selectedProperty().getValue().toString());
                                }
                                HTMLEditorSkin.this.updateToolbarState(false);
                            }
                            HTMLEditorSkin.this.resetToolbarState = false;
                        }
                    }
                });
            }
        });
        this.webView.addEventHandler(KeyEvent.KEY_RELEASED, new EventHandler<KeyEvent>(){

            @Override
            public void handle(final KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.CONTROL || keyEvent.getCode() == KeyCode.META) {
                    return;
                }
                if (HTMLEditorSkin.this.fgColorButton != null && HTMLEditorSkin.this.fgColorButton.isShowing() || HTMLEditorSkin.this.bgColorButton != null && HTMLEditorSkin.this.bgColorButton.isShowing()) {
                    return;
                }
                Platform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        if (HTMLEditorSkin.this.webPage.getClientSelectedText().isEmpty()) {
                            if (keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN || keyEvent.getCode() == KeyCode.LEFT || keyEvent.getCode() == KeyCode.RIGHT || keyEvent.getCode() == KeyCode.HOME || keyEvent.getCode() == KeyCode.END) {
                                HTMLEditorSkin.this.updateToolbarState(true);
                            } else if (keyEvent.isControlDown() || keyEvent.isMetaDown()) {
                                if (keyEvent.getCode() == KeyCode.B) {
                                    HTMLEditorSkin.this.keyboardShortcuts(HTMLEditorSkin.BOLD_COMMAND);
                                } else if (keyEvent.getCode() == KeyCode.I) {
                                    HTMLEditorSkin.this.keyboardShortcuts(HTMLEditorSkin.ITALIC_COMMAND);
                                } else if (keyEvent.getCode() == KeyCode.U) {
                                    HTMLEditorSkin.this.keyboardShortcuts(HTMLEditorSkin.UNDERLINE_COMMAND);
                                }
                                HTMLEditorSkin.this.updateToolbarState(true);
                            } else {
                                HTMLEditorSkin.this.resetToolbarState = keyEvent.getCode() == KeyCode.ENTER;
                                if (!HTMLEditorSkin.this.resetToolbarState) {
                                    HTMLEditorSkin.this.updateToolbarState(false);
                                }
                            }
                            HTMLEditorSkin.this.resetToolbarState = false;
                        }
                    }
                });
            }
        });
        ((HTMLEditor)this.getSkinnable()).focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, final Boolean bl2) {
                Platform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        if (bl2.booleanValue()) {
                            HTMLEditorSkin.this.webView.requestFocus();
                        }
                    }
                });
            }
        });
        this.webView.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (bl2.booleanValue()) {
                    HTMLEditorSkin.this.webPage.dispatchFocusEvent(new WCFocusEvent(2, 0));
                    HTMLEditorSkin.this.enableToolbar(true);
                } else {
                    HTMLEditorSkin.this.webPage.dispatchFocusEvent(new WCFocusEvent(3, 0));
                    HTMLEditorSkin.this.enableToolbar(false);
                }
            }
        });
        this.webView.getEngine().getLoadWorker().workDoneProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                Platform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        HTMLEditorSkin.this.webView.requestLayout();
                    }
                });
                double d = HTMLEditorSkin.this.webView.getEngine().getLoadWorker().getTotalWork();
                if (number2.doubleValue() == d) {
                    HTMLEditorSkin.this.cachedHTMLText = null;
                    Platform.runLater(new Runnable(){

                        @Override
                        public void run() {
                            HTMLEditorSkin.this.setContentEditable(true);
                            HTMLEditorSkin.this.updateToolbarState(true);
                        }
                    });
                }
            }
        });
        this.enableToolbar(true);
        this.setHTMLText(this.cachedHTMLText);
        this.engine = new TraversalEngine(this, false);
        this.engine.addTraverseListener(this);
        this.engine.reg(this.toolbar1);
        this.setImpl_traversalEngine(this.engine);
        this.webView.setFocusTraversable(true);
    }

    public final String getHTMLText() {
        return this.cachedHTMLText != null ? this.cachedHTMLText : this.webPage.getHtml(this.webPage.getMainFrame());
    }

    public final void setHTMLText(String string) {
        this.cachedHTMLText = string;
        this.webPage.load(this.webPage.getMainFrame(), string, "text/html");
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                HTMLEditorSkin.this.updateToolbarState(true);
            }
        });
    }

    private void populateToolbars() {
        Object object;
        final ResourceBundle resourceBundle = ResourceBundle.getBundle(this.getClass().getName());
        this.cutButton = this.addButton(this.toolbar1, resourceBundle.getString("cutIcon"), resourceBundle.getString(CUT_COMMAND), CUT_COMMAND);
        this.copyButton = this.addButton(this.toolbar1, resourceBundle.getString("copyIcon"), resourceBundle.getString(COPY_COMMAND), COPY_COMMAND);
        this.pasteButton = this.addButton(this.toolbar1, resourceBundle.getString("pasteIcon"), resourceBundle.getString(PASTE_COMMAND), PASTE_COMMAND);
        this.toolbar1.getItems().add(new Separator());
        this.alignmentToggleGroup = new ToggleGroup();
        this.alignLeftButton = this.addToggleButton(this.toolbar1, this.alignmentToggleGroup, resourceBundle.getString("alignLeftIcon"), resourceBundle.getString("alignLeft"), ALIGN_LEFT_COMMAND);
        this.alignCenterButton = this.addToggleButton(this.toolbar1, this.alignmentToggleGroup, resourceBundle.getString("alignCenterIcon"), resourceBundle.getString("alignCenter"), ALIGN_CENTER_COMMAND);
        this.alignRightButton = this.addToggleButton(this.toolbar1, this.alignmentToggleGroup, resourceBundle.getString("alignRightIcon"), resourceBundle.getString("alignRight"), ALIGN_RIGHT_COMMAND);
        this.alignJustifyButton = this.addToggleButton(this.toolbar1, this.alignmentToggleGroup, resourceBundle.getString("alignJustifyIcon"), resourceBundle.getString("alignJustify"), ALIGN_JUSTIFY_COMMAND);
        this.toolbar1.getItems().add(new Separator());
        this.outdentButton = this.addButton(this.toolbar1, resourceBundle.getString("outdentIcon"), resourceBundle.getString(OUTDENT_COMMAND), OUTDENT_COMMAND);
        this.indentButton = this.addButton(this.toolbar1, resourceBundle.getString("indentIcon"), resourceBundle.getString(INDENT_COMMAND), INDENT_COMMAND);
        this.toolbar1.getItems().add(new Separator());
        ToggleGroup toggleGroup = new ToggleGroup();
        this.bulletsButton = this.addToggleButton(this.toolbar1, toggleGroup, resourceBundle.getString("bulletsIcon"), resourceBundle.getString("bullets"), BULLETS_COMMAND);
        this.numbersButton = this.addToggleButton(this.toolbar1, toggleGroup, resourceBundle.getString("numbersIcon"), resourceBundle.getString("numbers"), NUMBERS_COMMAND);
        this.toolbar1.getItems().add(new Separator());
        this.formatToggleGroup = new ToggleGroup();
        this.formatMenuButton = new MenuButton();
        this.formatMenuButton.getStyleClass().add("font-menu-button");
        this.formatMenuButton.setMinWidth(80.0);
        this.formatMenuButton.setPrefWidth(80.0);
        this.formatMenuButton.setMaxWidth(80.0);
        this.formatMenuButton.setFocusTraversable(false);
        this.toolbar2.getItems().add(this.formatMenuButton);
        ObservableList<MenuItem> observableList = this.formatMenuButton.getItems();
        final RadioMenuItem radioMenuItem = this.createFormatMenuItem(FORMAT_PARAGRAPH, resourceBundle.getString("paragraph"));
        observableList.add(radioMenuItem);
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                ((RadioMenuItem)radioMenuItem).setSelected(true);
            }
        });
        observableList.add(this.createFormatMenuItem(FORMAT_HEADING_1, resourceBundle.getString("heading1")));
        observableList.add(this.createFormatMenuItem(FORMAT_HEADING_2, resourceBundle.getString("heading2")));
        observableList.add(this.createFormatMenuItem(FORMAT_HEADING_3, resourceBundle.getString("heading3")));
        observableList.add(this.createFormatMenuItem(FORMAT_HEADING_4, resourceBundle.getString("heading4")));
        observableList.add(this.createFormatMenuItem(FORMAT_HEADING_5, resourceBundle.getString("heading5")));
        observableList.add(this.createFormatMenuItem(FORMAT_HEADING_6, resourceBundle.getString("heading6")));
        this.formatMenuButton.setTooltip(new Tooltip(resourceBundle.getString("format")));
        this.formatToggleGroup.selectedToggleProperty().addListener(new ChangeListener<Toggle>(){

            @Override
            public synchronized void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle toggle2) {
                if (toggle2 == null) {
                    HTMLEditorSkin.this.formatMenuButton.setText(null);
                } else {
                    HTMLEditorSkin.this.formatChanged = true;
                    HTMLEditorSkin.this.formatMenuButton.setText(((RadioMenuItem)toggle2).getText());
                    String string = (String)toggle2.getProperties().get("formatValue");
                    HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.FORMAT_COMMAND, string);
                    HTMLEditorSkin.this.updateToolbarState(false);
                    for (int i = 0; i < DEFAULT_FORMAT_MAPPINGS.length; ++i) {
                        String[] stringArray = DEFAULT_FORMAT_MAPPINGS[i];
                        if (!stringArray[0].equalsIgnoreCase(string)) continue;
                        HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.FONT_SIZE_COMMAND, stringArray[2]);
                        HTMLEditorSkin.this.updateToolbarState(false);
                        break;
                    }
                }
            }
        });
        this.fontFamilyToggleGroup = new ToggleGroup();
        this.fontFamilyMenuButton = new MenuButton();
        this.fontFamilyMenuButton.getStyleClass().add("font-menu-button");
        this.fontFamilyMenuButton.setMinWidth(87.0);
        this.fontFamilyMenuButton.setPrefWidth(87.0);
        this.fontFamilyMenuButton.setMaxWidth(87.0);
        this.fontFamilyMenuButton.setFocusTraversable(false);
        this.toolbar2.getItems().add(this.fontFamilyMenuButton);
        ObservableList<MenuItem> observableList2 = this.fontFamilyMenuButton.getItems();
        for (String object22 : Font.getFamilies()) {
            object = this.createFontFamilyMenuItem(object22);
            observableList2.add((MenuItem)object);
            if (!DEFAULT_OS_FONT.equals(object22)) continue;
            Platform.runLater(new Runnable((MenuItem)object){
                final /* synthetic */ MenuItem val$menuItem;
                {
                    this.val$menuItem = menuItem;
                }

                @Override
                public void run() {
                    ((RadioMenuItem)this.val$menuItem).setSelected(true);
                }
            });
        }
        this.fontFamilyMenuButton.setTooltip(new Tooltip(resourceBundle.getString("fontFamily")));
        this.fontFamilyToggleGroup.selectedToggleProperty().addListener(new ChangeListener<Toggle>(){

            @Override
            public void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle toggle2) {
                if (toggle2 == null) {
                    HTMLEditorSkin.this.fontFamilyMenuButton.setText(null);
                } else {
                    HTMLEditorSkin.this.fontFamilyMenuButton.setText(((RadioMenuItem)toggle2).getText());
                    String string = (String)toggle2.getProperties().get("fontFamilyValue");
                    HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.FONT_FAMILY_COMMAND, string);
                }
            }
        });
        this.fontSizeToggleGroup = new ToggleGroup();
        this.fontSizeMenuButton = new MenuButton();
        this.fontSizeMenuButton.getStyleClass().add("font-menu-button");
        this.fontSizeMenuButton.setMinWidth(72.0);
        this.fontSizeMenuButton.setPrefWidth(72.0);
        this.fontSizeMenuButton.setMaxWidth(72.0);
        this.fontSizeMenuButton.setFocusTraversable(false);
        this.toolbar2.getItems().add(this.fontSizeMenuButton);
        ObservableList<MenuItem> observableList3 = this.fontSizeMenuButton.getItems();
        observableList3.add(this.createFontSizeMenuItem(SIZE_XX_SMALL, resourceBundle.getString("extraExtraSmall")));
        observableList3.add(this.createFontSizeMenuItem(SIZE_X_SMALL, resourceBundle.getString("extraSmall")));
        final RadioMenuItem radioMenuItem2 = this.createFontSizeMenuItem(SIZE_SMALL, resourceBundle.getString("small"));
        observableList3.add(radioMenuItem2);
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                ((RadioMenuItem)radioMenuItem2).setSelected(true);
            }
        });
        observableList3.add(this.createFontSizeMenuItem(SIZE_MEDIUM, resourceBundle.getString("medium")));
        observableList3.add(this.createFontSizeMenuItem(SIZE_LARGE, resourceBundle.getString("large")));
        observableList3.add(this.createFontSizeMenuItem(SIZE_X_LARGE, resourceBundle.getString("extraLarge")));
        observableList3.add(this.createFontSizeMenuItem(SIZE_XX_LARGE, resourceBundle.getString("extraExtraLarge")));
        this.fontSizeMenuButton.setTooltip(new Tooltip(resourceBundle.getString("fontSize")));
        this.fontSizeToggleGroup.selectedToggleProperty().addListener(new ChangeListener<Toggle>(){

            @Override
            public void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle toggle2) {
                if (toggle2 == null) {
                    HTMLEditorSkin.this.fontSizeMenuButton.setText(null);
                } else {
                    HTMLEditorSkin.this.fontSizeMenuButton.setText(((RadioMenuItem)toggle2).getText());
                    if (HTMLEditorSkin.this.formatChanged) {
                        HTMLEditorSkin.this.formatChanged = false;
                        return;
                    }
                    String string = (String)toggle2.getProperties().get("fontSizeValue");
                    HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.FONT_SIZE_COMMAND, string);
                }
            }
        });
        this.toolbar2.getItems().add(new Separator());
        this.boldButton = this.addToggleButton(this.toolbar2, null, resourceBundle.getString("boldIcon"), resourceBundle.getString(BOLD_COMMAND), BOLD_COMMAND);
        this.boldButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                if (HTMLEditorSkin.FORMAT_PARAGRAPH.equals(((RadioMenuItem)HTMLEditorSkin.this.formatMenuButton.getItems().get(0)).getToggleGroup().getSelectedToggle().getProperties().get("formatValue"))) {
                    HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.BOLD_COMMAND, HTMLEditorSkin.this.boldButton.selectedProperty().getValue().toString());
                }
            }
        });
        this.italicButton = this.addToggleButton(this.toolbar2, null, resourceBundle.getString("italicIcon"), resourceBundle.getString(ITALIC_COMMAND), ITALIC_COMMAND);
        this.underlineButton = this.addToggleButton(this.toolbar2, null, resourceBundle.getString("underlineIcon"), resourceBundle.getString(UNDERLINE_COMMAND), UNDERLINE_COMMAND);
        this.strikethroughButton = this.addToggleButton(this.toolbar2, null, resourceBundle.getString("strikethroughIcon"), resourceBundle.getString(STRIKETHROUGH_COMMAND), STRIKETHROUGH_COMMAND);
        this.toolbar2.getItems().add(new Separator());
        this.insertHorizontalRuleButton = this.addButton(this.toolbar2, resourceBundle.getString("insertHorizontalRuleIcon"), resourceBundle.getString("insertHorizontalRule"), INSERT_HORIZONTAL_RULE_COMMAND);
        this.insertHorizontalRuleButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                HTMLEditorSkin.this.webPage.executeEditorCommand(HTMLEditorSkin.INSERT_NEW_LINE_COMMAND);
                HTMLEditorSkin.this.webPage.executeEditorCommand(HTMLEditorSkin.INSERT_HORIZONTAL_RULE_COMMAND);
                HTMLEditorSkin.this.updateToolbarState(false);
            }
        });
        this.fgColorButton = new PopupButton();
        this.fgColorButton.setFocusTraversable(false);
        this.toolbar1.getItems().add(this.fgColorButton);
        object = AccessController.doPrivileged(new PrivilegedAction<Image>(){

            @Override
            public Image run() {
                return new Image(HTMLEditorSkin.class.getResource(resourceBundle.getString("foregroundColorIcon")).toString());
            }
        });
        this.fgColorRect = new Rectangle(0.0, 10.0, 16.0, 5.0);
        Group group = new Group();
        group.getChildren().addAll((Node[])new Node[]{this.fgColorRect, new ImageView((Image)object)});
        this.fgColorButton.setGraphic(group);
        this.fgColorPicker = new ColorPicker();
        this.fgColorPicker.setColor(DEFAULT_FG_COLOR);
        this.fgColorButton.setContent(this.fgColorPicker);
        this.fgColorButton.setTooltip(new Tooltip(resourceBundle.getString("foregroundColor")));
        this.fgColorPicker.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                Color color = HTMLEditorSkin.this.fgColorPicker.getColor();
                if (color != null) {
                    HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.FOREGROUND_COLOR_COMMAND, ColorPicker.colorValueToHex(color));
                    HTMLEditorSkin.this.fgColorButton.hide();
                    HTMLEditorSkin.this.fgColorRect.setFill(color);
                }
            }
        });
        this.bgColorButton = new PopupButton();
        this.bgColorButton.setFocusTraversable(false);
        this.toolbar1.getItems().add(this.bgColorButton);
        Image image = AccessController.doPrivileged(new PrivilegedAction<Image>(){

            @Override
            public Image run() {
                return new Image(HTMLEditorSkin.class.getResource(resourceBundle.getString("backgroundColorIcon")).toString());
            }
        });
        this.bgColorRect = new Rectangle(0.0, 10.0, 16.0, 5.0);
        this.bgColorRect.setFill(DEFAULT_BG_COLOR);
        Group group2 = new Group();
        group2.getChildren().addAll((Node[])new Node[]{this.bgColorRect, new ImageView(image)});
        this.bgColorButton.setGraphic(group2);
        this.bgColorPicker = new ColorPicker();
        this.bgColorPicker.setColor(DEFAULT_BG_COLOR);
        this.bgColorButton.setContent(this.bgColorPicker);
        this.bgColorButton.setTooltip(new Tooltip(resourceBundle.getString("backgroundColor")));
        this.bgColorPicker.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                Color color = HTMLEditorSkin.this.bgColorPicker.getColor();
                if (color != null) {
                    HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.BACKGROUND_COLOR_COMMAND, ColorPicker.colorValueToHex(color));
                    HTMLEditorSkin.this.bgColorButton.hide();
                    HTMLEditorSkin.this.bgColorRect.setFill(color);
                }
            }
        });
    }

    private Button addButton(ToolBar toolBar, final String string, String string2, final String string3) {
        Button button = new Button();
        button.setFocusTraversable(false);
        toolBar.getItems().add(button);
        Image image = AccessController.doPrivileged(new PrivilegedAction<Image>(){

            @Override
            public Image run() {
                return new Image(HTMLEditorSkin.class.getResource(string).toString());
            }
        });
        button.setGraphic(new ImageView(image));
        button.setTooltip(new Tooltip(string2));
        button.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                HTMLEditorSkin.this.webPage.executeEditorCommand(string3);
                HTMLEditorSkin.this.updateToolbarState(false);
            }
        });
        return button;
    }

    private ToggleButton addToggleButton(ToolBar toolBar, ToggleGroup toggleGroup, final String string, String string2, final String string3) {
        ToggleButton toggleButton = new ToggleButton();
        toggleButton.setUserData(string3);
        toggleButton.setFocusTraversable(false);
        toolBar.getItems().add(toggleButton);
        toggleButton.setToggleGroup(toggleGroup);
        Image image = AccessController.doPrivileged(new PrivilegedAction<Image>(){

            @Override
            public Image run() {
                return new Image(HTMLEditorSkin.class.getResource(string).toString());
            }
        });
        toggleButton.setGraphic(new ImageView(image));
        toggleButton.setTooltip(new Tooltip(string2));
        if (!BOLD_COMMAND.equals(string3)) {
            toggleButton.selectedProperty().addListener(new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                    if (HTMLEditorSkin.this.getCommandState(string3) != bl2) {
                        HTMLEditorSkin.this.webPage.executeEditorCommand(string3);
                    }
                }
            });
        }
        return toggleButton;
    }

    private RadioMenuItem createFormatMenuItem(String string, String string2) {
        RadioMenuItem radioMenuItem = new RadioMenuItem(string2, null);
        radioMenuItem.setToggleGroup(this.formatToggleGroup);
        radioMenuItem.getProperties().put("formatValue", string);
        return radioMenuItem;
    }

    private RadioMenuItem createFontFamilyMenuItem(String string) {
        RadioMenuItem radioMenuItem = new RadioMenuItem(string, null);
        radioMenuItem.setToggleGroup(this.fontFamilyToggleGroup);
        radioMenuItem.getProperties().put("fontFamilyValue", string);
        return radioMenuItem;
    }

    private RadioMenuItem createFontSizeMenuItem(String string, String string2) {
        RadioMenuItem radioMenuItem = new RadioMenuItem(string2, null);
        radioMenuItem.setToggleGroup(this.fontSizeToggleGroup);
        radioMenuItem.getProperties().put("fontSizeValue", string);
        return radioMenuItem;
    }

    private void updateToolbarState(boolean bl) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        if (!this.webView.isFocused()) {
            return;
        }
        this.copyButton.setDisable(!this.isCommandEnabled(FORMAT_COMMAND));
        this.cutButton.setDisable(!this.isCommandEnabled(FORMAT_COMMAND));
        this.pasteButton.setDisable(!this.isCommandEnabled(FORMAT_COMMAND));
        this.insertHorizontalRuleButton.setDisable(!this.isCommandEnabled(INSERT_HORIZONTAL_RULE_COMMAND));
        if (bl) {
            this.alignLeftButton.setDisable(!this.isCommandEnabled(ALIGN_LEFT_COMMAND));
            this.alignLeftButton.setSelected(this.getCommandState(ALIGN_LEFT_COMMAND));
            this.alignCenterButton.setDisable(!this.isCommandEnabled(ALIGN_CENTER_COMMAND));
            this.alignCenterButton.setSelected(this.getCommandState(ALIGN_CENTER_COMMAND));
            this.alignRightButton.setDisable(!this.isCommandEnabled(ALIGN_RIGHT_COMMAND));
            this.alignRightButton.setSelected(this.getCommandState(ALIGN_RIGHT_COMMAND));
            this.alignJustifyButton.setDisable(!this.isCommandEnabled(ALIGN_JUSTIFY_COMMAND));
            this.alignJustifyButton.setSelected(this.getCommandState(ALIGN_JUSTIFY_COMMAND));
        } else if (this.alignmentToggleGroup.getSelectedToggle() != null) {
            object7 = this.alignmentToggleGroup.getSelectedToggle().getUserData().toString();
            this.webPage.executeEditorCommand((String)object7);
        }
        if (this.alignmentToggleGroup.getSelectedToggle() == null) {
            this.alignmentToggleGroup.selectToggle(this.alignLeftButton);
        }
        this.bulletsButton.setDisable(!this.isCommandEnabled(BULLETS_COMMAND));
        this.bulletsButton.setSelected(this.getCommandState(BULLETS_COMMAND));
        this.numbersButton.setDisable(!this.isCommandEnabled(NUMBERS_COMMAND));
        this.numbersButton.setSelected(this.getCommandState(NUMBERS_COMMAND));
        this.indentButton.setDisable(!this.isCommandEnabled(INDENT_COMMAND));
        this.outdentButton.setDisable(!this.isCommandEnabled(OUTDENT_COMMAND));
        this.formatMenuButton.setDisable(!this.isCommandEnabled(FORMAT_COMMAND));
        object7 = this.getCommandValue(FORMAT_COMMAND);
        if (object7 instanceof String) {
            object6 = "<" + object7 + ">";
            object5 = this.formatMenuButton.getItems();
            object4 = null;
            object3 = object5.iterator();
            while (object3.hasNext()) {
                object2 = (MenuItem)object3.next();
                object = (String)((RadioMenuItem)object2).getProperties().get("formatValue");
                if (!((String)object).equalsIgnoreCase((String)object6) && (!((String)object).equals(FORMAT_PARAGRAPH) || !this.resetToolbarState && !((String)object6).equals("<>") && !((String)object6).equalsIgnoreCase("<div>"))) continue;
                object4 = object2;
                break;
            }
            if (object4 != null) {
                ((RadioMenuItem)object4).setSelected(true);
            }
        }
        this.fontFamilyMenuButton.setDisable(!this.isCommandEnabled(FONT_FAMILY_COMMAND));
        object6 = this.getCommandValue(FONT_FAMILY_COMMAND);
        if (object6 instanceof String) {
            object5 = (String)object6;
            if (((String)object5).startsWith("'")) {
                object5 = ((String)object5).substring(1);
            }
            if (((String)object5).endsWith("'")) {
                object5 = ((String)object5).substring(0, ((String)object5).length() - 1);
            }
            object4 = this.fontFamilyMenuButton.getItems();
            object3 = null;
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = (MenuItem)object2.next();
                string = (String)((RadioMenuItem)object).getProperties().get("fontFamilyValue");
                if (string.equals(object5)) {
                    object3 = object;
                    break;
                }
                if (!string.equals(DEFAULT_OS_FONT) || !((String)object5).equals("Dialog")) continue;
                object3 = object;
                break;
            }
            if (object3 != null) {
                ((RadioMenuItem)object3).setSelected(true);
            }
        }
        this.fontSizeMenuButton.setDisable(!this.isCommandEnabled(FONT_SIZE_COMMAND));
        object5 = this.getCommandValue(FONT_SIZE_COMMAND);
        if (object5 instanceof String) {
            object4 = this.fontSizeMenuButton.getItems();
            object3 = null;
            for (int i = 0; i < object4.size(); ++i) {
                object = (RadioMenuItem)object4.get(i);
                string = (String)((MenuItem)object).getProperties().get("fontSizeValue");
                if ((!this.resetToolbarState || !string.equals(SIZE_SMALL)) && (this.resetToolbarState || !string.equals(object5))) continue;
                object3 = object;
                break;
            }
            if (object3 != null) {
                ((RadioMenuItem)object3).setSelected(true);
            }
        }
        this.boldButton.setDisable(!this.isCommandEnabled(BOLD_COMMAND));
        if (object7 instanceof String && !this.resetToolbarState && ("p".equals(object7) || "div".equals(object7))) {
            this.boldButton.setSelected(this.getCommandState(BOLD_COMMAND));
        }
        this.italicButton.setDisable(!this.isCommandEnabled(ITALIC_COMMAND));
        this.italicButton.setSelected(this.getCommandState(ITALIC_COMMAND));
        this.underlineButton.setDisable(!this.isCommandEnabled(UNDERLINE_COMMAND));
        this.underlineButton.setSelected(this.getCommandState(UNDERLINE_COMMAND));
        this.strikethroughButton.setDisable(!this.isCommandEnabled(STRIKETHROUGH_COMMAND));
        this.strikethroughButton.setSelected(this.getCommandState(STRIKETHROUGH_COMMAND));
        this.fgColorButton.setDisable(!this.isCommandEnabled(FOREGROUND_COLOR_COMMAND));
        object4 = this.getCommandValue(FOREGROUND_COLOR_COMMAND);
        if (object4 instanceof String) {
            object3 = Color.web(HTMLEditorSkin.rgbToHex((String)object4));
            this.fgColorPicker.setColor((Color)object3);
            this.fgColorRect.setFill((Paint)object3);
        }
        this.bgColorButton.setDisable(!this.isCommandEnabled(BACKGROUND_COLOR_COMMAND));
        object3 = this.getCommandValue(BACKGROUND_COLOR_COMMAND);
        if (object3 instanceof String) {
            Color color = Color.web(HTMLEditorSkin.rgbToHex((String)object3));
            this.bgColorPicker.setColor(color);
            this.bgColorRect.setFill(color);
        }
    }

    private void enableToolbar(final boolean bl) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                HTMLEditorSkin.this.copyButton.setDisable(!bl);
                HTMLEditorSkin.this.cutButton.setDisable(!bl);
                HTMLEditorSkin.this.pasteButton.setDisable(!bl);
                HTMLEditorSkin.this.insertHorizontalRuleButton.setDisable(!bl);
                HTMLEditorSkin.this.alignLeftButton.setDisable(!bl);
                HTMLEditorSkin.this.alignCenterButton.setDisable(!bl);
                HTMLEditorSkin.this.alignRightButton.setDisable(!bl);
                HTMLEditorSkin.this.alignJustifyButton.setDisable(!bl);
                HTMLEditorSkin.this.bulletsButton.setDisable(!bl);
                HTMLEditorSkin.this.numbersButton.setDisable(!bl);
                HTMLEditorSkin.this.indentButton.setDisable(!bl);
                HTMLEditorSkin.this.outdentButton.setDisable(!bl);
                HTMLEditorSkin.this.formatMenuButton.setDisable(!bl);
                HTMLEditorSkin.this.fontFamilyMenuButton.setDisable(!bl);
                HTMLEditorSkin.this.fontSizeMenuButton.setDisable(!bl);
                HTMLEditorSkin.this.boldButton.setDisable(!bl);
                HTMLEditorSkin.this.italicButton.setDisable(!bl);
                HTMLEditorSkin.this.underlineButton.setDisable(!bl);
                HTMLEditorSkin.this.strikethroughButton.setDisable(!bl);
                HTMLEditorSkin.this.fgColorButton.setDisable(!bl);
                HTMLEditorSkin.this.bgColorButton.setDisable(!bl);
            }
        });
    }

    private boolean executeCommand(String string, String string2) {
        Object object = this.webPage.executeScript(this.webPage.getMainFrame(), "document.execCommand(\"" + string + "\", false, " + "\"" + string2 + "\")");
        return Boolean.parseBoolean(object.toString());
    }

    private boolean isCommandEnabled(String string) {
        Object object = this.webPage.executeScript(this.webPage.getMainFrame(), "document.queryCommandEnabled(\"" + string + "\")");
        return Boolean.parseBoolean(object.toString());
    }

    private void setContentEditable(boolean bl) {
        HTMLDocument hTMLDocument = (HTMLDocument)this.webPage.getDocument(this.webPage.getMainFrame());
        HTMLElement hTMLElement = (HTMLElement)hTMLDocument.getDocumentElement();
        HTMLElement hTMLElement2 = (HTMLElement)hTMLElement.getElementsByTagName("body").item(0);
        hTMLElement2.setAttribute("contenteditable", Boolean.toString(bl));
    }

    private boolean getCommandState(String string) {
        Object object = this.webPage.executeScript(this.webPage.getMainFrame(), "document.queryCommandState(\"" + string + "\")");
        return Boolean.parseBoolean(object.toString());
    }

    private Object getCommandValue(String string) {
        Object object = this.webPage.executeScript(this.webPage.getMainFrame(), "document.queryCommandValue(\"" + string + "\")");
        return object;
    }

    private static String rgbToHex(String string) {
        if (string.startsWith("rgba")) {
            String[] stringArray = string.substring(string.indexOf(40) + 1, string.lastIndexOf(41)).split(",");
            string = String.format("#%02X%02X%02X%02X", Integer.parseInt(stringArray[0].trim()), Integer.parseInt(stringArray[1].trim()), Integer.parseInt(stringArray[2].trim()), Integer.parseInt(stringArray[3].trim()));
            if ("#00000000".equals(string)) {
                return "#FFFFFFFF";
            }
        } else if (string.startsWith("rgb")) {
            String[] stringArray = string.substring(string.indexOf(40) + 1, string.lastIndexOf(41)).split(",");
            string = String.format("#%02X%02X%02X", Integer.parseInt(stringArray[0].trim()), Integer.parseInt(stringArray[1].trim()), Integer.parseInt(stringArray[2].trim()));
        }
        return string;
    }

    private void applyTextFormatting() {
        if (this.getCommandState(BULLETS_COMMAND) || this.getCommandState(NUMBERS_COMMAND)) {
            return;
        }
        if (this.webPage.getClientCommittedTextLength() == 0) {
            String string = ((RadioMenuItem)this.formatMenuButton.getItems().get(0)).getToggleGroup().getSelectedToggle().getProperties().get("formatValue").toString();
            String string2 = ((RadioMenuItem)this.fontFamilyMenuButton.getItems().get(0)).getToggleGroup().getSelectedToggle().getProperties().get("fontFamilyValue").toString();
            this.executeCommand(FORMAT_COMMAND, string);
            this.executeCommand(FONT_FAMILY_COMMAND, string2);
        }
    }

    public void keyboardShortcuts(String string) {
        if (BOLD_COMMAND.equals(string)) {
            this.boldButton.fire();
        } else if (ITALIC_COMMAND.equals(string)) {
            this.italicButton.setSelected(!this.italicButton.isSelected());
        } else if (UNDERLINE_COMMAND.equals(string)) {
            this.underlineButton.setSelected(!this.underlineButton.isSelected());
        }
    }

    @Override
    public void onTraverse(Node node, Bounds bounds) {
        this.cutButton.requestFocus();
    }

    @Override
    protected void layoutChildren() {
        super.layoutChildren();
        double d = Math.max(this.toolbar1.prefWidth(-1.0), this.toolbar2.prefWidth(-1.0));
        this.toolbar1.setMinWidth(d);
        this.toolbar1.setPrefWidth(d);
        this.toolbar2.setMinWidth(d);
        this.toolbar2.setPrefWidth(d);
    }
}

