/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import com.sun.javafx.css.Size;
import com.sun.javafx.css.SizeUnits;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.Value;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.URLConverter;
import com.sun.javafx.scene.layout.region.Repeat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.scene.image.Image;
import javafx.scene.text.Font;

public class BackgroundImage {
    private final Image image;
    private final Repeat repeatX;
    private final Repeat repeatY;
    private final double left;
    private final double top;
    private final double right;
    private final double bottom;
    private final boolean proportionalHPos;
    private final boolean proportionalVPos;
    private final double width;
    private final double height;
    private final boolean proportionalWidth;
    private final boolean proportionalHeight;
    private final boolean contain;
    private final boolean cover;

    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    public Image getImage() {
        return this.image;
    }

    public Repeat getRepeatX() {
        return this.repeatX;
    }

    public Repeat getRepeatY() {
        return this.repeatY;
    }

    public double getLeft() {
        return this.left;
    }

    public double getTop() {
        return this.top;
    }

    public double getRight() {
        return this.right;
    }

    public double getBottom() {
        return this.bottom;
    }

    public boolean isProportionalHPos() {
        return this.proportionalHPos;
    }

    public boolean isProportionalVPos() {
        return this.proportionalVPos;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean isProportionalWidth() {
        return this.proportionalWidth;
    }

    public boolean isProportionalHeight() {
        return this.proportionalHeight;
    }

    public boolean isContain() {
        return this.contain;
    }

    public boolean isCover() {
        return this.cover;
    }

    private BackgroundImage(Image image, Repeat repeat, Repeat repeat2, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.image = image;
        this.repeatX = repeat;
        this.repeatY = repeat2;
        this.left = d4;
        this.top = d;
        this.right = d2;
        this.bottom = d3;
        this.width = d5;
        this.height = d6;
        this.proportionalHPos = bl;
        this.proportionalVPos = bl2;
        this.proportionalWidth = bl3;
        this.proportionalHeight = bl4;
        this.contain = bl5;
        this.cover = bl6;
    }

    public static final class BackgroundSizeConverter
    extends StyleConverter<Value[], BackgroundSize> {
        public static BackgroundSizeConverter getInstance() {
            return Holder.BACKGROUND_SIZE_CONVERTER;
        }

        private BackgroundSizeConverter() {
        }

        @Override
        public BackgroundSize convert(Value<Value[], BackgroundSize> value, Font font) {
            Value[] valueArray = value.getValue();
            Size size = valueArray[0] != null ? (Size)valueArray[0].convert(font) : null;
            Size size2 = valueArray[1] != null ? (Size)valueArray[1].convert(font) : null;
            boolean bl = false;
            boolean bl2 = false;
            if (size != null) {
                boolean bl3 = bl = size.getUnits() == SizeUnits.PERCENT;
            }
            if (size2 != null) {
                bl2 = size2.getUnits() == SizeUnits.PERCENT;
            }
            double d = size != null ? size.pixels(font) : 0.0;
            double d2 = size2 != null ? size2.pixels(font) : 0.0;
            boolean bl4 = valueArray[2] != null ? (Boolean)BooleanConverter.getInstance().convert(valueArray[2], font) : false;
            boolean bl5 = valueArray[3] != null ? (Boolean)BooleanConverter.getInstance().convert(valueArray[3], font) : false;
            return new BackgroundSize(d, d2, bl, bl2, bl4, bl5);
        }

        public String toString() {
            return "BackgroundSizeConverter";
        }
    }

    public static final class LayeredBackgroundSizeConverter
    extends StyleConverter<Value<Value[], BackgroundSize>[], BackgroundSize[]> {
        public static LayeredBackgroundSizeConverter getInstance() {
            return Holder.LAYERED_BACKGROUND_SIZE_CONVERTER;
        }

        private LayeredBackgroundSizeConverter() {
        }

        @Override
        public BackgroundSize[] convert(Value<Value<Value[], BackgroundSize>[], BackgroundSize[]> value, Font font) {
            Value<Value[], BackgroundSize>[] valueArray = value.getValue();
            BackgroundSize[] backgroundSizeArray = new BackgroundSize[valueArray.length];
            for (int i = 0; i < valueArray.length; ++i) {
                backgroundSizeArray[i] = valueArray[i].convert(font);
            }
            return backgroundSizeArray;
        }
    }

    public static final class BackgroundSize {
        public static final BackgroundSize AUTO_SIZE = new BackgroundSize(0.0, 0.0, true, true, false, false);
        public static final BackgroundSize COVER = new BackgroundSize(0.0, 0.0, true, true, true, false);
        public static final BackgroundSize CONTAIN = new BackgroundSize(0.0, 0.0, true, true, false, true);
        private final boolean proportionalWidth;
        private final boolean proportionalHeight;
        private final double width;
        private final double height;
        private final boolean cover;
        private final boolean contain;

        public BackgroundSize(double d, double d2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.width = d;
            this.height = d2;
            this.proportionalWidth = bl;
            this.proportionalHeight = bl2;
            this.contain = bl4;
            this.cover = bl3;
        }

        private BackgroundSize() {
            this(0.0, 0.0, false, false, false, false);
        }

        public boolean isProportionalWidth() {
            return this.proportionalWidth;
        }

        public boolean isProportionalHeight() {
            return this.proportionalHeight;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isCover() {
            return this.cover;
        }

        public boolean isContain() {
            return this.contain;
        }
    }

    public static final class BackgroundPositionConverter
    extends StyleConverter<Value<?, Size>[], BackgroundPosition> {
        public static BackgroundPositionConverter getInstance() {
            return Holder.BACKGROUND_POSITION_CONVERTER;
        }

        private BackgroundPositionConverter() {
        }

        @Override
        public BackgroundPosition convert(Value<Value<?, Size>[], BackgroundPosition> value, Font font) {
            Value<?, Size>[] valueArray = value.getValue();
            Size size = valueArray[0].convert(font);
            Size size2 = valueArray[1].convert(font);
            Size size3 = valueArray[2].convert(font);
            Size size4 = valueArray[3].convert(font);
            boolean bl = size3.getValue() > 0.0 && size3.getUnits() == SizeUnits.PERCENT || size.getUnits() == SizeUnits.PERCENT;
            boolean bl2 = size2.getValue() > 0.0 && size2.getUnits() == SizeUnits.PERCENT || size4.getUnits() == SizeUnits.PERCENT;
            double d = size != null ? size.pixels(font) : 0.0;
            double d2 = size2 != null ? size2.pixels(font) : 0.0;
            double d3 = size3 != null ? size3.pixels(font) : 0.0;
            double d4 = size4 != null ? size4.pixels(font) : 0.0;
            return new BackgroundPosition(d, d2, d3, d4, bl2, bl);
        }

        public String toString() {
            return "BackgroundPositionConverter";
        }
    }

    public static final class LayeredBackgroundPositionConverter
    extends StyleConverter<Value<Value<?, Size>[], BackgroundPosition>[], BackgroundPosition[]> {
        public static LayeredBackgroundPositionConverter getInstance() {
            return Holder.LAYERED_BACKGROUND_POSITION_CONVERTER;
        }

        private LayeredBackgroundPositionConverter() {
        }

        @Override
        public BackgroundPosition[] convert(Value<Value<Value<?, Size>[], BackgroundPosition>[], BackgroundPosition[]> value, Font font) {
            Value<Value<?, Size>[], BackgroundPosition>[] valueArray = value.getValue();
            BackgroundPosition[] backgroundPositionArray = new BackgroundPosition[valueArray.length];
            for (int i = 0; i < valueArray.length; ++i) {
                backgroundPositionArray[i] = valueArray[i].convert(font);
            }
            return backgroundPositionArray;
        }

        public String toString() {
            return "LayeredBackgroundPositionConverter";
        }
    }

    public static final class BackgroundPosition {
        public static final Size ZERO_PERCENT = new Size(0.0, SizeUnits.PERCENT);
        public static final Size FIFTY_PERCENT = new Size(50.0, SizeUnits.PERCENT);
        public static final Size ONE_HUNDRED_PERCENT = new Size(100.0, SizeUnits.PERCENT);
        private final double top;
        private final double right;
        private final double bottom;
        private final double left;
        private boolean proportionalHPos;
        private boolean proportionalVPos;

        private BackgroundPosition() {
            this(0.0, 0.0, 0.0, 0.0, false, false);
        }

        public double getTop() {
            return this.top;
        }

        public double getRight() {
            return this.right;
        }

        public double getBottom() {
            return this.bottom;
        }

        public double getLeft() {
            return this.left;
        }

        public boolean isProportionalHPos() {
            return this.proportionalHPos;
        }

        public boolean isProportionalVPos() {
            return this.proportionalVPos;
        }

        public BackgroundPosition(double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
            this.top = d;
            this.right = d2;
            this.bottom = d3;
            this.left = d4;
            this.proportionalHPos = bl;
            this.proportionalVPos = bl2;
        }
    }

    public static final class BackgroundRepeat {
        private final Repeat repeatX;
        private final Repeat repeatY;

        public BackgroundRepeat(Repeat repeat, Repeat repeat2) {
            this.repeatX = repeat;
            this.repeatY = repeat2;
        }

        public Repeat getRepeatX() {
            return this.repeatX;
        }

        public Repeat getRepeatY() {
            return this.repeatY;
        }
    }

    public static final class BackgroundRepeatConverter
    extends StyleConverter<Value<Repeat[], Repeat[]>[], BackgroundRepeat[]> {
        public static BackgroundRepeatConverter getInstance() {
            return Holder.BACKGROUND_REPEAT_CONVERTER;
        }

        private BackgroundRepeatConverter() {
        }

        @Override
        public BackgroundRepeat[] convert(Value<Value<Repeat[], Repeat[]>[], BackgroundRepeat[]> value, Font font) {
            Value<Repeat[], Repeat[]>[] valueArray = value.getValue();
            BackgroundRepeat[] backgroundRepeatArray = new BackgroundRepeat[valueArray.length];
            for (int i = 0; i < valueArray.length; ++i) {
                Repeat[] repeatArray = valueArray[i].getValue();
                backgroundRepeatArray[i] = new BackgroundRepeat(repeatArray[0], repeatArray[1]);
            }
            return backgroundRepeatArray;
        }

        public String toString() {
            return "BackgroundRepeatType";
        }
    }

    public static class Builder {
        private Image image;
        private Repeat repeatX = Repeat.REPEAT;
        private Repeat repeatY = Repeat.REPEAT;
        private double top;
        private double right;
        private double bottom;
        private double left;
        private double width;
        private double height;
        private boolean proportionalHPos = true;
        private boolean proportionalVPos = true;
        private boolean proportionalWidth = true;
        private boolean proportionalHeight = true;
        private boolean contain = false;
        private boolean cover = false;

        public Builder setImage(Image image) {
            this.image = image;
            return this;
        }

        public Builder setRepeatX(Repeat repeat) {
            this.repeatX = repeat;
            return this;
        }

        public Builder setRepeatY(Repeat repeat) {
            this.repeatY = repeat;
            return this;
        }

        public Builder setTop(double d) {
            this.top = d;
            return this;
        }

        public Builder setRight(double d) {
            this.right = d;
            return this;
        }

        public Builder setBottom(double d) {
            this.bottom = d;
            return this;
        }

        public Builder setLeft(double d) {
            this.left = d;
            return this;
        }

        public Builder setWidth(double d) {
            this.width = d;
            return this;
        }

        public Builder setHeight(double d) {
            this.height = d;
            return this;
        }

        public Builder setProportionalHPos(boolean bl) {
            this.proportionalHPos = bl;
            return this;
        }

        public Builder setProportionalVPos(boolean bl) {
            this.proportionalVPos = bl;
            return this;
        }

        public Builder setProportionalWidth(boolean bl) {
            this.proportionalWidth = bl;
            return this;
        }

        public Builder setProportionalHeight(boolean bl) {
            this.proportionalHeight = bl;
            return this;
        }

        public Builder setContain(boolean bl) {
            this.contain = bl;
            return this;
        }

        public Builder setCover(boolean bl) {
            this.cover = bl;
            return this;
        }

        public BackgroundImage build() {
            return new BackgroundImage(this.image, this.repeatX, this.repeatY, this.top, this.right, this.bottom, this.left, this.width, this.height, this.proportionalHPos, this.proportionalVPos, this.proportionalWidth, this.proportionalHeight, this.contain, this.cover);
        }
    }

    private static class StyleableProperties {
        private static final List<StyleableProperty> STYLEABLES = Collections.unmodifiableList(Arrays.asList(StyleableProperty.createArtificialStyleable("-fx-background-image", URLConverter.SequenceConverter.getInstance(), null), StyleableProperty.createArtificialStyleable("-fx-background-repeat", BackgroundRepeatConverter.getInstance(), "repeat repeat"), StyleableProperty.createArtificialStyleable("-fx-background-position", LayeredBackgroundPositionConverter.getInstance(), "left top"), StyleableProperty.createArtificialStyleable("-fx-background-size", LayeredBackgroundSizeConverter.getInstance(), "0 0")));

        private StyleableProperties() {
        }
    }

    private static class Holder {
        private static final BackgroundRepeatConverter BACKGROUND_REPEAT_CONVERTER = new BackgroundRepeatConverter();
        private static final BackgroundPositionConverter BACKGROUND_POSITION_CONVERTER = new BackgroundPositionConverter();
        private static final LayeredBackgroundPositionConverter LAYERED_BACKGROUND_POSITION_CONVERTER = new LayeredBackgroundPositionConverter();
        private static final BackgroundSizeConverter BACKGROUND_SIZE_CONVERTER = new BackgroundSizeConverter();
        private static final LayeredBackgroundSizeConverter LAYERED_BACKGROUND_SIZE_CONVERTER = new LayeredBackgroundSizeConverter();

        private Holder() {
        }
    }
}

