/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.TextAreaBehavior;
import com.sun.javafx.scene.control.skin.TextInputControlSkin;
import com.sun.javafx.scene.text.HitInfo;
import com.sun.javafx.tk.FontMetrics;
import java.util.Collection;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.geometry.VerticalDirection;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class TextAreaSkin
extends TextInputControlSkin<TextArea, TextAreaBehavior> {
    private final boolean USE_MULTIPLE_NODES = false;
    private ContentView contentView = new ContentView();
    private Group paragraphNodes = new Group();
    private ObservableIntegerValue caretPosition;
    private Group selectionHighlightGroup = new Group();
    private ScrollPane scrollPane = new ScrollPane();
    private VerticalDirection scrollDirection = null;
    private Path characterBoundingPath = new Path();
    private Timeline scrollSelectionTimeline = new Timeline();
    private EventHandler<ActionEvent> scrollSelectionHandler = new EventHandler<ActionEvent>(){

        @Override
        public void handle(ActionEvent actionEvent) {
            switch (TextAreaSkin.this.scrollDirection) {
                case UP: {
                    break;
                }
            }
        }
    };
    public static final int SCROLL_RATE = 30;
    double targetCaretX = -1.0;

    public TextAreaSkin(final TextArea textArea) {
        super(textArea, new TextAreaBehavior(textArea));
        ((TextAreaBehavior)this.getBehavior()).setTextAreaSkin(this);
        this.caretPosition = new IntegerBinding(){
            {
                this.bind(textArea.caretPositionProperty());
            }

            @Override
            protected int computeValue() {
                return textArea.getCaretPosition();
            }
        };
        this.caretPosition.addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                TextAreaSkin.this.targetCaretX = -1.0;
            }
        });
        this.setManaged(false);
        this.scrollPane = new ScrollPane();
        this.scrollPane.setFitToWidth(textArea.isWrapText());
        this.scrollPane.setContent(this.contentView);
        this.getChildren().add(this.scrollPane);
        this.selectionHighlightGroup.setManaged(false);
        this.selectionHighlightGroup.setVisible(false);
        this.contentView.getChildren().add(this.selectionHighlightGroup);
        this.paragraphNodes.setManaged(false);
        this.contentView.getChildren().add(this.paragraphNodes);
        this.caretPath.setManaged(false);
        this.caretPath.setStrokeWidth(1.0);
        this.caretPath.fillProperty().bind(this.textFill);
        this.caretPath.strokeProperty().bind(this.textFill);
        this.caretPath.visibleProperty().bind(this.caretVisible);
        this.contentView.getChildren().add(this.caretPath);
        this.scrollPane.hvalueProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                ((TextArea)TextAreaSkin.this.getSkinnable()).setScrollLeft(number2.doubleValue() * TextAreaSkin.this.getScrollLeftMax());
            }
        });
        this.scrollPane.vvalueProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                ((TextArea)TextAreaSkin.this.getSkinnable()).setScrollTop(number2.doubleValue() * TextAreaSkin.this.getScrollTopMax());
            }
        });
        this.scrollSelectionTimeline.setCycleCount(-1);
        ObservableList<KeyFrame> observableList = this.scrollSelectionTimeline.getKeyFrames();
        observableList.clear();
        observableList.add(new KeyFrame(Duration.millis(350.0), this.scrollSelectionHandler, new KeyValue[0]));
        int n = 1;
        for (int i = 0; i < n; ++i) {
            String string = n == 1 ? textArea.getText() : (CharSequence)textArea.getParagraphs().get(i);
            Text text = new Text(string.toString());
            text.setTextOrigin(VPos.TOP);
            text.setManaged(false);
            this.paragraphNodes.getChildren().add(text);
        }
        textArea.selectionProperty().addListener(new ChangeListener<IndexRange>(){

            @Override
            public void changed(ObservableValue<? extends IndexRange> observableValue, IndexRange indexRange, IndexRange indexRange2) {
                TextAreaSkin.this.requestLayout();
                TextAreaSkin.this.contentView.requestLayout();
            }
        });
        textArea.wrapTextProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                TextAreaSkin.this.scrollPane.setFitToWidth(bl2);
            }
        });
        textArea.prefColumnCountProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                TextAreaSkin.this.updatePrefViewportWidth();
            }
        });
        textArea.prefRowCountProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                TextAreaSkin.this.updatePrefViewportHeight();
            }
        });
        textArea.scrollTopProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                double d = number2.doubleValue() < TextAreaSkin.this.getScrollTopMax() ? number2.doubleValue() / TextAreaSkin.this.getScrollTopMax() : 1.0;
                TextAreaSkin.this.scrollPane.setVvalue(d);
            }
        });
        textArea.scrollLeftProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                double d = number2.doubleValue() < TextAreaSkin.this.getScrollLeftMax() ? number2.doubleValue() / TextAreaSkin.this.getScrollLeftMax() : 1.0;
                TextAreaSkin.this.scrollPane.setHvalue(d);
            }
        });
        textArea.textProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                ((Text)TextAreaSkin.this.paragraphNodes.getChildren().get(0)).setText(textArea.getText());
                TextAreaSkin.this.contentView.requestLayout();
            }
        });
        this.updateTextFill();
        this.updateHighlightFill();
        this.updateHighlightTextFill();
        this.updatePrefViewportWidth();
        this.updatePrefViewportHeight();
        if (textArea.isFocused()) {
            this.setCaretAnimating(true);
        }
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getBaselineOffset() {
        return (double)((FontMetrics)this.fontMetrics.get()).getAscent() + this.getInsets().getTop();
    }

    @Override
    public char getCharacter(int n) {
        Text text;
        int n2;
        int n3;
        int n4 = this.paragraphNodes.getChildren().size();
        int n5 = 0;
        String string = null;
        for (n2 = n; n5 < n4 && n2 >= (n3 = (string = (text = (Text)this.paragraphNodes.getChildren().get(n5)).getText()).length() + 1); n2 -= n3, ++n5) {
        }
        return n2 == string.length() ? (char)'\n' : string.charAt(n2);
    }

    @Override
    public int getInsertionPoint(double d, double d2) {
        TextArea textArea = (TextArea)this.getSkinnable();
        int n = this.paragraphNodes.getChildren().size();
        int n2 = -1;
        if (n > 0) {
            Insets insets = this.contentView.getInsets();
            if (d2 < insets.getTop()) {
                Text text = (Text)this.paragraphNodes.getChildren().get(0);
                n2 = this.getNextInsertionPoint(text, d, -1, VerticalDirection.DOWN);
            } else if (d2 > insets.getTop() + this.contentView.getHeight()) {
                int n3 = n - 1;
                Text text = (Text)this.paragraphNodes.getChildren().get(n3);
                n2 = this.getNextInsertionPoint(text, d, -1, VerticalDirection.UP) + (textArea.getLength() - text.getText().length());
            } else {
                int n4 = 0;
                for (int i = 0; i < n; ++i) {
                    Text text = (Text)this.paragraphNodes.getChildren().get(i);
                    Bounds bounds = text.getBoundsInLocal();
                    double d3 = text.getLayoutY() + bounds.getMinY();
                    if (d2 >= d3 && d2 < d3 + text.getBoundsInLocal().getHeight()) {
                        n2 = this.getInsertionPoint(text, d - text.getLayoutX(), d2 - text.getLayoutY()) + n4;
                        break;
                    }
                    n4 += text.getText().length() + 1;
                }
            }
        }
        return n2;
    }

    public void positionCaret(HitInfo hitInfo, boolean bl) {
        boolean bl2;
        int n = hitInfo.getInsertionIndex();
        boolean bl3 = bl2 = n > 0 && n < ((TextArea)this.getSkinnable()).getLength() && ((TextArea)this.getSkinnable()).getText().codePointAt(n - 1) == 10;
        if (!hitInfo.isLeading() && bl2) {
            hitInfo.setLeading(true);
            --n;
        }
        if (bl) {
            ((TextArea)this.getSkinnable()).selectPositionCaret(n);
        } else {
            ((TextArea)this.getSkinnable()).positionCaret(n);
        }
    }

    private double getScrollTopMax() {
        return Math.max(0.0, this.contentView.getHeight() - this.scrollPane.getViewportBounds().getHeight());
    }

    private double getScrollLeftMax() {
        return Math.max(0.0, this.contentView.getWidth() - this.scrollPane.getViewportBounds().getWidth());
    }

    private int getInsertionPoint(Text text, double d, double d2) {
        HitInfo hitInfo = text.impl_hitTestChar(new Point2D(d, d2));
        return hitInfo.getInsertionIndex();
    }

    public int getNextInsertionPoint(double d, int n, VerticalDirection verticalDirection) {
        return 0;
    }

    private int getNextInsertionPoint(Text text, double d, int n, VerticalDirection verticalDirection) {
        return 0;
    }

    @Override
    public Rectangle2D getCharacterBounds(int n) {
        double d;
        TextArea textArea = (TextArea)this.getSkinnable();
        int n2 = this.paragraphNodes.getChildren().size();
        int n3 = textArea.getLength() + 1;
        Text text = null;
        while (n < (n3 -= (text = (Text)this.paragraphNodes.getChildren().get(--n2)).getText().length() + 1)) {
        }
        int n4 = n - n3;
        boolean bl = false;
        if (n4 == text.getText().length()) {
            --n4;
            bl = true;
        }
        this.characterBoundingPath.getElements().clear();
        this.characterBoundingPath.getElements().addAll((PathElement[])text.impl_getRangeShape(n4, n4 + 1));
        this.characterBoundingPath.setLayoutX(text.getLayoutX());
        this.characterBoundingPath.setLayoutY(text.getLayoutY());
        Bounds bounds = this.characterBoundingPath.getBoundsInLocal();
        double d2 = bounds.getMinX() + text.getLayoutX() - textArea.getScrollLeft();
        double d3 = bounds.getMinY() + text.getLayoutY() - textArea.getScrollTop();
        double d4 = bounds.isEmpty() ? 0.0 : bounds.getWidth();
        double d5 = d = bounds.isEmpty() ? 0.0 : bounds.getHeight();
        if (bl) {
            d2 += d4;
            d4 = 0.0;
        }
        return new Rectangle2D(d2, d3, d4, d);
    }

    @Override
    public void scrollCharacterToVisible(final int n) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (((TextArea)TextAreaSkin.this.getSkinnable()).getLength() == 0) {
                    return;
                }
                Rectangle2D rectangle2D = TextAreaSkin.this.getCharacterBounds(n);
                TextAreaSkin.this.scrollBoundsToVisible(rectangle2D);
            }
        });
    }

    private void scrollCaretToVisible() {
        Bounds bounds = this.caretPath.getLayoutBounds();
        TextArea textArea = (TextArea)this.getSkinnable();
        this.scrollBoundsToVisible(new Rectangle2D(bounds.getMinX() - textArea.getScrollLeft(), bounds.getMinY() - textArea.getScrollTop(), bounds.getWidth(), bounds.getHeight()));
    }

    private void scrollBoundsToVisible(Rectangle2D rectangle2D) {
        double d;
        TextArea textArea = (TextArea)this.getSkinnable();
        Bounds bounds = this.scrollPane.getViewportBounds();
        Insets insets = this.contentView.getInsets();
        double d2 = bounds.getWidth();
        double d3 = bounds.getHeight();
        double d4 = textArea.getScrollTop();
        double d5 = textArea.getScrollLeft();
        double d6 = 6.0;
        if (rectangle2D.getMinY() < 0.0) {
            d = d4 + rectangle2D.getMinY();
            if (d <= insets.getTop()) {
                d = 0.0;
            }
            textArea.setScrollTop(d);
        } else if (insets.getTop() + rectangle2D.getMaxY() > d3) {
            d = d4 + insets.getTop() + rectangle2D.getMaxY() - d3;
            if (d >= this.getScrollTopMax() - insets.getBottom()) {
                d = this.getScrollTopMax();
            }
            textArea.setScrollTop(d);
        }
        if (rectangle2D.getMinX() < 0.0) {
            d = d5 + rectangle2D.getMinX() - d6;
            if (d <= insets.getLeft() + d6) {
                d = 0.0;
            }
            textArea.setScrollLeft(d);
        } else if (insets.getLeft() + rectangle2D.getMaxX() > d2) {
            d = d5 + insets.getLeft() + rectangle2D.getMaxX() - d2 + d6;
            if (d >= this.getScrollLeftMax() - insets.getRight() - d6) {
                d = this.getScrollLeftMax();
            }
            textArea.setScrollLeft(d);
        }
    }

    private void updatePrefViewportWidth() {
        double d = ((FontMetrics)this.fontMetrics.get()).computeStringWidth("W");
        int n = ((TextArea)this.getSkinnable()).getPrefColumnCount();
        Insets insets = this.contentView.getInsets();
        this.scrollPane.setPrefViewportWidth((double)n * d + insets.getLeft() + insets.getRight());
    }

    private void updatePrefViewportHeight() {
        double d = ((FontMetrics)this.fontMetrics.get()).getLineHeight();
        int n = ((TextArea)this.getSkinnable()).getPrefRowCount();
        Insets insets = this.contentView.getInsets();
        this.scrollPane.setPrefViewportHeight((double)n * d + insets.getTop() + insets.getBottom());
    }

    @Override
    protected void updateTextFill() {
    }

    @Override
    protected void updateHighlightFill() {
        for (Node node : this.selectionHighlightGroup.getChildren()) {
            Path path = (Path)node;
            path.setFill((Paint)this.highlightFill.get());
        }
    }

    @Override
    protected void updateHighlightTextFill() {
    }

    private double getTextTranslateX() {
        return 0.0;
    }

    private double getTextTranslateY() {
        return 0.0;
    }

    private double getTextLeft() {
        return 0.0;
    }

    private Point2D translateCaretPosition(Point2D point2D) {
        return point2D;
    }

    private Text getTextNode() {
        return (Text)this.paragraphNodes.getChildren().get(0);
    }

    public HitInfo getIndex(MouseEvent mouseEvent) {
        Point2D point2D;
        Text text = this.getTextNode();
        HitInfo hitInfo = text.impl_hitTestChar(this.translateCaretPosition(point2D = new Point2D(mouseEvent.getX() - text.getLayoutX(), mouseEvent.getY() - this.getTextTranslateY())));
        int n = hitInfo.getCharIndex();
        if (n > 0) {
            int n2 = text.getImpl_caretPosition();
            text.setImpl_caretPosition(n);
            PathElement pathElement = text.getImpl_caretShape()[0];
            if (pathElement instanceof MoveTo && ((MoveTo)pathElement).getY() > mouseEvent.getY() - this.getTextTranslateY()) {
                hitInfo.setCharIndex(n - 1);
            }
            text.setImpl_caretPosition(n2);
        }
        return hitInfo;
    }

    protected void downLines(int n, boolean bl) {
        double d;
        HitInfo hitInfo;
        int n2;
        Text text = this.getTextNode();
        Bounds bounds = this.caretPath.getLayoutBounds();
        double d2 = (bounds.getMinY() + bounds.getMaxY()) / 2.0 + (double)((float)n * ((FontMetrics)this.fontMetrics.get()).getLineHeight());
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if ((n2 = (hitInfo = text.impl_hitTestChar(this.translateCaretPosition(new Point2D(d = this.targetCaretX >= 0.0 ? this.targetCaretX : bounds.getMaxX() + this.getTextTranslateX(), d2)))).getCharIndex()) > 0) {
            text.setImpl_caretPosition(n2);
            PathElement pathElement = text.getImpl_caretShape()[0];
            if (pathElement instanceof MoveTo && ((MoveTo)pathElement).getY() > d2) {
                hitInfo.setCharIndex(n2 - 1);
            }
        }
        this.positionCaret(hitInfo, bl);
        this.targetCaretX = d;
    }

    public void previousLine(boolean bl) {
        this.downLines(-1, bl);
    }

    public void nextLine(boolean bl) {
        this.downLines(1, bl);
    }

    public void previousPage(boolean bl) {
        this.downLines(-((int)(this.scrollPane.getViewportBounds().getHeight() / (double)((FontMetrics)this.fontMetrics.get()).getLineHeight())), bl);
    }

    public void nextPage(boolean bl) {
        this.downLines((int)(this.scrollPane.getViewportBounds().getHeight() / (double)((FontMetrics)this.fontMetrics.get()).getLineHeight()), bl);
    }

    public void lineStart(boolean bl) {
        Bounds bounds = this.caretPath.getLayoutBounds();
        double d = (bounds.getMinY() + bounds.getMaxY()) / 2.0;
        HitInfo hitInfo = this.getTextNode().impl_hitTestChar(this.translateCaretPosition(new Point2D(this.getTextLeft(), d)));
        this.positionCaret(hitInfo, bl);
    }

    public void lineEnd(boolean bl) {
        this.targetCaretX = Double.MAX_VALUE;
        this.downLines(0, bl);
        this.targetCaretX = -1.0;
    }

    @Override
    protected PathElement[] getUnderlineShape(int n, int n2) {
        int n3 = 0;
        for (Node node : this.paragraphNodes.getChildren()) {
            Text text = (Text)node;
            int n4 = n3 + text.getText().length();
            if (n4 >= n) {
                return text.impl_getUnderlineShape(n - n3, n2 - n3);
            }
            n3 = n4 + 1;
        }
        return null;
    }

    @Override
    protected PathElement[] getRangeShape(int n, int n2) {
        int n3 = 0;
        for (Node node : this.paragraphNodes.getChildren()) {
            Text text = (Text)node;
            int n4 = n3 + text.getText().length();
            if (n4 >= n) {
                return text.impl_getRangeShape(n - n3, n2 - n3);
            }
            n3 = n4 + 1;
        }
        return null;
    }

    @Override
    protected void addHighlight(List<? extends Node> list, int n) {
        int n2 = 0;
        Node node = null;
        for (Node node2 : this.paragraphNodes.getChildren()) {
            Text text = (Text)node2;
            int n3 = n2 + text.getText().length();
            if (n3 >= n) {
                node = text;
                break;
            }
            n2 = n3 + 1;
        }
        if (node != null) {
            for (Node node2 : list) {
                node2.setLayoutX(node.getLayoutX());
                node2.setLayoutY(node.getLayoutY());
            }
        }
        this.contentView.getChildren().addAll((Collection<Node>)list);
    }

    @Override
    protected void removeHighlight(List<? extends Node> list) {
        this.contentView.getChildren().removeAll((Collection<?>)list);
    }

    public void deleteChar(boolean bl) {
        boolean bl2;
        boolean bl3 = bl ? !((TextArea)this.getSkinnable()).deletePreviousChar() : (bl2 = !((TextArea)this.getSkinnable()).deleteNextChar());
        if (bl2) {
            // empty if block
        }
    }

    private class ContentView
    extends Region {
        private ContentView() {
            this.getStyleClass().add("content");
            this.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    ((TextAreaBehavior)TextAreaSkin.this.getBehavior()).mousePressed(mouseEvent);
                }
            });
            this.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    ((TextAreaBehavior)TextAreaSkin.this.getBehavior()).mouseReleased(mouseEvent);
                }
            });
            this.addEventHandler(MouseEvent.MOUSE_DRAGGED, new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    ((TextAreaBehavior)TextAreaSkin.this.getBehavior()).mouseDragged(mouseEvent);
                }
            });
        }

        @Override
        protected ObservableList<Node> getChildren() {
            return super.getChildren();
        }

        @Override
        public Orientation getContentBias() {
            return Orientation.HORIZONTAL;
        }

        @Override
        protected double computePrefWidth(double d) {
            Font font = (Font)TextAreaSkin.this.font.get();
            Insets insets = this.getInsets();
            double d2 = 0.0;
            for (Node node : TextAreaSkin.this.paragraphNodes.getChildren()) {
                Text text = (Text)node;
                text.setWrappingWidth(-1.0);
                text.setFont(font);
                Bounds bounds = text.getBoundsInLocal();
                d2 = Math.max(d2, bounds.getWidth());
            }
            return Math.max(d2 += insets.getLeft() + insets.getRight(), TextAreaSkin.this.scrollPane.getViewportBounds().getWidth());
        }

        @Override
        protected double computePrefHeight(double d) {
            Font font = (Font)TextAreaSkin.this.font.get();
            Insets insets = this.getInsets();
            double d2 = d == -1.0 ? 0.0 : Math.max(d - (insets.getLeft() + insets.getRight()), 0.0);
            double d3 = 0.0;
            int n = 0;
            for (Node node : TextAreaSkin.this.paragraphNodes.getChildren()) {
                Text text = (Text)node;
                text.setFont(font);
                text.setWrappingWidth(d2);
                Bounds bounds = text.getBoundsInLocal();
                d3 += bounds.getHeight();
                ++n;
            }
            return Math.max(d3 += insets.getTop() + insets.getBottom(), TextAreaSkin.this.scrollPane.getViewportBounds().getHeight());
        }

        @Override
        public void layoutChildren() {
            TextArea textArea = (TextArea)TextAreaSkin.this.getSkinnable();
            double d = this.getWidth();
            Font font = (Font)TextAreaSkin.this.font.get();
            Insets insets = this.getInsets();
            double d2 = Math.max(d - (insets.getLeft() + insets.getRight()), 0.0);
            double d3 = insets.getTop();
            for (Node node : TextAreaSkin.this.paragraphNodes.getChildren()) {
                Text text = (Text)node;
                text.setFont(font);
                text.setWrappingWidth(d2);
                Bounds bounds = text.getBoundsInLocal();
                text.setLayoutX(insets.getLeft());
                text.setLayoutY(d3);
                d3 += bounds.getHeight();
            }
            IndexRange indexRange = textArea.getSelection();
            TextAreaSkin.this.caretPath.getElements().clear();
            TextAreaSkin.this.selectionHighlightGroup.getChildren().clear();
            int n = textArea.getCaretPosition();
            int n2 = TextAreaSkin.this.paragraphNodes.getChildren().size();
            int n3 = textArea.getLength() + 1;
            Text text = null;
            while (n < (n3 -= (text = (Text)TextAreaSkin.this.paragraphNodes.getChildren().get(--n2)).getText().length() + 1)) {
            }
            text.setImpl_caretPosition(n - n3);
            TextAreaSkin.this.caretPath.getElements().addAll((PathElement[])text.getImpl_caretShape());
            TextAreaSkin.this.caretPath.setLayoutX(text.getLayoutX());
            TextAreaSkin.this.caretPath.setLayoutY(text.getLayoutY());
            TextAreaSkin.this.scrollCaretToVisible();
            if (indexRange.getLength() == 0) {
                TextAreaSkin.this.selectionHighlightGroup.setVisible(false);
            } else {
                int n4;
                TextAreaSkin.this.selectionHighlightGroup.setVisible(true);
                n = indexRange.getStart();
                n2 = indexRange.getEnd();
                n3 = TextAreaSkin.this.paragraphNodes.getChildren().size();
                int n5 = textArea.getLength() + 1;
                Text text2 = null;
                while (n2 < (n5 -= (text2 = (Text)TextAreaSkin.this.paragraphNodes.getChildren().get(--n3)).getText().length() + 1)) {
                }
                int n6 = n3++;
                n5 += text2.getText().length() + 1;
                while (n < (n5 -= (text2 = (Text)TextAreaSkin.this.paragraphNodes.getChildren().get(--n3)).getText().length() + 1)) {
                }
                for (int i = n4 = n3; i <= n6; ++i) {
                    String string = textArea.getText();
                    text2 = (Text)TextAreaSkin.this.paragraphNodes.getChildren().get(i);
                    int n7 = Math.max(n - n5, 0);
                    int n8 = Math.min(n2 - n5, string.length());
                    text2.setImpl_selectionStart(n7);
                    text2.setImpl_selectionEnd(n8);
                    Path path = new Path();
                    path.setManaged(false);
                    path.setStroke(null);
                    PathElement[] pathElementArray = text2.getImpl_selectionShape();
                    if (pathElementArray != null) {
                        path.getElements().addAll((PathElement[])pathElementArray);
                    }
                    TextAreaSkin.this.selectionHighlightGroup.getChildren().add(path);
                    path.setLayoutX(text2.getLayoutX());
                    path.setLayoutY(text2.getLayoutY());
                    n5 += string.length() + 1;
                }
                TextAreaSkin.this.updateHighlightFill();
                TextAreaSkin.this.updateHighlightTextFill();
            }
            if (TextAreaSkin.this.scrollPane.getPrefViewportWidth() == 0.0 || TextAreaSkin.this.scrollPane.getPrefViewportHeight() == 0.0) {
                TextAreaSkin.this.updatePrefViewportWidth();
                TextAreaSkin.this.updatePrefViewportHeight();
                if (this.getParent() != null && TextAreaSkin.this.scrollPane.getPrefViewportWidth() > 0.0 || TextAreaSkin.this.scrollPane.getPrefViewportHeight() > 0.0) {
                    this.getParent().requestLayout();
                }
            }
        }
    }
}

