/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.runnable.Runnable0;
import com.sun.javafx.scene.control.WeakListChangeListener;
import com.sun.javafx.scene.control.behavior.TableViewBehavior;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import com.sun.javafx.scene.control.skin.VirtualContainerBase;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.util.Iterator;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public class TableViewSkin<T>
extends VirtualContainerBase<TableView<T>, TableViewBehavior<T>, TableRow<T>> {
    private ListChangeListener rowCountListener = new ListChangeListener(){

        public void onChanged(ListChangeListener.Change change) {
            TableViewSkin.this.rowCountDirty = true;
            TableViewSkin.this.requestLayout();
        }
    };
    private ListChangeListener<TableColumn<T, ?>> visibleLeafColumnsListener = new ListChangeListener<TableColumn<T, ?>>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TableColumn<T, ?>> change) {
            TableViewSkin.this.updateVisibleColumnCount();
            while (change.next()) {
                TableViewSkin.this.updateVisibleLeafColumnWidthListeners(change.getAddedSubList(), change.getRemoved());
            }
        }
    };
    private InvalidationListener widthListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableViewSkin.this.flow.reconfigureCells();
        }
    };
    private ChangeListener<ObservableList<T>> itemsChangeListener = new ChangeListener<ObservableList<T>>(){

        @Override
        public void changed(ObservableValue<? extends ObservableList<T>> observableValue, ObservableList<T> observableList, ObservableList<T> observableList2) {
            TableViewSkin.this.updateTableItems(observableList, observableList2);
        }
    };
    private WeakListChangeListener<T> weakRowCountListener = new WeakListChangeListener(this.rowCountListener);
    private WeakListChangeListener<TableColumn<T, ?>> weakVisibleLeafColumnsListener = new WeakListChangeListener(this.visibleLeafColumnsListener);
    private WeakInvalidationListener weakWidthListener = new WeakInvalidationListener(this.widthListener);
    private WeakChangeListener<ObservableList<T>> weakItemsChangeListener = new WeakChangeListener<ObservableList<ObservableList<T>>>(this.itemsChangeListener);
    private boolean rowCountDirty;
    private boolean contentWidthDirty = true;
    private double scrollX;
    private Region columnReorderLine;
    private Region columnReorderOverlay;
    private TableHeaderRow tableHeaderRow;
    private Callback<TableView<T>, TableRow<T>> rowFactory;
    private StackPane placeholderRegion;
    private Label placeholderLabel;
    private static final String EMPTY_TABLE_TEXT = ControlResources.getString("TableView.noContent");
    private static final String NO_COLUMNS_TEXT = ControlResources.getString("TableView.noColumns");
    private int visibleColCount;

    public TableViewSkin(final TableView tableView) {
        super(tableView, new TableViewBehavior(tableView));
        this.flow = new VirtualFlow();
        this.flow.setPannable(false);
        this.flow.setFocusTraversable(((TableView)this.getSkinnable()).isFocusTraversable());
        this.flow.setCreateCell((Runnable0<? extends IndexedCell>)new Runnable0<TableRow>(){

            @Override
            public TableRow run() {
                return TableViewSkin.this.createCell();
            }
        });
        EventHandler<MouseEvent> eventHandler = new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (tableView.getEditingCell() != null) {
                    tableView.edit(-1, null);
                }
                tableView.requestFocus();
            }
        };
        this.flow.getVbar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        this.flow.getHbar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        this.columnReorderLine = new Region();
        this.columnReorderLine.getStyleClass().setAll((String[])new String[]{"column-resize-line"});
        this.columnReorderLine.setManaged(false);
        this.columnReorderLine.setVisible(false);
        this.columnReorderOverlay = new Region();
        this.columnReorderOverlay.getStyleClass().setAll((String[])new String[]{"column-overlay"});
        this.columnReorderOverlay.setVisible(false);
        this.columnReorderOverlay.setManaged(false);
        this.tableHeaderRow = new TableHeaderRow(tableView, this.flow);
        this.tableHeaderRow.setColumnReorderLine(this.columnReorderLine);
        this.tableHeaderRow.setTablePadding(this.getInsets());
        this.tableHeaderRow.setFocusTraversable(false);
        this.paddingProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                TableViewSkin.this.tableHeaderRow.setTablePadding(TableViewSkin.this.getInsets());
            }
        });
        this.getChildren().addAll((Node[])new Node[]{this.tableHeaderRow, this.flow, this.columnReorderOverlay, this.columnReorderLine});
        this.updateVisibleColumnCount();
        this.updateVisibleLeafColumnWidthListeners(((TableView)this.getSkinnable()).getVisibleLeafColumns(), FXCollections.emptyObservableList());
        this.tableHeaderRow.reorderingProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                TableViewSkin.this.requestLayout();
            }
        });
        ((TableView)this.getSkinnable()).getVisibleLeafColumns().addListener(this.weakVisibleLeafColumnsListener);
        this.updateTableItems(null, ((TableView)this.getSkinnable()).getItems());
        ((TableView)this.getSkinnable()).itemsProperty().addListener(this.weakItemsChangeListener);
        ((TableView)this.getSkinnable()).getProperties().addListener(new MapChangeListener<Object, Object>(){

            @Override
            public void onChanged(MapChangeListener.Change<? extends Object, ? extends Object> change) {
                if (change.wasAdded() && "TableView.refresh".equals(change.getKey())) {
                    TableViewSkin.this.refreshView();
                    tableView.getProperties().remove("TableView.refresh");
                }
            }
        });
        InvalidationListener invalidationListener = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                TableViewSkin.this.contentWidthDirty = true;
                TableViewSkin.this.requestLayout();
            }
        };
        this.flow.widthProperty().addListener(invalidationListener);
        this.flow.getVbar().widthProperty().addListener(invalidationListener);
        ((TableViewBehavior)this.getBehavior()).setOnFocusPreviousRow(new Runnable(){

            @Override
            public void run() {
                TableViewSkin.this.onFocusPreviousCell();
            }
        });
        ((TableViewBehavior)this.getBehavior()).setOnFocusNextRow(new Runnable(){

            @Override
            public void run() {
                TableViewSkin.this.onFocusNextCell();
            }
        });
        ((TableViewBehavior)this.getBehavior()).setOnMoveToFirstCell(new Runnable(){

            @Override
            public void run() {
                TableViewSkin.this.onMoveToFirstCell();
            }
        });
        ((TableViewBehavior)this.getBehavior()).setOnMoveToLastCell(new Runnable(){

            @Override
            public void run() {
                TableViewSkin.this.onMoveToLastCell();
            }
        });
        ((TableViewBehavior)this.getBehavior()).setOnScrollPageDown(new Callback<Void, Integer>(){

            @Override
            public Integer call(Void void_) {
                return TableViewSkin.this.onScrollPageDown();
            }
        });
        ((TableViewBehavior)this.getBehavior()).setOnScrollPageUp(new Callback<Void, Integer>(){

            @Override
            public Integer call(Void void_) {
                return TableViewSkin.this.onScrollPageUp();
            }
        });
        ((TableViewBehavior)this.getBehavior()).setOnSelectPreviousRow(new Runnable(){

            @Override
            public void run() {
                TableViewSkin.this.onSelectPreviousCell();
            }
        });
        ((TableViewBehavior)this.getBehavior()).setOnSelectNextRow(new Runnable(){

            @Override
            public void run() {
                TableViewSkin.this.onSelectNextCell();
            }
        });
        ((TableViewBehavior)this.getBehavior()).setOnSelectLeftCell(new Runnable(){

            @Override
            public void run() {
                TableViewSkin.this.onSelectLeftCell();
            }
        });
        ((TableViewBehavior)this.getBehavior()).setOnSelectRightCell(new Runnable(){

            @Override
            public void run() {
                TableViewSkin.this.onSelectRightCell();
            }
        });
        this.registerChangeListener(tableView.rowFactoryProperty(), "ROW_FACTORY");
        this.registerChangeListener(tableView.placeholderProperty(), "PLACEHOLDER");
        this.registerChangeListener(tableView.focusTraversableProperty(), "FOCUS_TRAVERSABLE");
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "ROW_FACTORY") {
            Callback<TableView<T>, TableRow<T>> callback = this.rowFactory;
            this.rowFactory = ((TableView)this.getSkinnable()).getRowFactory();
            if (callback != this.rowFactory) {
                this.flow.recreateCells();
            }
        } else if (string == "PLACEHOLDER") {
            this.updatePlaceholderRegionVisibility();
        } else if (string == "FOCUS_TRAVERSABLE") {
            this.flow.setFocusTraversable(((TableView)this.getSkinnable()).isFocusTraversable());
        }
    }

    @Override
    public int getItemCount() {
        return ((TableView)this.getSkinnable()).getItems() == null ? 0 : ((TableView)this.getSkinnable()).getItems().size();
    }

    @Override
    public TableRow createCell() {
        TableRow<Object> tableRow = ((TableView)this.getSkinnable()).getRowFactory() != null ? ((TableView)this.getSkinnable()).getRowFactory().call(this.getSkinnable()) : new TableRow();
        tableRow.updateTableView((TableView)this.getSkinnable());
        return tableRow;
    }

    public int onScrollPageDown() {
        boolean bl;
        TableRow tableRow = (TableRow)this.flow.getLastVisibleCellWithinViewPort();
        if (tableRow == null) {
            return -1;
        }
        boolean bl2 = bl = tableRow.isSelected() || tableRow.isFocused() || this.isCellSelected(tableRow.getIndex()) || this.isCellFocused(tableRow.getIndex());
        if (bl) {
            this.flow.showAsFirst(tableRow);
            tableRow = (TableRow)this.flow.getLastVisibleCellWithinViewPort();
        }
        int n = tableRow.getIndex();
        this.flow.show(n);
        return n;
    }

    public int onScrollPageUp() {
        boolean bl;
        TableRow tableRow = (TableRow)this.flow.getFirstVisibleCellWithinViewPort();
        if (tableRow == null) {
            return -1;
        }
        boolean bl2 = bl = tableRow.isSelected() || tableRow.isFocused() || this.isCellSelected(tableRow.getIndex()) || this.isCellFocused(tableRow.getIndex());
        if (bl) {
            this.flow.showAsLast(tableRow);
            tableRow = (TableRow)this.flow.getFirstVisibleCellWithinViewPort();
        }
        int n = tableRow.getIndex();
        this.flow.show(n);
        return n;
    }

    @Override
    protected double computePrefHeight(double d) {
        return 400.0;
    }

    @Override
    protected double computePrefWidth(double d) {
        ObservableList observableList = ((TableView)this.getSkinnable()).getVisibleLeafColumns();
        if (observableList == null || observableList.isEmpty()) {
            return 200.0;
        }
        double d2 = this.getInsets().getLeft() + this.getInsets().getRight();
        for (TableColumn tableColumn : observableList) {
            d2 += Math.max(tableColumn.getPrefWidth(), tableColumn.getMinWidth());
        }
        return d2;
    }

    @Override
    protected void layoutChildren() {
        if (this.rowCountDirty) {
            this.updateRowCount();
            this.rowCountDirty = false;
        }
        double d = this.getInsets().getLeft();
        double d2 = this.getInsets().getTop();
        double d3 = this.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
        double d4 = this.getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom());
        double d5 = this.getLayoutBounds().getHeight() / 2.0;
        double d6 = this.tableHeaderRow.prefHeight(-1.0);
        this.layoutInArea(this.tableHeaderRow, d, d2, d3, d6, d5, this.getAlignment().getHpos(), this.getAlignment().getVpos());
        d2 += d6;
        double d7 = Math.floor(d4 - d6);
        if (this.getItemCount() == 0 || this.visibleColCount == 0) {
            this.layoutInArea(this.placeholderRegion, d, d2, d3, d7, d5, this.getAlignment().getHpos(), this.getAlignment().getVpos());
        } else {
            this.layoutInArea(this.flow, d, d2, d3, d7, d5, this.getAlignment().getHpos(), this.getAlignment().getVpos());
        }
        if (this.tableHeaderRow.getReorderingRegion() != null) {
            double d8;
            double d9;
            Object object;
            TableColumn tableColumn = this.tableHeaderRow.getReorderingRegion().getTableColumn();
            if (tableColumn != null) {
                object = this.tableHeaderRow.getReorderingRegion();
                d9 = this.tableHeaderRow.sceneToLocal(((Node)object).localToScene(((Node)object).getBoundsInLocal())).getMinX();
                d8 = tableColumn.getWidth();
                if (d9 < 0.0) {
                    d8 += d9;
                }
                double d10 = d9 = d9 < 0.0 ? 0.0 : d9;
                if (d9 + d8 > d3) {
                    d8 = d3 - d9;
                    if (this.flow.getVbar().isVisible()) {
                        d8 -= this.flow.getVbar().getWidth() - 1.0;
                    }
                }
                double d11 = d7;
                if (this.flow.getHbar().isVisible()) {
                    d11 -= this.flow.getHbar().getHeight();
                }
                this.columnReorderOverlay.resize(d8, d11);
                this.columnReorderOverlay.setLayoutX(d9);
                this.columnReorderOverlay.setLayoutY(this.tableHeaderRow.getHeight());
            }
            object = this.columnReorderLine.getInsets();
            d9 = ((Insets)object).getLeft() + ((Insets)object).getRight();
            d8 = d4 - (this.flow.getHbar().isVisible() ? this.flow.getHbar().getHeight() - 1.0 : 0.0);
            this.columnReorderLine.resizeRelocate(0.0, ((Insets)object).getTop(), d9, d8);
        }
        this.columnReorderLine.setVisible(this.tableHeaderRow.isReordering());
        this.columnReorderOverlay.setVisible(this.tableHeaderRow.isReordering());
        if (this.contentWidthDirty || this.getItemCount() == 0) {
            this.updateContentWidth();
            this.contentWidthDirty = false;
        }
    }

    private void updateTableItems(ObservableList<T> observableList, ObservableList<T> observableList2) {
        if (observableList != null) {
            observableList.removeListener(this.weakRowCountListener);
        }
        if (observableList2 != null) {
            observableList2.addListener(this.weakRowCountListener);
        }
        this.updateRowCount();
    }

    private void updateVisibleColumnCount() {
        this.visibleColCount = ((TableView)this.getSkinnable()).getVisibleLeafColumns().size();
        this.updatePlaceholderRegionVisibility();
        this.reconfigureCells();
    }

    private void updateVisibleLeafColumnWidthListeners(List<? extends TableColumn<T, ?>> list, List<? extends TableColumn<T, ?>> list2) {
        for (TableColumn<T, ?> tableColumn : list2) {
            tableColumn.widthProperty().removeListener(this.weakWidthListener);
        }
        for (TableColumn<T, ?> tableColumn : list) {
            tableColumn.widthProperty().addListener(this.weakWidthListener);
        }
        this.flow.reconfigureCells();
    }

    private void updatePlaceholderRegionVisibility() {
        boolean bl;
        boolean bl2 = bl = this.visibleColCount == 0 || this.getItemCount() == 0;
        if (bl) {
            Node node;
            if (this.placeholderRegion == null) {
                this.placeholderRegion = new StackPane();
                this.placeholderRegion.getStyleClass().setAll((String[])new String[]{"placeholder"});
                this.getChildren().add(this.placeholderRegion);
            }
            if ((node = ((TableView)this.getSkinnable()).getPlaceholder()) == null) {
                if (this.placeholderLabel == null) {
                    this.placeholderLabel = new Label();
                }
                String string = this.visibleColCount == 0 ? NO_COLUMNS_TEXT : EMPTY_TABLE_TEXT;
                this.placeholderLabel.setText(string);
                this.placeholderRegion.getChildren().setAll((Node[])new Node[]{this.placeholderLabel});
            } else {
                this.placeholderRegion.getChildren().setAll((Node[])new Node[]{node});
            }
        }
        this.flow.setVisible(!bl);
        if (this.placeholderRegion != null) {
            this.placeholderRegion.setVisible(bl);
        }
    }

    private void updateContentWidth() {
        double d = this.flow.getWidth();
        if (this.flow.getVbar().isVisible()) {
            d -= this.flow.getVbar().getWidth();
        }
        if (d <= 0.0) {
            d = this.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
        }
        ((TableView)this.getSkinnable()).getProperties().put("TableView.contentWidth", Math.floor(d));
    }

    private void refreshView() {
        this.updateRowCount();
    }

    private void reconfigureCells() {
        this.flow.reconfigureCells();
    }

    private void updateRowCount() {
        this.updatePlaceholderRegionVisibility();
        for (int i = 0; i < this.flow.cells.size(); ++i) {
            ((TableRow)this.flow.cells.get(i)).updateTableView(null);
        }
        this.flow.setCellCount(this.getItemCount());
        this.flow.recreateCells();
    }

    private void onFocusPreviousCell() {
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getSkinnable()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        this.flow.show(tableViewFocusModel.getFocusedIndex());
    }

    private void onFocusNextCell() {
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getSkinnable()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        this.flow.show(tableViewFocusModel.getFocusedIndex());
    }

    private void onSelectPreviousCell() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getSkinnable()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        this.flow.show(tableViewSelectionModel.getSelectedIndex());
    }

    private void onSelectNextCell() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getSkinnable()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        this.flow.show(tableViewSelectionModel.getSelectedIndex());
    }

    private void onSelectLeftCell() {
        this.scrollHorizontally();
    }

    private void onSelectRightCell() {
        this.scrollHorizontally();
    }

    private void moveToLeftMostColumn() {
        this.scrollHorizontally(((TableView)this.getSkinnable()).getVisibleLeafColumn(0));
    }

    private void moveToRightMostColumn() {
        this.scrollHorizontally(((TableView)this.getSkinnable()).getVisibleLeafColumn(((TableView)this.getSkinnable()).getVisibleLeafColumns().size() - 1));
    }

    private void scrollHorizontally() {
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getSkinnable()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        TableColumn tableColumn = tableViewFocusModel.getFocusedCell().getTableColumn();
        this.scrollHorizontally(tableColumn);
    }

    private void scrollHorizontally(TableColumn tableColumn) {
        TableColumn tableColumn2;
        if (tableColumn == null || !tableColumn.isVisible()) {
            return;
        }
        double d = this.scrollX;
        Iterator iterator = ((TableView)this.getSkinnable()).getVisibleLeafColumns().iterator();
        while (iterator.hasNext() && !(tableColumn2 = (TableColumn)iterator.next()).equals(tableColumn)) {
            d += tableColumn2.getWidth();
        }
        double d2 = d + tableColumn.getWidth();
        double d3 = ((TableView)this.getSkinnable()).getWidth() - this.getInsets().getLeft() + this.getInsets().getRight();
        double d4 = this.flow.getHbar().getValue();
        double d5 = this.flow.getHbar().getMax();
        double d6 = d4;
        if (d < d4 && d >= 0.0) {
            d6 = d;
        } else {
            double d7 = d < 0.0 || d2 > d3 ? d : 0.0;
            d6 = d4 + d7 > d5 ? d5 : d4 + d7;
        }
        this.flow.getHbar().setValue(d6);
    }

    private void onMoveToFirstCell() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getSkinnable()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        this.flow.show(0);
        this.flow.setPosition(0.0);
    }

    private void onMoveToLastCell() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getSkinnable()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        int n = this.getItemCount();
        this.flow.show(n);
        this.flow.setPosition(1.0);
    }

    private boolean isCellSelected(int n) {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getSkinnable()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return false;
        }
        if (!tableViewSelectionModel.isCellSelectionEnabled()) {
            return false;
        }
        int n2 = ((TableView)this.getSkinnable()).getVisibleLeafColumns().size();
        for (int i = 0; i < n2; ++i) {
            if (!tableViewSelectionModel.isSelected(n, ((TableView)this.getSkinnable()).getVisibleLeafColumn(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isCellFocused(int n) {
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getSkinnable()).getFocusModel();
        if (tableViewFocusModel == null) {
            return false;
        }
        int n2 = ((TableView)this.getSkinnable()).getVisibleLeafColumns().size();
        for (int i = 0; i < n2; ++i) {
            if (!tableViewFocusModel.isFocused(n, ((TableView)this.getSkinnable()).getVisibleLeafColumn(i))) continue;
            return true;
        }
        return false;
    }
}

