/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.ListIterator;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;

public class SplitPaneSkin
extends SkinBase<SplitPane, BehaviorBase<SplitPane>> {
    private ObservableList<Content> contentRegions;
    private ObservableList<ContentDivider> contentDividers;
    private boolean horizontal;
    private boolean updateDividerPos = false;
    private double previousSize = -1.0;
    private final ChangeListener posPropertyListener = new ChangeListener(){

        public void changed(ObservableValue observableValue, Object object, Object object2) {
            SplitPaneSkin.this.updateDividerPos = true;
            SplitPaneSkin.this.requestLayout();
        }
    };
    private boolean minSizeReached = false;

    public SplitPaneSkin(SplitPane splitPane) {
        super(splitPane, new BehaviorBase<SplitPane>(splitPane));
        this.setManaged(false);
        this.horizontal = ((SplitPane)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
        this.contentRegions = FXCollections.observableArrayList();
        this.contentDividers = FXCollections.observableArrayList();
        int n = 0;
        for (Node object : ((SplitPane)this.getSkinnable()).getItems()) {
            this.addContent(n++, object);
        }
        this.initializeContentListener();
        for (SplitPane.Divider divider : ((SplitPane)this.getSkinnable()).getDividers()) {
            this.addDivider(divider);
        }
        this.registerChangeListener(splitPane.orientationProperty(), "ORIENTATION");
        this.registerChangeListener(splitPane.widthProperty(), "WIDTH");
        this.registerChangeListener(splitPane.heightProperty(), "HEIGHT");
    }

    private void addContent(int n, Node node) {
        Content content = new Content(node);
        this.contentRegions.add(n, content);
        this.getChildren().add(n, content);
    }

    private void removeContent(Node node) {
        for (Content content : this.contentRegions) {
            if (!content.getContent().equals(node)) continue;
            this.getChildren().remove(content);
            this.contentRegions.remove(content);
            break;
        }
    }

    private void initializeContentListener() {
        ((SplitPane)this.getSkinnable()).getItems().addListener(new ListChangeListener<Node>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Node> change) {
                while (change.next()) {
                    for (Node node : change.getRemoved()) {
                        SplitPaneSkin.this.removeContent(node);
                    }
                    int n = change.getFrom();
                    for (Node node : change.getAddedSubList()) {
                        SplitPaneSkin.this.addContent(n++, node);
                    }
                }
                SplitPaneSkin.this.removeAllDividers();
                for (SplitPane.Divider divider : ((SplitPane)SplitPaneSkin.this.getSkinnable()).getDividers()) {
                    SplitPaneSkin.this.addDivider(divider);
                }
            }
        });
    }

    private void addDivider(SplitPane.Divider divider) {
        ContentDivider contentDivider = new ContentDivider(divider);
        contentDivider.setInitialPos(divider.getPosition());
        contentDivider.setDividerPos(divider.getPosition());
        divider.positionProperty().addListener(this.posPropertyListener);
        this.initializeDivderEventHandlers(contentDivider);
        this.contentDividers.add(contentDivider);
        this.getChildren().add(contentDivider);
    }

    private void removeAllDividers() {
        ListIterator listIterator = this.contentDividers.listIterator();
        while (listIterator.hasNext()) {
            ContentDivider contentDivider = (ContentDivider)listIterator.next();
            this.getChildren().remove(contentDivider);
            contentDivider.getDivider().positionProperty().removeListener(this.posPropertyListener);
            listIterator.remove();
        }
    }

    private void initializeDivderEventHandlers(final ContentDivider contentDivider) {
        contentDivider.addEventHandler(MouseEvent.ANY, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }
        });
        contentDivider.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (SplitPaneSkin.this.horizontal) {
                    contentDivider.setInitialPos(contentDivider.getDividerPos());
                    contentDivider.setPressPos(mouseEvent.getSceneX());
                } else {
                    contentDivider.setInitialPos(contentDivider.getDividerPos());
                    contentDivider.setPressPos(mouseEvent.getSceneY());
                }
                mouseEvent.consume();
            }
        });
        contentDivider.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                double d;
                double d2;
                double d3;
                double d4;
                double d5 = contentDivider.prefWidth(-1.0);
                double d6 = d5 / 2.0;
                Content content = SplitPaneSkin.this.getLeft(contentDivider);
                Content content2 = SplitPaneSkin.this.getRight(contentDivider);
                double d7 = content == null ? 0.0 : (d4 = SplitPaneSkin.this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0));
                double d8 = content2 == null ? 0.0 : (d3 = SplitPaneSkin.this.horizontal ? content2.minWidth(-1.0) : content2.minHeight(-1.0));
                double d9 = content == null ? 0.0 : (content.getContent() != null ? (SplitPaneSkin.this.horizontal ? content.getContent().maxWidth(-1.0) : content.getContent().maxHeight(-1.0)) : (d2 = 0.0));
                double d10 = content2 == null ? 0.0 : (content2.getContent() != null ? (SplitPaneSkin.this.horizontal ? content2.getContent().maxWidth(-1.0) : content2.getContent().maxHeight(-1.0)) : 0.0);
                double d11 = 0.0;
                if (SplitPaneSkin.this.horizontal) {
                    d = mouseEvent.getSceneX() - contentDivider.getPressPos();
                    d11 = SplitPaneSkin.this.getWidth() - (SplitPaneSkin.this.getInsets().getLeft() + SplitPaneSkin.this.getInsets().getRight());
                } else {
                    d = mouseEvent.getSceneY() - contentDivider.getPressPos();
                    d11 = SplitPaneSkin.this.getHeight() - (SplitPaneSkin.this.getInsets().getTop() + SplitPaneSkin.this.getInsets().getBottom());
                }
                double d12 = Math.ceil(contentDivider.getInitialPos() + d);
                double d13 = 0.0;
                double d14 = SplitPaneSkin.this.getSize();
                int n = SplitPaneSkin.this.contentDividers.indexOf(contentDivider);
                if (n - 1 >= 0) {
                    d13 = ((ContentDivider)SplitPaneSkin.this.contentDividers.get(n - 1)).getDividerPos();
                }
                if (n + 1 < SplitPaneSkin.this.contentDividers.size()) {
                    d14 = ((ContentDivider)SplitPaneSkin.this.contentDividers.get(n + 1)).getDividerPos();
                }
                if (d > 0.0) {
                    double d15;
                    double d16 = d13 == 0.0 ? d2 + d6 : d13 + d2 + d5;
                    double d17 = d14 - d3 - d5;
                    if (d14 > d11) {
                        d14 = d11;
                        d17 = d14 - d5;
                    }
                    if (d14 == d11) {
                        d17 += d6;
                    }
                    if (d12 >= (d15 = Math.min(d16, d17))) {
                        SplitPaneSkin.this.setDividerPos(contentDivider, d15);
                    } else {
                        SplitPaneSkin.this.setDividerPos(contentDivider, d12);
                    }
                } else {
                    double d18;
                    double d19;
                    double d20 = d14 - d10 - d5;
                    double d21 = d19 = d13 == 0.0 ? d4 + d6 : d13 + d4 + d5;
                    if (d14 == d11) {
                        d20 += d6;
                    }
                    if (d12 <= (d18 = Math.max(d20, d19))) {
                        SplitPaneSkin.this.setDividerPos(contentDivider, d18);
                    } else {
                        SplitPaneSkin.this.setDividerPos(contentDivider, d12);
                    }
                }
                mouseEvent.consume();
            }
        });
    }

    private Content getLeft(ContentDivider contentDivider) {
        int n = this.contentDividers.indexOf(contentDivider);
        if (n != -1) {
            return (Content)this.contentRegions.get(n);
        }
        return null;
    }

    private Content getRight(ContentDivider contentDivider) {
        int n = this.contentDividers.indexOf(contentDivider);
        if (n != -1) {
            return (Content)this.contentRegions.get(n + 1);
        }
        return null;
    }

    private ContentDivider getContentDivider(SplitPane.Divider divider) {
        for (ContentDivider contentDivider : this.contentDividers) {
            if (!contentDivider.getDivider().equals(divider)) continue;
            return contentDivider;
        }
        return null;
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "ORIENTATION") {
            this.horizontal = ((SplitPane)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
            for (ContentDivider contentDivider : this.contentDividers) {
                contentDivider.setGrabberStyle(this.horizontal);
            }
            ((SplitPane)this.getSkinnable()).requestLayout();
        } else if (string == "WIDTH") {
            this.updateDividerPos = true;
        } else if (string == "HEIGHT") {
            this.updateDividerPos = true;
        }
    }

    private void setDividerPos(ContentDivider contentDivider, double d) {
        if (this.getWidth() > 0.0 && this.getHeight() > 0.0) {
            SplitPane.Divider divider = contentDivider.getDivider();
            contentDivider.setDividerPos(d);
            double d2 = this.getSize();
            if (d2 != 0.0) {
                divider.setPosition(contentDivider.getDividerPos() / d2);
            } else {
                divider.setPosition(0.0);
            }
        }
        this.requestLayout();
    }

    private void updateDividerPos(ContentDivider contentDivider) {
        if (this.updateDividerPos) {
            if (this.getWidth() > 0.0 && this.getHeight() > 0.0) {
                double d = this.getSize() * contentDivider.getDivider().getPosition();
                contentDivider.setDividerPos(Math.round(d -= contentDivider.prefWidth(-1.0) / 2.0));
            }
            this.updateDividerPos = false;
        }
    }

    private int indexOfMaxContent() {
        double d = 0.0;
        Content content = null;
        for (Content content2 : this.contentRegions) {
            if (!content2.fitsInArea() || !(content2.getDisplayWidth() > d)) continue;
            d = content2.getDisplayWidth();
            content = content2;
        }
        return this.contentRegions.indexOf(content);
    }

    private double totalMinSize() {
        double d = !this.contentDividers.isEmpty() ? (double)this.contentDividers.size() * ((ContentDivider)this.contentDividers.get(0)).prefWidth(-1.0) : 0.0;
        double d2 = 0.0;
        for (Content content : this.contentRegions) {
            if (this.horizontal) {
                d2 += content.minWidth(-1.0);
                continue;
            }
            d2 += content.minHeight(-1.0);
        }
        return d2 + d;
    }

    private double totalMaxSize() {
        double d = !this.contentDividers.isEmpty() ? (double)this.contentDividers.size() * ((ContentDivider)this.contentDividers.get(0)).prefWidth(-1.0) : 0.0;
        double d2 = 0.0;
        for (Content content : this.contentRegions) {
            d2 += content.getContent() != null ? (this.horizontal ? content.getContent().maxWidth(-1.0) : content.getContent().maxHeight(-1.0)) : 0.0;
        }
        return d2 + d;
    }

    private double getSize() {
        double d = this.totalMinSize();
        if (this.horizontal) {
            if (this.getWidth() > d) {
                d = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
            }
        } else if (this.getHeight() > d) {
            d = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        }
        return d;
    }

    private void layoutDividersAndContent() {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.getInsets().getLeft();
        double d5 = this.getInsets().getTop();
        double d6 = d = this.contentDividers.isEmpty() ? 0.0 : ((ContentDivider)this.contentDividers.get(0)).prefWidth(-1.0);
        if (this.horizontal) {
            d2 = this.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
            d3 = this.getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom());
        } else {
            d2 = this.getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom());
            d3 = this.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
        }
        for (Content stackPane : this.contentRegions) {
            if (this.horizontal) {
                this.layoutInArea(stackPane, stackPane.getX() + d4, stackPane.getY() + d5, stackPane.getDisplayWidth(), stackPane.getDisplayHeight(), 0.0, HPos.CENTER, VPos.CENTER);
                continue;
            }
            this.layoutInArea(stackPane, stackPane.getX() + d4, stackPane.getY() + d5, stackPane.getDisplayHeight(), stackPane.getDisplayWidth(), 0.0, HPos.CENTER, VPos.CENTER);
        }
        for (ContentDivider contentDivider : this.contentDividers) {
            if (this.horizontal) {
                contentDivider.resize(d, d3);
                this.positionInArea(contentDivider, contentDivider.getX() + d4, contentDivider.getY() + d5, d, d3, 0.0, HPos.CENTER, VPos.CENTER);
                continue;
            }
            contentDivider.resize(d3, d);
            this.positionInArea(contentDivider, contentDivider.getX() + d4, contentDivider.getY() + d5, d3, d, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resizeSplitPane() {
        boolean bl;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl2 = bl = this.previousSize < (this.horizontal ? this.getWidth() : this.getHeight());
        if (this.horizontal) {
            d = this.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
            d2 = this.getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom());
        } else {
            d = this.getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom());
            d2 = this.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
        }
        double d3 = this.totalMinSize();
        if (!bl && this.minSizeReached) {
            return;
        }
        if (this.minSizeReached) {
            if (!(d >= d3)) return;
            this.minSizeReached = false;
        } else if (d < d3) {
            d = d3;
        }
        double d4 = this.contentDividers.isEmpty() ? 0.0 : ((ContentDivider)this.contentDividers.get(0)).prefWidth(-1.0);
        double d5 = d4 / 2.0;
        double d6 = this.totalMaxSize();
        double d7 = this.horizontal ? ((ContentDivider)this.contentDividers.get(this.contentDividers.size() - 1)).getDividerPos() - d5 : 0.0;
        double d8 = this.horizontal ? 0.0 : ((ContentDivider)this.contentDividers.get(this.contentDividers.size() - 1)).getDividerPos() - d5;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = d;
        double d12 = 0.0;
        Content content = null;
        ContentDivider contentDivider = null;
        Content content2 = null;
        for (int i = this.contentDividers.size() - 1; i >= 0; --i) {
            double d13;
            double d14;
            double d15;
            double d16;
            double d17;
            double d18;
            contentDivider = (ContentDivider)this.contentDividers.get(i);
            content2 = this.getRight(contentDivider);
            content = this.getLeft(contentDivider);
            d11 = i + 1 >= this.contentDividers.size() ? d : ((ContentDivider)this.contentDividers.get(i + 1)).getDividerPos() - d5;
            d9 = ((ContentDivider)this.contentDividers.get(i)).getDividerPos() - d5;
            d10 = i - 1 < 0 ? 0.0 : ((ContentDivider)this.contentDividers.get(i - 1)).getDividerPos() - d5;
            double d19 = d9 - (d10 == 0.0 ? 0.0 : d10 + d4);
            double d20 = d11 - (d9 + d4);
            double d21 = content == null ? 0.0 : (d18 = this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0));
            double d22 = content == null ? 0.0 : (d17 = this.horizontal ? content.prefWidth(-1.0) : content.prefHeight(-1.0));
            double d23 = content == null ? 0.0 : (content.getContent() != null ? (this.horizontal ? content.getContent().maxWidth(-1.0) : content.getContent().maxHeight(-1.0)) : (d16 = 0.0));
            double d24 = content2 == null ? 0.0 : (d15 = this.horizontal ? content2.minWidth(-1.0) : content2.minHeight(-1.0));
            double d25 = content2 == null ? 0.0 : (d14 = this.horizontal ? content2.prefWidth(-1.0) : content2.prefHeight(-1.0));
            double d26 = content2 == null ? 0.0 : (content2.getContent() != null ? (this.horizontal ? content2.getContent().maxWidth(-1.0) : content2.getContent().maxHeight(-1.0)) : (d13 = 0.0));
            double d27 = d20 <= d15 ? d15 : (d20 >= d13 ? d13 : (content2.isManaged() ? d20 : Math.min(d14, d20)));
            double d28 = d19 <= d18 ? d18 : (d19 >= d16 ? d16 : (content.isManaged() ? d19 : Math.min(d17, d19)));
            double d29 = d20;
            double d30 = d19;
            if (this.horizontal) {
                if (d29 >= d13) {
                    content2.setX(d7 + d4 + (d29 - d13) / 2.0);
                    content2.setY(d8);
                    content2.setDisplayWidth(d13);
                    content2.setDisplayHeight(d2);
                    if (bl) {
                        d9 = d12 = d11 - d13 - d4;
                        d30 = d12 - (d10 == 0.0 ? 0.0 : d10 + d4);
                        if (d9 + d13 + d4 >= d6) {
                            d12 = d6 - d13 - d4;
                        }
                        d29 = d11 - (d12 + d4);
                        content2.setX(d12 + d4 + (d29 - d13) / 2.0);
                    } else {
                        d12 = d9;
                    }
                } else if (d29 > d15) {
                    content2.setX(d7 + d4);
                    content2.setY(d8);
                    content2.setDisplayWidth(d29);
                    content2.setDisplayHeight(d2);
                    d12 = d9;
                } else {
                    d7 = d11 - d15;
                    content2.setX(d7);
                    content2.setY(d8);
                    content2.setDisplayWidth(d15);
                    content2.setDisplayHeight(d2);
                    d9 = d12 = d7 - d4;
                    d30 = d12 - (d10 == 0.0 ? 0.0 : d10 + d4);
                    if (d30 <= d18) {
                        d30 = d18;
                        double d31 = d10 = d10 <= 0.0 ? 0.0 : d9 - d18 - d4;
                        if (!bl && d <= d3) {
                            this.minSizeReached = true;
                        }
                    }
                }
                contentDivider.setX(d12);
                contentDivider.setY(d8);
                if (d30 >= d16) {
                    d7 = d10;
                    content.setX(d7);
                    content.setY(d8);
                    content.setDisplayWidth(d16);
                    content.setDisplayHeight(d2);
                } else if (d30 > d18) {
                    d7 = d10;
                    content.setX(d7);
                    content.setY(d8);
                    content.setDisplayWidth(d30);
                    content.setDisplayHeight(d2);
                } else {
                    d7 = d10;
                    content.setX(d7);
                    content.setY(d8);
                    content.setDisplayWidth(d18);
                    content.setDisplayHeight(d2);
                }
            } else {
                if (d29 >= d13) {
                    content2.setX(d7);
                    content2.setY(d8 + d4 + (d29 - d13) / 2.0);
                    content2.setDisplayWidth(d13);
                    content2.setDisplayHeight(d2);
                    if (bl) {
                        d9 = d12 = d11 - d13 - d4;
                        d30 = d12 - (d10 == 0.0 ? 0.0 : d10 + d4);
                        if (d9 + d13 + d4 >= d6) {
                            d12 = d6 - d13 - d4;
                        }
                        d29 = d11 - (d12 + d4);
                        content2.setY(d12 + d4 + (d29 - d13) / 2.0);
                    } else {
                        d12 = d9;
                    }
                } else if (d29 > d15) {
                    content2.setX(d7);
                    content2.setY(d8 + d4);
                    content2.setDisplayWidth(d29);
                    content2.setDisplayHeight(d2);
                    d12 = d9;
                } else {
                    d8 = d11 - d15;
                    content2.setX(d7);
                    content2.setY(d8);
                    content2.setDisplayWidth(d15);
                    content2.setDisplayHeight(d2);
                    d9 = d12 = d8 - d4;
                    d30 = d12 - (d10 == 0.0 ? 0.0 : d10 + d4);
                    if (d30 <= d18) {
                        d30 = d18;
                        double d32 = d10 = d10 <= 0.0 ? 0.0 : d9 - d18 - d4;
                        if (!bl && d <= d3) {
                            this.minSizeReached = true;
                        }
                    }
                }
                contentDivider.setX(d7);
                contentDivider.setY(d12);
                if (d30 >= d16) {
                    d8 = d10;
                    content.setX(d7);
                    content.setY(d8);
                    content.setDisplayWidth(d16);
                    content.setDisplayHeight(d2);
                } else if (d30 > d18) {
                    d8 = d10;
                    content.setX(d7);
                    content.setY(d8);
                    content.setDisplayWidth(d30);
                    content.setDisplayHeight(d2);
                } else {
                    d8 = d10;
                    content.setX(d7);
                    content.setY(d8);
                    content.setDisplayWidth(d18);
                    content.setDisplayHeight(d2);
                }
            }
            this.setDividerPos(contentDivider, d12 + d5);
        }
        this.layoutDividersAndContent();
    }

    @Override
    protected void layoutChildren() {
        int n;
        double d;
        int n2;
        if (this.contentDividers.size() > 0 && this.previousSize != -1.0 && this.previousSize != (this.horizontal ? this.getWidth() : this.getHeight())) {
            this.resizeSplitPane();
            this.previousSize = this.horizontal ? this.getWidth() : this.getHeight();
            return;
        }
        this.previousSize = this.horizontal ? this.getWidth() : this.getHeight();
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.horizontal) {
            d2 = this.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
            d3 = this.getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom());
        } else {
            d2 = this.getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom());
            d3 = this.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
        }
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = d2;
        double d9 = this.contentDividers.isEmpty() ? 0.0 : ((ContentDivider)this.contentDividers.get(0)).prefWidth(-1.0);
        double d10 = d9 / 2.0;
        double d11 = 0.0;
        Content content = null;
        ContentDivider contentDivider = null;
        Content content2 = null;
        ContentDivider contentDivider2 = null;
        for (n2 = 0; n2 < this.contentRegions.size(); ++n2) {
            double d12;
            double d13;
            double d14;
            double d15;
            double d16;
            double d17;
            double d18;
            double d19;
            if (n2 + 1 == this.contentRegions.size()) {
                if (n2 != 0) break;
                ((Content)this.contentRegions.get(0)).setX(d4);
                ((Content)this.contentRegions.get(0)).setY(d5);
                ((Content)this.contentRegions.get(0)).setDisplayWidth(d2);
                ((Content)this.contentRegions.get(0)).setDisplayHeight(d3);
                break;
            }
            d8 = d2;
            contentDivider2 = null;
            content = (Content)this.contentRegions.get(n2);
            if (n2 < this.contentDividers.size()) {
                this.updateDividerPos = true;
                if (contentDivider != null) {
                    d7 = contentDivider.getDividerPos();
                }
                contentDivider = (ContentDivider)this.contentDividers.get(n2);
            }
            if (n2 + 1 < this.contentRegions.size()) {
                content2 = (Content)this.contentRegions.get(n2 + 1);
            }
            this.updateDividerPos(contentDivider);
            d6 = contentDivider.getDividerPos();
            if (n2 + 1 < this.contentDividers.size()) {
                contentDivider2 = (ContentDivider)this.contentDividers.get(n2 + 1);
                this.updateDividerPos = true;
                this.updateDividerPos(contentDivider2);
            }
            if (contentDivider2 != null && contentDivider2.getDividerPos() > d6) {
                d8 = contentDivider2.getDividerPos();
            }
            d = d6 + d10 - (d7 == 0.0 ? 0.0 : d7 + d9 - d10);
            double d20 = d8 - d6 - d10;
            double d21 = content == null ? 0.0 : (d19 = this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0));
            double d22 = content == null ? 0.0 : (d18 = this.horizontal ? content.prefWidth(-1.0) : content.prefHeight(-1.0));
            double d23 = content == null ? 0.0 : (content.getContent() != null ? (this.horizontal ? content.getContent().maxWidth(-1.0) : content.getContent().maxHeight(-1.0)) : (d17 = 0.0));
            double d24 = content2 == null ? 0.0 : (d16 = this.horizontal ? content2.minWidth(-1.0) : content2.minHeight(-1.0));
            double d25 = content2 == null ? 0.0 : (d15 = this.horizontal ? content2.prefWidth(-1.0) : content2.prefHeight(-1.0));
            double d26 = content2 == null ? 0.0 : (content2.getContent() != null ? (this.horizontal ? content2.getContent().maxWidth(-1.0) : content2.getContent().maxHeight(-1.0)) : 0.0);
            boolean bl = false;
            if (d <= d19 + d10) {
                d6 = (this.horizontal ? d4 : d5) + d19;
                d14 = d19;
                d20 = d8 - d6 - d10;
                bl = true;
            } else if (d >= d17) {
                d14 = d17;
                d20 = d8 - d6 - d10;
            } else {
                d -= d10;
                d14 = content.isManaged() ? d : Math.min(d18, d);
            }
            if (d20 <= d16 + d10) {
                d13 = d16;
                if (!bl) {
                    d12 = d8 - (d6 + d9);
                    d6 = d16 > d12 ? d8 - d12 - d9 : d8 - d16 - d9;
                }
                if (content.isManaged()) {
                    d14 = Math.min(d6, d17);
                }
            } else if (d20 >= d26) {
                d13 = d26;
            } else {
                d20 -= d10;
                d13 = content2.isManaged() ? d20 : Math.min(d15, d20);
            }
            d12 = d6 - (d7 == 0.0 ? 0.0 : d7 + d9 - d10);
            double d27 = d8 - (d6 + d9);
            if (this.horizontal) {
                if (d12 >= d17) {
                    content.setX(d4);
                    content.setY(d5);
                    content.setDisplayWidth(d17);
                    content.setDisplayHeight(d3);
                    d6 = d11 = d4 + d17;
                    d27 = d8 - (d11 + d9);
                } else if (d12 > d19) {
                    content.setX(d4);
                    content.setY(d5);
                    content.setDisplayWidth(d12);
                    content.setDisplayHeight(d3);
                    d11 = d6;
                } else {
                    content.setX(d4);
                    content.setY(d5);
                    content.setDisplayWidth(d19);
                    content.setDisplayHeight(d3);
                    d11 = d4 + d19;
                }
                contentDivider.setX(d11);
                contentDivider.setY(d5);
                if (d27 >= d26) {
                    d4 = d6 + d9;
                    content2.setX(d4 + (d27 - d26) / 2.0);
                    content2.setY(d5);
                    content2.setDisplayWidth(d26);
                    content2.setDisplayHeight(d3);
                } else if (d27 > d16) {
                    d4 = d6 + d9;
                    content2.setX(d4);
                    content2.setY(d5);
                    content2.setDisplayWidth(d27);
                    content2.setDisplayHeight(d3);
                } else {
                    content2.setFitsInArea(true);
                    if (d16 > d27) {
                        content2.setFitsInArea(false);
                    }
                    d4 = d6 + d9;
                    content2.setX(d4);
                    content2.setY(d5);
                    content2.setDisplayWidth(d16);
                    content2.setDisplayHeight(d3);
                }
            } else {
                if (d12 >= d17) {
                    content.setX(d4);
                    content.setY(d5);
                    content.setDisplayWidth(d17);
                    content.setDisplayHeight(d3);
                    d6 = d11 = d5 + d17;
                    d27 = d8 - (d11 + d9);
                } else if (d12 > d19) {
                    content.setX(d4);
                    content.setY(d5);
                    content.setDisplayWidth(d12);
                    content.setDisplayHeight(d3);
                    d11 = d6;
                } else {
                    content.setX(d4);
                    content.setY(d5);
                    content.setDisplayWidth(d19);
                    content.setDisplayHeight(d3);
                    d11 = d5 + d19;
                }
                contentDivider.setX(d4);
                contentDivider.setY(d11);
                if (d27 >= d26) {
                    d5 = d6 + d9;
                    content2.setX(d4);
                    content2.setY(d5 + (d27 - d26) / 2.0);
                    content2.setDisplayWidth(d26);
                    content2.setDisplayHeight(d3);
                } else if (d27 > d16) {
                    d5 = d6 + d9;
                    content2.setX(d4);
                    content2.setY(d5);
                    content2.setDisplayWidth(d27);
                    content2.setDisplayHeight(d3);
                } else {
                    content2.setFitsInArea(true);
                    if (d16 > d27) {
                        content2.setFitsInArea(false);
                    }
                    d5 = d6 + d9;
                    content2.setX(d4);
                    content2.setY(d5);
                    content2.setDisplayWidth(d16);
                    content2.setDisplayHeight(d3);
                }
            }
            this.setDividerPos(contentDivider, d11 + d10);
        }
        double d28 = d = this.contentRegions.size() > 1 ? ((ContentDivider)this.contentDividers.get(this.contentDividers.size() - 1)).getDividerPos() - d10 + d9 + ((Content)this.contentRegions.get(this.contentRegions.size() - 1)).getDisplayWidth() - d2 : 0.0;
        for (n2 = 0; d > 0.0 && n2 < 50 && (n = this.indexOfMaxContent()) != -1; ++n2) {
            double d29;
            ListIterator listIterator = this.contentRegions.listIterator(n);
            Content content3 = (Content)listIterator.next();
            double d30 = d29 = this.horizontal ? content3.minWidth(-1.0) : content3.minHeight(-1.0);
            if (content3.getDisplayWidth() - d > d29) {
                content3.setDisplayWidth(content3.getDisplayWidth() - d);
            } else {
                d -= d29 - (content3.getDisplayWidth() - d);
                content3.setDisplayWidth(d29);
            }
            while (listIterator.hasNext()) {
                content3 = (Content)listIterator.next();
                if (this.horizontal) {
                    content3.setX(content3.getX() - d);
                    continue;
                }
                content3.setY(content3.getY() - d);
            }
            ListIterator listIterator2 = this.contentDividers.listIterator(n);
            while (listIterator2.hasNext()) {
                ContentDivider contentDivider3 = (ContentDivider)listIterator2.next();
                if (this.horizontal) {
                    contentDivider3.setX(contentDivider3.getX() - d);
                } else {
                    contentDivider3.setY(contentDivider3.getY() - d);
                }
                this.setDividerPos(contentDivider3, contentDivider3.getDividerPos() - d);
            }
            d = ((ContentDivider)this.contentDividers.get(this.contentDividers.size() - 1)).getDividerPos() - d10 + d9 + ((Content)this.contentRegions.get(this.contentRegions.size() - 1)).getDisplayWidth() - d2;
        }
        this.layoutDividersAndContent();
    }

    @Override
    protected double computeMinWidth(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (Content stackPane : this.contentRegions) {
            d2 += stackPane.minWidth(-1.0);
            d3 = Math.max(d3, stackPane.minWidth(-1.0));
        }
        for (ContentDivider contentDivider : this.contentDividers) {
            d2 += contentDivider.prefWidth(-1.0);
        }
        if (this.horizontal) {
            return d2 + this.getInsets().getLeft() + this.getInsets().getRight();
        }
        return d3 + this.getInsets().getLeft() + this.getInsets().getRight();
    }

    @Override
    protected double computeMinHeight(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (Content stackPane : this.contentRegions) {
            d2 += stackPane.minHeight(-1.0);
            d3 = Math.max(d3, stackPane.minHeight(-1.0));
        }
        for (ContentDivider contentDivider : this.contentDividers) {
            d2 += contentDivider.prefWidth(-1.0);
        }
        if (this.horizontal) {
            return d3 + this.getInsets().getTop() + this.getInsets().getBottom();
        }
        return d2 + this.getInsets().getTop() + this.getInsets().getBottom();
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (Content stackPane : this.contentRegions) {
            d2 += stackPane.prefWidth(-1.0);
            d3 = Math.max(d3, stackPane.prefWidth(-1.0));
        }
        for (ContentDivider contentDivider : this.contentDividers) {
            d2 += contentDivider.prefWidth(-1.0);
        }
        if (this.horizontal) {
            return d2 + this.getInsets().getLeft() + this.getInsets().getRight();
        }
        return d3 + this.getInsets().getLeft() + this.getInsets().getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (Content stackPane : this.contentRegions) {
            d2 += stackPane.prefHeight(-1.0);
            d3 = Math.max(d3, stackPane.prefHeight(-1.0));
        }
        for (ContentDivider contentDivider : this.contentDividers) {
            d2 += contentDivider.prefWidth(-1.0);
        }
        if (this.horizontal) {
            return d3 + this.getInsets().getTop() + this.getInsets().getBottom();
        }
        return d2 + this.getInsets().getTop() + this.getInsets().getBottom();
    }

    class Content
    extends StackPane {
        private Node content;
        private Rectangle clipRect = new Rectangle();
        private double x;
        private double y;
        private double displayWidth;
        private double displayHeight;
        private boolean fitsInArea;

        public Content(Node node) {
            this.setClip(this.clipRect);
            this.content = node;
            if (node != null) {
                this.getChildren().add(node);
            }
            this.x = 0.0;
            this.y = 0.0;
            this.displayWidth = 0.0;
            this.displayHeight = 0.0;
            this.fitsInArea = true;
        }

        public Node getContent() {
            return this.content;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double d) {
            this.x = d;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double d) {
            this.y = d;
        }

        public double getDisplayHeight() {
            return this.displayHeight;
        }

        public void setDisplayHeight(double d) {
            this.displayHeight = d;
        }

        public double getDisplayWidth() {
            return this.displayWidth;
        }

        public void setDisplayWidth(double d) {
            this.displayWidth = d;
        }

        public boolean fitsInArea() {
            return this.fitsInArea;
        }

        public void setFitsInArea(boolean bl) {
            this.fitsInArea = bl;
        }

        @Override
        protected void setWidth(double d) {
            super.setWidth(d);
            this.clipRect.setWidth(d);
        }

        @Override
        protected void setHeight(double d) {
            super.setHeight(d);
            this.clipRect.setHeight(d);
        }
    }

    class ContentDivider
    extends StackPane {
        private double initialPos;
        private double dividerPos;
        private double pressPos;
        private SplitPane.Divider d;
        private StackPane grabber;
        private double x;
        private double y;

        public ContentDivider(SplitPane.Divider divider) {
            this.getStyleClass().setAll((String[])new String[]{"split-pane-divider"});
            this.d = divider;
            this.initialPos = 0.0;
            this.dividerPos = 0.0;
            this.pressPos = 0.0;
            this.grabber = new StackPane(){

                @Override
                protected double computeMinWidth(double d) {
                    return 0.0;
                }

                @Override
                protected double computeMinHeight(double d) {
                    return 0.0;
                }

                @Override
                protected double computePrefWidth(double d) {
                    return this.getInsets().getLeft() + this.getInsets().getRight();
                }

                @Override
                protected double computePrefHeight(double d) {
                    return this.getInsets().getTop() + this.getInsets().getBottom();
                }

                @Override
                protected double computeMaxWidth(double d) {
                    return this.computePrefWidth(-1.0);
                }

                @Override
                protected double computeMaxHeight(double d) {
                    return this.computePrefHeight(-1.0);
                }
            };
            this.setGrabberStyle(SplitPaneSkin.this.horizontal);
            this.getChildren().add(this.grabber);
        }

        public SplitPane.Divider getDivider() {
            return this.d;
        }

        public final void setGrabberStyle(boolean bl) {
            this.grabber.getStyleClass().clear();
            this.grabber.getStyleClass().setAll((String[])new String[]{"vertical-grabber"});
            this.setCursor(Cursor.V_RESIZE);
            if (bl) {
                this.grabber.getStyleClass().setAll((String[])new String[]{"horizontal-grabber"});
                this.setCursor(Cursor.H_RESIZE);
            }
        }

        public double getInitialPos() {
            return this.initialPos;
        }

        public void setInitialPos(double d) {
            this.initialPos = d;
        }

        public double getDividerPos() {
            return this.dividerPos;
        }

        public void setDividerPos(double d) {
            this.dividerPos = d;
        }

        public double getPressPos() {
            return this.pressPos;
        }

        public void setPressPos(double d) {
            this.pressPos = d;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double d) {
            this.x = d;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double d) {
            this.y = d;
        }

        @Override
        protected double computeMinWidth(double d) {
            return this.computePrefWidth(d);
        }

        @Override
        protected double computeMinHeight(double d) {
            return this.computePrefHeight(d);
        }

        @Override
        protected double computePrefWidth(double d) {
            return this.getInsets().getLeft() + this.getInsets().getRight();
        }

        @Override
        protected double computePrefHeight(double d) {
            return this.getInsets().getTop() + this.getInsets().getBottom();
        }

        @Override
        protected double computeMaxWidth(double d) {
            return this.computePrefWidth(d);
        }

        @Override
        protected double computeMaxHeight(double d) {
            return this.computePrefHeight(d);
        }

        @Override
        protected void layoutChildren() {
            double d = this.grabber.prefWidth(-1.0);
            double d2 = this.grabber.prefHeight(-1.0);
            double d3 = (this.getWidth() - d) / 2.0;
            double d4 = (this.getHeight() - d2) / 2.0;
            this.grabber.resize(d, d2);
            this.positionInArea(this.grabber, d3, d4, d, d2, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }
}

