/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.ScrollPaneBehavior;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.scene.traversal.TraversalEngine;
import com.sun.javafx.scene.traversal.TraverseListener;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.event.EventHandler;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;

public class ScrollPaneSkin
extends SkinBase<ScrollPane, ScrollPaneBehavior>
implements TraverseListener {
    private static final double DEFAULT_PREF_SIZE = 100.0;
    private static final double DEFAULT_MIN_SIZE = 36.0;
    private static final double DEFAULT_SB_BREADTH = 12.0;
    private static final double PAN_THRESHOLD = 0.5;
    private Node scrollNode;
    private double nodeWidth;
    private double nodeHeight;
    private double posX;
    private double posY;
    private boolean hsbvis;
    private boolean vsbvis;
    private double hsbHeight;
    private double vsbWidth;
    private StackPane viewRect;
    private double contentWidth;
    private double contentHeight;
    private StackPane corner;
    protected ScrollBar hsb;
    protected ScrollBar vsb;
    double pressX;
    double pressY;
    double ohvalue;
    double ovvalue;
    private Cursor saveCursor = null;
    private boolean dragDetected = false;
    Rectangle clipRect;
    private final InvalidationListener nodeListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            if (ScrollPaneSkin.this.vsbvis != ScrollPaneSkin.this.determineVerticalSBVisible() || ScrollPaneSkin.this.hsbvis != ScrollPaneSkin.this.determineHorizontalSBVisible()) {
                ScrollPaneSkin.this.requestLayout();
            } else {
                ScrollPaneSkin.this.updateVerticalSB();
                ScrollPaneSkin.this.updateHorizontalSB();
            }
        }
    };

    public ScrollPaneSkin(ScrollPane scrollPane) {
        super(scrollPane, new ScrollPaneBehavior(scrollPane));
        this.initialize();
        this.registerChangeListener(scrollPane.contentProperty(), "NODE");
        this.registerChangeListener(scrollPane.fitToWidthProperty(), "FIT_TO_WIDTH");
        this.registerChangeListener(scrollPane.fitToHeightProperty(), "FIT_TO_HEIGHT");
        this.registerChangeListener(scrollPane.hbarPolicyProperty(), "HBAR_POLICY");
        this.registerChangeListener(scrollPane.vbarPolicyProperty(), "VBAR_POLICY");
        this.registerChangeListener(scrollPane.hvalueProperty(), "HVALUE");
        this.registerChangeListener(scrollPane.vvalueProperty(), "VVALUE");
        this.registerChangeListener(scrollPane.prefViewportWidthProperty(), "PREF_VIEWPORT_WIDTH");
        this.registerChangeListener(scrollPane.prefViewportHeightProperty(), "PREF_VIEWPORT_HEIGHT");
    }

    private void initialize() {
        this.setManaged(false);
        ScrollPane scrollPane = (ScrollPane)this.getSkinnable();
        this.scrollNode = scrollPane.getContent();
        if (this.scrollNode != null) {
            this.scrollNode.layoutBoundsProperty().addListener(this.nodeListener);
        }
        this.viewRect = new StackPane(){

            @Override
            public void requestLayout() {
                ScrollPaneSkin.this.nodeWidth = -1.0;
                ScrollPaneSkin.this.nodeHeight = -1.0;
                super.requestLayout();
            }

            @Override
            protected void layoutChildren() {
                if (ScrollPaneSkin.this.nodeWidth == -1.0 || ScrollPaneSkin.this.nodeHeight == -1.0) {
                    ScrollPaneSkin.this.computeScrollNodeSize(this.getWidth(), this.getHeight());
                }
                if (ScrollPaneSkin.this.scrollNode != null && ScrollPaneSkin.this.scrollNode.isResizable()) {
                    ScrollPaneSkin.this.scrollNode.resize(ScrollPaneSkin.this.nodeWidth, ScrollPaneSkin.this.nodeHeight);
                    if (ScrollPaneSkin.this.vsbvis != ScrollPaneSkin.this.determineVerticalSBVisible() || ScrollPaneSkin.this.hsbvis != ScrollPaneSkin.this.determineHorizontalSBVisible()) {
                        ScrollPaneSkin.this.requestLayout();
                    }
                }
                if (ScrollPaneSkin.this.scrollNode != null) {
                    ScrollPaneSkin.this.scrollNode.relocate(0.0, 0.0);
                }
            }
        };
        this.viewRect.setManaged(false);
        this.clipRect = new Rectangle();
        this.viewRect.setClip(this.clipRect);
        this.hsb = new ScrollBar();
        this.vsb = new ScrollBar();
        this.vsb.setOrientation(Orientation.VERTICAL);
        this.corner = new StackPane();
        this.corner.getStyleClass().setAll((String[])new String[]{"corner"});
        this.viewRect.getChildren().clear();
        if (this.scrollNode != null) {
            this.viewRect.getChildren().add(this.scrollNode);
        }
        this.getChildren().clear();
        this.getChildren().addAll((Node[])new Node[]{this.viewRect, this.vsb, this.hsb, this.corner});
        InvalidationListener invalidationListener = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                ScrollPaneSkin.this.posY = Utils.clamp(((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getVmin(), ScrollPaneSkin.this.vsb.getValue(), ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getVmax());
                ScrollPaneSkin.this.updatePosY();
            }
        };
        this.vsb.valueProperty().addListener(invalidationListener);
        InvalidationListener invalidationListener2 = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                ScrollPaneSkin.this.posX = Utils.clamp(((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getHmin(), ScrollPaneSkin.this.hsb.getValue(), ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getHmax());
                ScrollPaneSkin.this.updatePosX();
            }
        };
        this.hsb.valueProperty().addListener(invalidationListener2);
        this.viewRect.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                ScrollPaneSkin.this.pressX = mouseEvent.getX() + ScrollPaneSkin.this.viewRect.getLayoutX();
                ScrollPaneSkin.this.pressY = mouseEvent.getY() + ScrollPaneSkin.this.viewRect.getLayoutY();
                ScrollPaneSkin.this.ohvalue = ScrollPaneSkin.this.hsb.getValue();
                ScrollPaneSkin.this.ovvalue = ScrollPaneSkin.this.vsb.getValue();
            }
        });
        this.viewRect.setOnDragDetected((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (((ScrollPane)ScrollPaneSkin.this.getSkinnable()).isPannable()) {
                    ScrollPaneSkin.this.dragDetected = true;
                    if (ScrollPaneSkin.this.saveCursor == null) {
                        ScrollPaneSkin.this.saveCursor = ScrollPaneSkin.this.getCursor();
                        if (ScrollPaneSkin.this.saveCursor == null) {
                            ScrollPaneSkin.this.saveCursor = Cursor.DEFAULT;
                        }
                        ScrollPaneSkin.this.setCursor(Cursor.MOVE);
                        ScrollPaneSkin.this.requestLayout();
                    }
                }
            }
        });
        this.viewRect.addEventFilter(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (ScrollPaneSkin.this.dragDetected) {
                    if (ScrollPaneSkin.this.saveCursor != null) {
                        ScrollPaneSkin.this.setCursor(ScrollPaneSkin.this.saveCursor);
                        ScrollPaneSkin.this.saveCursor = null;
                        ScrollPaneSkin.this.requestLayout();
                    }
                    ScrollPaneSkin.this.dragDetected = false;
                }
            }
        });
        this.viewRect.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (((ScrollPane)ScrollPaneSkin.this.getSkinnable()).isPannable()) {
                    double d;
                    double d2 = ScrollPaneSkin.this.pressX - (mouseEvent.getX() + ScrollPaneSkin.this.viewRect.getLayoutX());
                    double d3 = ScrollPaneSkin.this.pressY - (mouseEvent.getY() + ScrollPaneSkin.this.viewRect.getLayoutY());
                    if (ScrollPaneSkin.this.hsb.getVisibleAmount() < ScrollPaneSkin.this.hsb.getMax() && Math.abs(d2) > 0.5) {
                        d = ScrollPaneSkin.this.ohvalue + d2 / (ScrollPaneSkin.this.nodeWidth - ScrollPaneSkin.this.viewRect.getWidth()) * (ScrollPaneSkin.this.hsb.getMax() - ScrollPaneSkin.this.hsb.getMin());
                        if (d > ScrollPaneSkin.this.hsb.getMax()) {
                            d = ScrollPaneSkin.this.hsb.getMax();
                        } else if (d < ScrollPaneSkin.this.hsb.getMin()) {
                            d = ScrollPaneSkin.this.hsb.getMin();
                        }
                        ScrollPaneSkin.this.hsb.setValue(d);
                    }
                    if (ScrollPaneSkin.this.vsb.getVisibleAmount() < ScrollPaneSkin.this.vsb.getMax() && Math.abs(d3) > 0.5) {
                        d = ScrollPaneSkin.this.ovvalue + d3 / (ScrollPaneSkin.this.nodeHeight - ScrollPaneSkin.this.viewRect.getHeight()) * (ScrollPaneSkin.this.vsb.getMax() - ScrollPaneSkin.this.vsb.getMin());
                        if (d > ScrollPaneSkin.this.vsb.getMax()) {
                            d = ScrollPaneSkin.this.vsb.getMax();
                        } else if (d < ScrollPaneSkin.this.vsb.getMin()) {
                            d = ScrollPaneSkin.this.vsb.getMin();
                        }
                        ScrollPaneSkin.this.vsb.setValue(d);
                    }
                }
            }
        });
        this.viewRect.addEventFilter(ScrollEvent.SCROLL, new EventHandler<ScrollEvent>(){

            @Override
            public void handle(ScrollEvent scrollEvent) {
                double d;
                double d2;
                if (ScrollPaneSkin.this.vsb.getVisibleAmount() < ScrollPaneSkin.this.vsb.getMax() && (scrollEvent.getDeltaY() > 0.0 && ScrollPaneSkin.this.vsb.getValue() > ScrollPaneSkin.this.vsb.getMin() || scrollEvent.getDeltaY() < 0.0 && ScrollPaneSkin.this.vsb.getValue() < ScrollPaneSkin.this.vsb.getMax())) {
                    d2 = ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getVmax() - ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getVmin();
                    d = d2 / ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getHeight();
                    ScrollPaneSkin.this.vsb.setValue(ScrollPaneSkin.this.vsb.getValue() + -scrollEvent.getDeltaY() * d);
                    scrollEvent.consume();
                }
                if (ScrollPaneSkin.this.hsb.getVisibleAmount() < ScrollPaneSkin.this.hsb.getMax() && (scrollEvent.getDeltaX() > 0.0 && ScrollPaneSkin.this.hsb.getValue() > ScrollPaneSkin.this.hsb.getMin() || scrollEvent.getDeltaX() < 0.0 && ScrollPaneSkin.this.hsb.getValue() < ScrollPaneSkin.this.hsb.getMax())) {
                    d2 = ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getHmax() - ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getHmin();
                    d = d2 / ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getWidth();
                    ScrollPaneSkin.this.hsb.setValue(ScrollPaneSkin.this.hsb.getValue() + -scrollEvent.getDeltaX() * d);
                    scrollEvent.consume();
                }
            }
        });
        TraversalEngine traversalEngine = new TraversalEngine(this, false);
        traversalEngine.addTraverseListener(this);
        this.setImpl_traversalEngine(traversalEngine);
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "NODE") {
            if (this.scrollNode != ((ScrollPane)this.getSkinnable()).getContent()) {
                if (this.scrollNode != null) {
                    this.scrollNode.layoutBoundsProperty().removeListener(this.nodeListener);
                    this.viewRect.getChildren().remove(this.scrollNode);
                }
                this.scrollNode = ((ScrollPane)this.getSkinnable()).getContent();
                if (this.scrollNode != null) {
                    this.nodeWidth = Math.floor(this.scrollNode.getLayoutBounds().getWidth());
                    this.nodeHeight = Math.floor(this.scrollNode.getLayoutBounds().getHeight());
                    this.viewRect.getChildren().setAll((Node[])new Node[]{this.scrollNode});
                    this.scrollNode.layoutBoundsProperty().addListener(this.nodeListener);
                }
            }
            this.requestLayout();
        } else if (string == "FIT_TO_WIDTH") {
            this.requestLayout();
            this.viewRect.requestLayout();
        } else if (string == "FIT_TO_HEIGHT") {
            this.requestLayout();
            this.viewRect.requestLayout();
        } else if (string == "HBAR_POLICY") {
            ((ScrollPane)this.getSkinnable()).requestLayout();
            this.requestLayout();
        } else if (string == "VBAR_POLICY") {
            ((ScrollPane)this.getSkinnable()).requestLayout();
            this.requestLayout();
        } else if (string == "HVALUE") {
            this.hsb.setValue(((ScrollPane)this.getSkinnable()).getHvalue());
        } else if (string == "VVALUE") {
            this.vsb.setValue(((ScrollPane)this.getSkinnable()).getVvalue());
        } else if (string == "PREF_VIEWPORT_WIDTH") {
            ((ScrollPane)this.getSkinnable()).requestLayout();
        } else if (string == "PREF_VIEWPORT_HEIGHT") {
            ((ScrollPane)this.getSkinnable()).requestLayout();
        }
    }

    @Override
    public void onTraverse(Node node, Bounds bounds) {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = false;
        if (bounds.getMaxX() > this.contentWidth) {
            d2 = this.contentWidth - bounds.getMaxX();
        }
        if (bounds.getMinX() < 0.0) {
            d2 = -bounds.getMinX();
        }
        if (bounds.getMaxY() > this.contentHeight) {
            d3 = this.contentHeight - bounds.getMaxY();
        }
        if (bounds.getMinY() < 0.0) {
            d3 = -bounds.getMinY();
        }
        double d4 = this.hsb.getValue();
        double d5 = this.vsb.getValue();
        if (d2 != 0.0) {
            d = -d2 * (this.hsb.getMax() - this.hsb.getMin()) / (this.nodeWidth - this.viewRect.getWidth());
            d = d < 0.0 ? (d -= this.hsb.getUnitIncrement()) : (d += this.hsb.getUnitIncrement());
            d4 = Utils.clamp(this.hsb.getMin(), this.hsb.getValue() + d, this.hsb.getMax());
            this.hsb.setValue(d4);
            bl = true;
        }
        if (d3 != 0.0) {
            d = -d3 * (this.vsb.getMax() - this.vsb.getMin()) / (this.nodeHeight - this.viewRect.getHeight());
            d = d < 0.0 ? (d -= this.vsb.getUnitIncrement()) : (d += this.vsb.getUnitIncrement());
            d5 = Utils.clamp(this.vsb.getMin(), this.vsb.getValue() + d, this.vsb.getMax());
            this.vsb.setValue(d5);
            bl = true;
        }
        if (bl) {
            this.requestLayout();
        }
    }

    public void hsbIncrement() {
        if (this.hsb != null) {
            this.hsb.increment();
        }
    }

    public void hsbDecrement() {
        if (this.hsb != null) {
            this.hsb.decrement();
        }
    }

    public void hsbPageIncrement() {
        if (this.hsb != null) {
            this.hsb.increment();
        }
    }

    public void hsbPageDecrement() {
        if (this.hsb != null) {
            this.hsb.decrement();
        }
    }

    public void vsbIncrement() {
        if (this.vsb != null) {
            this.vsb.increment();
        }
    }

    public void vsbDecrement() {
        if (this.vsb != null) {
            this.vsb.decrement();
        }
    }

    public void vsbPageIncrement() {
        if (this.vsb != null) {
            this.vsb.increment();
        }
    }

    public void vsbPageDecrement() {
        if (this.vsb != null) {
            this.vsb.decrement();
        }
    }

    @Override
    protected double computePrefWidth(double d) {
        if (((ScrollPane)this.getSkinnable()).getPrefViewportWidth() > 0.0) {
            double d2 = ((ScrollPane)this.getSkinnable()).getVbarPolicy() == ScrollPane.ScrollBarPolicy.ALWAYS ? this.vsb.prefWidth(-1.0) : 0.0;
            return ((ScrollPane)this.getSkinnable()).getPrefViewportWidth() + d2 + this.getInsets().getLeft() + this.getInsets().getRight();
        }
        return 100.0;
    }

    @Override
    protected double computePrefHeight(double d) {
        if (((ScrollPane)this.getSkinnable()).getPrefViewportHeight() > 0.0) {
            double d2 = ((ScrollPane)this.getSkinnable()).getHbarPolicy() == ScrollPane.ScrollBarPolicy.ALWAYS ? this.hsb.prefHeight(-1.0) : 0.0;
            return ((ScrollPane)this.getSkinnable()).getPrefViewportHeight() + d2 + this.getInsets().getTop() + this.getInsets().getBottom();
        }
        return 100.0;
    }

    @Override
    protected double computeMinWidth(double d) {
        double d2 = this.corner.minWidth(-1.0);
        return d2 > 0.0 ? 3.0 * d2 : 36.0;
    }

    @Override
    protected double computeMinHeight(double d) {
        double d2 = this.corner.minHeight(-1.0);
        return d2 > 0.0 ? 3.0 * d2 : 36.0;
    }

    @Override
    protected void layoutChildren() {
        ScrollPane scrollPane = (ScrollPane)this.getSkinnable();
        this.vsb.setMin(scrollPane.getVmin());
        this.vsb.setMax(scrollPane.getVmax());
        this.hsb.setMin(scrollPane.getHmin());
        this.hsb.setMax(scrollPane.getHmax());
        this.contentWidth = scrollPane.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.contentHeight = scrollPane.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
        this.computeScrollBarSize();
        this.vsbvis = this.determineVerticalSBVisible();
        this.hsbvis = this.determineHorizontalSBVisible();
        if (this.vsbvis) {
            this.contentWidth -= this.vsbWidth;
        }
        if (this.hsbvis) {
            this.contentHeight -= this.hsbHeight;
        }
        if (this.scrollNode != null && this.scrollNode.isResizable()) {
            if (this.vsbvis && this.hsbvis) {
                this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
            } else if (this.hsbvis && !this.vsbvis) {
                this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
                this.vsbvis = this.determineVerticalSBVisible();
                if (this.vsbvis) {
                    this.contentWidth -= this.vsbWidth;
                    this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
                }
            } else if (this.vsbvis && !this.hsbvis) {
                this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
                this.hsbvis = this.determineHorizontalSBVisible();
                if (this.hsbvis) {
                    this.contentHeight -= this.hsbHeight;
                    this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
                }
            }
        }
        double d = this.getInsets().getLeft();
        double d2 = this.getInsets().getTop();
        this.vsb.setVisible(this.vsbvis);
        if (this.vsbvis) {
            this.vsb.resizeRelocate(this.snapPosition(scrollPane.getWidth() - this.vsbWidth - this.getInsets().getRight()), d2, this.vsbWidth, this.contentHeight);
        }
        this.updateVerticalSB();
        this.hsb.setVisible(this.hsbvis);
        if (this.hsbvis) {
            this.hsb.resizeRelocate(d, this.snapPosition(scrollPane.getHeight() - (this.hsbHeight + this.getInsets().getBottom())), this.contentWidth, this.hsbHeight);
        }
        this.updateHorizontalSB();
        this.viewRect.resize(this.contentWidth, this.contentHeight);
        this.clipRect.setWidth(this.contentWidth);
        this.clipRect.setHeight(this.contentHeight);
        this.clipRect.relocate(this.getInsets().getLeft() - this.viewRect.getLayoutX(), this.getInsets().getTop() - this.viewRect.getLayoutY());
        if (this.vsbvis && this.hsbvis) {
            this.corner.setVisible(true);
            this.corner.resizeRelocate(this.vsb.getLayoutX(), this.hsb.getLayoutY(), this.vsbWidth, this.hsbHeight);
        } else {
            this.corner.setVisible(false);
        }
        scrollPane.setViewportBounds(new BoundingBox(this.viewRect.getLayoutX(), this.viewRect.getLayoutY(), this.contentWidth, this.contentHeight));
    }

    private void computeScrollNodeSize(double d, double d2) {
        if (this.scrollNode != null) {
            if (this.scrollNode.isResizable()) {
                ScrollPane scrollPane = (ScrollPane)this.getSkinnable();
                Orientation orientation = this.scrollNode.getContentBias();
                if (orientation == null) {
                    this.nodeWidth = com.sun.javafx.scene.control.skin.Utils.boundedSize(scrollPane.isFitToWidth() ? d : this.scrollNode.prefWidth(-1.0), this.scrollNode.minWidth(-1.0), this.scrollNode.maxWidth(-1.0));
                    this.nodeHeight = com.sun.javafx.scene.control.skin.Utils.boundedSize(scrollPane.isFitToHeight() ? d2 : this.scrollNode.prefHeight(-1.0), this.scrollNode.minHeight(-1.0), this.scrollNode.maxHeight(-1.0));
                } else if (orientation == Orientation.HORIZONTAL) {
                    this.nodeWidth = com.sun.javafx.scene.control.skin.Utils.boundedSize(scrollPane.isFitToWidth() ? d : this.scrollNode.prefWidth(-1.0), this.scrollNode.minWidth(-1.0), this.scrollNode.maxWidth(-1.0));
                    this.nodeHeight = com.sun.javafx.scene.control.skin.Utils.boundedSize(scrollPane.isFitToHeight() ? d2 : this.scrollNode.prefHeight(this.nodeWidth), this.scrollNode.minHeight(this.nodeWidth), this.scrollNode.maxHeight(this.nodeWidth));
                } else {
                    this.nodeHeight = com.sun.javafx.scene.control.skin.Utils.boundedSize(scrollPane.isFitToHeight() ? d2 : this.scrollNode.prefHeight(-1.0), this.scrollNode.minHeight(-1.0), this.scrollNode.maxHeight(-1.0));
                    this.nodeWidth = com.sun.javafx.scene.control.skin.Utils.boundedSize(scrollPane.isFitToWidth() ? d : this.scrollNode.prefWidth(this.nodeHeight), this.scrollNode.minWidth(this.nodeHeight), this.scrollNode.maxWidth(this.nodeHeight));
                }
            } else {
                this.nodeWidth = this.scrollNode.getLayoutBounds().getWidth();
                this.nodeHeight = this.scrollNode.getLayoutBounds().getHeight();
            }
        }
    }

    private boolean determineHorizontalSBVisible() {
        double d = ((ScrollPane)this.getSkinnable()).getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        return ((ScrollPane)this.getSkinnable()).getHbarPolicy().equals((Object)ScrollPane.ScrollBarPolicy.NEVER) ? false : (((ScrollPane)this.getSkinnable()).getHbarPolicy().equals((Object)ScrollPane.ScrollBarPolicy.ALWAYS) ? true : (((ScrollPane)this.getSkinnable()).isFitToWidth() && this.scrollNode.isResizable() ? false : this.nodeWidth > d));
    }

    private boolean determineVerticalSBVisible() {
        double d = ((ScrollPane)this.getSkinnable()).getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        return ((ScrollPane)this.getSkinnable()).getVbarPolicy().equals((Object)ScrollPane.ScrollBarPolicy.NEVER) ? false : (((ScrollPane)this.getSkinnable()).getVbarPolicy().equals((Object)ScrollPane.ScrollBarPolicy.ALWAYS) ? true : (((ScrollPane)this.getSkinnable()).isFitToHeight() && this.scrollNode.isResizable() ? false : this.nodeHeight > d));
    }

    private void computeScrollBarSize() {
        this.vsbWidth = this.vsb.prefWidth(-1.0);
        if (this.vsbWidth == 0.0) {
            this.vsbWidth = 12.0;
        }
        this.hsbHeight = this.hsb.prefHeight(-1.0);
        if (this.hsbHeight == 0.0) {
            this.hsbHeight = 12.0;
        }
    }

    private void updateHorizontalSB() {
        if (this.hsb.isVisible()) {
            this.hsb.setVisibleAmount(this.contentWidth / this.nodeWidth * (this.hsb.getMax() - this.hsb.getMin()));
            this.hsb.setBlockIncrement(0.9 * this.hsb.getVisibleAmount());
            this.hsb.setUnitIncrement(0.1 * this.hsb.getVisibleAmount());
            this.updatePosX();
        } else if (this.nodeWidth > this.contentWidth) {
            this.updatePosX();
        } else {
            this.viewRect.setLayoutX(this.getInsets().getLeft());
        }
    }

    private void updateVerticalSB() {
        if (this.vsb.isVisible()) {
            this.vsb.setVisibleAmount(this.contentHeight / this.nodeHeight * (this.vsb.getMax() - this.vsb.getMin()));
            this.vsb.setBlockIncrement(0.9 * this.vsb.getVisibleAmount());
            this.vsb.setUnitIncrement(0.1 * this.vsb.getVisibleAmount());
            this.updatePosY();
        } else if (this.nodeHeight > this.contentHeight) {
            this.updatePosY();
        } else {
            this.viewRect.setLayoutY(this.getInsets().getTop());
        }
    }

    private double updatePosX() {
        this.viewRect.setLayoutX(this.snapPosition(this.getInsets().getLeft() - this.posX / (this.hsb.getMax() - this.hsb.getMin()) * (this.nodeWidth - this.contentWidth)));
        ((ScrollPane)this.getSkinnable()).setHvalue(Utils.clamp(((ScrollPane)this.getSkinnable()).getHmin(), this.posX, ((ScrollPane)this.getSkinnable()).getHmax()));
        return this.posX;
    }

    private double updatePosY() {
        this.viewRect.setLayoutY(this.snapPosition(this.getInsets().getTop() - this.posY / (this.vsb.getMax() - this.vsb.getMin()) * (this.nodeHeight - this.contentHeight)));
        ((ScrollPane)this.getSkinnable()).setVvalue(Utils.clamp(((ScrollPane)this.getSkinnable()).getVmin(), this.posY, ((ScrollPane)this.getSkinnable()).getVmax()));
        return this.posY;
    }
}

