/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.ScrollBarBehavior;
import com.sun.javafx.scene.control.skin.EndButton;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.StackPane;

public class ScrollBarSkin
extends SkinBase<ScrollBar, ScrollBarBehavior> {
    public static int DEFAULT_LENGTH = 100;
    public static int DEFAULT_WIDTH = 20;
    private StackPane thumb;
    private StackPane track;
    private EndButton incButton;
    private EndButton decButton;
    private double trackLength;
    private double thumbLength;
    private double preDragThumbPos;
    private Point2D dragStart;
    private double trackPos;

    public ScrollBarSkin(ScrollBar scrollBar) {
        super(scrollBar, new ScrollBarBehavior(scrollBar));
        this.initialize();
        this.requestLayout();
        this.registerChangeListener(scrollBar.minProperty(), "MIN");
        this.registerChangeListener(scrollBar.maxProperty(), "MAX");
        this.registerChangeListener(scrollBar.valueProperty(), "VALUE");
        this.registerChangeListener(scrollBar.orientationProperty(), "ORIENTATION");
        this.registerChangeListener(scrollBar.visibleAmountProperty(), "VISIBLE_AMOUNT");
    }

    private void initialize() {
        this.decButton = new EndButton("decrement-button", "decrement-arrow");
        this.track = new StackPane();
        this.track.getStyleClass().setAll((String[])new String[]{"track"});
        this.thumb = new StackPane();
        this.thumb.getStyleClass().setAll((String[])new String[]{"thumb"});
        this.incButton = new EndButton("increment-button", "increment-arrow");
        ObservableList<StackPane> observableList = FXCollections.observableArrayList();
        observableList.add(this.incButton);
        observableList.add(this.decButton);
        observableList.add(this.track);
        observableList.add(this.thumb);
        this.getChildren().clear();
        this.getChildren().addAll((Collection<Node>)observableList);
        this.incButton.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (!ScrollBarSkin.this.thumb.isVisible() || ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                    ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).incButtonPressed(mouseEvent);
                }
                mouseEvent.consume();
            }
        });
        this.incButton.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (!ScrollBarSkin.this.thumb.isVisible() || ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                    ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).incButtonReleased(mouseEvent);
                }
                mouseEvent.consume();
            }
        });
        this.decButton.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (!ScrollBarSkin.this.thumb.isVisible() || ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                    ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).decButtonPressed(mouseEvent);
                }
                mouseEvent.consume();
            }
        });
        this.decButton.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (!ScrollBarSkin.this.thumb.isVisible() || ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                    ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).decButtonReleased(mouseEvent);
                }
                mouseEvent.consume();
            }
        });
        this.track.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (!ScrollBarSkin.this.thumb.isPressed()) {
                    if (((ScrollBar)ScrollBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                        if (ScrollBarSkin.this.trackLength != 0.0) {
                            ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).trackPress(mouseEvent, mouseEvent.getY() / ScrollBarSkin.this.trackLength);
                            mouseEvent.consume();
                        }
                    } else if (ScrollBarSkin.this.trackLength != 0.0) {
                        ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).trackPress(mouseEvent, mouseEvent.getX() / ScrollBarSkin.this.trackLength);
                        mouseEvent.consume();
                    }
                }
            }
        });
        this.track.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).trackRelease(mouseEvent, 0.0);
                mouseEvent.consume();
            }
        });
        this.thumb.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax() > ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin()) {
                    ScrollBarSkin.this.dragStart = ScrollBarSkin.this.thumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
                    double d = Utils.clamp(((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin(), ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getValue(), ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax());
                    ScrollBarSkin.this.preDragThumbPos = (d - ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin()) / (((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax() - ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin());
                    mouseEvent.consume();
                }
            }
        });
        this.thumb.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax() > ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin()) {
                    if (ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                        Point2D point2D = ScrollBarSkin.this.thumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
                        double d = ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? point2D.getY() - ScrollBarSkin.this.dragStart.getY() : point2D.getX() - ScrollBarSkin.this.dragStart.getX();
                        ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).thumbDragged(mouseEvent, ScrollBarSkin.this.preDragThumbPos + d / (ScrollBarSkin.this.trackLength - ScrollBarSkin.this.thumbLength));
                    }
                    mouseEvent.consume();
                }
            }
        });
        this.setOnScroll((EventHandler<? super ScrollEvent>)new EventHandler<ScrollEvent>(){

            @Override
            public void handle(ScrollEvent scrollEvent) {
                if (ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                    double d;
                    double d2 = scrollEvent.getDeltaX();
                    double d3 = scrollEvent.getDeltaY();
                    d2 = Math.abs(d2) < Math.abs(d3) ? d3 : d2;
                    ScrollBar scrollBar = (ScrollBar)ScrollBarSkin.this.getSkinnable();
                    double d4 = d = ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? d3 : d2;
                    if (d > 0.0 && scrollBar.getValue() > scrollBar.getMin()) {
                        scrollBar.decrement();
                        scrollEvent.consume();
                    } else if (d < 0.0 && scrollBar.getValue() < scrollBar.getMax()) {
                        scrollBar.increment();
                        scrollEvent.consume();
                    }
                }
            }
        });
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "ORIENTATION") {
            this.requestLayout();
        } else if (string == "MIN" || string == "MAX" || string == "VALUE" || string == "VISIBLE_AMOUNT") {
            this.positionThumb();
            this.requestLayout();
        }
    }

    double getBreadth() {
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            return Math.max(this.decButton.prefWidth(-1.0) + this.getInsets().getLeft() + this.getInsets().getRight(), this.incButton.prefWidth(-1.0) + this.getInsets().getLeft() + this.getInsets().getRight());
        }
        return Math.max(this.decButton.prefHeight(-1.0) + this.getInsets().getTop() + this.getInsets().getBottom(), this.incButton.prefHeight(-1.0) + this.getInsets().getTop() + this.getInsets().getBottom());
    }

    double minThumbLength() {
        return 1.5 * this.getBreadth();
    }

    double minTrackLength() {
        return 2.0 * this.getBreadth();
    }

    @Override
    protected double computeMinWidth(double d) {
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            return this.getBreadth();
        }
        return this.decButton.minWidth(-1.0) + this.incButton.minWidth(-1.0) + this.minTrackLength() + this.getInsets().getLeft() + this.getInsets().getRight();
    }

    @Override
    protected double computeMinHeight(double d) {
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            return this.decButton.minHeight(-1.0) + this.incButton.minHeight(-1.0) + this.minTrackLength() + this.getInsets().getTop() + this.getInsets().getBottom();
        }
        return this.getBreadth();
    }

    @Override
    protected double computePrefWidth(double d) {
        return ((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? this.getBreadth() : (double)DEFAULT_LENGTH + this.getInsets().getLeft() + this.getInsets().getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        return ((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? (double)DEFAULT_LENGTH + this.getInsets().getTop() + this.getInsets().getBottom() : this.getBreadth();
    }

    @Override
    protected double computeMaxWidth(double d) {
        return ((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? ((ScrollBar)this.getSkinnable()).prefWidth(-1.0) : Double.MAX_VALUE;
    }

    @Override
    protected double computeMaxHeight(double d) {
        return ((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? Double.MAX_VALUE : ((ScrollBar)this.getSkinnable()).prefHeight(-1.0);
    }

    void positionThumb() {
        ScrollBar scrollBar = (ScrollBar)this.getSkinnable();
        double d = Utils.clamp(scrollBar.getMin(), scrollBar.getValue(), scrollBar.getMax());
        double d2 = this.trackPos = scrollBar.getMax() - scrollBar.getMin() > 0.0 ? (this.trackLength - this.thumbLength) * (d - scrollBar.getMin()) / (scrollBar.getMax() - scrollBar.getMin()) : 0.0;
        this.trackPos = scrollBar.getOrientation() == Orientation.VERTICAL ? (this.trackPos += this.decButton.prefHeight(-1.0)) : (this.trackPos += this.decButton.prefWidth(-1.0));
        this.thumb.setTranslateX(scrollBar.getOrientation() == Orientation.VERTICAL ? this.getInsets().getLeft() : this.trackPos + this.getInsets().getLeft());
        this.thumb.setTranslateY(scrollBar.getOrientation() == Orientation.VERTICAL ? this.trackPos + this.getInsets().getTop() : this.getInsets().getTop());
    }

    @Override
    protected void layoutChildren() {
        double d = this.getInsets().getLeft();
        double d2 = this.getInsets().getTop();
        double d3 = this.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
        double d4 = this.getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom());
        double d5 = ((ScrollBar)this.getSkinnable()).getMax() > ((ScrollBar)this.getSkinnable()).getMin() ? ((ScrollBar)this.getSkinnable()).getVisibleAmount() / (((ScrollBar)this.getSkinnable()).getMax() - ((ScrollBar)this.getSkinnable()).getMin()) : 1.0;
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            double d6 = this.decButton.prefHeight(-1.0);
            double d7 = this.incButton.prefHeight(-1.0);
            this.trackLength = d4 - (d6 + d7);
            this.thumbLength = Utils.clamp(this.minThumbLength(), this.trackLength * d5, this.trackLength);
            this.decButton.resizeRelocate(d, d2, d3, d6 + 3.0);
            this.incButton.resizeRelocate(d, d2 + d4 - (d7 + 4.0), d3, d7 + 4.0);
            this.track.resizeRelocate(d, d2 + d6, d3, this.trackLength);
            this.thumb.resize(d >= 0.0 ? d3 : d3 + d, this.thumbLength);
            this.positionThumb();
        } else {
            double d8 = this.decButton.prefWidth(-1.0);
            double d9 = this.incButton.prefWidth(-1.0);
            this.trackLength = d3 - (d8 + d9);
            this.thumbLength = Utils.clamp(this.minThumbLength(), this.trackLength * d5, this.trackLength);
            this.decButton.resizeRelocate(d, d2, d8 + 3.0, d4);
            this.incButton.resizeRelocate(d + d3 - d9 - 4.0, d2, d9 + 4.0, d4);
            this.track.resizeRelocate(d + d8, d2, this.trackLength, d4);
            this.thumb.resize(this.thumbLength, d2 >= 0.0 ? d4 : d4 + d2);
            this.positionThumb();
        }
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL && d4 >= this.computeMinHeight(-1.0) - (this.getInsets().getTop() + this.getInsets().getBottom()) || ((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL && d3 >= this.computeMinWidth(-1.0) - (this.getInsets().getLeft() + this.getInsets().getRight())) {
            this.track.setVisible(true);
            this.thumb.setVisible(true);
            this.incButton.setVisible(true);
            this.decButton.setVisible(true);
        } else {
            this.track.setVisible(false);
            this.thumb.setVisible(false);
            if (d4 >= this.decButton.computeMinWidth(-1.0)) {
                this.decButton.setVisible(true);
            } else {
                this.decButton.setVisible(false);
            }
            if (d4 >= this.incButton.computeMinWidth(-1.0)) {
                this.incButton.setVisible(true);
            } else {
                this.incButton.setVisible(false);
            }
        }
    }
}

