/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.scene.control.behavior.ProgressIndicatorBehavior;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.SVGPath;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

public class ProgressIndicatorSkin
extends SkinBase<ProgressIndicator, ProgressIndicatorBehavior<ProgressIndicator>> {
    private static final String DONE = ControlResources.getString("ProgressIndicator.doneString");
    private static final Text doneText = new Text(DONE);
    private static final ObservableList<String> paths = FXCollections.observableArrayList();
    private IndeterminateSpinner spinner;
    private DeterminateIndicator determinateIndicator;
    private boolean timelineNulled = false;
    private ObservableList<Color> segmentColors;
    private ObservableList<SVGPath> svgpaths;
    @Styleable(property="-fx-progress-color", initial="Color.DODGERBLUE")
    public Paint progressColor = Color.DODGERBLUE;

    public ProgressIndicatorSkin(ProgressIndicator progressIndicator) {
        super(progressIndicator, new ProgressIndicatorBehavior<ProgressIndicator>(progressIndicator));
        InvalidationListener invalidationListener = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                ProgressIndicatorSkin.this.initialize();
            }
        };
        progressIndicator.indeterminateProperty().addListener(invalidationListener);
        InvalidationListener invalidationListener2 = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                if (((ProgressIndicator)ProgressIndicatorSkin.this.getSkinnable()).isIndeterminate() && ProgressIndicatorSkin.this.timelineNulled && ProgressIndicatorSkin.this.spinner == null) {
                    ProgressIndicatorSkin.this.timelineNulled = false;
                    ProgressIndicatorSkin.this.spinner = new IndeterminateSpinner((ProgressIndicator)ProgressIndicatorSkin.this.getSkinnable(), ProgressIndicatorSkin.this);
                    ProgressIndicatorSkin.this.getChildren().add(ProgressIndicatorSkin.this.spinner);
                }
                if (ProgressIndicatorSkin.this.spinner != null) {
                    if (((ProgressIndicator)ProgressIndicatorSkin.this.getSkinnable()).isVisible() && ((ProgressIndicator)ProgressIndicatorSkin.this.getSkinnable()).getScene() != null) {
                        ProgressIndicatorSkin.this.spinner.indeterminateTimeline.play();
                    } else {
                        ProgressIndicatorSkin.this.spinner.indeterminateTimeline.pause();
                        ProgressIndicatorSkin.this.getChildren().remove(ProgressIndicatorSkin.this.spinner);
                        ProgressIndicatorSkin.this.spinner = null;
                        ProgressIndicatorSkin.this.timelineNulled = true;
                    }
                }
            }
        };
        progressIndicator.visibleProperty().addListener(invalidationListener2);
        progressIndicator.parentProperty().addListener(invalidationListener2);
        InvalidationListener invalidationListener3 = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                if (ProgressIndicatorSkin.this.spinner != null) {
                    if (((ProgressIndicator)ProgressIndicatorSkin.this.getSkinnable()).getScene() == null) {
                        ProgressIndicatorSkin.this.spinner.indeterminateTimeline.pause();
                        ProgressIndicatorSkin.this.getChildren().remove(ProgressIndicatorSkin.this.spinner);
                        ProgressIndicatorSkin.this.spinner = null;
                        ProgressIndicatorSkin.this.timelineNulled = true;
                    }
                } else if (((ProgressIndicator)ProgressIndicatorSkin.this.getSkinnable()).getScene() != null && ((ProgressIndicator)ProgressIndicatorSkin.this.getSkinnable()).isIndeterminate()) {
                    ProgressIndicatorSkin.this.timelineNulled = false;
                    ProgressIndicatorSkin.this.spinner = new IndeterminateSpinner((ProgressIndicator)ProgressIndicatorSkin.this.getSkinnable(), ProgressIndicatorSkin.this);
                    ProgressIndicatorSkin.this.getChildren().add(ProgressIndicatorSkin.this.spinner);
                    ProgressIndicatorSkin.this.spinner.indeterminateTimeline.play();
                    ProgressIndicatorSkin.this.requestLayout();
                }
            }
        };
        progressIndicator.sceneProperty().addListener(invalidationListener3);
        this.initialize();
        this.requestLayout();
    }

    private void initialize() {
        ProgressIndicator progressIndicator = (ProgressIndicator)this.getSkinnable();
        boolean bl = progressIndicator.isIndeterminate();
        if (bl) {
            this.determinateIndicator = null;
            this.spinner = new IndeterminateSpinner(progressIndicator, this);
            this.getChildren().clear();
            this.getChildren().add(this.spinner);
            if (((ProgressIndicator)this.getSkinnable()).isVisible()) {
                this.spinner.indeterminateTimeline.play();
            }
        } else {
            if (this.spinner != null) {
                this.spinner.indeterminateTimeline.stop();
                this.spinner = null;
            }
            this.determinateIndicator = new DeterminateIndicator(progressIndicator, this);
            this.getChildren().clear();
            this.getChildren().add(this.determinateIndicator);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.spinner != null) {
            this.spinner.indeterminateTimeline.stop();
            this.spinner = null;
        }
    }

    private void setColors(Paint paint) {
        block5: {
            if (this.segmentColors == null) break block5;
            this.segmentColors.clear();
            if (paint instanceof Color) {
                Color color = (Color)paint;
                for (int i = 0; i <= 7; ++i) {
                    this.segmentColors.add(Utils.deriveColor(color, -0.2f + 0.17142858f * (float)i));
                }
            } else {
                for (int i = 0; i <= 7; ++i) {
                    this.segmentColors.add((Color)paint);
                }
            }
            for (int i = 0; i <= 7; ++i) {
                SVGPath sVGPath = new SVGPath();
                sVGPath.setContent((String)paths.get(i));
                sVGPath.setFill((Paint)this.segmentColors.get(i));
                this.svgpaths.add(sVGPath);
            }
        }
    }

    private void shiftColors() {
        FXCollections.rotate(this.segmentColors, -1);
        for (int i = 0; i <= 7; ++i) {
            ((SVGPath)this.svgpaths.get(i)).setFill((Paint)this.segmentColors.get(i));
        }
    }

    private Paint getProgressColor() {
        return this.progressColor;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-progress-color".equals(string)) {
            this.progressColor = (Paint)object;
            if (this.progressColor instanceof Color) {
                this.setColors((Color)this.progressColor);
            } else {
                this.setColors(Color.DODGERBLUE);
            }
        } else {
            return super.impl_cssSet(string, object);
        }
        return true;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-progress-color".equals(string)) {
            return true;
        }
        return super.impl_cssSettable(string);
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    static {
        paths.addAll((String[])new String[]{"M 18.19152 4.2642355 L 15.734064 5.984965 L 15.734064 5.984965 C  16.55803 7.1617074 17.0 8.563462 17.0 10.0 L 20.0 10.0 C  20.0 7.9478035 19.368612 5.9452963 18.19152 4.2642355 Z", "M 11.736482 0.15192246 L 11.215537 3.1063457 L 11.215537 3.1063457 C  12.63025 3.3557978 13.933962 4.034467 14.949747 5.0502524 L 10.0 10.0 L 17.071068 2.9289322 C  15.619946 1.4778103 13.757501 0.5082826 11.736482 0.15192246 Z", "M 10.0 0.0 C  7.9478035 0.0 5.9452963 0.6313881 4.2642355 1.8084795 L 5.984965 4.265936 L 5.984965 4.265936 C  7.1617074 3.4419718 8.563462 3.0 10.0 3.0 L 10.0 0.0 Z", "M 2.9289322 2.9289322 C  1.4778103 4.380054 0.5082826 6.2424994 0.15192246 8.263518 L 3.1063457 8.784463 L 3.1063457 8.784463 C  3.3557978 7.3697495 4.034467 6.0660377 5.0502524 5.0502524 L 5.0502524 5.0502524 L 2.9289322 2.9289322 Z", "M 0.0 10.0 C  0.0 12.0521965 0.6313881 14.054704 1.8084795 15.7357645 L 10.0 10.0 L 4.265936 14.015035 C  3.4419718 12.838292 3.0 11.436538 3.0 10.0 Z", "M 10.0 10.0 L 8.784463 16.893654 C  7.3697495 16.644201 6.0660377 15.965533 5.050253 14.949747 L 5.0502524 14.949747 L 2.9289322 17.071068 C  4.380054 18.52219 6.2424994 19.491718 8.263518 19.848078 L 10.0 10.0 Z", "M 10.0 10.0 L 14.015035 15.734064 C  12.838292 16.55803 11.436538 17.0 10.0 17.0 L 10.0 20.0 C  12.0521965 20.0 14.054704 19.368612 15.7357645 18.19152 L 10.0 10.0 Z", "M 10.0 10.0 L 16.893654 11.215537 C  16.644201 12.63025 15.965533 13.933962 14.949747 14.949747 L 17.071068 17.071068 C  18.52219 15.619946 19.491718 13.757501 19.848078 11.736482 L 10.0 10.0 Z"});
    }

    private static class StyleableProperties {
        private static final StyleableProperty PROGRESS_COLOR = new StyleableProperty(ProgressIndicatorSkin.class, "progressColor");
        public static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(SkinBase.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, PROGRESS_COLOR);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }

    static class IndeterminateSpinner
    extends Region {
        private ProgressIndicator control;
        private ProgressIndicatorSkin skin;
        private Group childrenG;
        Scale scaleTransform;
        Rotate rotateTransform;
        private Timeline indeterminateTimeline;
        private double angle = 0.0;

        public IndeterminateSpinner(ProgressIndicator progressIndicator, ProgressIndicatorSkin progressIndicatorSkin) {
            this.control = progressIndicator;
            this.skin = progressIndicatorSkin;
            this.getStyleClass().setAll((String[])new String[]{"spinner"});
            this.skin.segmentColors = FXCollections.observableArrayList();
            this.skin.svgpaths = FXCollections.observableArrayList();
            this.skin.setColors(this.skin.getProgressColor());
            this.childrenG = new Group();
            this.scaleTransform = new Scale();
            this.rotateTransform = new Rotate();
            this.rotateTransform.setAngle(this.angle);
            this.childrenG.getChildren().clear();
            this.childrenG.getChildren().addAll(this.skin.svgpaths);
            this.indeterminateTimeline = new Timeline();
            this.indeterminateTimeline.setCycleCount(-1);
            ObservableList<KeyFrame> observableList = FXCollections.observableArrayList();
            for (int i = 100; i <= 3900; i += 100) {
                observableList.add(new KeyFrame(Duration.millis(i), new EventHandler<ActionEvent>(){

                    @Override
                    public void handle(ActionEvent actionEvent) {
                        IndeterminateSpinner.this.skin.shiftColors();
                    }
                }, new KeyValue[0]));
            }
            this.indeterminateTimeline.getKeyFrames().clear();
            this.indeterminateTimeline.getKeyFrames().addAll((Collection<KeyFrame>)observableList);
            this.getChildren().clear();
            this.getChildren().addAll((Node[])new Node[]{this.childrenG});
            this.requestLayout();
        }

        @Override
        protected void layoutChildren() {
            double d = (this.control.getWidth() - (this.skin.getInsets().getLeft() + this.skin.getInsets().getRight())) / 2.0;
            double d2 = (this.control.getHeight() - (this.skin.getInsets().getTop() + this.skin.getInsets().getBottom())) / 2.0;
            double d3 = Math.min(d, d2);
            this.scaleTransform.setX(d3 / 10.0);
            this.scaleTransform.setY(d3 / 10.0);
            this.rotateTransform.setPivotX(d3);
            this.rotateTransform.setPivotY(d3);
            this.childrenG.getTransforms().clear();
            this.childrenG.getTransforms().addAll((Transform[])new Transform[]{this.scaleTransform, this.rotateTransform});
            this.childrenG.resizeRelocate(0.0, 0.0, this.control.getWidth(), this.control.getHeight());
        }

        @Override
        protected double computePrefWidth(double d) {
            return this.getInsets().getLeft() + doneText.getLayoutBounds().getWidth() + this.getInsets().getRight();
        }

        @Override
        protected double computePrefHeight(double d) {
            return this.getInsets().getTop() + doneText.getLayoutBounds().getWidth() + this.getInsets().getBottom();
        }

        @Override
        protected double computeMaxWidth(double d) {
            return this.computePrefWidth(-1.0);
        }

        @Override
        protected double computeMaxHeight(double d) {
            return this.computePrefHeight(-1.0);
        }

        @Override
        @Deprecated
        protected boolean impl_cssSet(String string, Object object) {
            if (!"-fx-padding".equals(string)) {
                return super.impl_cssSet(string, object);
            }
            return true;
        }

        @Override
        @Deprecated
        protected boolean impl_cssSettable(String string) {
            if ("-fx-padding".equals(string)) {
                return true;
            }
            return super.impl_cssSettable(string);
        }
    }

    static class DeterminateIndicator
    extends Region {
        private Font font;
        private double textGap = 2.0;
        private int intProgress;
        private int degProgress;
        private ProgressIndicator control;
        private ProgressIndicatorSkin skin;
        private Text text;
        private StackPane indicator;
        private StackPane progress;
        private StackPane tick;
        Arc arcShape;
        Arc arcProgress;
        private Paint textFill = Color.BLACK;

        public DeterminateIndicator(ProgressIndicator progressIndicator, ProgressIndicatorSkin progressIndicatorSkin) {
            this.control = progressIndicator;
            this.skin = progressIndicatorSkin;
            this.intProgress = (int)Math.round(progressIndicator.getProgress() * 100.0);
            this.degProgress = (int)(360.0 * progressIndicator.getProgress());
            InvalidationListener invalidationListener = new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    DeterminateIndicator.this.updateProgress();
                }
            };
            progressIndicator.progressProperty().addListener(invalidationListener);
            this.getChildren().clear();
            this.text = new Text(progressIndicator.getProgress() >= 1.0 ? DONE : "" + this.intProgress + "%");
            this.text.setFill(this.textFill);
            this.text.setTextOrigin(VPos.TOP);
            this.text.getStyleClass().setAll((String[])new String[]{"percentage"});
            this.indicator = new StackPane();
            this.indicator.getStyleClass().setAll((String[])new String[]{"indicator"});
            this.arcShape = new Arc();
            this.arcShape.setType(ArcType.ROUND);
            this.arcShape.setStartAngle(90.0);
            this.arcProgress = new Arc();
            this.arcProgress.setType(ArcType.ROUND);
            this.arcProgress.setStartAngle(90.0);
            this.arcProgress.setFill(this.skin.getProgressColor());
            this.progress = new StackPane(){

                @Override
                protected void layoutChildren() {
                    DeterminateIndicator.this.arcProgress.setFill(DeterminateIndicator.this.skin.getProgressColor());
                }
            };
            this.progress.getStyleClass().setAll((String[])new String[]{"progress"});
            this.progress.impl_setScaleShape(false);
            this.progress.impl_setPositionShape(false);
            this.progress.impl_setShape(this.arcShape);
            this.progress.getChildren().clear();
            this.progress.getChildren().addAll((Node[])new Node[]{this.arcProgress});
            this.tick = new StackPane();
            this.tick.getStyleClass().setAll((String[])new String[]{"tick"});
            this.getChildren().setAll((Node[])new Node[]{this.indicator, this.progress, this.text, this.tick});
            this.updateProgress();
        }

        private void updateProgress() {
            this.intProgress = (int)Math.round(this.control.getProgress() * 100.0);
            this.text.setText(this.control.getProgress() >= 1.0 ? DONE : "" + this.intProgress + "%");
            this.degProgress = (int)(360.0 * this.control.getProgress());
            this.arcShape.setLength(-this.degProgress);
            this.arcProgress.setLength(-this.degProgress);
            this.requestLayout();
        }

        @Override
        protected void layoutChildren() {
            double d = doneText.getLayoutBounds().getHeight();
            double d2 = (this.control.getWidth() - (this.skin.getInsets().getLeft() + this.skin.getInsets().getRight())) / 2.0;
            double d3 = (this.control.getHeight() - (this.skin.getInsets().getTop() + this.skin.getInsets().getBottom())) / 2.0;
            double d4 = Math.min(d2, d3);
            d4 = Math.min(d4, (this.control.getHeight() - this.skin.getInsets().getTop() - this.skin.getInsets().getBottom() - this.textGap - d) / 2.0);
            this.indicator.impl_setShape(new Circle(d4));
            this.indicator.resize(2.0 * d4, 2.0 * d4);
            double d5 = this.indicator.getHeight() + this.textGap + d;
            double d6 = (this.getHeight() - d5) / 2.0;
            this.indicator.setLayoutX((this.getWidth() - this.indicator.getWidth()) / 2.0);
            this.indicator.setLayoutY(d6);
            this.arcShape.setRadiusX((this.indicator.getWidth() - this.indicator.getInsets().getLeft() - this.indicator.getInsets().getRight()) / 2.0);
            this.arcShape.setRadiusY(this.arcShape.getRadiusX());
            this.arcProgress.setRadiusX(this.arcShape.getRadiusX() - 1.0);
            this.arcProgress.setRadiusY(this.arcShape.getRadiusY() - 1.0);
            this.progress.setLayoutX(this.indicator.getLayoutX() + d4);
            this.progress.setLayoutY(this.indicator.getLayoutY() + d4);
            this.progress.resize(2.0 * this.arcShape.getRadiusX(), 2.0 * this.arcShape.getRadiusY());
            this.tick.setLayoutX(this.indicator.getLayoutX() + this.indicator.getWidth() / 2.0 - this.tick.getWidth() / 2.0);
            this.tick.setLayoutY(this.indicator.getLayoutY() + this.indicator.getHeight() / 2.0 - this.tick.getHeight() / 2.0);
            this.tick.setVisible(this.control.getProgress() >= 1.0);
            this.text.setLayoutY(d6 + this.indicator.getHeight() + this.textGap);
            this.text.setLayoutX(this.indicator.getLayoutX() + (this.indicator.getWidth() - this.text.getLayoutBounds().getWidth()) / 2.0);
        }

        @Override
        protected double computePrefWidth(double d) {
            double d2 = this.indicator.getInsets().getLeft() + this.indicator.getInsets().getRight() + this.progress.getInsets().getLeft() + this.progress.getInsets().getRight();
            return this.getInsets().getLeft() + Math.max(d2, doneText.getLayoutBounds().getWidth()) + this.getInsets().getRight();
        }

        @Override
        protected double computePrefHeight(double d) {
            double d2 = this.indicator.getInsets().getTop() + this.indicator.getInsets().getBottom() + this.progress.getInsets().getTop() + this.progress.getInsets().getBottom();
            return this.getInsets().getTop() + d2 + this.textGap + doneText.getLayoutBounds().getHeight() + this.getInsets().getBottom();
        }

        @Override
        protected double computeMaxWidth(double d) {
            return this.computePrefWidth(d);
        }

        @Override
        protected double computeMaxHeight(double d) {
            return this.computePrefHeight(d);
        }
    }
}

