/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.scene.control.skin.KeystrokeUtils;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.effect.Effect;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class ContextMenuContent
extends StackPane {
    private ContextMenu contextMenu;
    private double maxGraphicWidth = 0.0;
    private double maxRightWidth = 0.0;
    private double maxLabelWidth = 0.0;
    private double maxRowHeight = 0.0;
    private double maxLeftWidth = 0.0;
    private Rectangle clipRect;
    private MenuBox itemsContainer;
    private ArrowMenuItem upArrow;
    private ArrowMenuItem downArrow;
    private int currentFocusedIndex = -1;
    private boolean isFirstShow = true;
    private double ty;
    private Menu openSubmenu;
    private ContextMenu submenu;
    private Region selectedBackground;
    private static final long SELECTED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("selected");
    private static final long DISABLED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("disabled");
    private static final long CHECKED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("checked");

    public ContextMenuContent(ContextMenu contextMenu) {
        this.contextMenu = contextMenu;
        this.clipRect = new Rectangle();
        this.clipRect.setSmooth(false);
        this.itemsContainer = new MenuBox();
        this.itemsContainer.setClip(this.clipRect);
        this.upArrow = new ArrowMenuItem(this);
        this.upArrow.setUp(true);
        this.upArrow.setFocusTraversable(false);
        this.downArrow = new ArrowMenuItem(this);
        this.downArrow.setUp(false);
        this.downArrow.setFocusTraversable(false);
        this.getChildren().add(this.itemsContainer);
        this.getChildren().add(this.upArrow);
        this.getChildren().add(this.downArrow);
        this.updateVisualItems();
        this.initialize();
        this.setUpBinds();
    }

    private void computeVisualMetrics() {
        this.maxRightWidth = 0.0;
        this.maxLabelWidth = 0.0;
        this.maxRowHeight = 0.0;
        this.maxGraphicWidth = 0.0;
        this.maxLeftWidth = 0.0;
        for (int i = 0; i < this.itemsContainer.getChildren().size(); ++i) {
            MenuItemContainer menuItemContainer;
            Node node = (Node)this.itemsContainer.getChildren().get(i);
            if (!(node instanceof MenuItemContainer) || !(menuItemContainer = (MenuItemContainer)this.itemsContainer.getChildren().get(i)).isVisible()) continue;
            double d = -1.0;
            Node node2 = menuItemContainer.left;
            if (node2 != null) {
                d = node2.getContentBias() == Orientation.VERTICAL ? this.snapSize(node2.prefHeight(-1.0)) : -1.0;
                this.maxLeftWidth = Math.max(this.maxLeftWidth, this.snapSize(node2.prefWidth(d)));
                this.maxRowHeight = Math.max(this.maxRowHeight, node2.prefHeight(-1.0));
            }
            if ((node2 = menuItemContainer.graphic) != null) {
                d = node2.getContentBias() == Orientation.VERTICAL ? this.snapSize(node2.prefHeight(-1.0)) : -1.0;
                this.maxGraphicWidth = Math.max(this.maxGraphicWidth, this.snapSize(node2.prefWidth(d)));
                this.maxRowHeight = Math.max(this.maxRowHeight, node2.prefHeight(-1.0));
            }
            if ((node2 = menuItemContainer.label) != null) {
                d = node2.getContentBias() == Orientation.VERTICAL ? this.snapSize(node2.prefHeight(-1.0)) : -1.0;
                this.maxLabelWidth = Math.max(this.maxLabelWidth, this.snapSize(node2.prefWidth(d)));
                this.maxRowHeight = Math.max(this.maxRowHeight, node2.prefHeight(-1.0));
            }
            if ((node2 = menuItemContainer.right) == null) continue;
            d = node2.getContentBias() == Orientation.VERTICAL ? this.snapSize(node2.prefHeight(-1.0)) : -1.0;
            this.maxRightWidth = Math.max(this.maxRightWidth, this.snapSize(node2.prefWidth(d)));
            this.maxRowHeight = Math.max(this.maxRowHeight, node2.prefHeight(-1.0));
        }
    }

    private void updateVisualItems() {
        this.itemsContainer.getChildren().clear();
        for (int i = 0; i < this.getItems().size(); ++i) {
            MenuItem menuItem = (MenuItem)this.getItems().get(i);
            MenuItemContainer menuItemContainer = new MenuItemContainer(menuItem);
            menuItemContainer.visibleProperty().bind(menuItem.visibleProperty());
            this.itemsContainer.getChildren().add(menuItemContainer);
            if (!(menuItem instanceof SeparatorMenuItem)) continue;
            Node node = ((CustomMenuItem)menuItem).getContent();
            this.itemsContainer.getChildren().remove(menuItemContainer);
            this.itemsContainer.getChildren().add(node);
            node.getProperties().put(MenuItem.class, menuItem);
        }
        if (this.getItems().size() > 0) {
            MenuItem menuItem = (MenuItem)this.getItems().get(0);
            this.getProperties().put(Menu.class, menuItem.getParentMenu());
        }
    }

    @Override
    protected void layoutChildren() {
        double d;
        double d2 = this.snapSpace(this.getInsets().getLeft());
        double d3 = this.snapSpace(this.getInsets().getTop());
        double d4 = this.snapSize(this.getWidth()) - (this.snapSpace(this.getInsets().getLeft()) + this.snapSpace(this.getInsets().getRight()));
        double d5 = this.snapSize(this.getHeight()) - (this.snapSpace(this.getInsets().getTop()) + this.snapSpace(this.getInsets().getBottom()));
        double d6 = this.snapSize(this.getContentHeight());
        this.itemsContainer.resize(d4, d6);
        this.itemsContainer.relocate(this.snapSpace(this.getInsets().getLeft()), d3);
        if (this.isFirstShow && this.ty == 0.0) {
            this.upArrow.setVisible(false);
            this.isFirstShow = false;
        } else {
            this.upArrow.setVisible(this.ty < d3 && this.ty < 0.0);
        }
        this.downArrow.setVisible(this.ty + d6 > d3 + d5);
        this.clipRect.setX(0.0);
        this.clipRect.setY(0.0);
        this.clipRect.setWidth(d4);
        this.clipRect.setHeight(d5);
        if (this.upArrow.isVisible()) {
            d = this.snapSize(this.upArrow.prefHeight(-1.0));
            this.clipRect.setHeight(this.snapSize(this.clipRect.getHeight() - d));
            this.clipRect.setY(this.snapSize(this.clipRect.getY()) + d);
            this.upArrow.resize(this.snapSize(this.upArrow.prefWidth(-1.0)), d);
            this.positionInArea(this.upArrow, d2, d3, d4, d, 0.0, HPos.CENTER, VPos.CENTER);
        }
        if (this.downArrow.isVisible()) {
            d = this.snapSize(this.downArrow.prefHeight(-1.0));
            this.clipRect.setHeight(this.snapSize(this.clipRect.getHeight()) - d);
            this.downArrow.resize(this.snapSize(this.downArrow.prefWidth(-1.0)), d);
            this.positionInArea(this.downArrow, d2, d3 + d5 - d, d4, d, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    @Override
    protected double computePrefWidth(double d) {
        this.computeVisualMetrics();
        double d2 = 0.0;
        for (Node node : this.itemsContainer.getChildren()) {
            if (!node.isVisible()) continue;
            d2 = Math.max(d2, this.snapSize(node.prefWidth(-1.0)));
        }
        return this.snapSize(this.getInsets().getLeft()) + this.snapSize(d2) + this.snapSize(this.getInsets().getRight());
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = this.getScreenHeight();
        double d3 = this.getContentHeight();
        double d4 = this.snapSpace(this.getInsets().getTop()) + this.snapSize(d3) + this.snapSpace(this.getInsets().getBottom());
        double d5 = d2 <= 0.0 ? d4 : Math.min(d4, d2);
        return d5;
    }

    @Override
    protected double computeMinHeight(double d) {
        return 0.0;
    }

    @Override
    protected double computeMaxHeight(double d) {
        return this.getScreenHeight();
    }

    private double getScreenHeight() {
        if (this.contextMenu == null || this.contextMenu.getOwnerWindow() == null) {
            return -1.0;
        }
        return this.snapSize(Utils.getScreen(this.contextMenu.getOwnerWindow().getScene().getRoot()).getVisualBounds().getHeight());
    }

    private double getContentHeight() {
        double d = 0.0;
        for (Node node : this.itemsContainer.getChildren()) {
            if (!node.isVisible()) continue;
            d += this.snapSize(node.prefHeight(-1.0));
        }
        return d;
    }

    protected ObservableList<MenuItem> getItems() {
        return this.contextMenu.getItems();
    }

    private int findFocusedIndex() {
        for (int i = 0; i < this.itemsContainer.getChildren().size(); ++i) {
            Node node = (Node)this.itemsContainer.getChildren().get(i);
            if (!node.isFocused()) continue;
            return i;
        }
        return -1;
    }

    private void setTy(double d) {
        if (this.ty == d) {
            return;
        }
        this.ty = d;
        this.itemsContainer.requestLayout();
    }

    private void initialize() {
        this.contextMenu.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (bl2.booleanValue()) {
                    ContextMenuContent.this.currentFocusedIndex = -1;
                    ContextMenuContent.this.requestFocus();
                }
            }
        });
        this.setOnKeyPressed((EventHandler<? super KeyEvent>)new EventHandler<KeyEvent>(){

            @Override
            public void handle(KeyEvent keyEvent) {
                switch (keyEvent.getCode()) {
                    case LEFT: {
                        ContextMenuContent.this.processLeftKey(keyEvent);
                        break;
                    }
                    case RIGHT: {
                        ContextMenuContent.this.processRightKey(keyEvent);
                        break;
                    }
                    case CANCEL: {
                        keyEvent.consume();
                    }
                    case ESCAPE: {
                        break;
                    }
                    case DOWN: {
                        ContextMenuContent.this.moveToNextSibling();
                        keyEvent.consume();
                        break;
                    }
                    case UP: {
                        ContextMenuContent.this.moveToPreviousSibling();
                        keyEvent.consume();
                        break;
                    }
                    case SPACE: 
                    case ENTER: {
                        ContextMenuContent.this.selectMenuItem();
                        keyEvent.consume();
                    }
                }
            }
        });
        this.setOnScroll((EventHandler<? super ScrollEvent>)new EventHandler<ScrollEvent>(){

            @Override
            public void handle(ScrollEvent scrollEvent) {
                if (ContextMenuContent.this.downArrow.isVisible() && (scrollEvent.getTextDeltaY() < 0.0 || scrollEvent.getDeltaY() < 0.0) || ContextMenuContent.this.upArrow.isVisible() && (scrollEvent.getTextDeltaY() > 0.0 || scrollEvent.getDeltaY() > 0.0)) {
                    switch (scrollEvent.getTextDeltaYUnits()) {
                        case LINES: {
                            int n = ContextMenuContent.this.findFocusedIndex();
                            if (n == -1) {
                                n = 0;
                            }
                            double d = ((Node)ContextMenuContent.this.itemsContainer.getChildren().get(n)).prefHeight(-1.0);
                            ContextMenuContent.this.scroll(scrollEvent.getTextDeltaY() * d);
                            break;
                        }
                        case PAGES: {
                            ContextMenuContent.this.scroll(scrollEvent.getTextDeltaY() * ContextMenuContent.this.itemsContainer.getHeight());
                            break;
                        }
                        case NONE: {
                            ContextMenuContent.this.scroll(scrollEvent.getDeltaY());
                        }
                    }
                    scrollEvent.consume();
                }
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_EXITED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (ContextMenuContent.this.submenu != null && ContextMenuContent.this.submenu.isShowing()) {
                    return;
                }
                ContextMenuContent.this.requestFocus();
            }
        });
    }

    private void processLeftKey(KeyEvent keyEvent) {
        Menu menu;
        MenuItem menuItem;
        Node node;
        if (this.currentFocusedIndex != -1 && (node = (Node)this.itemsContainer.getChildren().get(this.currentFocusedIndex)) instanceof MenuItemContainer && (menuItem = ((MenuItemContainer)node).item) instanceof Menu && (menu = (Menu)menuItem) == this.openSubmenu && this.submenu != null && this.submenu.isShowing()) {
            this.hideSubmenu();
            keyEvent.consume();
        }
    }

    private void processRightKey(KeyEvent keyEvent) {
        MenuItem menuItem;
        Node node;
        if (this.currentFocusedIndex != -1 && (node = (Node)this.itemsContainer.getChildren().get(this.currentFocusedIndex)) instanceof MenuItemContainer && (menuItem = ((MenuItemContainer)node).item) instanceof Menu) {
            Menu menu = (Menu)menuItem;
            if (menu.isDisable()) {
                return;
            }
            this.selectedBackground = (MenuItemContainer)node;
            if (this.openSubmenu == menu && this.submenu.isShowing()) {
                return;
            }
            this.showSubmenu(menu);
            ContextMenuContent contextMenuContent = (ContextMenuContent)this.submenu.getSkin().getNode();
            if (contextMenuContent != null) {
                if (contextMenuContent.itemsContainer.getChildren().size() > 0) {
                    ((MenuItemContainer)contextMenuContent.itemsContainer.getChildren().get(0)).requestFocus();
                } else {
                    contextMenuContent.requestFocus();
                }
            }
            keyEvent.consume();
        }
    }

    private void selectMenuItem() {
        Node node;
        if (this.currentFocusedIndex != -1 && (node = (Node)this.itemsContainer.getChildren().get(this.currentFocusedIndex)) instanceof MenuItemContainer) {
            MenuItem menuItem = ((MenuItemContainer)node).item;
            if (menuItem instanceof Menu) {
                Menu menu = (Menu)menuItem;
                if (this.openSubmenu != null) {
                    this.hideSubmenu();
                }
                if (menu.isDisable()) {
                    return;
                }
                this.selectedBackground = (MenuItemContainer)node;
                this.showSubmenu(menu);
            } else {
                ((MenuItemContainer)node).doSelect();
            }
        }
    }

    private int findNext(int n) {
        Node node;
        int n2;
        for (n2 = n; n2 < this.itemsContainer.getChildren().size(); ++n2) {
            node = (Node)this.itemsContainer.getChildren().get(n2);
            if (!(node instanceof MenuItemContainer)) continue;
            return n2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            node = (Node)this.itemsContainer.getChildren().get(n2);
            if (!(node instanceof MenuItemContainer)) continue;
            return n2;
        }
        return -1;
    }

    private void moveToNextSibling() {
        this.currentFocusedIndex = this.findFocusedIndex();
        if (this.currentFocusedIndex != -1) {
            this.currentFocusedIndex = this.findNext(this.currentFocusedIndex + 1);
        } else if (this.currentFocusedIndex == -1 || this.currentFocusedIndex == this.itemsContainer.getChildren().size() - 1) {
            this.currentFocusedIndex = this.findNext(0);
        }
        if (this.currentFocusedIndex != -1) {
            ((MenuItemContainer)this.itemsContainer.getChildren().get(this.currentFocusedIndex)).requestFocus();
        }
    }

    private int findPrevious(int n) {
        Node node;
        int n2;
        for (n2 = n; n2 >= 0; --n2) {
            node = (Node)this.itemsContainer.getChildren().get(n2);
            if (!(node instanceof MenuItemContainer)) continue;
            return n2;
        }
        for (n2 = this.itemsContainer.getChildren().size() - 1; n2 > n; --n2) {
            node = (Node)this.itemsContainer.getChildren().get(n2);
            if (!(node instanceof MenuItemContainer)) continue;
            return n2;
        }
        return -1;
    }

    private void moveToPreviousSibling() {
        this.currentFocusedIndex = this.findFocusedIndex();
        if (this.currentFocusedIndex != -1) {
            this.currentFocusedIndex = this.findPrevious(this.currentFocusedIndex - 1);
        } else if (this.currentFocusedIndex == -1 || this.currentFocusedIndex == 0) {
            this.currentFocusedIndex = this.findPrevious(this.itemsContainer.getChildren().size() - 1);
        }
        if (this.currentFocusedIndex != -1) {
            ((MenuItemContainer)this.itemsContainer.getChildren().get(this.currentFocusedIndex)).requestFocus();
        }
    }

    private Menu getRootMenu(Menu menu) {
        if (menu == null || menu.getParentMenu() == null) {
            return menu;
        }
        Menu menu2 = menu.getParentMenu();
        while (menu2.getParentMenu() != null) {
            menu2 = menu2.getParentMenu();
        }
        return menu2;
    }

    double getMenuYOffset(int n) {
        double d = 0.0;
        if (this.itemsContainer.getChildren().size() >= n) {
            d = this.getInsets().getTop();
            Node node = (Node)this.itemsContainer.getChildren().get(n);
            d += node.getLayoutY() + node.prefHeight(-1.0);
        }
        return d;
    }

    private void setUpBinds() {
        this.updateMenuShowingListeners(this.contextMenu.getItems());
        this.contextMenu.getItems().addListener(new ListChangeListener<MenuItem>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends MenuItem> change) {
                while (change.next()) {
                    ContextMenuContent.this.updateMenuShowingListeners(change.getAddedSubList());
                }
                ContextMenuContent.this.updateVisualItems();
            }
        });
    }

    private void updateMenuShowingListeners(List<? extends MenuItem> list) {
        for (MenuItem menuItem : list) {
            if (menuItem instanceof Menu) {
                final Menu menu = (Menu)menuItem;
                menu.showingProperty().addListener(new ChangeListener<Boolean>(){

                    @Override
                    public void changed(ObservableValue observableValue, Boolean bl, Boolean bl2) {
                        if (bl.booleanValue() && !bl2.booleanValue()) {
                            ContextMenuContent.this.hideSubmenu();
                        } else if (!bl.booleanValue() && bl2.booleanValue()) {
                            ContextMenuContent.this.showSubmenu(menu);
                        }
                    }
                });
            }
            menuItem.visibleProperty().addListener(new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue observableValue, Boolean bl, Boolean bl2) {
                    ContextMenuContent.this.requestLayout();
                }
            });
        }
    }

    private void showSubmenu(Menu menu) {
        this.openSubmenu = menu;
        if (this.submenu == null) {
            this.submenu = new ContextMenu();
            this.submenu.showingProperty().addListener(new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                    if (!ContextMenuContent.this.submenu.isShowing()) {
                        for (Node node : ContextMenuContent.this.itemsContainer.getChildren()) {
                            Menu menu;
                            if (!(node instanceof MenuItemContainer) || !(((MenuItemContainer)node).item instanceof Menu) || !(menu = (Menu)((MenuItemContainer)node).item).isShowing()) continue;
                            menu.hide();
                        }
                    }
                }
            });
        }
        this.submenu.getItems().setAll((Collection<MenuItem>)menu.getItems());
        this.submenu.show(this.selectedBackground, Side.RIGHT, 0.0, 0.0);
    }

    private void hideSubmenu() {
        if (this.submenu == null) {
            return;
        }
        this.submenu.hide();
    }

    private void hideAllMenus(MenuItem menuItem) {
        Menu menu;
        this.contextMenu.hide();
        while ((menu = menuItem.getParentMenu()) != null) {
            menu.hide();
            menuItem = menu;
        }
    }

    void scroll(double d) {
        this.setTy(this.ty + d);
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if (!"-fx-effect".equals(string)) {
            return super.impl_cssSet(string, object);
        }
        this.setEffect((Effect)object);
        return true;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-effect".equals(string)) {
            return true;
        }
        return super.impl_cssSettable(string);
    }

    protected Label getLabelAt(int n) {
        return ((MenuItemContainer)this.itemsContainer.getChildren().get(n)).getLabel();
    }

    private class MenuLabel
    extends Label {
        final MenuItem menuitem;
        MenuItemContainer menuItemContainer;

        public MenuLabel(MenuItem menuItem, MenuItemContainer menuItemContainer) {
            super(menuItem.getText());
            this.setMnemonicParsing(menuItem.isMnemonicParsing());
            this.setFocusTraversable(true);
            this.setLabelFor(menuItemContainer);
            this.menuitem = menuItem;
            this.menuItemContainer = menuItemContainer;
            this.addEventHandler(ActionEvent.ACTION, new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    Event.fireEvent(MenuLabel.this.menuitem, new ActionEvent());
                    actionEvent.consume();
                }
            });
        }

        public void fire() {
            this.menuItemContainer.doSelect();
        }
    }

    class MenuItemContainer
    extends Pane {
        private final MenuItem item;
        private Node left;
        private Node graphic;
        private Node label;
        private Node right;
        private static final String PSEUDO_CLASS_SELECTED = "selected";
        private static final String PSEUDO_CLASS_DISABLED = "disabled";
        private static final String PSEUDO_CLASS_CHECKED = "checked";

        protected Label getLabel() {
            return (Label)this.label;
        }

        public MenuItemContainer(MenuItem menuItem) {
            if (menuItem == null) {
                throw new NullPointerException("MenuItem can not be null");
            }
            this.getStyleClass().addAll((Collection<String>)menuItem.getStyleClass());
            this.setId(menuItem.getId());
            this.item = menuItem;
            this.createChildren();
            if (menuItem instanceof Menu) {
                this.listen(((Menu)menuItem).showingProperty(), PSEUDO_CLASS_SELECTED);
            } else if (menuItem instanceof RadioMenuItem) {
                this.listen(((RadioMenuItem)menuItem).selectedProperty(), PSEUDO_CLASS_CHECKED);
            } else if (menuItem instanceof CheckMenuItem) {
                this.listen(((CheckMenuItem)menuItem).selectedProperty(), PSEUDO_CLASS_CHECKED);
            }
            this.listen(menuItem.disableProperty(), PSEUDO_CLASS_DISABLED);
            this.getProperties().put(MenuItem.class, menuItem);
        }

        private void createChildren() {
            if (this.item instanceof CustomMenuItem) {
                this.createNodeMenuItemChildren((CustomMenuItem)this.item);
                this.setOnMouseEntered((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                    @Override
                    public void handle(MouseEvent mouseEvent) {
                        MenuItemContainer.this.requestFocus();
                    }
                });
            } else {
                Region region;
                EventTarget eventTarget;
                Node node = this.getLeftGraphic(this.item);
                if (node != null) {
                    eventTarget = new StackPane();
                    eventTarget.getStyleClass().add("left-container");
                    eventTarget.getChildren().add(node);
                    this.left = eventTarget;
                    this.getChildren().add(this.left);
                }
                if (this.item.getGraphic() != null) {
                    eventTarget = this.item.getGraphic();
                    region = new StackPane();
                    region.getStyleClass().add("graphic-container");
                    ((Pane)region).getChildren().add((Node)eventTarget);
                    this.graphic = region;
                    this.getChildren().add(this.graphic);
                }
                this.label = new MenuLabel(this.item, this);
                this.label.setStyle(this.item.getStyle());
                ((Label)this.label).textProperty().bind(this.item.textProperty());
                this.label.setMouseTransparent(true);
                this.getChildren().add(this.label);
                this.setOnMouseEntered((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                    @Override
                    public void handle(MouseEvent mouseEvent) {
                        MenuItemContainer.this.requestFocus();
                    }
                });
                if (this.item instanceof Menu) {
                    eventTarget = (Menu)this.item;
                    region = new Region();
                    region.setMouseTransparent(true);
                    region.getStyleClass().add("arrow");
                    StackPane stackPane = new StackPane();
                    stackPane.setMaxWidth(Math.max(region.prefWidth(-1.0), 10.0));
                    stackPane.setMouseTransparent(true);
                    stackPane.getStyleClass().add("right-container");
                    stackPane.getChildren().add(region);
                    this.right = stackPane;
                    this.getChildren().add(stackPane);
                    this.setOnMouseEntered((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>((Menu)eventTarget){
                        final /* synthetic */ Menu val$menu;
                        {
                            this.val$menu = menu;
                        }

                        @Override
                        public void handle(MouseEvent mouseEvent) {
                            if (ContextMenuContent.this.openSubmenu != null && MenuItemContainer.this.item != ContextMenuContent.this.openSubmenu) {
                                ContextMenuContent.this.hideSubmenu();
                            }
                            if (this.val$menu.isDisable()) {
                                return;
                            }
                            ContextMenuContent.this.selectedBackground = MenuItemContainer.this;
                            this.val$menu.show();
                            MenuItemContainer.this.requestFocus();
                        }
                    });
                } else {
                    this.updateAccelerator();
                    this.item.acceleratorProperty().addListener(new InvalidationListener(){

                        @Override
                        public void invalidated(Observable observable) {
                            MenuItemContainer.this.updateAccelerator();
                        }
                    });
                    this.setOnMouseEntered((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                        @Override
                        public void handle(MouseEvent mouseEvent) {
                            if (ContextMenuContent.this.openSubmenu != null) {
                                ContextMenuContent.this.openSubmenu.hide();
                            }
                            MenuItemContainer.this.requestFocus();
                        }
                    });
                    this.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                        @Override
                        public void handle(MouseEvent mouseEvent) {
                            MenuItemContainer.this.doSelect();
                        }
                    });
                }
            }
        }

        private void updateAccelerator() {
            if (this.item.getAccelerator() != null) {
                String string = KeystrokeUtils.toString(this.item.getAccelerator());
                this.right = new Label(string);
                this.right.setStyle(this.item.getStyle());
                this.right.getStyleClass().add("accelerator-text");
                this.getChildren().add(this.right);
            } else {
                this.getChildren().remove(this.right);
            }
        }

        void doSelect() {
            if (this.item == null || this.item.isDisable()) {
                return;
            }
            if (this.item instanceof CheckMenuItem) {
                CheckMenuItem checkMenuItem;
                checkMenuItem.setSelected(!(checkMenuItem = (CheckMenuItem)this.item).isSelected());
            } else if (this.item instanceof RadioMenuItem) {
                RadioMenuItem radioMenuItem;
                radioMenuItem.setSelected((radioMenuItem = (RadioMenuItem)this.item).getToggleGroup() != null ? true : !radioMenuItem.isSelected());
            }
            this.item.fire();
            ContextMenuContent.this.hideAllMenus(this.item);
        }

        private void createNodeMenuItemChildren(final CustomMenuItem customMenuItem) {
            Node node = customMenuItem.getContent();
            this.getChildren().add(node);
            node.getStyleClass().addAll((Collection<String>)customMenuItem.getStyleClass());
            node.setOnMouseClicked((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (customMenuItem == null || customMenuItem.isDisable()) {
                        return;
                    }
                    customMenuItem.fire();
                    if (customMenuItem.isHideOnClick()) {
                        ContextMenuContent.this.hideAllMenus(customMenuItem);
                    }
                }
            });
        }

        @Override
        protected void layoutChildren() {
            double d;
            double d2 = this.prefHeight(-1.0);
            if (this.left != null) {
                d = this.getInsets().getLeft();
                this.left.resize(this.left.prefWidth(-1.0), this.left.prefHeight(-1.0));
                this.positionInArea(this.left, d, 0.0, ContextMenuContent.this.maxLeftWidth, d2, 0.0, HPos.LEFT, VPos.CENTER);
            }
            if (this.graphic != null) {
                d = this.getInsets().getLeft() + ContextMenuContent.this.maxLeftWidth;
                this.graphic.resize(this.graphic.prefWidth(-1.0), this.graphic.prefHeight(-1.0));
                this.positionInArea(this.graphic, d, 0.0, ContextMenuContent.this.maxGraphicWidth, d2, 0.0, HPos.LEFT, VPos.CENTER);
            }
            if (this.label != null) {
                d = this.getInsets().getLeft() + ContextMenuContent.this.maxLeftWidth + ContextMenuContent.this.maxGraphicWidth;
                this.label.resize(this.label.prefWidth(-1.0), this.label.prefHeight(-1.0));
                this.positionInArea(this.label, d, 0.0, ContextMenuContent.this.maxLabelWidth, d2, 0.0, HPos.LEFT, VPos.CENTER);
            }
            if (this.right != null) {
                d = this.getInsets().getLeft() + ContextMenuContent.this.maxLeftWidth + ContextMenuContent.this.maxGraphicWidth + ContextMenuContent.this.maxLabelWidth;
                this.right.resize(this.right.prefWidth(-1.0), this.right.prefHeight(-1.0));
                this.positionInArea(this.right, d, 0.0, ContextMenuContent.this.maxRightWidth, d2, 0.0, HPos.RIGHT, VPos.CENTER);
            }
            if (this.item instanceof CustomMenuItem) {
                Node node = ((CustomMenuItem)this.item).getContent();
                if (this.item instanceof SeparatorMenuItem) {
                    double d3 = this.prefWidth(-1.0) - (this.getInsets().getLeft() + ContextMenuContent.this.maxGraphicWidth + this.getInsets().getRight());
                    node.resize(d3, node.prefHeight(-1.0));
                    this.positionInArea(node, this.getInsets().getLeft() + ContextMenuContent.this.maxGraphicWidth, 0.0, this.prefWidth(-1.0), d2, 0.0, HPos.LEFT, VPos.CENTER);
                } else {
                    node.resize(node.prefWidth(-1.0), node.prefHeight(-1.0));
                    this.positionInArea(node, this.getInsets().getLeft(), 0.0, this.getWidth(), d2, 0.0, HPos.LEFT, VPos.CENTER);
                }
            }
            if ("choice-box-menu-item".equals(this.item.getId()) && ((RadioMenuItem)this.item).isSelected()) {
                this.requestFocus();
            }
        }

        @Override
        public long impl_getPseudoClassState() {
            long l = super.impl_getPseudoClassState();
            if (this.item instanceof Menu && this.item.equals(ContextMenuContent.this.openSubmenu) && ContextMenuContent.this.submenu.isShowing()) {
                l |= SELECTED_PSEUDOCLASS_STATE;
            } else if (this.item instanceof RadioMenuItem && ((RadioMenuItem)this.item).isSelected()) {
                l |= CHECKED_PSEUDOCLASS_STATE;
            } else if (this.item instanceof CheckMenuItem && ((CheckMenuItem)this.item).isSelected()) {
                l |= CHECKED_PSEUDOCLASS_STATE;
            }
            if (this.item.isDisable()) {
                l |= DISABLED_PSEUDOCLASS_STATE;
            }
            return l;
        }

        @Override
        protected double computePrefHeight(double d) {
            double d2 = 0.0;
            if (this.item instanceof CustomMenuItem || this.item instanceof SeparatorMenuItem) {
                d2 = ((Node)this.getChildren().get(0)).prefHeight(-1.0);
            } else {
                d2 = Math.max(d2, this.left != null ? this.left.prefHeight(-1.0) : 0.0);
                d2 = Math.max(d2, this.graphic != null ? this.graphic.prefHeight(-1.0) : 0.0);
                d2 = Math.max(d2, this.label != null ? this.label.prefHeight(-1.0) : 0.0);
                d2 = Math.max(d2, this.right != null ? this.right.prefHeight(-1.0) : 0.0);
            }
            return this.getInsets().getTop() + d2 + this.getInsets().getBottom();
        }

        @Override
        protected double computePrefWidth(double d) {
            double d2 = 0.0;
            if (this.item instanceof CustomMenuItem && !(this.item instanceof SeparatorMenuItem)) {
                d2 = this.getInsets().getLeft() + ((CustomMenuItem)this.item).getContent().prefWidth(-1.0) + this.getInsets().getRight();
            }
            return Math.max(d2, this.getInsets().getLeft() + ContextMenuContent.this.maxLeftWidth + ContextMenuContent.this.maxGraphicWidth + ContextMenuContent.this.maxLabelWidth + ContextMenuContent.this.maxRightWidth + this.getInsets().getRight());
        }

        private void listen(ObservableBooleanValue observableBooleanValue, final String string) {
            observableBooleanValue.addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    MenuItemContainer.this.impl_pseudoClassStateChanged(string);
                }
            });
        }

        private Node getLeftGraphic(MenuItem menuItem) {
            if (menuItem instanceof RadioMenuItem) {
                StackPane stackPane = new StackPane();
                stackPane.getStyleClass().add("radio");
                return stackPane;
            }
            if (menuItem instanceof CheckMenuItem) {
                StackPane stackPane = new StackPane();
                stackPane.getStyleClass().add("check");
                return stackPane;
            }
            return null;
        }
    }

    class ArrowMenuItem
    extends StackPane {
        private StackPane upDownArrow;
        private ContextMenuContent popupMenuContent;
        private boolean up = false;
        private Timeline scrollTimeline;

        public final boolean isUp() {
            return this.up;
        }

        public void setUp(boolean bl) {
            this.up = bl;
            this.upDownArrow.getStyleClass().setAll((String[])new String[]{this.isUp() ? "menu-up-arrow" : "menu-down-arrow"});
        }

        public ArrowMenuItem(ContextMenuContent contextMenuContent2) {
            this.getStyleClass().setAll((String[])new String[]{"scroll-arrow"});
            this.upDownArrow = new StackPane();
            this.popupMenuContent = contextMenuContent2;
            this.upDownArrow.setMouseTransparent(true);
            this.upDownArrow.getStyleClass().setAll((String[])new String[]{this.isUp() ? "menu-up-arrow" : "menu-down-arrow"});
            this.setOnMouseEntered((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (ArrowMenuItem.this.scrollTimeline != null && ArrowMenuItem.this.scrollTimeline.getStatus() != Animation.Status.STOPPED) {
                        return;
                    }
                    ArrowMenuItem.this.startTimeline();
                }
            });
            this.setOnMouseExited((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    ArrowMenuItem.this.stopTimeline();
                }
            });
            this.setVisible(false);
            this.setManaged(false);
            this.getChildren().add(this.upDownArrow);
        }

        @Override
        protected double computePrefWidth(double d) {
            return ContextMenuContent.this.itemsContainer.getWidth();
        }

        @Override
        protected double computePrefHeight(double d) {
            return this.snapSize(this.getInsets().getTop()) + this.upDownArrow.prefHeight(-1.0) + this.snapSize(this.getInsets().getBottom());
        }

        @Override
        protected void layoutChildren() {
            double d = this.snapSize(this.upDownArrow.prefWidth(-1.0));
            double d2 = this.snapSize(this.upDownArrow.prefHeight(-1.0));
            double d3 = (this.snapSize(this.getWidth()) - d) / 2.0;
            double d4 = (this.snapSize(this.getHeight()) - d2) / 2.0;
            this.upDownArrow.resize(d, d2);
            this.positionInArea(this.upDownArrow, 0.0, 0.0, this.getWidth(), this.getHeight(), 0.0, HPos.CENTER, VPos.CENTER);
        }

        public Region getArrowRegion() {
            return this.upDownArrow;
        }

        private void adjust() {
            if (this.up) {
                this.popupMenuContent.scroll(12.0);
            } else {
                this.popupMenuContent.scroll(-12.0);
            }
        }

        private void startTimeline() {
            this.scrollTimeline = new Timeline();
            this.scrollTimeline.setCycleCount(-1);
            KeyFrame keyFrame = new KeyFrame(Duration.millis(60.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    ArrowMenuItem.this.adjust();
                }
            }, new KeyValue[0]);
            this.scrollTimeline.getKeyFrames().clear();
            this.scrollTimeline.getKeyFrames().add(keyFrame);
            this.scrollTimeline.play();
        }

        private void stopTimeline() {
            this.scrollTimeline.stop();
            this.scrollTimeline = null;
        }
    }

    class MenuBox
    extends VBox {
        MenuBox() {
        }

        @Override
        protected void layoutChildren() {
            double d = ContextMenuContent.this.ty;
            for (Node node : ContextMenuContent.this.itemsContainer.getChildren()) {
                if (!node.isVisible()) continue;
                double d2 = this.snapSize(node.prefHeight(-1.0));
                node.resize(this.snapSize(this.getWidth()), d2);
                node.relocate(this.snapSpace(this.getInsets().getLeft()), d);
                d += d2;
            }
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty EFFECT;
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            StyleableProperty styleableProperty = null;
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(SkinBase.impl_CSS_STYLEABLES());
            List<StyleableProperty> list = Node.impl_CSS_STYLEABLES();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                StyleableProperty styleableProperty2 = list.get(i);
                if (!"effect".equals(styleableProperty2.getFieldName())) continue;
                styleableProperty = styleableProperty2;
                arrayList.add(styleableProperty);
                break;
            }
            EFFECT = styleableProperty;
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

