/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.AccordionBehavior;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.Collection;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.TitledPane;

public class AccordionSkin
extends SkinBase<Accordion, AccordionBehavior> {
    private TitledPane firstTitledPane;

    public AccordionSkin(final Accordion accordion) {
        super(accordion, new AccordionBehavior(accordion));
        accordion.getPanes().addListener(new ListChangeListener<TitledPane>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends TitledPane> change) {
                if (AccordionSkin.this.firstTitledPane != null) {
                    AccordionSkin.this.firstTitledPane.getStyleClass().remove("first-titled-pane");
                }
                if (!accordion.getPanes().isEmpty()) {
                    AccordionSkin.this.firstTitledPane = (TitledPane)accordion.getPanes().get(0);
                    AccordionSkin.this.firstTitledPane.getStyleClass().add("first-titled-pane");
                }
                AccordionSkin.this.getChildren().setAll((Collection<Node>)accordion.getPanes());
                while (change.next()) {
                    AccordionSkin.this.initTitledPaneListeners(change.getAddedSubList());
                }
            }
        });
        if (!accordion.getPanes().isEmpty()) {
            this.firstTitledPane = (TitledPane)accordion.getPanes().get(0);
            this.firstTitledPane.getStyleClass().add("first-titled-pane");
        }
        this.initTitledPaneListeners(accordion.getPanes());
        this.getChildren().setAll((Collection<Node>)accordion.getPanes());
        this.requestLayout();
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = 0.0;
        for (Node node : this.getManagedChildren()) {
            d2 += this.snapSize(node.prefHeight(d));
        }
        return d2 + this.snapSpace(this.getInsets().getTop()) + this.snapSpace(this.getInsets().getBottom());
    }

    @Override
    protected void layoutChildren() {
        double d = this.snapSize(this.getWidth()) - (this.snapSpace(this.getInsets().getLeft()) + this.snapSpace(this.getInsets().getRight()));
        double d2 = this.snapSpace(this.getInsets().getLeft());
        double d3 = this.snapSpace(this.getInsets().getTop());
        double d4 = 0.0;
        for (TitledPane titledPane : ((Accordion)this.getSkinnable()).getPanes()) {
            double d5 = this.snapSize(((Node)titledPane).prefHeight(-1.0));
            ((Node)titledPane).resize(d, d5);
            titledPane.relocate(d2, d3);
            d3 += d5 + d4;
        }
    }

    private void initTitledPaneListeners(List<? extends TitledPane> list) {
        for (final TitledPane titledPane : list) {
            titledPane.setExpanded(titledPane == ((Accordion)this.getSkinnable()).getExpandedPane());
            titledPane.expandedProperty().addListener(new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                    if (bl2.booleanValue()) {
                        if (((Accordion)AccordionSkin.this.getSkinnable()).getExpandedPane() != null) {
                            ((Accordion)AccordionSkin.this.getSkinnable()).getExpandedPane().setExpanded(false);
                        }
                        if (titledPane != null) {
                            ((Accordion)AccordionSkin.this.getSkinnable()).setExpandedPane(titledPane);
                        }
                    } else {
                        ((Accordion)AccordionSkin.this.getSkinnable()).setExpandedPane(null);
                    }
                }
            });
        }
    }
}

