/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.TextInputControlBindings;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyEvent;

public abstract class TextInputControlBehavior<T extends TextInputControl>
extends BehaviorBase<T> {
    protected static final List<KeyBinding> TEXT_INPUT_BINDINGS = new ArrayList<KeyBinding>();
    private KeyEvent lastEvent;
    protected boolean macOS = Utils.isMac();

    public TextInputControlBehavior(T t) {
        super(t);
    }

    protected abstract void deleteChar(boolean var1);

    protected abstract void replaceText(int var1, int var2, String var3);

    protected abstract void setCaretAnimating(boolean var1);

    protected void scrollCharacterToVisible(int n) {
    }

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return TEXT_INPUT_BINDINGS;
    }

    @Override
    protected void callActionForEvent(KeyEvent keyEvent) {
        this.lastEvent = keyEvent;
        super.callActionForEvent(keyEvent);
    }

    @Override
    protected void callAction(String string) {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        if (textInputControl.isEditable()) {
            this.setCaretAnimating(false);
            if ("InputCharacter".equals(string)) {
                this.defaultKeyTyped(this.lastEvent);
            } else if ("Cut".equals(string)) {
                textInputControl.cut();
            } else if ("Copy".equals(string)) {
                textInputControl.copy();
            } else if ("Paste".equals(string)) {
                textInputControl.paste();
            } else if ("SelectBackward".equals(string)) {
                textInputControl.selectBackward();
            } else if ("SelectForward".equals(string)) {
                textInputControl.selectForward();
            } else if ("PreviousWord".equals(string)) {
                textInputControl.previousWord();
            } else if ("NextWord".equals(string)) {
                this.nextWord();
            } else if ("SelectPreviousWord".equals(string)) {
                textInputControl.selectPreviousWord();
            } else if ("SelectNextWord".equals(string)) {
                this.selectNextWord();
            } else if ("SelectAll".equals(string)) {
                textInputControl.selectAll();
            } else if ("Home".equals(string)) {
                textInputControl.home();
            } else if ("End".equals(string)) {
                textInputControl.end();
            } else if ("DeletePreviousChar".equals(string)) {
                this.deletePreviousChar();
            } else if ("DeleteNextChar".equals(string)) {
                this.deleteNextChar();
            } else if ("Forward".equals(string)) {
                textInputControl.forward();
            } else if ("Backward".equals(string)) {
                textInputControl.backward();
            } else if ("Fire".equals(string)) {
                this.fire(this.lastEvent);
            } else if ("Unselect".equals(string)) {
                textInputControl.deselect();
            } else if ("SelectHome".equals(string)) {
                this.selectHome();
            } else if ("SelectEnd".equals(string)) {
                this.selectEnd();
            } else {
                super.callAction(string);
            }
            this.setCaretAnimating(true);
        } else if ("Copy".equals(string)) {
            textInputControl.copy();
        } else if (string.startsWith("Traverse")) {
            super.callAction(string);
        }
    }

    private void defaultKeyTyped(KeyEvent keyEvent) {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        if (!textInputControl.isEditable() || textInputControl.isDisabled()) {
            return;
        }
        String string = keyEvent.getCharacter();
        if (string.length() == 0) {
            return;
        }
        if ((keyEvent.isControlDown() || keyEvent.isAltDown() || Utils.isMac() && keyEvent.isMetaDown()) && (!keyEvent.isControlDown() && !Utils.isMac() || !keyEvent.isAltDown())) {
            return;
        }
        if (string.charAt(0) > '\u001f' && string.charAt(0) != '\u007f' && !keyEvent.isMetaDown()) {
            IndexRange indexRange = textInputControl.getSelection();
            int n = indexRange.getStart();
            int n2 = indexRange.getEnd();
            this.replaceText(n, n2, string);
            this.scrollCharacterToVisible(n);
        }
    }

    private void deletePreviousChar() {
        this.deleteChar(true);
    }

    private void deleteNextChar() {
        this.deleteChar(false);
    }

    private void selectNextWord() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        if (this.macOS) {
            textInputControl.selectEndOfNextWord();
        } else {
            textInputControl.selectNextWord();
        }
    }

    private void nextWord() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        if (this.macOS) {
            textInputControl.endOfNextWord();
        } else {
            textInputControl.nextWord();
        }
    }

    protected void fire(KeyEvent keyEvent) {
    }

    private void selectHome() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        if (this.macOS) {
            textInputControl.extendSelection(0);
        } else {
            textInputControl.selectHome();
        }
    }

    private void selectEnd() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        if (this.macOS) {
            textInputControl.extendSelection(textInputControl.getLength());
        } else {
            textInputControl.selectEnd();
        }
    }

    static {
        TEXT_INPUT_BINDINGS.addAll(TextInputControlBindings.BINDINGS);
        TEXT_INPUT_BINDINGS.add(new KeyBinding(null, KeyEvent.KEY_PRESSED, "Consume"));
    }
}

