/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.TextInputControlBehavior;
import com.sun.javafx.scene.control.skin.TextFieldSkin;
import com.sun.javafx.scene.text.HitInfo;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HorizontalDirection;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;

public class TextFieldBehavior
extends TextInputControlBehavior<TextField> {
    public static final int SCROLL_RATE = 15;
    private TextFieldSkin skin;
    private HorizontalDirection scrollDirection = null;
    private Timeline scrollSelectionTimeline = new Timeline();
    private EventHandler<ActionEvent> scrollSelectionHandler = new EventHandler<ActionEvent>(){

        @Override
        public void handle(ActionEvent actionEvent) {
            TextField textField = (TextField)TextFieldBehavior.this.getControl();
            IndexRange indexRange = textField.getSelection();
            int n = indexRange.getStart();
            int n2 = indexRange.getEnd();
            switch (TextFieldBehavior.this.scrollDirection) {
                case RIGHT: {
                    if (n2 >= textField.getLength()) break;
                    textField.selectRange(n, ++n2);
                    break;
                }
                case LEFT: {
                    if (n <= 0) break;
                    textField.selectRange(--n, n2);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    };
    private boolean focusGainedByMouseClick = false;
    private boolean shiftDown = false;
    private boolean deferClick = false;

    public TextFieldBehavior(TextField textField) {
        super(textField);
        this.scrollSelectionTimeline.setCycleCount(-1);
        ObservableList<KeyFrame> observableList = this.scrollSelectionTimeline.getKeyFrames();
        observableList.add(new KeyFrame(Duration.millis(15.0), this.scrollSelectionHandler, new KeyValue[0]));
        textField.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                TextField textField = (TextField)TextFieldBehavior.this.getControl();
                if (textField.isFocused()) {
                    if (!TextFieldBehavior.this.focusGainedByMouseClick) {
                        textField.selectRange(textField.getLength(), 0);
                        TextFieldBehavior.this.setCaretAnimating(true);
                    }
                } else {
                    textField.selectRange(0, 0);
                    TextFieldBehavior.this.focusGainedByMouseClick = false;
                }
            }
        });
    }

    public void setTextFieldSkin(TextFieldSkin textFieldSkin) {
        this.skin = textFieldSkin;
    }

    @Override
    protected void fire(KeyEvent keyEvent) {
        TextField textField = (TextField)this.getControl();
        if (textField.getOnAction() != null) {
            textField.fireEvent(new ActionEvent(textField, null));
        } else if (textField.getParent() != null) {
            textField.getParent().fireEvent(keyEvent);
        }
    }

    @Override
    protected void deleteChar(boolean bl) {
        this.skin.deleteChar(bl);
    }

    @Override
    protected void replaceText(int n, int n2, String string) {
        this.skin.replaceText(n, n2, string);
    }

    @Override
    protected void setCaretAnimating(boolean bl) {
        this.skin.setCaretAnimating(bl);
    }

    private void beep() {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        TextField textField = (TextField)this.getControl();
        super.mousePressed(mouseEvent);
        if (!textField.isDisabled()) {
            if (!textField.isFocused()) {
                this.focusGainedByMouseClick = true;
                textField.requestFocus();
            }
            this.setCaretAnimating(false);
            if (mouseEvent.isPrimaryButtonDown() && !mouseEvent.isMiddleButtonDown() && !mouseEvent.isSecondaryButtonDown()) {
                HitInfo hitInfo = this.skin.getIndex(mouseEvent);
                int n = hitInfo.getInsertionIndex();
                int n2 = textField.getAnchor();
                int n3 = textField.getCaretPosition();
                if (mouseEvent.getClickCount() < 2 && n2 != n3 && (n > n2 && n < n3 || n < n2 && n > n3)) {
                    this.deferClick = true;
                } else if (!(mouseEvent.isControlDown() || mouseEvent.isAltDown() || mouseEvent.isShiftDown() || mouseEvent.isMetaDown())) {
                    switch (mouseEvent.getClickCount()) {
                        case 1: {
                            this.mouseSingleClick(hitInfo);
                            break;
                        }
                        case 2: {
                            this.mouseDoubleClick(hitInfo);
                            break;
                        }
                        case 3: {
                            this.mouseTripleClick(hitInfo);
                        }
                    }
                } else if (!(mouseEvent.isShiftDown() || mouseEvent.isControlDown() || mouseEvent.isAltDown() || mouseEvent.isMetaDown() || mouseEvent.getClickCount() != 1)) {
                    this.shiftDown = true;
                    if (this.macOS) {
                        textField.extendSelection(n);
                    } else {
                        this.skin.positionCaret(hitInfo, true);
                    }
                }
                this.skin.setForwardBias(hitInfo.isLeading());
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        TextField textField = (TextField)this.getControl();
        if (!(textField.isDisabled() || this.deferClick || !mouseEvent.isPrimaryButtonDown() || mouseEvent.isMiddleButtonDown() || mouseEvent.isSecondaryButtonDown() || mouseEvent.isControlDown() || mouseEvent.isAltDown() || mouseEvent.isShiftDown() || mouseEvent.isMetaDown())) {
            this.skin.positionCaret(this.skin.getIndex(mouseEvent), true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        TextField textField = (TextField)this.getControl();
        super.mouseReleased(mouseEvent);
        if (!textField.isDisabled()) {
            this.setCaretAnimating(false);
            if (this.deferClick) {
                this.deferClick = false;
                this.skin.positionCaret(this.skin.getIndex(mouseEvent), this.shiftDown);
                this.shiftDown = false;
            }
            this.setCaretAnimating(true);
        }
    }

    protected void mouseSingleClick(HitInfo hitInfo) {
        this.skin.positionCaret(hitInfo, false);
    }

    protected void mouseDoubleClick(HitInfo hitInfo) {
        TextField textField = (TextField)this.getControl();
        textField.previousWord();
        textField.selectNextWord();
    }

    protected void mouseTripleClick(HitInfo hitInfo) {
        ((TextField)this.getControl()).selectAll();
    }
}

